/*
 * Decompiled with CFR 0.152.
 */
package kafka.perf;

import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.perf.SimpleConsumerPerformance;
import kafka.perf.SimpleConsumerPerformance$;
import kafka.utils.SystemTime$;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class SimpleConsumerPerformance$
implements ScalaObject {
    public static final SimpleConsumerPerformance$ MODULE$;

    static {
        new SimpleConsumerPerformance$();
    }

    public void main(String[] stringArray) {
        Logger logger = Logger.getLogger(this.getClass());
        SimpleConsumerPerformance.ConsumerPerfConfig consumerPerfConfig = new SimpleConsumerPerformance.ConsumerPerfConfig(stringArray);
        if (!consumerPerfConfig.hideHeader()) {
            if (consumerPerfConfig.showDetailedStats()) {
                Predef$.MODULE$.println((Object)"time, fetch.size, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec");
            } else {
                Predef$.MODULE$.println((Object)"start.time, end.time, fetch.size, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec");
            }
        }
        SimpleConsumer simpleConsumer = new SimpleConsumer(consumerPerfConfig.url().getHost(), consumerPerfConfig.url().getPort(), 30000, 2 * consumerPerfConfig.fetchSize(), consumerPerfConfig.clientId());
        TopicAndPartition topicAndPartition = new TopicAndPartition(consumerPerfConfig.topic(), consumerPerfConfig.partition());
        OffsetRequest offsetRequest = new OffsetRequest((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition).$minus$greater((Object)new PartitionOffsetRequestInfo(consumerPerfConfig.fromLatest() ? OffsetRequest$.MODULE$.LatestTime() : OffsetRequest$.MODULE$.EarliestTime(), 1))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
        long l = BoxesRunTime.unboxToLong((Object)((PartitionOffsetsResponse)simpleConsumer.getOffsetsBefore(offsetRequest).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets().head());
        long l2 = System.currentTimeMillis();
        boolean bl = false;
        long l3 = 0L;
        long l4 = 0L;
        int n = 0;
        long l5 = l2;
        long l6 = 0L;
        long l7 = 0L;
        while (true) {
            if (bl) {
                long l8 = System.currentTimeMillis();
                double d = (double)(l8 - l2) / 1000.0;
                if (!consumerPerfConfig.showDetailedStats()) {
                    double d2 = (double)l3 * 1.0 / (double)0x100000;
                    Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%s, %s, %d, %.4f, %.4f, %d, %.4f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{consumerPerfConfig.dateFormat().format(BoxesRunTime.boxToLong((long)l2)), consumerPerfConfig.dateFormat().format(BoxesRunTime.boxToLong((long)l8)), BoxesRunTime.boxToInteger((int)consumerPerfConfig.fetchSize()), BoxesRunTime.boxToDouble((double)d2), BoxesRunTime.boxToDouble((double)(d2 / d)), BoxesRunTime.boxToLong((long)l4), BoxesRunTime.boxToDouble((double)((double)l4 / d))})));
                }
                System.exit(0);
                return;
            }
            FetchRequest fetchRequest = new FetchRequestBuilder().clientId(consumerPerfConfig.clientId()).addFetch(consumerPerfConfig.topic(), consumerPerfConfig.partition(), l, consumerPerfConfig.fetchSize()).build();
            FetchResponse fetchResponse = simpleConsumer.fetch(fetchRequest);
            IntRef intRef = new IntRef(0);
            IntRef intRef2 = new IntRef(0);
            ByteBufferMessageSet byteBufferMessageSet = fetchResponse.messageSet(consumerPerfConfig.topic(), consumerPerfConfig.partition());
            byteBufferMessageSet.foreach((Function1)new anonfun.main.1(intRef, intRef2));
            if (intRef.elem == 0 || l4 > consumerPerfConfig.numMessages()) {
                bl = true;
            } else {
                l += (long)byteBufferMessageSet.validBytes();
            }
            l3 += (long)intRef2.elem;
            l4 += (long)intRef.elem;
            if ((n += intRef.elem) <= consumerPerfConfig.reportingInterval()) continue;
            if (consumerPerfConfig.showDetailedStats()) {
                long l9 = System.currentTimeMillis();
                double d = (double)(l9 - l5) / 1000.0;
                double d3 = (double)(l3 - l6) * 1.0 / (double)0x100000;
                Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%s, %d, %.4f, %.4f, %d, %.4f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{consumerPerfConfig.dateFormat().format(BoxesRunTime.boxToLong((long)l9)), BoxesRunTime.boxToInteger((int)consumerPerfConfig.fetchSize()), BoxesRunTime.boxToDouble((double)((double)l3 * 1.0 / (double)0x100000)), BoxesRunTime.boxToDouble((double)(d3 / d)), BoxesRunTime.boxToLong((long)l4), BoxesRunTime.boxToDouble((double)((double)(l4 - l7) / d))})));
            }
            l5 = SystemTime$.MODULE$.milliseconds();
            l6 = l3;
            l7 = l4;
            n = 0;
        }
    }

    private SimpleConsumerPerformance$() {
        MODULE$ = this;
    }
}

