/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public enum RemoteLogSegmentState {
    COPY_SEGMENT_STARTED(0),
    COPY_SEGMENT_FINISHED(1),
    DELETE_SEGMENT_STARTED(2),
    DELETE_SEGMENT_FINISHED(3);

    private static final Map<Byte, RemoteLogSegmentState> STATE_TYPES;
    private final byte id;

    private RemoteLogSegmentState(byte id) {
        this.id = id;
    }

    public byte id() {
        return this.id;
    }

    public static RemoteLogSegmentState forId(byte id) {
        return STATE_TYPES.get(id);
    }

    public static boolean isValidTransition(RemoteLogSegmentState srcState, RemoteLogSegmentState targetState) {
        Objects.requireNonNull(targetState, "targetState can not be null");
        if (srcState == null) {
            return targetState == COPY_SEGMENT_STARTED;
        }
        if (srcState == targetState) {
            return true;
        }
        if (srcState == COPY_SEGMENT_STARTED) {
            return targetState == COPY_SEGMENT_FINISHED || targetState == DELETE_SEGMENT_STARTED;
        }
        if (srcState == COPY_SEGMENT_FINISHED) {
            return targetState == DELETE_SEGMENT_STARTED;
        }
        if (srcState == DELETE_SEGMENT_STARTED) {
            return targetState == DELETE_SEGMENT_FINISHED;
        }
        return false;
    }

    static {
        STATE_TYPES = Collections.unmodifiableMap(Arrays.stream(RemoteLogSegmentState.values()).collect(Collectors.toMap(RemoteLogSegmentState::id, Function.identity())));
    }
}

