/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Map;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.TimeWindow;

public class JoinWindows
extends Windows<TimeWindow> {
    public final long before;
    public final long after;

    private JoinWindows(String name, long before, long after) {
        super(name);
        if (before + after < 0L) {
            throw new IllegalArgumentException("Window interval (ie, before+after) must not be negative");
        }
        this.after = after;
        this.before = before;
    }

    public static JoinWindows of(String name) {
        return new JoinWindows(name, 0L, 0L);
    }

    public JoinWindows with(long timeDifference) {
        return new JoinWindows(this.name, timeDifference, timeDifference);
    }

    public JoinWindows before(long timeDifference) {
        return new JoinWindows(this.name, timeDifference, this.after);
    }

    public JoinWindows after(long timeDifference) {
        return new JoinWindows(this.name, this.before, timeDifference);
    }

    @Override
    public Map<Long, TimeWindow> windowsFor(long timestamp) {
        throw new UnsupportedOperationException("windowsFor() is not supported in JoinWindows");
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoinWindows)) {
            return false;
        }
        JoinWindows other = (JoinWindows)o;
        return this.before == other.before && this.after == other.after;
    }

    public int hashCode() {
        int result = (int)(this.before ^ this.before >>> 32);
        result = 31 * result + (int)(this.after ^ this.after >>> 32);
        return result;
    }
}

