/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.TimeWindow;

public class TimeWindows
extends Windows<TimeWindow> {
    public final long size;
    public final long advance;

    private TimeWindows(String name, long size, long advance) {
        super(name);
        if (size <= 0L) {
            throw new IllegalArgumentException("window size must be > 0 (you provided " + size + ")");
        }
        this.size = size;
        if (0L >= advance || advance > size) {
            throw new IllegalArgumentException(String.format("advance interval (%d) must lie within interval (0, %d]", advance, size));
        }
        this.advance = advance;
    }

    public static TimeWindows of(String name, long size) {
        return new TimeWindows(name, size, size);
    }

    public TimeWindows advanceBy(long interval) {
        return new TimeWindows(this.name, this.size, interval);
    }

    @Override
    public Map<Long, TimeWindow> windowsFor(long timestamp) {
        HashMap<Long, TimeWindow> windows = new HashMap<Long, TimeWindow>();
        for (long windowStart = Math.max(0L, timestamp - this.size + this.advance) / this.advance * this.advance; windowStart <= timestamp; windowStart += this.advance) {
            TimeWindow window = new TimeWindow(windowStart, windowStart + this.size);
            windows.put(windowStart, window);
        }
        return windows;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeWindows)) {
            return false;
        }
        TimeWindows other = (TimeWindows)o;
        return this.size == other.size && this.advance == other.advance;
    }

    public int hashCode() {
        int result = (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (int)(this.advance ^ this.advance >>> 32);
        return result;
    }
}

