/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueLoggedStore;
import org.apache.kafka.streams.state.internals.MemoryNavigableLRUCache;
import org.apache.kafka.streams.state.internals.MeteredKeyValueStore;

public class InMemoryLRUCacheStoreSupplier<K, V>
implements StateStoreSupplier {
    private final String name;
    private final int capacity;
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private final Time time;

    public InMemoryLRUCacheStoreSupplier(String name, int capacity, Serde<K> keySerde, Serde<V> valueSerde) {
        this(name, capacity, keySerde, valueSerde, null);
    }

    public InMemoryLRUCacheStoreSupplier(String name, int capacity, Serde<K> keySerde, Serde<V> valueSerde, Time time) {
        this.name = name;
        this.capacity = capacity;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.time = time;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public StateStore get() {
        MemoryNavigableLRUCache<K, V> cache = new MemoryNavigableLRUCache<K, V>(this.name, this.capacity, this.keySerde, this.valueSerde);
        InMemoryKeyValueLoggedStore loggedCache = (InMemoryKeyValueLoggedStore)cache.enableLogging();
        return new MeteredKeyValueStore(loggedCache, "in-memory-lru-state", this.time);
    }
}

