/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;

interface WrappedStateStore
extends StateStore {
    public StateStore inner();

    public static abstract class AbstractWrappedStateStore
    implements WrappedStateStore {
        final StateStore innerState;

        AbstractWrappedStateStore(StateStore inner) {
            this.innerState = inner;
        }

        @Override
        public void init(ProcessorContext context, StateStore root) {
            this.innerState.init(context, root);
        }

        @Override
        public String name() {
            return this.innerState.name();
        }

        @Override
        public boolean persistent() {
            return this.innerState.persistent();
        }

        @Override
        public boolean isOpen() {
            return this.innerState.isOpen();
        }

        void validateStoreOpen() {
            if (!this.innerState.isOpen()) {
                throw new InvalidStateStoreException("Store " + this.innerState.name() + " is currently closed.");
            }
        }

        @Override
        public StateStore inner() {
            if (this.innerState instanceof WrappedStateStore) {
                return ((WrappedStateStore)this.innerState).inner();
            }
            return this.innerState;
        }

        @Override
        public void flush() {
            this.innerState.flush();
        }

        @Override
        public void close() {
            this.innerState.close();
        }
    }
}

