/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.ReadOnlySessionStore;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.StateStoreProvider;

public class CompositeReadOnlySessionStore<K, V>
implements ReadOnlySessionStore<K, V> {
    private final StateStoreProvider storeProvider;
    private final QueryableStoreType<ReadOnlySessionStore<K, V>> queryableStoreType;
    private final String storeName;

    public CompositeReadOnlySessionStore(StateStoreProvider storeProvider, QueryableStoreType<ReadOnlySessionStore<K, V>> queryableStoreType, String storeName) {
        this.storeProvider = storeProvider;
        this.queryableStoreType = queryableStoreType;
        this.storeName = storeName;
    }

    @Override
    private KeyValueIterator<Windowed<K>, V> fetch(Fetcher<K, V> fetcher) {
        List<ReadOnlySessionStore<K, V>> stores = this.storeProvider.stores(this.storeName, this.queryableStoreType);
        for (ReadOnlySessionStore<K, V> store : stores) {
            try {
                KeyValueIterator<Windowed<K>, V> result = fetcher.fetch(store);
                if (!result.hasNext()) {
                    result.close();
                    continue;
                }
                return result;
            }
            catch (InvalidStateStoreException ise) {
                throw new InvalidStateStoreException("State store  [" + this.storeName + "] is not available anymore" + " and may have been migrated to another instance; " + "please re-discover its location from the state metadata.");
            }
        }
        return KeyValueIterators.emptyIterator();
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(final K key) {
        return this.fetch((K)new Fetcher<K, V>(){

            @Override
            public KeyValueIterator<Windowed<K>, V> fetch(ReadOnlySessionStore<K, V> store) {
                return store.fetch(key);
            }
        });
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(final K from, final K to) {
        return this.fetch((K)new Fetcher<K, V>(){

            @Override
            public KeyValueIterator<Windowed<K>, V> fetch(ReadOnlySessionStore<K, V> store) {
                return store.fetch(from, to);
            }
        });
    }

    private static interface Fetcher<K, V> {
        public KeyValueIterator<Windowed<K>, V> fetch(ReadOnlySessionStore<K, V> var1);
    }
}

