/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionKeySerde;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.AbstractMergedSortedCacheStoreIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;

class MergedSortedCacheSessionStoreIterator<K, AGG>
extends AbstractMergedSortedCacheStoreIterator<Windowed<K>, Windowed<Bytes>, AGG, byte[]> {
    private final StateSerdes<K, AGG> serdes;
    private final SegmentedCacheFunction cacheFunction;

    MergedSortedCacheSessionStoreIterator(PeekingKeyValueIterator<Bytes, LRUCacheEntry> cacheIterator, KeyValueIterator<Windowed<Bytes>, byte[]> storeIterator, StateSerdes<K, AGG> serdes, SegmentedCacheFunction cacheFunction) {
        super(cacheIterator, storeIterator);
        this.serdes = serdes;
        this.cacheFunction = cacheFunction;
    }

    @Override
    public KeyValue<Windowed<K>, AGG> deserializeStorePair(KeyValue<Windowed<Bytes>, byte[]> pair) {
        return KeyValue.pair(this.deserializeStoreKey((Windowed)pair.key), this.serdes.valueFrom((byte[])pair.value));
    }

    @Override
    Windowed<K> deserializeCacheKey(Bytes cacheKey) {
        byte[] binaryKey = this.cacheFunction.key(cacheKey).get();
        return SessionKeySerde.from(binaryKey, this.serdes.keyDeserializer(), this.serdes.topic());
    }

    @Override
    AGG deserializeCacheValue(LRUCacheEntry cacheEntry) {
        return this.serdes.valueFrom(cacheEntry.value);
    }

    @Override
    public Windowed<K> deserializeStoreKey(Windowed<Bytes> key) {
        K originalKey = this.serdes.keyFrom(key.key().get());
        return new Windowed<K>(originalKey, key.window());
    }

    @Override
    public int compare(Bytes cacheKey, Windowed<Bytes> storeKey) {
        Bytes storeKeyBytes = SessionKeySerde.bytesToBinary(storeKey);
        return this.cacheFunction.compareSegmentedKeys(cacheKey, storeKeyBytes);
    }
}

