/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

class MeteredSegmentedBytesStore
extends WrappedStateStore.AbstractStateStore
implements SegmentedBytesStore {
    private final SegmentedBytesStore inner;
    private final String metricScope;
    private final Time time;
    private Sensor putTime;
    private Sensor fetchTime;
    private Sensor flushTime;
    private StreamsMetrics metrics;
    private Sensor getTime;
    private Sensor removeTime;

    MeteredSegmentedBytesStore(SegmentedBytesStore inner, String metricScope, Time time) {
        super(inner);
        this.inner = inner;
        this.metricScope = metricScope;
        this.time = time != null ? time : new SystemTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ProcessorContext context, StateStore root) {
        String tagKey = "task-id";
        String tagValue = context.taskId().toString();
        this.metrics = context.metrics();
        this.putTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "put", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        this.fetchTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "fetch", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        this.flushTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "flush", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        this.getTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "get", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        this.removeTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "remove", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        Sensor restoreTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "restore", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        long startNs = this.time.nanoseconds();
        try {
            this.inner.init(context, root);
        }
        finally {
            this.metrics.recordLatency(restoreTime, startNs, this.time.nanoseconds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(Bytes key) {
        long startNs = this.time.nanoseconds();
        try {
            byte[] byArray = this.inner.get(key);
            return byArray;
        }
        finally {
            this.metrics.recordLatency(this.getTime, startNs, this.time.nanoseconds());
        }
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> fetch(Bytes key, long timeFrom, long timeTo) {
        return new MeteredSegmentedBytesStoreIterator(this.inner.fetch(key, timeFrom, timeTo), this.fetchTime);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> fetch(Bytes keyFrom, Bytes keyTo, long from, long to) {
        return new MeteredSegmentedBytesStoreIterator(this.inner.fetch(keyFrom, keyTo, from, to), this.fetchTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Bytes key) {
        long startNs = this.time.nanoseconds();
        try {
            this.inner.remove(key);
        }
        finally {
            this.metrics.recordLatency(this.removeTime, startNs, this.time.nanoseconds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Bytes key, byte[] value) {
        long startNs = this.time.nanoseconds();
        try {
            this.inner.put(key, value);
        }
        finally {
            this.metrics.recordLatency(this.putTime, startNs, this.time.nanoseconds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        long startNs = this.time.nanoseconds();
        try {
            this.inner.flush();
        }
        finally {
            this.metrics.recordLatency(this.flushTime, startNs, this.time.nanoseconds());
        }
    }

    private class MeteredSegmentedBytesStoreIterator
    implements KeyValueIterator<Bytes, byte[]> {
        private final KeyValueIterator<Bytes, byte[]> iter;
        private final Sensor sensor;
        private final long startNs;

        MeteredSegmentedBytesStoreIterator(KeyValueIterator<Bytes, byte[]> iter, Sensor sensor) {
            this.iter = iter;
            this.sensor = sensor;
            this.startNs = MeteredSegmentedBytesStore.this.time.nanoseconds();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public KeyValue<Bytes, byte[]> next() {
            return (KeyValue)this.iter.next();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                this.iter.close();
            }
            finally {
                MeteredSegmentedBytesStore.this.metrics.recordLatency(this.sensor, this.startNs, MeteredSegmentedBytesStore.this.time.nanoseconds());
            }
        }

        @Override
        public Bytes peekNextKey() {
            return this.iter.peekNextKey();
        }
    }
}

