/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.state.StateSerdes;

public class WindowStoreUtils {
    static final int SEQNUM_SIZE = 4;
    static final int TIMESTAMP_SIZE = 8;
    static final Serde<Bytes> INNER_KEY_SERDE = Serdes.Bytes();
    static final Serde<byte[]> INNER_VALUE_SERDE = Serdes.ByteArray();

    static StateSerdes<Bytes, byte[]> getInnerStateSerde(String topic) {
        return new StateSerdes<Bytes, byte[]>(topic, INNER_KEY_SERDE, INNER_VALUE_SERDE);
    }

    static <K> Bytes toBinaryKey(K key, long timestamp, int seqnum, StateSerdes<K, ?> serdes) {
        byte[] serializedKey = serdes.rawKey(key);
        return WindowStoreUtils.toBinaryKey(serializedKey, timestamp, seqnum);
    }

    static Bytes toBinaryKey(byte[] serializedKey, long timestamp, int seqnum) {
        ByteBuffer buf = ByteBuffer.allocate(serializedKey.length + 8 + 4);
        buf.put(serializedKey);
        buf.putLong(timestamp);
        buf.putInt(seqnum);
        return Bytes.wrap((byte[])buf.array());
    }

    static <K> K keyFromBinaryKey(byte[] binaryKey, StateSerdes<K, ?> serdes) {
        byte[] bytes = new byte[binaryKey.length - 8 - 4];
        System.arraycopy(binaryKey, 0, bytes, 0, bytes.length);
        return serdes.keyFrom(bytes);
    }

    static Bytes bytesKeyFromBinaryKey(byte[] binaryKey) {
        byte[] bytes = new byte[binaryKey.length - 8 - 4];
        System.arraycopy(binaryKey, 0, bytes, 0, bytes.length);
        return Bytes.wrap((byte[])bytes);
    }

    static long timestampFromBinaryKey(byte[] binaryKey) {
        return ByteBuffer.wrap(binaryKey).getLong(binaryKey.length - 8 - 4);
    }

    static int sequenceNumberFromBinaryKey(byte[] binaryKey) {
        return ByteBuffer.wrap(binaryKey).getInt(binaryKey.length - 4);
    }

    static TimeWindow timeWindowForSize(long startMs, long windowSize) {
        long endMs = startMs + windowSize;
        return new TimeWindow(startMs, endMs < 0L ? Long.MAX_VALUE : endMs);
    }
}

