/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.streams.internals.ApiUtils;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windows;

public final class JoinWindows
extends Windows<Window> {
    private final long maintainDurationMs;
    public final long beforeMs;
    public final long afterMs;
    private final Duration grace;

    private JoinWindows(long beforeMs, long afterMs, Duration grace, long maintainDurationMs) {
        if (beforeMs + afterMs < 0L) {
            throw new IllegalArgumentException("Window interval (ie, beforeMs+afterMs) must not be negative.");
        }
        this.afterMs = afterMs;
        this.beforeMs = beforeMs;
        this.grace = grace;
        this.maintainDurationMs = maintainDurationMs;
    }

    private JoinWindows(long beforeMs, long afterMs, Duration grace, long maintainDurationMs, int segments) {
        super(segments);
        if (beforeMs + afterMs < 0L) {
            throw new IllegalArgumentException("Window interval (ie, beforeMs+afterMs) must not be negative.");
        }
        this.afterMs = afterMs;
        this.beforeMs = beforeMs;
        this.grace = grace;
        this.maintainDurationMs = maintainDurationMs;
    }

    @Deprecated
    public static JoinWindows of(long timeDifferenceMs) throws IllegalArgumentException {
        return new JoinWindows(timeDifferenceMs, timeDifferenceMs, null, 86400000L);
    }

    public static JoinWindows of(Duration timeDifference) throws IllegalArgumentException {
        ApiUtils.validateMillisecondDuration(timeDifference, "timeDifference");
        return JoinWindows.of(timeDifference.toMillis());
    }

    @Deprecated
    public JoinWindows before(long timeDifferenceMs) throws IllegalArgumentException {
        return new JoinWindows(timeDifferenceMs, this.afterMs, this.grace, this.maintainDurationMs, this.segments);
    }

    public JoinWindows before(Duration timeDifference) throws IllegalArgumentException {
        ApiUtils.validateMillisecondDuration(timeDifference, "timeDifference");
        return this.before(timeDifference.toMillis());
    }

    @Deprecated
    public JoinWindows after(long timeDifferenceMs) throws IllegalArgumentException {
        return new JoinWindows(this.beforeMs, timeDifferenceMs, this.grace, this.maintainDurationMs, this.segments);
    }

    public JoinWindows after(Duration timeDifference) throws IllegalArgumentException {
        ApiUtils.validateMillisecondDuration(timeDifference, "timeDifference");
        return this.after(timeDifference.toMillis());
    }

    @Override
    public Map<Long, Window> windowsFor(long timestamp) {
        throw new UnsupportedOperationException("windowsFor() is not supported by JoinWindows.");
    }

    @Override
    public long size() {
        return this.beforeMs + this.afterMs;
    }

    public JoinWindows grace(Duration afterWindowEnd) throws IllegalArgumentException {
        ApiUtils.validateMillisecondDuration(afterWindowEnd, "afterWindowEnd");
        if (afterWindowEnd.toMillis() < 0L) {
            throw new IllegalArgumentException("Grace period must not be negative.");
        }
        return new JoinWindows(this.beforeMs, this.afterMs, afterWindowEnd, this.maintainDurationMs, this.segments);
    }

    @Override
    public long gracePeriodMs() {
        return this.grace != null ? this.grace.toMillis() : this.maintainMs() - this.size();
    }

    @Deprecated
    public JoinWindows until(long durationMs) throws IllegalArgumentException {
        if (durationMs < this.size()) {
            throw new IllegalArgumentException("Window retention time (durationMs) cannot be smaller than the window size.");
        }
        return new JoinWindows(this.beforeMs, this.afterMs, this.grace, durationMs, this.segments);
    }

    @Override
    @Deprecated
    public long maintainMs() {
        return Math.max(this.maintainDurationMs, this.size());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinWindows that = (JoinWindows)o;
        return this.beforeMs == that.beforeMs && this.afterMs == that.afterMs && this.maintainDurationMs == that.maintainDurationMs && this.segments == that.segments && Objects.equals(this.grace, that.grace);
    }

    public int hashCode() {
        return Objects.hash(this.beforeMs, this.afterMs, this.grace, this.maintainDurationMs, this.segments);
    }

    public String toString() {
        return "JoinWindows{beforeMs=" + this.beforeMs + ", afterMs=" + this.afterMs + ", grace=" + this.grace + ", maintainDurationMs=" + this.maintainDurationMs + ", segments=" + this.segments + '}';
    }
}

