/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.internals.ForwardingCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KStreamReduce<K, V>
implements KStreamAggProcessorSupplier<K, K, V, V> {
    private static final Logger LOG = LoggerFactory.getLogger(KStreamReduce.class);
    private final String storeName;
    private final Reducer<V> reducer;
    private boolean sendOldValues = false;

    KStreamReduce(String storeName, Reducer<V> reducer) {
        this.storeName = storeName;
        this.reducer = reducer;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamReduceProcessor();
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public KTableValueGetterSupplier<K, V> view() {
        return new KTableValueGetterSupplier<K, V>(){

            @Override
            public KTableValueGetter<K, V> get() {
                return new KStreamReduceValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KStreamReduce.this.storeName};
            }
        };
    }

    private class KStreamReduceValueGetter
    implements KTableValueGetter<K, V> {
        private KeyValueStore<K, V> store;

        private KStreamReduceValueGetter() {
        }

        @Override
        public void init(ProcessorContext context) {
            this.store = (KeyValueStore)context.getStateStore(KStreamReduce.this.storeName);
        }

        @Override
        public V get(K key) {
            return this.store.get(key);
        }

        @Override
        public void close() {
        }
    }

    private class KStreamReduceProcessor
    extends AbstractProcessor<K, V> {
        private KeyValueStore<K, V> store;
        private TupleForwarder<K, V> tupleForwarder;
        private StreamsMetricsImpl metrics;

        private KStreamReduceProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.metrics = (StreamsMetricsImpl)context.metrics();
            this.store = (KeyValueStore)context.getStateStore(KStreamReduce.this.storeName);
            this.tupleForwarder = new TupleForwarder(this.store, context, new ForwardingCacheFlushListener(context, KStreamReduce.this.sendOldValues), KStreamReduce.this.sendOldValues);
        }

        @Override
        public void process(K key, V value) {
            if (key == null || value == null) {
                LOG.warn("Skipping record due to null key or value. key=[{}] value=[{}] topic=[{}] partition=[{}] offset=[{}]", new Object[]{key, value, this.context().topic(), this.context().partition(), this.context().offset()});
                this.metrics.skippedRecordsSensor().record();
                return;
            }
            Object oldAgg = this.store.get(key);
            Object newAgg = oldAgg;
            newAgg = newAgg == null ? value : KStreamReduce.this.reducer.apply(newAgg, value);
            this.store.put(key, newAgg);
            this.tupleForwarder.maybeForward(key, newAgg, oldAgg);
        }
    }
}

