/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.suppress;

import java.util.Objects;
import org.apache.kafka.streams.kstream.Suppressed;
import org.apache.kafka.streams.kstream.internals.suppress.BufferConfigInternal;
import org.apache.kafka.streams.kstream.internals.suppress.BufferFullStrategy;

public class EagerBufferConfigImpl
extends BufferConfigInternal {
    private final long maxRecords;
    private final long maxBytes;

    public EagerBufferConfigImpl(long maxRecords, long maxBytes) {
        this.maxRecords = maxRecords;
        this.maxBytes = maxBytes;
    }

    @Override
    public Suppressed.BufferConfig withMaxRecords(long recordLimit) {
        return new EagerBufferConfigImpl(recordLimit, this.maxBytes);
    }

    @Override
    public Suppressed.BufferConfig withMaxBytes(long byteLimit) {
        return new EagerBufferConfigImpl(this.maxRecords, byteLimit);
    }

    @Override
    public long maxRecords() {
        return this.maxRecords;
    }

    @Override
    public long maxBytes() {
        return this.maxBytes;
    }

    @Override
    public BufferFullStrategy bufferFullStrategy() {
        return BufferFullStrategy.EMIT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EagerBufferConfigImpl that = (EagerBufferConfigImpl)o;
        return this.maxRecords == that.maxRecords && this.maxBytes == that.maxBytes;
    }

    public int hashCode() {
        return Objects.hash(this.maxRecords, this.maxBytes);
    }

    public String toString() {
        return "EagerBufferConfigImpl{maxKeys=" + this.maxRecords + ", maxBytes=" + this.maxBytes + '}';
    }
}

