/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.Change;

public final class FullChangeSerde<T> {
    private final Serde<T> inner;

    public static <T> FullChangeSerde<T> wrap(Serde<T> serde) {
        if (serde == null) {
            return null;
        }
        return new FullChangeSerde<T>(serde);
    }

    private FullChangeSerde(Serde<T> inner) {
        this.inner = Objects.requireNonNull(inner);
    }

    public Serde<T> innerSerde() {
        return this.inner;
    }

    public Change<byte[]> serializeParts(String topic, Change<T> data) {
        if (data == null) {
            return null;
        }
        Serializer innerSerializer = this.innerSerde().serializer();
        byte[] oldBytes = data.oldValue == null ? null : innerSerializer.serialize(topic, data.oldValue);
        byte[] newBytes = data.newValue == null ? null : innerSerializer.serialize(topic, data.newValue);
        return new Change<byte[]>(newBytes, oldBytes);
    }

    public Change<T> deserializeParts(String topic, Change<byte[]> serialChange) {
        if (serialChange == null) {
            return null;
        }
        Deserializer innerDeserializer = this.innerSerde().deserializer();
        Object oldValue = serialChange.oldValue == null ? null : innerDeserializer.deserialize(topic, (byte[])serialChange.oldValue);
        Object newValue = serialChange.newValue == null ? null : innerDeserializer.deserialize(topic, (byte[])serialChange.newValue);
        return new Change<Object>(newValue, oldValue);
    }

    public static byte[] mergeChangeArraysIntoSingleLegacyFormattedArray(Change<byte[]> serialChange) {
        if (serialChange == null) {
            return null;
        }
        int oldSize = serialChange.oldValue == null ? -1 : ((byte[])serialChange.oldValue).length;
        int newSize = serialChange.newValue == null ? -1 : ((byte[])serialChange.newValue).length;
        ByteBuffer buffer = ByteBuffer.allocate(8 + Math.max(0, oldSize) + Math.max(0, newSize));
        buffer.putInt(oldSize);
        if (serialChange.oldValue != null) {
            buffer.put((byte[])serialChange.oldValue);
        }
        buffer.putInt(newSize);
        if (serialChange.newValue != null) {
            buffer.put((byte[])serialChange.newValue);
        }
        return buffer.array();
    }

    public static Change<byte[]> decomposeLegacyFormattedArrayIntoChangeArrays(byte[] data) {
        int newSize;
        byte[] newBytes;
        byte[] oldBytes;
        if (data == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int oldSize = buffer.getInt();
        byte[] byArray = oldBytes = oldSize == -1 ? null : new byte[oldSize];
        if (oldBytes != null) {
            buffer.get(oldBytes);
        }
        byte[] byArray2 = newBytes = (newSize = buffer.getInt()) == -1 ? null : new byte[newSize];
        if (newBytes != null) {
            buffer.get(newBytes);
        }
        return new Change<byte[]>(newBytes, oldBytes);
    }
}

