/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.streams.state.HostInfo;

public class KeyQueryMetadata {
    public static final KeyQueryMetadata NOT_AVAILABLE = new KeyQueryMetadata(new HostInfo("unavailable", -1), Collections.emptySet(), -1);
    private final HostInfo activeHost;
    private final Set<HostInfo> standbyHosts;
    private final int partition;

    public KeyQueryMetadata(HostInfo activeHost, Set<HostInfo> standbyHosts, int partition) {
        this.activeHost = activeHost;
        this.standbyHosts = standbyHosts;
        this.partition = partition;
    }

    public HostInfo getActiveHost() {
        return this.activeHost;
    }

    public Set<HostInfo> getStandbyHosts() {
        return this.standbyHosts;
    }

    public int getPartition() {
        return this.partition;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyQueryMetadata)) {
            return false;
        }
        KeyQueryMetadata keyQueryMetadata = (KeyQueryMetadata)obj;
        return Objects.equals(keyQueryMetadata.activeHost, this.activeHost) && Objects.equals(keyQueryMetadata.standbyHosts, this.standbyHosts) && Objects.equals(keyQueryMetadata.partition, this.partition);
    }

    public String toString() {
        return "KeyQueryMetadata {activeHost=" + this.activeHost + ", standbyHosts=" + this.standbyHosts + ", partition=" + this.partition + '}';
    }

    public int hashCode() {
        return Objects.hash(this.activeHost, this.standbyHosts, this.partition);
    }
}

