/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableDeserializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableSerializer;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionResponseWrapper;

public class SubscriptionResponseWrapperSerde<V>
implements Serde<SubscriptionResponseWrapper<V>> {
    private final SubscriptionResponseWrapperSerializer<V> serializer;
    private final SubscriptionResponseWrapperDeserializer<V> deserializer;

    public SubscriptionResponseWrapperSerde(Serde<V> foreignValueSerde) {
        this.serializer = new SubscriptionResponseWrapperSerializer(foreignValueSerde == null ? null : foreignValueSerde.serializer());
        this.deserializer = new SubscriptionResponseWrapperDeserializer(foreignValueSerde == null ? null : foreignValueSerde.deserializer());
    }

    public Serializer<SubscriptionResponseWrapper<V>> serializer() {
        return this.serializer;
    }

    public Deserializer<SubscriptionResponseWrapper<V>> deserializer() {
        return this.deserializer;
    }

    private static final class SubscriptionResponseWrapperDeserializer<V>
    implements Deserializer<SubscriptionResponseWrapper<V>>,
    WrappingNullableDeserializer<SubscriptionResponseWrapper<V>, V> {
        private Deserializer<V> deserializer;

        private SubscriptionResponseWrapperDeserializer(Deserializer<V> deserializer) {
            this.deserializer = deserializer;
        }

        @Override
        public void setIfUnset(Deserializer<V> defaultDeserializer) {
            if (this.deserializer == null) {
                this.deserializer = Objects.requireNonNull(defaultDeserializer, "defaultDeserializer cannot be null");
            }
        }

        public SubscriptionResponseWrapper<V> deserialize(String topic, byte[] data) {
            Object value;
            long[] hash;
            ByteBuffer buf = ByteBuffer.wrap(data);
            byte versionAndIsHashNull = buf.get();
            byte version = (byte)(0x7F & versionAndIsHashNull);
            boolean isHashNull = (0x80 & versionAndIsHashNull) == 128;
            int lengthSum = 1;
            if (isHashNull) {
                hash = null;
            } else {
                hash = new long[]{buf.getLong(), buf.getLong()};
                lengthSum += 16;
            }
            if (data.length - lengthSum > 0) {
                byte[] serializedValue = new byte[data.length - lengthSum];
                buf.get(serializedValue, 0, serializedValue.length);
                value = this.deserializer.deserialize(topic, serializedValue);
            } else {
                value = null;
            }
            return new SubscriptionResponseWrapper<Object>(hash, value, version);
        }
    }

    private static final class SubscriptionResponseWrapperSerializer<V>
    implements Serializer<SubscriptionResponseWrapper<V>>,
    WrappingNullableSerializer<SubscriptionResponseWrapper<V>, V> {
        private Serializer<V> serializer;

        private SubscriptionResponseWrapperSerializer(Serializer<V> serializer) {
            this.serializer = serializer;
        }

        @Override
        public void setIfUnset(Serializer<V> defaultSerializer) {
            if (this.serializer == null) {
                this.serializer = Objects.requireNonNull(defaultSerializer, "defaultSerializer cannot be null");
            }
        }

        public byte[] serialize(String topic, SubscriptionResponseWrapper<V> data) {
            if (Byte.compare((byte)127, data.getVersion()) < 0) {
                throw new UnsupportedVersionException("SubscriptionResponseWrapper version is larger than maximum supported 0x7F");
            }
            byte[] serializedData = data.getForeignValue() == null ? null : this.serializer.serialize(topic, data.getForeignValue());
            int serializedDataLength = serializedData == null ? 0 : serializedData.length;
            long[] originalHash = data.getOriginalValueHash();
            int hashLength = originalHash == null ? 0 : 16;
            ByteBuffer buf = ByteBuffer.allocate(1 + hashLength + serializedDataLength);
            if (originalHash != null) {
                buf.put(data.getVersion());
                buf.putLong(originalHash[0]);
                buf.putLong(originalHash[1]);
            } else {
                buf.put((byte)(data.getVersion() | 0xFFFFFF80));
            }
            if (serializedData != null) {
                buf.put(serializedData);
            }
            return buf.array();
        }
    }
}

