/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.internals.QuietStreamsConfig;
import org.apache.kafka.streams.processor.PartitionGrouper;
import org.apache.kafka.streams.processor.internals.InternalTopicManager;
import org.apache.kafka.streams.processor.internals.StreamsMetadataState;
import org.apache.kafka.streams.processor.internals.TaskManager;
import org.apache.kafka.streams.processor.internals.assignment.CopartitionedTopicsEnforcer;
import org.apache.kafka.streams.processor.internals.assignment.HighAvailabilityTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.TaskAssignor;
import org.slf4j.Logger;

public final class AssignorConfiguration {
    private final String taskAssignorClass;
    private final String logPrefix;
    private final Logger log;
    private final TaskManager taskManager;
    private final Admin adminClient;
    private final StreamsConfig streamsConfig;
    private final Map<String, ?> internalConfigs;

    public AssignorConfiguration(Map<String, ?> configs) {
        this.streamsConfig = new QuietStreamsConfig(configs);
        this.internalConfigs = configs;
        this.logPrefix = String.format("stream-thread [%s] ", this.streamsConfig.getString("client.id"));
        LogContext logContext = new LogContext(this.logPrefix);
        this.log = logContext.logger(this.getClass());
        Object o = configs.get("__task.manager.instance__");
        if (o == null) {
            KafkaException fatalException = new KafkaException("TaskManager is not specified");
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        if (!(o instanceof TaskManager)) {
            KafkaException fatalException = new KafkaException(String.format("%s is not an instance of %s", o.getClass().getName(), TaskManager.class.getName()));
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        this.taskManager = (TaskManager)o;
        o = configs.get("__streams.admin.client.instance__");
        if (o == null) {
            KafkaException fatalException = new KafkaException("Admin is not specified");
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        if (!(o instanceof Admin)) {
            KafkaException fatalException = new KafkaException(String.format("%s is not an instance of %s", o.getClass().getName(), Admin.class.getName()));
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        this.adminClient = (Admin)o;
        o = (String)configs.get("internal.task.assignor.class");
        this.taskAssignorClass = o == null ? HighAvailabilityTaskAssignor.class.getName() : o;
    }

    public AtomicInteger assignmentErrorCode() {
        Object ai = this.internalConfigs.get("__assignment.error.code__");
        if (ai == null) {
            KafkaException fatalException = new KafkaException("assignmentErrorCode is not specified");
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        if (!(ai instanceof AtomicInteger)) {
            KafkaException fatalException = new KafkaException(String.format("%s is not an instance of %s", ai.getClass().getName(), AtomicInteger.class.getName()));
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        return (AtomicInteger)ai;
    }

    public AtomicLong nextScheduledRebalanceMs() {
        Object al = this.internalConfigs.get("__next.probing.rebalance.ms__");
        if (al == null) {
            KafkaException fatalException = new KafkaException("nextProbingRebalanceMs is not specified");
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        if (!(al instanceof AtomicLong)) {
            KafkaException fatalException = new KafkaException(String.format("%s is not an instance of %s", al.getClass().getName(), AtomicLong.class.getName()));
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        return (AtomicLong)al;
    }

    public Time time() {
        Object t = this.internalConfigs.get("__time__");
        if (t == null) {
            KafkaException fatalException = new KafkaException("time is not specified");
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        if (!(t instanceof Time)) {
            KafkaException fatalException = new KafkaException(String.format("%s is not an instance of %s", t.getClass().getName(), Time.class.getName()));
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        return (Time)t;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    public StreamsMetadataState streamsMetadataState() {
        Object o = this.internalConfigs.get("__streams.metadata.state.instance__");
        if (o == null) {
            KafkaException fatalException = new KafkaException("StreamsMetadataState is not specified");
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        if (!(o instanceof StreamsMetadataState)) {
            KafkaException fatalException = new KafkaException(String.format("%s is not an instance of %s", o.getClass().getName(), StreamsMetadataState.class.getName()));
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        return (StreamsMetadataState)o;
    }

    public ConsumerPartitionAssignor.RebalanceProtocol rebalanceProtocol() {
        String upgradeFrom = this.streamsConfig.getString("upgrade.from");
        if (upgradeFrom != null) {
            switch (upgradeFrom) {
                case "0.10.0": 
                case "0.10.1": 
                case "0.10.2": 
                case "0.11.0": 
                case "1.0": 
                case "1.1": 
                case "2.0": 
                case "2.1": 
                case "2.2": 
                case "2.3": {
                    this.log.info("Eager rebalancing enabled now for upgrade from {}.x", (Object)upgradeFrom);
                    return ConsumerPartitionAssignor.RebalanceProtocol.EAGER;
                }
            }
            throw new IllegalArgumentException("Unknown configuration value for parameter 'upgrade.from': " + upgradeFrom);
        }
        this.log.info("Cooperative rebalancing enabled now");
        return ConsumerPartitionAssignor.RebalanceProtocol.COOPERATIVE;
    }

    public String logPrefix() {
        return this.logPrefix;
    }

    public int configuredMetadataVersion(int priorVersion) {
        String upgradeFrom = this.streamsConfig.getString("upgrade.from");
        if (upgradeFrom != null) {
            switch (upgradeFrom) {
                case "0.10.0": {
                    this.log.info("Downgrading metadata version from {} to 1 for upgrade from 0.10.0.x.", (Object)7);
                    return 1;
                }
                case "0.10.1": 
                case "0.10.2": 
                case "0.11.0": 
                case "1.0": 
                case "1.1": {
                    this.log.info("Downgrading metadata version from {} to 2 for upgrade from {}.x.", (Object)7, (Object)upgradeFrom);
                    return 2;
                }
                case "2.0": 
                case "2.1": 
                case "2.2": 
                case "2.3": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown configuration value for parameter 'upgrade.from': " + upgradeFrom);
                }
            }
        }
        return priorVersion;
    }

    public PartitionGrouper partitionGrouper() {
        return (PartitionGrouper)this.streamsConfig.getConfiguredInstance("partition.grouper", PartitionGrouper.class);
    }

    public String userEndPoint() {
        String configuredUserEndpoint = this.streamsConfig.getString("application.server");
        if (configuredUserEndpoint != null && !configuredUserEndpoint.isEmpty()) {
            try {
                String host = Utils.getHost((String)configuredUserEndpoint);
                Integer port = Utils.getPort((String)configuredUserEndpoint);
                if (host == null || port == null) {
                    throw new ConfigException(String.format("%s Config %s isn't in the correct format. Expected a host:port pair but received %s", this.logPrefix, "application.server", configuredUserEndpoint));
                }
            }
            catch (NumberFormatException nfe) {
                throw new ConfigException(String.format("%s Invalid port supplied in %s for config %s: %s", this.logPrefix, configuredUserEndpoint, "application.server", nfe));
            }
            return configuredUserEndpoint;
        }
        return null;
    }

    public Admin adminClient() {
        return this.adminClient;
    }

    public InternalTopicManager internalTopicManager() {
        return new InternalTopicManager(this.adminClient, this.streamsConfig);
    }

    public CopartitionedTopicsEnforcer copartitionedTopicsEnforcer() {
        return new CopartitionedTopicsEnforcer(this.logPrefix);
    }

    public AssignmentConfigs assignmentConfigs() {
        return new AssignmentConfigs(this.streamsConfig);
    }

    public TaskAssignor taskAssignor() {
        try {
            return (TaskAssignor)Utils.newInstance((String)this.taskAssignorClass, TaskAssignor.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Expected an instantiable class name for internal.task.assignor.class", e);
        }
    }

    public AssignmentListener assignmentListener() {
        Object o = this.internalConfigs.get("__assignment.listener__");
        if (o == null) {
            return stable -> {};
        }
        if (!(o instanceof AssignmentListener)) {
            KafkaException fatalException = new KafkaException(String.format("%s is not an instance of %s", o.getClass().getName(), AssignmentListener.class.getName()));
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        return (AssignmentListener)o;
    }

    public static class AssignmentConfigs {
        public final long acceptableRecoveryLag;
        public final int maxWarmupReplicas;
        public final int numStandbyReplicas;
        public final long probingRebalanceIntervalMs;

        private AssignmentConfigs(StreamsConfig configs) {
            this.acceptableRecoveryLag = configs.getLong("acceptable.recovery.lag");
            this.maxWarmupReplicas = configs.getInt("max.warmup.replicas");
            this.numStandbyReplicas = configs.getInt("num.standby.replicas");
            this.probingRebalanceIntervalMs = configs.getLong("probing.rebalance.interval.ms");
        }

        AssignmentConfigs(Long acceptableRecoveryLag, Integer maxWarmupReplicas, Integer numStandbyReplicas, Long probingRebalanceIntervalMs) {
            this.acceptableRecoveryLag = AssignmentConfigs.validated("acceptable.recovery.lag", acceptableRecoveryLag);
            this.maxWarmupReplicas = AssignmentConfigs.validated("max.warmup.replicas", maxWarmupReplicas);
            this.numStandbyReplicas = AssignmentConfigs.validated("num.standby.replicas", numStandbyReplicas);
            this.probingRebalanceIntervalMs = AssignmentConfigs.validated("probing.rebalance.interval.ms", probingRebalanceIntervalMs);
        }

        private static <T> T validated(String configKey, T value) {
            ConfigDef.Validator validator = ((ConfigDef.ConfigKey)StreamsConfig.configDef().configKeys().get((Object)configKey)).validator;
            if (validator != null) {
                validator.ensureValid(configKey, value);
            }
            return value;
        }

        public String toString() {
            return "AssignmentConfigs{\n  acceptableRecoveryLag=" + this.acceptableRecoveryLag + "\n  maxWarmupReplicas=" + this.maxWarmupReplicas + "\n  numStandbyReplicas=" + this.numStandbyReplicas + "\n  probingRebalanceIntervalMs=" + this.probingRebalanceIntervalMs + "\n}";
        }
    }

    public static interface AssignmentListener {
        public void onAssignmentComplete(boolean var1);
    }
}

