/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.RocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedWindowStore;
import org.apache.kafka.streams.state.internals.RocksDBWindowStore;
import org.apache.kafka.streams.state.internals.WindowKeySchema;

public class RocksDbWindowBytesStoreSupplier
implements WindowBytesStoreSupplier {
    private final String name;
    private final long retentionPeriod;
    private final long segmentInterval;
    private final long windowSize;
    private final boolean retainDuplicates;
    private final boolean returnTimestampedStore;

    public RocksDbWindowBytesStoreSupplier(String name, long retentionPeriod, long segmentInterval, long windowSize, boolean retainDuplicates, boolean returnTimestampedStore) {
        this.name = name;
        this.retentionPeriod = retentionPeriod;
        this.segmentInterval = segmentInterval;
        this.windowSize = windowSize;
        this.retainDuplicates = retainDuplicates;
        this.returnTimestampedStore = returnTimestampedStore;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public WindowStore<Bytes, byte[]> get() {
        if (!this.returnTimestampedStore) {
            return new RocksDBWindowStore(new RocksDBSegmentedBytesStore(this.name, this.metricsScope(), this.retentionPeriod, this.segmentInterval, new WindowKeySchema()), this.retainDuplicates, this.windowSize);
        }
        return new RocksDBTimestampedWindowStore(new RocksDBTimestampedSegmentedBytesStore(this.name, this.metricsScope(), this.retentionPeriod, this.segmentInterval, new WindowKeySchema()), this.retainDuplicates, this.windowSize);
    }

    @Override
    public String metricsScope() {
        return "rocksdb-window";
    }

    @Override
    @Deprecated
    public int segments() {
        return (int)(this.retentionPeriod / this.segmentInterval) + 1;
    }

    @Override
    public long segmentIntervalMs() {
        return this.segmentInterval;
    }

    @Override
    public long windowSize() {
        return this.windowSize;
    }

    @Override
    public boolean retainDuplicates() {
        return this.retainDuplicates;
    }

    @Override
    public long retentionPeriod() {
        return this.retentionPeriod;
    }
}

