/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.ValueAndTimestampDeserializer;
import org.apache.kafka.streams.state.internals.ValueAndTimestampSerializer;

public class ValueAndTimestampSerde<V>
implements Serde<ValueAndTimestamp<V>> {
    private final ValueAndTimestampSerializer<V> valueAndTimestampSerializer;
    private final ValueAndTimestampDeserializer<V> valueAndTimestampDeserializer;

    public ValueAndTimestampSerde(Serde<V> valueSerde) {
        Objects.requireNonNull(valueSerde);
        this.valueAndTimestampSerializer = new ValueAndTimestampSerializer(valueSerde.serializer());
        this.valueAndTimestampDeserializer = new ValueAndTimestampDeserializer(valueSerde.deserializer());
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.valueAndTimestampSerializer.configure(configs, isKey);
        this.valueAndTimestampDeserializer.configure(configs, isKey);
    }

    public void close() {
        this.valueAndTimestampSerializer.close();
        this.valueAndTimestampDeserializer.close();
    }

    public Serializer<ValueAndTimestamp<V>> serializer() {
        return this.valueAndTimestampSerializer;
    }

    public Deserializer<ValueAndTimestamp<V>> deserializer() {
        return this.valueAndTimestampDeserializer;
    }
}

