/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

class ChangeLoggingWindowBytesStore
extends WrappedStateStore<WindowStore<Bytes, byte[]>, byte[], byte[]>
implements WindowStore<Bytes, byte[]> {
    private final boolean retainDuplicates;
    InternalProcessorContext context;
    private int seqnum = 0;

    ChangeLoggingWindowBytesStore(WindowStore<Bytes, byte[]> bytesStore, boolean retainDuplicates) {
        super(bytesStore);
        this.retainDuplicates = retainDuplicates;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.context = (InternalProcessorContext)context;
        super.init(context, root);
    }

    @Override
    public byte[] fetch(Bytes key, long timestamp) {
        return (byte[])((WindowStore)this.wrapped()).fetch(key, timestamp);
    }

    @Override
    public WindowStoreIterator<byte[]> fetch(Bytes key, long from, long to) {
        return ((WindowStore)this.wrapped()).fetch(key, from, to);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes keyFrom, Bytes keyTo, long from, long to) {
        return ((WindowStore)this.wrapped()).fetch(keyFrom, keyTo, from, to);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> all() {
        return ((WindowStore)this.wrapped()).all();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetchAll(long timeFrom, long timeTo) {
        return ((WindowStore)this.wrapped()).fetchAll(timeFrom, timeTo);
    }

    @Override
    @Deprecated
    public void put(Bytes key, byte[] value) {
        this.put(key, value, this.context.timestamp());
    }

    @Override
    public void put(Bytes key, byte[] value, long windowStartTimestamp) {
        ((WindowStore)this.wrapped()).put(key, value, windowStartTimestamp);
        this.log(WindowKeySchema.toStoreKeyBinary(key, windowStartTimestamp, this.maybeUpdateSeqnumForDups()), value);
    }

    void log(Bytes key, byte[] value) {
        this.context.logChange(this.name(), key, value, this.context.timestamp());
    }

    private int maybeUpdateSeqnumForDups() {
        if (this.retainDuplicates) {
            this.seqnum = this.seqnum + 1 & Integer.MAX_VALUE;
        }
        return this.seqnum;
    }
}

