/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.streams.kstream.Joined;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.internals.graph.BaseJoinProcessorNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.WindowStore;

public class StreamStreamJoinNode<K, V1, V2, VR>
extends BaseJoinProcessorNode<K, V1, V2, VR> {
    private final ProcessorParameters<K, V1, ?, ?> thisWindowedStreamProcessorParameters;
    private final ProcessorParameters<K, V2, ?, ?> otherWindowedStreamProcessorParameters;
    private final StoreBuilder<WindowStore<K, V1>> thisWindowStoreBuilder;
    private final StoreBuilder<WindowStore<K, V2>> otherWindowStoreBuilder;
    private final Joined<K, V1, V2> joined;

    private StreamStreamJoinNode(String nodeName, ValueJoiner<? super V1, ? super V2, ? extends VR> valueJoiner, ProcessorParameters<K, V1, ?, ?> joinThisProcessorParameters, ProcessorParameters<K, V2, ?, ?> joinOtherProcessParameters, ProcessorParameters<K, VR, ?, ?> joinMergeProcessorParameters, ProcessorParameters<K, V1, ?, ?> thisWindowedStreamProcessorParameters, ProcessorParameters<K, V2, ?, ?> otherWindowedStreamProcessorParameters, StoreBuilder<WindowStore<K, V1>> thisWindowStoreBuilder, StoreBuilder<WindowStore<K, V2>> otherWindowStoreBuilder, Joined<K, V1, V2> joined) {
        super(nodeName, valueJoiner, joinThisProcessorParameters, joinOtherProcessParameters, joinMergeProcessorParameters, null, null);
        this.thisWindowStoreBuilder = thisWindowStoreBuilder;
        this.otherWindowStoreBuilder = otherWindowStoreBuilder;
        this.joined = joined;
        this.thisWindowedStreamProcessorParameters = thisWindowedStreamProcessorParameters;
        this.otherWindowedStreamProcessorParameters = otherWindowedStreamProcessorParameters;
    }

    @Override
    public String toString() {
        return "StreamStreamJoinNode{thisWindowedStreamProcessorParameters=" + this.thisWindowedStreamProcessorParameters + ", otherWindowedStreamProcessorParameters=" + this.otherWindowedStreamProcessorParameters + ", thisWindowStoreBuilder=" + this.thisWindowStoreBuilder + ", otherWindowStoreBuilder=" + this.otherWindowStoreBuilder + ", joined=" + this.joined + "} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        String thisProcessorName = this.thisProcessorParameters().processorName();
        String otherProcessorName = this.otherProcessorParameters().processorName();
        String thisWindowedStreamProcessorName = this.thisWindowedStreamProcessorParameters.processorName();
        String otherWindowedStreamProcessorName = this.otherWindowedStreamProcessorParameters.processorName();
        topologyBuilder.addProcessor(thisProcessorName, this.thisProcessorParameters().processorSupplier(), thisWindowedStreamProcessorName);
        topologyBuilder.addProcessor(otherProcessorName, this.otherProcessorParameters().processorSupplier(), otherWindowedStreamProcessorName);
        topologyBuilder.addProcessor(this.mergeProcessorParameters().processorName(), this.mergeProcessorParameters().processorSupplier(), thisProcessorName, otherProcessorName);
        topologyBuilder.addStateStore(this.thisWindowStoreBuilder, thisWindowedStreamProcessorName, otherProcessorName);
        topologyBuilder.addStateStore(this.otherWindowStoreBuilder, otherWindowedStreamProcessorName, thisProcessorName);
    }

    public static <K, V1, V2, VR> StreamStreamJoinNodeBuilder<K, V1, V2, VR> streamStreamJoinNodeBuilder() {
        return new StreamStreamJoinNodeBuilder();
    }

    public static final class StreamStreamJoinNodeBuilder<K, V1, V2, VR> {
        private String nodeName;
        private ValueJoiner<? super V1, ? super V2, ? extends VR> valueJoiner;
        private ProcessorParameters<K, V1, ?, ?> joinThisProcessorParameters;
        private ProcessorParameters<K, V2, ?, ?> joinOtherProcessorParameters;
        private ProcessorParameters<K, VR, ?, ?> joinMergeProcessorParameters;
        private ProcessorParameters<K, V1, ?, ?> thisWindowedStreamProcessorParameters;
        private ProcessorParameters<K, V2, ?, ?> otherWindowedStreamProcessorParameters;
        private StoreBuilder<WindowStore<K, V1>> thisWindowStoreBuilder;
        private StoreBuilder<WindowStore<K, V2>> otherWindowStoreBuilder;
        private Joined<K, V1, V2> joined;

        private StreamStreamJoinNodeBuilder() {
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withValueJoiner(ValueJoiner<? super V1, ? super V2, ? extends VR> valueJoiner) {
            this.valueJoiner = valueJoiner;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withJoinThisProcessorParameters(ProcessorParameters<K, V1, ?, ?> joinThisProcessorParameters) {
            this.joinThisProcessorParameters = joinThisProcessorParameters;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withNodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withJoinOtherProcessorParameters(ProcessorParameters<K, V2, ?, ?> joinOtherProcessParameters) {
            this.joinOtherProcessorParameters = joinOtherProcessParameters;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withJoinMergeProcessorParameters(ProcessorParameters<K, VR, ?, ?> joinMergeProcessorParameters) {
            this.joinMergeProcessorParameters = joinMergeProcessorParameters;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withThisWindowedStreamProcessorParameters(ProcessorParameters<K, V1, ?, ?> thisWindowedStreamProcessorParameters) {
            this.thisWindowedStreamProcessorParameters = thisWindowedStreamProcessorParameters;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withOtherWindowedStreamProcessorParameters(ProcessorParameters<K, V2, ?, ?> otherWindowedStreamProcessorParameters) {
            this.otherWindowedStreamProcessorParameters = otherWindowedStreamProcessorParameters;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withThisWindowStoreBuilder(StoreBuilder<WindowStore<K, V1>> thisWindowStoreBuilder) {
            this.thisWindowStoreBuilder = thisWindowStoreBuilder;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withOtherWindowStoreBuilder(StoreBuilder<WindowStore<K, V2>> otherWindowStoreBuilder) {
            this.otherWindowStoreBuilder = otherWindowStoreBuilder;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withJoined(Joined<K, V1, V2> joined) {
            this.joined = joined;
            return this;
        }

        public StreamStreamJoinNode<K, V1, V2, VR> build() {
            return new StreamStreamJoinNode(this.nodeName, this.valueJoiner, this.joinThisProcessorParameters, this.joinOtherProcessorParameters, this.joinMergeProcessorParameters, this.thisWindowedStreamProcessorParameters, this.otherWindowedStreamProcessorParameters, this.thisWindowStoreBuilder, this.otherWindowStoreBuilder, this.joined);
        }
    }
}

