/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Objects;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableMaterializedValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.ForwardingDisabledProcessorContext;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;

class KTableTransformValues<K, V, V1>
implements KTableProcessorSupplier<K, V, V1> {
    private final KTableImpl<K, ?, V> parent;
    private final ValueTransformerWithKeySupplier<? super K, ? super V, ? extends V1> transformerSupplier;
    private final String queryableName;
    private boolean sendOldValues = false;

    KTableTransformValues(KTableImpl<K, ?, V> parent, ValueTransformerWithKeySupplier<? super K, ? super V, ? extends V1> transformerSupplier, String queryableName) {
        this.parent = Objects.requireNonNull(parent, "parent");
        this.transformerSupplier = Objects.requireNonNull(transformerSupplier, "transformerSupplier");
        this.queryableName = queryableName;
    }

    @Override
    public Processor<K, Change<V>> get() {
        return new KTableTransformValuesProcessor((ValueTransformerWithKey)this.transformerSupplier.get());
    }

    @Override
    public KTableValueGetterSupplier<K, V1> view() {
        if (this.queryableName != null) {
            return new KTableMaterializedValueGetterSupplier(this.queryableName);
        }
        return new KTableValueGetterSupplier<K, V1>(){
            final KTableValueGetterSupplier<K, V> parentValueGetterSupplier;
            {
                this.parentValueGetterSupplier = KTableTransformValues.this.parent.valueGetterSupplier();
            }

            @Override
            public KTableValueGetter<K, V1> get() {
                return new KTableTransformValuesGetter(this.parentValueGetterSupplier.get(), KTableTransformValues.this.transformerSupplier.get());
            }

            @Override
            public String[] storeNames() {
                return this.parentValueGetterSupplier.storeNames();
            }
        };
    }

    @Override
    public boolean enableSendingOldValues(boolean forceMaterialization) {
        if (this.queryableName != null) {
            this.sendOldValues = true;
            return true;
        }
        if (this.parent.enableSendingOldValues(forceMaterialization)) {
            this.sendOldValues = true;
        }
        return this.sendOldValues;
    }

    private class KTableTransformValuesGetter
    implements KTableValueGetter<K, V1> {
        private final KTableValueGetter<K, V> parentGetter;
        private final ValueTransformerWithKey<? super K, ? super V, ? extends V1> valueTransformer;

        KTableTransformValuesGetter(KTableValueGetter<K, V> parentGetter, ValueTransformerWithKey<? super K, ? super V, ? extends V1> valueTransformer) {
            this.parentGetter = Objects.requireNonNull(parentGetter, "parentGetter");
            this.valueTransformer = Objects.requireNonNull(valueTransformer, "valueTransformer");
        }

        @Override
        public void init(ProcessorContext context) {
            this.parentGetter.init(context);
            this.valueTransformer.init(new ForwardingDisabledProcessorContext(context));
        }

        @Override
        public ValueAndTimestamp<V1> get(K key) {
            ValueAndTimestamp valueAndTimestamp = this.parentGetter.get(key);
            return ValueAndTimestamp.make(this.valueTransformer.transform(key, ValueAndTimestamp.getValueOrNull(valueAndTimestamp)), valueAndTimestamp == null ? -1L : valueAndTimestamp.timestamp());
        }

        @Override
        public void close() {
            this.parentGetter.close();
            this.valueTransformer.close();
        }
    }

    private class KTableTransformValuesProcessor
    extends AbstractProcessor<K, Change<V>> {
        private final ValueTransformerWithKey<? super K, ? super V, ? extends V1> valueTransformer;
        private TimestampedKeyValueStore<K, V1> store;
        private TimestampedTupleForwarder<K, V1> tupleForwarder;

        private KTableTransformValuesProcessor(ValueTransformerWithKey<? super K, ? super V, ? extends V1> valueTransformer) {
            this.valueTransformer = Objects.requireNonNull(valueTransformer, "valueTransformer");
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.valueTransformer.init(new ForwardingDisabledProcessorContext(context));
            if (KTableTransformValues.this.queryableName != null) {
                this.store = (TimestampedKeyValueStore)context.getStateStore(KTableTransformValues.this.queryableName);
                this.tupleForwarder = new TimestampedTupleForwarder(this.store, context, new TimestampedCacheFlushListener(context), KTableTransformValues.this.sendOldValues);
            }
        }

        @Override
        public void process(K key, Change<V> change) {
            Object newValue = this.valueTransformer.transform(key, change.newValue);
            if (KTableTransformValues.this.queryableName == null) {
                Object oldValue = KTableTransformValues.this.sendOldValues ? (Object)this.valueTransformer.transform((Object)key, (Object)change.oldValue) : null;
                this.context().forward(key, new Change<Object>(newValue, oldValue));
            } else {
                Object oldValue = KTableTransformValues.this.sendOldValues ? (Object)ValueAndTimestamp.getValueOrNull((ValueAndTimestamp)this.store.get(key)) : null;
                this.store.put(key, ValueAndTimestamp.make(newValue, this.context().timestamp()));
                this.tupleForwarder.maybeForward(key, newValue, oldValue);
            }
        }

        @Override
        public void close() {
            this.valueTransformer.close();
        }
    }
}

