/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.WindowedSerdes;
import org.apache.kafka.streams.kstream.internals.WindowedSerializer;
import org.apache.kafka.streams.state.internals.WindowKeySchema;

public class TimeWindowedSerializer<T>
implements WindowedSerializer<T> {
    private Serializer<T> inner;

    public TimeWindowedSerializer() {
    }

    public TimeWindowedSerializer(Serializer<T> inner) {
        this.inner = inner;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        String windowedInnerClassSerdeConfig = (String)configs.get("windowed.inner.class.serde");
        Serde windowInnerClassSerde = null;
        if (windowedInnerClassSerdeConfig != null) {
            try {
                windowInnerClassSerde = (Serde)Utils.newInstance((String)windowedInnerClassSerdeConfig, Serde.class);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigException("windowed.inner.class.serde", (Object)windowedInnerClassSerdeConfig, "Serde class " + windowedInnerClassSerdeConfig + " could not be found.");
            }
        }
        if (this.inner != null && windowedInnerClassSerdeConfig != null) {
            if (!this.inner.getClass().getName().equals(windowInnerClassSerde.serializer().getClass().getName())) {
                throw new IllegalArgumentException("Inner class serializer set using constructor (" + this.inner.getClass().getName() + ") is different from the one set in windowed.inner.class.serde config (" + windowInnerClassSerde.serializer().getClass().getName() + ").");
            }
        } else {
            if (this.inner == null && windowedInnerClassSerdeConfig == null) {
                throw new IllegalArgumentException("Inner class serializer should be set either via constructor or via the windowed.inner.class.serde config");
            }
            if (this.inner == null) {
                this.inner = windowInnerClassSerde.serializer();
            }
        }
    }

    public byte[] serialize(String topic, Windowed<T> data) {
        WindowedSerdes.verifyInnerSerializerNotNull(this.inner, this);
        if (data == null) {
            return null;
        }
        return WindowKeySchema.toBinary(data, this.inner, topic);
    }

    public void close() {
        if (this.inner != null) {
            this.inner.close();
        }
    }

    @Override
    public byte[] serializeBaseKey(String topic, Windowed<T> data) {
        WindowedSerdes.verifyInnerSerializerNotNull(this.inner, this);
        return this.inner.serialize(topic, data.key());
    }

    Serializer<T> innerSerializer() {
        return this.inner;
    }
}

