/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.CogroupedKStream;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.SessionWindowedCogroupedKStream;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.SlidingWindows;
import org.apache.kafka.streams.kstream.TimeWindowedCogroupedKStream;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.AbstractStream;
import org.apache.kafka.streams.kstream.internals.CogroupedStreamAggregateBuilder;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.KGroupedStreamImpl;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.NamedInternal;
import org.apache.kafka.streams.kstream.internals.SessionWindowedCogroupedKStreamImpl;
import org.apache.kafka.streams.kstream.internals.SlidingWindowedCogroupedKStreamImpl;
import org.apache.kafka.streams.kstream.internals.TimeWindowedCogroupedKStreamImpl;
import org.apache.kafka.streams.kstream.internals.TimestampedKeyValueStoreMaterializer;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.state.KeyValueStore;

public class CogroupedKStreamImpl<K, VOut>
extends AbstractStream<K, VOut>
implements CogroupedKStream<K, VOut> {
    static final String AGGREGATE_NAME = "COGROUPKSTREAM-AGGREGATE-";
    static final String MERGE_NAME = "COGROUPKSTREAM-MERGE-";
    private final Map<KGroupedStreamImpl<K, ?>, Aggregator<? super K, ? super Object, VOut>> groupPatterns = new LinkedHashMap();
    private final CogroupedStreamAggregateBuilder<K, VOut> aggregateBuilder;

    CogroupedKStreamImpl(String name, Set<String> subTopologySourceNodes, GraphNode graphNode, InternalStreamsBuilder builder) {
        super(name, null, null, subTopologySourceNodes, graphNode, builder);
        this.aggregateBuilder = new CogroupedStreamAggregateBuilder(builder);
    }

    @Override
    public <VIn> CogroupedKStream<K, VOut> cogroup(KGroupedStream<K, VIn> groupedStream, Aggregator<? super K, ? super VIn, VOut> aggregator) {
        Objects.requireNonNull(groupedStream, "groupedStream can't be null");
        Objects.requireNonNull(aggregator, "aggregator can't be null");
        this.groupPatterns.put((KGroupedStreamImpl)groupedStream, aggregator);
        return this;
    }

    @Override
    public KTable<K, VOut> aggregate(Initializer<VOut> initializer, Materialized<K, VOut, KeyValueStore<Bytes, byte[]>> materialized) {
        return this.aggregate(initializer, NamedInternal.empty(), materialized);
    }

    @Override
    public KTable<K, VOut> aggregate(Initializer<VOut> initializer, Named named) {
        return this.aggregate(initializer, named, Materialized.with(this.keySerde, null));
    }

    @Override
    public KTable<K, VOut> aggregate(Initializer<VOut> initializer, Named named, Materialized<K, VOut, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(initializer, "initializer can't be null");
        Objects.requireNonNull(named, "named can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        return this.doAggregate(initializer, new NamedInternal(named), new MaterializedInternal<K, VOut, KeyValueStore<Bytes, byte[]>>(materialized, this.builder, AGGREGATE_NAME));
    }

    @Override
    public KTable<K, VOut> aggregate(Initializer<VOut> initializer) {
        return this.aggregate(initializer, Materialized.with(this.keySerde, null));
    }

    @Override
    public <W extends Window> TimeWindowedCogroupedKStream<K, VOut> windowedBy(Windows<W> windows) {
        Objects.requireNonNull(windows, "windows can't be null");
        return new TimeWindowedCogroupedKStreamImpl(windows, this.builder, this.subTopologySourceNodes, this.name, this.aggregateBuilder, this.graphNode, this.groupPatterns);
    }

    @Override
    public TimeWindowedCogroupedKStream<K, VOut> windowedBy(SlidingWindows slidingWindows) {
        Objects.requireNonNull(slidingWindows, "slidingWindows can't be null");
        return new SlidingWindowedCogroupedKStreamImpl(slidingWindows, this.builder, this.subTopologySourceNodes, this.name, this.aggregateBuilder, this.graphNode, this.groupPatterns);
    }

    @Override
    public SessionWindowedCogroupedKStream<K, VOut> windowedBy(SessionWindows sessionWindows) {
        Objects.requireNonNull(sessionWindows, "sessionWindows can't be null");
        return new SessionWindowedCogroupedKStreamImpl(sessionWindows, this.builder, this.subTopologySourceNodes, this.name, this.aggregateBuilder, this.graphNode, this.groupPatterns);
    }

    private KTable<K, VOut> doAggregate(Initializer<VOut> initializer, NamedInternal named, MaterializedInternal<K, VOut, KeyValueStore<Bytes, byte[]>> materializedInternal) {
        return this.aggregateBuilder.build(this.groupPatterns, initializer, named, new TimestampedKeyValueStoreMaterializer<K, VOut>(materializedInternal).materialize(), materializedInternal.keySerde(), materializedInternal.valueSerde(), materializedInternal.queryableStoreName());
    }
}

