/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;

class KStreamMapValues<KIn, VIn, VOut>
implements ProcessorSupplier<KIn, VIn, KIn, VOut> {
    private final ValueMapperWithKey<KIn, VIn, VOut> mapper;

    public KStreamMapValues(ValueMapperWithKey<KIn, VIn, VOut> mapper) {
        this.mapper = mapper;
    }

    @Override
    public Processor<KIn, VIn, KIn, VOut> get() {
        return new KStreamMapProcessor();
    }

    private class KStreamMapProcessor
    extends ContextualProcessor<KIn, VIn, KIn, VOut> {
        private KStreamMapProcessor() {
        }

        @Override
        public void process(Record<KIn, VIn> record) {
            Object newValue = KStreamMapValues.this.mapper.apply(record.key(), record.value());
            this.context().forward(record.withValue(newValue));
        }
    }
}

