/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.util.Objects;

public class CombinedKey<KF, KP> {
    private final KF foreignKey;
    private final KP primaryKey;

    CombinedKey(KF foreignKey, KP primaryKey) {
        Objects.requireNonNull(foreignKey, "foreignKey can't be null");
        Objects.requireNonNull(primaryKey, "primaryKey can't be null");
        this.foreignKey = foreignKey;
        this.primaryKey = primaryKey;
    }

    public KF getForeignKey() {
        return this.foreignKey;
    }

    public KP getPrimaryKey() {
        return this.primaryKey;
    }

    public boolean equals(KF foreignKey, KP primaryKey) {
        return this.foreignKey.equals(foreignKey) && this.primaryKey.equals(primaryKey);
    }

    public String toString() {
        return "CombinedKey{foreignKey=" + this.foreignKey + ", primaryKey=" + this.primaryKey + '}';
    }
}

