/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ProcessorMetadata {
    private final Map<String, Long> metadata;
    private boolean needsCommit;

    public ProcessorMetadata() {
        this(new HashMap<String, Long>());
    }

    public ProcessorMetadata(Map<String, Long> metadata) {
        this.metadata = metadata;
        this.needsCommit = false;
    }

    public static ProcessorMetadata deserialize(byte[] metaDataBytes) {
        if (metaDataBytes == null || metaDataBytes.length == 0) {
            return new ProcessorMetadata();
        }
        ByteBuffer buffer = ByteBuffer.wrap(metaDataBytes);
        int entrySize = buffer.getInt();
        HashMap<String, Long> metadata = new HashMap<String, Long>(entrySize);
        for (int i = 0; i < entrySize; ++i) {
            int keySize = buffer.getInt();
            byte[] keyBytes = new byte[keySize];
            buffer.get(keyBytes);
            Long value = buffer.getLong();
            metadata.put(new String(keyBytes, StandardCharsets.UTF_8), value);
        }
        return new ProcessorMetadata(metadata);
    }

    public byte[] serialize() {
        if (this.metadata.isEmpty()) {
            return new byte[0];
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] mapSizeBytes = ByteBuffer.allocate(4).putInt(this.metadata.size()).array();
        outputStream.write(mapSizeBytes, 0, mapSizeBytes.length);
        for (Map.Entry<String, Long> entry : this.metadata.entrySet()) {
            byte[] keyBytes = entry.getKey().getBytes(StandardCharsets.UTF_8);
            int keyLen = keyBytes.length;
            byte[] buffer = ByteBuffer.allocate(4 + keyBytes.length + 8).putInt(keyLen).put(keyBytes).putLong(entry.getValue()).array();
            outputStream.write(buffer, 0, buffer.length);
        }
        return outputStream.toByteArray();
    }

    public void put(String key, long value) {
        this.metadata.put(key, value);
        this.needsCommit = true;
    }

    public Long get(String key) {
        return this.metadata.get(key);
    }

    public void update(ProcessorMetadata other) {
        if (other == null) {
            return;
        }
        for (Map.Entry<String, Long> kv : other.metadata.entrySet()) {
            Long value = this.metadata.get(kv.getKey());
            if (value != null && value >= kv.getValue()) continue;
            this.metadata.put(kv.getKey(), kv.getValue());
        }
    }

    public void setNeedsCommit(boolean needsCommit) {
        this.needsCommit = needsCommit;
    }

    public boolean needsCommit() {
        return this.needsCommit;
    }

    public int hashCode() {
        return Objects.hashCode(this.metadata);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.metadata.equals(((ProcessorMetadata)obj).metadata);
    }
}

