/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.TimestampedBytesStore;

class KeyValueToTimestampedKeyValueIteratorAdapter<K>
implements KeyValueIterator<K, byte[]> {
    private final KeyValueIterator<K, byte[]> innerIterator;

    KeyValueToTimestampedKeyValueIteratorAdapter(KeyValueIterator<K, byte[]> innerIterator) {
        this.innerIterator = innerIterator;
    }

    @Override
    public void close() {
        this.innerIterator.close();
    }

    @Override
    public K peekNextKey() {
        return this.innerIterator.peekNextKey();
    }

    @Override
    public boolean hasNext() {
        return this.innerIterator.hasNext();
    }

    @Override
    public KeyValue<K, byte[]> next() {
        KeyValue plainKeyValue = (KeyValue)this.innerIterator.next();
        return KeyValue.pair(plainKeyValue.key, TimestampedBytesStore.convertToTimestampedFormat((byte[])plainKeyValue.value));
    }
}

