/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.CircularIterator;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.NamedCache;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.slf4j.Logger;

public class ThreadCache {
    private final Logger log;
    private volatile long maxCacheSizeBytes;
    private final StreamsMetricsImpl metrics;
    private final Map<String, NamedCache> caches = new HashMap<String, NamedCache>();
    private final AtomicLong sizeInBytes = new AtomicLong();
    private long numPuts = 0L;
    private long numGets = 0L;
    private long numEvicts = 0L;
    private long numFlushes = 0L;

    public ThreadCache(LogContext logContext, long maxCacheSizeBytes, StreamsMetricsImpl metrics) {
        this.maxCacheSizeBytes = maxCacheSizeBytes;
        this.metrics = metrics;
        this.log = logContext.logger(this.getClass());
    }

    public long puts() {
        return this.numPuts;
    }

    public long gets() {
        return this.numGets;
    }

    public long evicts() {
        return this.numEvicts;
    }

    public long flushes() {
        return this.numFlushes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resize(long newCacheSizeBytes) {
        boolean shrink = newCacheSizeBytes < this.maxCacheSizeBytes;
        this.maxCacheSizeBytes = newCacheSizeBytes;
        if (shrink) {
            this.log.debug("Cache size was shrunk to {}", (Object)newCacheSizeBytes);
            if (this.caches.values().isEmpty()) {
                return;
            }
            CircularIterator circularIterator = new CircularIterator(this.caches.values());
            while (this.sizeInBytes.get() > this.maxCacheSizeBytes) {
                NamedCache cache;
                NamedCache namedCache = cache = (NamedCache)circularIterator.next();
                synchronized (namedCache) {
                    long oldSize = cache.sizeInBytes();
                    cache.evict();
                    this.sizeInBytes.getAndAdd(cache.sizeInBytes() - oldSize);
                }
                ++this.numEvicts;
            }
        } else {
            this.log.debug("Cache size was expanded to {}", (Object)newCacheSizeBytes);
        }
    }

    public static String nameSpaceFromTaskIdAndStore(String taskIDString, String underlyingStoreName) {
        return taskIDString + "-" + underlyingStoreName;
    }

    public static String taskIDfromCacheName(String cacheName) {
        String[] tokens = cacheName.split("-", 2);
        return tokens[0];
    }

    public static String underlyingStoreNamefromCacheName(String cacheName) {
        String[] tokens = cacheName.split("-", 2);
        return tokens[1];
    }

    public void addDirtyEntryFlushListener(String namespace, DirtyEntryFlushListener listener) {
        NamedCache cache = this.getOrCreateCache(namespace);
        cache.setListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(String namespace) {
        ++this.numFlushes;
        NamedCache cache = this.getCache(namespace);
        if (cache == null) {
            return;
        }
        NamedCache namedCache = cache;
        synchronized (namedCache) {
            long oldSize = cache.sizeInBytes();
            cache.flush();
            this.sizeInBytes.getAndAdd(cache.sizeInBytes() - oldSize);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Cache stats on flush: #puts={}, #gets={}, #evicts={}, #flushes={}", new Object[]{this.puts(), this.gets(), this.evicts(), this.flushes()});
        }
    }

    public LRUCacheEntry get(String namespace, Bytes key) {
        ++this.numGets;
        if (key == null) {
            return null;
        }
        NamedCache cache = this.getCache(namespace);
        if (cache == null) {
            return null;
        }
        return cache.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String namespace, Bytes key, LRUCacheEntry value) {
        NamedCache cache;
        ++this.numPuts;
        NamedCache namedCache = cache = this.getOrCreateCache(namespace);
        synchronized (namedCache) {
            long oldSize = cache.sizeInBytes();
            cache.put(key, value);
            this.sizeInBytes.getAndAdd(cache.sizeInBytes() - oldSize);
            this.maybeEvict(namespace, cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LRUCacheEntry putIfAbsent(String namespace, Bytes key, LRUCacheEntry value) {
        LRUCacheEntry result;
        NamedCache cache;
        NamedCache namedCache = cache = this.getOrCreateCache(namespace);
        synchronized (namedCache) {
            long oldSize = cache.sizeInBytes();
            result = cache.putIfAbsent(key, value);
            this.sizeInBytes.getAndAdd(cache.sizeInBytes() - oldSize);
            this.maybeEvict(namespace, cache);
        }
        if (result == null) {
            ++this.numPuts;
        }
        return result;
    }

    public void putAll(String namespace, List<KeyValue<Bytes, LRUCacheEntry>> entries) {
        for (KeyValue<Bytes, LRUCacheEntry> entry : entries) {
            this.put(namespace, (Bytes)entry.key, (LRUCacheEntry)entry.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LRUCacheEntry delete(String namespace, Bytes key) {
        LRUCacheEntry entry;
        NamedCache cache = this.getCache(namespace);
        if (cache == null) {
            return null;
        }
        NamedCache namedCache = cache;
        synchronized (namedCache) {
            long oldSize = cache.sizeInBytes();
            entry = cache.delete(key);
            this.sizeInBytes.getAndAdd(cache.sizeInBytes() - oldSize);
        }
        return entry;
    }

    public MemoryLRUCacheBytesIterator range(String namespace, Bytes from, Bytes to) {
        return this.range(namespace, from, to, true);
    }

    public MemoryLRUCacheBytesIterator range(String namespace, Bytes from, Bytes to, boolean toInclusive) {
        NamedCache cache = this.getCache(namespace);
        if (cache == null) {
            return new MemoryLRUCacheBytesIterator(Collections.emptyIterator(), new NamedCache(namespace, this.metrics));
        }
        return new MemoryLRUCacheBytesIterator(cache.keyRange(from, to, toInclusive), cache);
    }

    public MemoryLRUCacheBytesIterator reverseRange(String namespace, Bytes from, Bytes to) {
        NamedCache cache = this.getCache(namespace);
        if (cache == null) {
            return new MemoryLRUCacheBytesIterator(Collections.emptyIterator(), new NamedCache(namespace, this.metrics));
        }
        return new MemoryLRUCacheBytesIterator(cache.reverseKeyRange(from, to), cache);
    }

    public MemoryLRUCacheBytesIterator all(String namespace) {
        NamedCache cache = this.getCache(namespace);
        if (cache == null) {
            return new MemoryLRUCacheBytesIterator(Collections.emptyIterator(), new NamedCache(namespace, this.metrics));
        }
        return new MemoryLRUCacheBytesIterator(cache.allKeys(), cache);
    }

    public MemoryLRUCacheBytesIterator reverseAll(String namespace) {
        NamedCache cache = this.getCache(namespace);
        if (cache == null) {
            return new MemoryLRUCacheBytesIterator(Collections.emptyIterator(), new NamedCache(namespace, this.metrics));
        }
        return new MemoryLRUCacheBytesIterator(cache.reverseAllKeys(), cache);
    }

    public long size() {
        long size = 0L;
        for (NamedCache cache : this.caches.values()) {
            if (!this.isOverflowing(size += cache.size())) continue;
            return Long.MAX_VALUE;
        }
        return size;
    }

    private boolean isOverflowing(long size) {
        return size < 0L;
    }

    long sizeBytes() {
        return this.sizeInBytes.get();
    }

    synchronized void close(String namespace) {
        NamedCache removed = this.caches.remove(namespace);
        if (removed != null) {
            this.sizeInBytes.getAndAdd(-removed.sizeInBytes());
            removed.close();
        }
    }

    private void maybeEvict(String namespace, NamedCache cache) {
        int numEvicted = 0;
        while (this.sizeInBytes.get() > this.maxCacheSizeBytes) {
            if (cache.isEmpty()) {
                return;
            }
            long oldSize = cache.sizeInBytes();
            cache.evict();
            this.sizeInBytes.getAndAdd(cache.sizeInBytes() - oldSize);
            ++this.numEvicts;
            ++numEvicted;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Evicted {} entries from cache {}", (Object)numEvicted, (Object)namespace);
        }
    }

    private synchronized NamedCache getCache(String namespace) {
        return this.caches.get(namespace);
    }

    private synchronized NamedCache getOrCreateCache(String name) {
        NamedCache cache = this.caches.get(name);
        if (cache == null) {
            cache = new NamedCache(name, this.metrics);
            this.caches.put(name, cache);
        }
        return cache;
    }

    static class DirtyEntry {
        private final Bytes key;
        private final byte[] newValue;
        private final LRUCacheEntry recordContext;

        DirtyEntry(Bytes key, byte[] newValue, LRUCacheEntry recordContext) {
            this.key = key;
            this.newValue = newValue;
            this.recordContext = recordContext;
        }

        public Bytes key() {
            return this.key;
        }

        public byte[] newValue() {
            return this.newValue;
        }

        public LRUCacheEntry entry() {
            return this.recordContext;
        }
    }

    static class MemoryLRUCacheBytesIterator
    implements PeekingKeyValueIterator<Bytes, LRUCacheEntry> {
        private final Iterator<Bytes> keys;
        private final NamedCache cache;
        private KeyValue<Bytes, LRUCacheEntry> nextEntry;

        MemoryLRUCacheBytesIterator(Iterator<Bytes> keys, NamedCache cache) {
            this.keys = keys;
            this.cache = cache;
        }

        @Override
        public Bytes peekNextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (Bytes)this.nextEntry.key;
        }

        @Override
        public KeyValue<Bytes, LRUCacheEntry> peekNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextEntry;
        }

        @Override
        public boolean hasNext() {
            if (this.nextEntry != null) {
                return true;
            }
            while (this.keys.hasNext() && this.nextEntry == null) {
                this.internalNext();
            }
            return this.nextEntry != null;
        }

        @Override
        public KeyValue<Bytes, LRUCacheEntry> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            KeyValue<Bytes, LRUCacheEntry> result = this.nextEntry;
            this.nextEntry = null;
            return result;
        }

        private void internalNext() {
            Bytes cacheKey = this.keys.next();
            LRUCacheEntry entry = this.cache.get(cacheKey);
            if (entry == null) {
                return;
            }
            this.nextEntry = new KeyValue<Bytes, LRUCacheEntry>(cacheKey, entry);
        }

        @Override
        public void close() {
        }
    }

    public static interface DirtyEntryFlushListener {
        public void apply(List<DirtyEntry> var1);
    }
}

