/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.InMemoryWindowStore;

public class InMemoryWindowBytesStoreSupplier
implements WindowBytesStoreSupplier {
    private final String name;
    private final long retentionPeriod;
    private final long windowSize;
    private final boolean retainDuplicates;

    public InMemoryWindowBytesStoreSupplier(String name, long retentionPeriod, long windowSize, boolean retainDuplicates) {
        this.name = name;
        this.retentionPeriod = retentionPeriod;
        this.windowSize = windowSize;
        this.retainDuplicates = retainDuplicates;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public WindowStore<Bytes, byte[]> get() {
        return new InMemoryWindowStore(this.name, this.retentionPeriod, this.windowSize, this.retainDuplicates, this.metricsScope());
    }

    @Override
    public String metricsScope() {
        return "in-memory-window";
    }

    @Override
    public long retentionPeriod() {
        return this.retentionPeriod;
    }

    @Override
    public long windowSize() {
        return this.windowSize;
    }

    @Override
    public long segmentIntervalMs() {
        return 1L;
    }

    @Override
    public boolean retainDuplicates() {
        return this.retainDuplicates;
    }

    public String toString() {
        return "InMemoryWindowBytesStoreSupplier{name='" + this.name + '\'' + ", retentionPeriod=" + this.retentionPeriod + ", windowSize=" + this.windowSize + ", retainDuplicates=" + this.retainDuplicates + '}';
    }
}

