/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class Position {
    private final ConcurrentHashMap<String, ConcurrentHashMap<Integer, Long>> position;

    private Position(ConcurrentHashMap<String, ConcurrentHashMap<Integer, Long>> position) {
        this.position = position;
    }

    public static Position emptyPosition() {
        return new Position(new ConcurrentHashMap<String, ConcurrentHashMap<Integer, Long>>());
    }

    public static Position fromMap(Map<String, ? extends Map<Integer, Long>> map) {
        return new Position(Position.deepCopy(map));
    }

    public Position withComponent(String topic, int partition, long offset) {
        this.position.computeIfAbsent(topic, k -> new ConcurrentHashMap()).compute(partition, (integer, prior) -> prior == null || offset > prior ? offset : prior);
        return this;
    }

    public Position copy() {
        return new Position(Position.deepCopy(this.position));
    }

    public Position merge(Position other) {
        if (other == null) {
            return this;
        }
        for (Map.Entry<String, ConcurrentHashMap<Integer, Long>> entry : other.position.entrySet()) {
            String topic = entry.getKey();
            Map partitionMap = this.position.computeIfAbsent(topic, k -> new ConcurrentHashMap());
            for (Map.Entry<Integer, Long> partitionOffset : entry.getValue().entrySet()) {
                Integer partition = partitionOffset.getKey();
                Long offset = partitionOffset.getValue();
                if (partitionMap.containsKey(partition) && (Long)partitionMap.get(partition) >= offset) continue;
                partitionMap.put(partition, offset);
            }
        }
        return this;
    }

    public Set<String> getTopics() {
        return Collections.unmodifiableSet(this.position.keySet());
    }

    public Map<Integer, Long> getPartitionPositions(String topic) {
        ConcurrentHashMap<Integer, Long> bound = this.position.get(topic);
        return bound == null ? Collections.emptyMap() : Collections.unmodifiableMap(bound);
    }

    private static ConcurrentHashMap<String, ConcurrentHashMap<Integer, Long>> deepCopy(Map<String, ? extends Map<Integer, Long>> map) {
        if (map == null) {
            return new ConcurrentHashMap<String, ConcurrentHashMap<Integer, Long>>();
        }
        ConcurrentHashMap<String, ConcurrentHashMap<Integer, Long>> copy = new ConcurrentHashMap<String, ConcurrentHashMap<Integer, Long>>(map.size());
        for (Map.Entry<String, ? extends Map<Integer, Long>> entry : map.entrySet()) {
            copy.put(entry.getKey(), new ConcurrentHashMap<Integer, Long>(entry.getValue()));
        }
        return copy;
    }

    public String toString() {
        return "Position{position=" + this.position + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Position position1 = (Position)o;
        return Objects.equals(this.position, position1.position);
    }

    public int hashCode() {
        throw new UnsupportedOperationException("This mutable object is not suitable as a hash key");
    }

    public boolean isEmpty() {
        return this.position.isEmpty();
    }
}

