/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.api;

import java.io.File;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.ClientUtils;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;

public class MockProcessorContext<KForward, VForward>
implements ProcessorContext<KForward, VForward>,
RecordCollector.Supplier {
    private final StreamsMetricsImpl metrics;
    private final TaskId taskId;
    private final StreamsConfig config;
    private final File stateDir;
    private MockRecordMetadata recordMetadata;
    private final Map<String, StateStore> stateStores = new HashMap<String, StateStore>();
    private final List<CapturedPunctuator> punctuators = new LinkedList<CapturedPunctuator>();
    private final List<CapturedForward<? extends KForward, ? extends VForward>> capturedForwards = new LinkedList<CapturedForward<? extends KForward, ? extends VForward>>();
    private boolean committed = false;

    public MockProcessorContext() {
        this(Utils.mkProperties((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)""), Utils.mkEntry((Object)"bootstrap.servers", (Object)"")})), new TaskId(0, 0), null);
    }

    public MockProcessorContext(Properties config) {
        this(config, new TaskId(0, 0), null);
    }

    public MockProcessorContext(Properties config, TaskId taskId, File stateDir) {
        Properties configCopy = new Properties();
        configCopy.putAll((Map<?, ?>)config);
        if (!configCopy.containsKey("bootstrap.servers")) {
            configCopy.setProperty("bootstrap.servers", "dummy-bootstrap-host:0");
        }
        if (!configCopy.containsKey("application.id")) {
            configCopy.setProperty("application.id", "dummy-mock-app-id");
        }
        ClientUtils.QuietStreamsConfig streamsConfig = new ClientUtils.QuietStreamsConfig((Map)configCopy);
        this.taskId = taskId;
        this.config = streamsConfig;
        this.stateDir = stateDir;
        MetricConfig metricConfig = new MetricConfig();
        metricConfig.recordLevel(Sensor.RecordingLevel.DEBUG);
        String threadId = Thread.currentThread().getName();
        this.metrics = new StreamsMetricsImpl(new Metrics(metricConfig), threadId, streamsConfig.getString("built.in.metrics.version"), Time.SYSTEM);
        TaskMetrics.droppedRecordsSensorOrSkippedRecordsSensor((String)threadId, (String)taskId.toString(), (StreamsMetricsImpl)this.metrics);
    }

    public String applicationId() {
        return this.config.getString("application.id");
    }

    public TaskId taskId() {
        return this.taskId;
    }

    public Map<String, Object> appConfigs() {
        HashMap<String, Object> combined = new HashMap<String, Object>();
        combined.putAll(this.config.originals());
        combined.putAll(this.config.values());
        return combined;
    }

    public Map<String, Object> appConfigsWithPrefix(String prefix) {
        return this.config.originalsWithPrefix(prefix);
    }

    public Serde<?> keySerde() {
        return this.config.defaultKeySerde();
    }

    public Serde<?> valueSerde() {
        return this.config.defaultValueSerde();
    }

    public File stateDir() {
        return Objects.requireNonNull(this.stateDir, "The stateDir constructor argument was needed (probably for a state store) but not supplied. You can either reconfigure your test so that it doesn't need access to the disk (such as using an in-memory store), or use the full MockProcessorContext constructor to supply a non-null stateDir argument.");
    }

    public StreamsMetrics metrics() {
        return this.metrics;
    }

    public void setRecordMetadata(String topic, int partition, long offset) {
        this.recordMetadata = new MockRecordMetadata(topic, partition, offset);
    }

    public Optional<RecordMetadata> recordMetadata() {
        return Optional.ofNullable(this.recordMetadata);
    }

    public <S extends StateStore> S getStateStore(String name) {
        return (S)this.stateStores.get(name);
    }

    public <S extends StateStore> void addStateStore(S stateStore) {
        this.stateStores.put(stateStore.name(), stateStore);
    }

    public Cancellable schedule(Duration interval, PunctuationType type, Punctuator callback) {
        CapturedPunctuator capturedPunctuator = new CapturedPunctuator(interval, type, callback);
        this.punctuators.add(capturedPunctuator);
        return capturedPunctuator::cancel;
    }

    public List<CapturedPunctuator> scheduledPunctuators() {
        return new LinkedList<CapturedPunctuator>(this.punctuators);
    }

    public <K extends KForward, V extends VForward> void forward(Record<K, V> record) {
        this.forward(record, null);
    }

    public <K extends KForward, V extends VForward> void forward(Record<K, V> record, String childName) {
        this.capturedForwards.add(new CapturedForward<K, V>(record, Optional.ofNullable(childName)));
    }

    public List<CapturedForward<? extends KForward, ? extends VForward>> forwarded() {
        return new LinkedList<CapturedForward<? extends KForward, ? extends VForward>>(this.capturedForwards);
    }

    public List<CapturedForward<? extends KForward, ? extends VForward>> forwarded(String childName) {
        LinkedList<CapturedForward<KForward, VForward>> result = new LinkedList<CapturedForward<KForward, VForward>>();
        for (CapturedForward<KForward, VForward> capture : this.capturedForwards) {
            if (capture.childName().isPresent() && !capture.childName().equals(Optional.of(childName))) continue;
            result.add(capture);
        }
        return result;
    }

    public void resetForwards() {
        this.capturedForwards.clear();
    }

    public void commit() {
        this.committed = true;
    }

    public boolean committed() {
        return this.committed;
    }

    public void resetCommit() {
        this.committed = false;
    }

    public RecordCollector recordCollector() {
        throw new UnsupportedOperationException("MockProcessorContext does not provide record collection. For processor unit tests, use an in-memory state store with change-logging disabled. Alternatively, use the TopologyTestDriver for testing processor/store/topology integration.");
    }

    public StateStoreContext getStateStoreContext() {
        return new StateStoreContext(){

            public String applicationId() {
                return MockProcessorContext.this.applicationId();
            }

            public TaskId taskId() {
                return MockProcessorContext.this.taskId();
            }

            public Serde<?> keySerde() {
                return MockProcessorContext.this.keySerde();
            }

            public Serde<?> valueSerde() {
                return MockProcessorContext.this.valueSerde();
            }

            public File stateDir() {
                return MockProcessorContext.this.stateDir();
            }

            public StreamsMetrics metrics() {
                return MockProcessorContext.this.metrics();
            }

            public void register(StateStore store, StateRestoreCallback stateRestoreCallback) {
                MockProcessorContext.this.stateStores.put(store.name(), store);
            }

            public Map<String, Object> appConfigs() {
                return MockProcessorContext.this.appConfigs();
            }

            public Map<String, Object> appConfigsWithPrefix(String prefix) {
                return MockProcessorContext.this.appConfigsWithPrefix(prefix);
            }
        };
    }

    public static final class CapturedForward<K, V> {
        private final Record<K, V> record;
        private final Optional<String> childName;

        public CapturedForward(Record<K, V> record) {
            this(record, Optional.empty());
        }

        public CapturedForward(Record<K, V> record, Optional<String> childName) {
            this.record = Objects.requireNonNull(record);
            this.childName = Objects.requireNonNull(childName);
        }

        public Optional<String> childName() {
            return this.childName;
        }

        public Record<K, V> record() {
            return this.record;
        }

        public String toString() {
            return "CapturedForward{record=" + this.record + ", childName=" + this.childName + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CapturedForward that = (CapturedForward)o;
            return Objects.equals(this.record, that.record) && Objects.equals(this.childName, that.childName);
        }

        public int hashCode() {
            return Objects.hash(this.record, this.childName);
        }
    }

    public static final class CapturedPunctuator {
        private final Duration interval;
        private final PunctuationType type;
        private final Punctuator punctuator;
        private boolean cancelled = false;

        private CapturedPunctuator(Duration interval, PunctuationType type, Punctuator punctuator) {
            this.interval = interval;
            this.type = type;
            this.punctuator = punctuator;
        }

        public Duration getInterval() {
            return this.interval;
        }

        public PunctuationType getType() {
            return this.type;
        }

        public Punctuator getPunctuator() {
            return this.punctuator;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public boolean cancelled() {
            return this.cancelled;
        }
    }

    private static final class MockRecordMetadata
    implements RecordMetadata {
        private final String topic;
        private final int partition;
        private final long offset;

        private MockRecordMetadata(String topic, int partition, long offset) {
            this.topic = topic;
            this.partition = partition;
            this.offset = offset;
        }

        public String topic() {
            return this.topic;
        }

        public int partition() {
            return this.partition;
        }

        public long offset() {
            return this.offset;
        }
    }
}

