/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.admin.AdminUtils$;
import kafka.admin.DeleteConsumerGroupTest$;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.message.MessageAndMetadata;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u0001\u001d\u0011q\u0003R3mKR,7i\u001c8tk6,'o\u0012:pkB$Vm\u001d;\u000b\u0005\r!\u0011!B1e[&t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\n\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u0011!BS+oSR\u001cV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)B!A\u0006j]R,wM]1uS>t\u0017BA\f\u0015\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u0015q\u0002\u0001\"\u0001 \u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cH#\u0001\u0011\u0011\u0007\u0005ZcF\u0004\u0002#Q9\u00111EJ\u0007\u0002I)\u0011QEB\u0001\u0007yI|w\u000e\u001e \n\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0016\u0002\u000fA\f7m[1hK*\tq%\u0003\u0002-[\t\u00191+Z9\u000b\u0005%R\u0003CA\u00183\u001b\u0005\u0001$BA\u0019\u0005\u0003\u0019\u0019XM\u001d<fe&\u00111\u0007\r\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u00036\u0001\u0011\u0005a'A\fuKN$xI]8va^KG-\u001a#fY\u0016$X-\u00138[\u0017R\tq\u0007\u0005\u00029s5\t!&\u0003\u0002;U\t!QK\\5uQ\t!D\b\u0005\u0002>\u007f5\taH\u0003\u0002\f\u001d%\u0011\u0001I\u0010\u0002\u0005)\u0016\u001cH\u000fC\u0003C\u0001\u0011\u0005a'\u0001\u001duKN$xI]8va^KG-\u001a#fY\u0016$X-\u00138[\u0017\u0012{Wm\u001d(pi\"Lgn\u001a$pe\u0006\u001bG/\u001b<f\u0007>t7/^7fe\u001e\u0013x.\u001e9)\u0005\u0005c\u0004\"B#\u0001\t\u00031\u0014!\u000e;fgR<%o\\;q)>\u0004\u0018nY,jI\u0016$U\r\\3uK&s'l\u0013$pe\u001e\u0013x.\u001e9D_:\u001cX/\\5oO>sW\rV8qS\u000eD#\u0001\u0012\u001f\t\u000b!\u0003A\u0011\u0001\u001c\u0002wQ,7\u000f^$s_V\u0004Hk\u001c9jG^KG-\u001a#fY\u0016$X-\u00138[\u0017\u001a{'o\u0012:pkB\u001cuN\\:v[&tw-T;mi&\u0004H.\u001a+pa&\u001c7\u000f\u000b\u0002Hy!)1\n\u0001C\u0001m\u0005aE/Z:u\u000fJ|W\u000f\u001d+pa&\u001cw+\u001b3f\t\u0016dW\r^3J]j[Ei\\3t\u001d>$\b.\u001b8h\r>\u0014\u0018i\u0019;jm\u0016<%o\\;q\u0007>t7/^7j]\u001elU\u000f\u001c;ja2,Gk\u001c9jGND#A\u0013\u001f\t\u000b9\u0003A\u0011\u0001\u001c\u0002/Q,7\u000f\u001e+pa&\u001cw+\u001b3f\t\u0016dW\r^3J]j[\u0005FA'=\u0011\u0015\t\u0006\u0001\"\u00017\u0003]\"Xm\u001d;D_:\u001cX/\u001c9uS>twJ\u001c*fGJ,\u0017\r^3e)>\u0004\u0018nY!gi\u0016\u0014Hk\u001c9jG^KG-\u001a#fY\u0016$X-\u00138[\u0017\"\u0012\u0001\u000b\u0010\u0005\u0006)\u0002!I!V\u0001\u0018M&dG.\u00138D_:\u001cX/\\3s\u000fJ|W\u000f]%oM>$ra\u000e,`C\u000eD'\u000eC\u0003X'\u0002\u0007\u0001,A\u0003u_BL7\r\u0005\u0002Z9:\u0011\u0001HW\u0005\u00037*\na\u0001\u0015:fI\u00164\u0017BA/_\u0005\u0019\u0019FO]5oO*\u00111L\u000b\u0005\u0006AN\u0003\r\u0001W\u0001\u0006OJ|W\u000f\u001d\u0005\u0006EN\u0003\r\u0001W\u0001\u000bG>t7/^7fe&#\u0007\"\u00023T\u0001\u0004)\u0017!\u00039beRLG/[8o!\tAd-\u0003\u0002hU\t\u0019\u0011J\u001c;\t\u000b%\u001c\u0006\u0019A3\u0002\r=4gm]3u\u0011\u0015Y7\u000b1\u0001m\u0003A\u0011XmZ5ti\u0016\u00148i\u001c8tk6,'\u000f\u0005\u00029[&\u0011aN\u000b\u0002\b\u0005>|G.Z1o\u0011\u0015\u0001\b\u0001\"\u0003r\u000399'o\\;q\t&\u0014X\t_5tiN$\"\u0001\u001c:\t\u000bM|\u0007\u0019\u0001;\u0002\u0007\u0011L'\u000f\u0005\u0002vq6\taO\u0003\u0002x\t\u0005)Q\u000f^5mg&\u0011\u0011P\u001e\u0002\f5.;%o\\;q\t&\u00148\u000fC\u0003|\u0001\u0011%A0A\u0011he>,\b\u000fV8qS\u000e|eMZ:fi\u0006sGmT<oKJ$\u0015N]:Fq&\u001cH\u000f\u0006\u0002m{\")1O\u001fa\u0001}B\u0011Qo`\u0005\u0004\u0003\u00031(\u0001\u0005.L\u000fJ|W\u000f\u001d+pa&\u001cG)\u001b:t\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u000f\tQ\u0002\u001d:pIV\u001cW-\u0012<f]R\u001cHcB\u001c\u0002\n\u00055\u0012q\u0006\u0005\t\u0003\u0017\t\u0019\u00011\u0001\u0002\u000e\u0005A\u0001O]8ek\u000e,'\u000f\u0005\u0005\u0002\u0010\u0005u\u0011\u0011EA\u0011\u001b\t\t\tB\u0003\u0003\u0002\f\u0005M!\u0002BA\u000b\u0003/\tqa\u00197jK:$8OC\u0002\u0006\u00033Q1!a\u0007\u000f\u0003\u0019\t\u0007/Y2iK&!\u0011qDA\t\u00055Y\u0015MZ6b!J|G-^2feB)\u0001(a\t\u0002(%\u0019\u0011Q\u0005\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0007a\nI#C\u0002\u0002,)\u0012AAQ=uK\"1q+a\u0001A\u0002aC\u0001\"!\r\u0002\u0004\u0001\u0007\u00111G\u0001\t[\u0016\u001c8/Y4fgB!\u0011%!\u000eY\u0013\r\t9$\f\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0002<\u0001!I!!\u0010\u0002\u001b\r|gn];nK\u00163XM\u001c;t)\u00159\u0014qHA(\u0011!\t\t%!\u000fA\u0002\u0005\r\u0013!D7fgN\fw-Z*ue\u0016\fW\u000e\u0005\u0005\u0002F\u0005-\u0013\u0011EA\u0011\u001b\t\t9EC\u0002\u0002J\u0011\t\u0001bY8ogVlWM]\u0005\u0005\u0003\u001b\n9EA\u0006LC\u001a\\\u0017m\u0015;sK\u0006l\u0007bBA)\u0003s\u0001\r!Z\u0001\u0002]\u0002")
public class DeleteConsumerGroupTest
extends JUnitSuite
implements KafkaServerTestHarness {
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final Option<Function0<BoxedUnit>> setClusterAcl;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public Option<Function0<BoxedUnit>> setClusterAcl() {
        return this.setClusterAcl;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$setClusterAcl_$eq(Option x$1) {
        this.setClusterAcl = x$1;
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> saslProperties() {
        return KafkaServerTestHarness$class.saslProperties(this);
    }

    @Override
    @Before
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        DeleteConsumerGroupTest deleteConsumerGroupTest = this;
        synchronized (deleteConsumerGroupTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, true, TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testGroupWideDeleteInZK() {
        String topic = "test";
        String groupToDelete = "groupToDelete";
        String otherGroup = "otherGroup";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topic, groupToDelete, "consumer", 0, 10, false);
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topic, otherGroup, "consumer", 0, 10, false);
        AdminUtils$.MODULE$.deleteConsumerGroupInZK(this.zkUtils(), groupToDelete);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, groupToDelete){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String groupToDelete$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupDirExists(new ZKGroupDirs(this.groupToDelete$1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.groupToDelete$1 = groupToDelete$1;
            }
        }, "DeleteConsumerGroupInZK should delete the provided consumer group's directory", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, otherGroup){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String otherGroup$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupDirExists(new ZKGroupDirs(this.otherGroup$1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.otherGroup$1 = otherGroup$1;
            }
        }, "DeleteConsumerGroupInZK should not delete unrelated consumer group directories", TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    @Test
    public void testGroupWideDeleteInZKDoesNothingForActiveConsumerGroup() {
        String topic = "test";
        String groupToDelete = "groupToDelete";
        String otherGroup = "otherGroup";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topic, groupToDelete, "consumer", 0, 10, true);
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topic, otherGroup, "consumer", 0, 10, false);
        AdminUtils$.MODULE$.deleteConsumerGroupInZK(this.zkUtils(), groupToDelete);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, groupToDelete){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String groupToDelete$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupDirExists(new ZKGroupDirs(this.groupToDelete$2));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.groupToDelete$2 = groupToDelete$2;
            }
        }, "DeleteConsumerGroupInZK should not delete the provided consumer group's directory if the consumer group is still active", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, otherGroup){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String otherGroup$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupDirExists(new ZKGroupDirs(this.otherGroup$2));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.otherGroup$2 = otherGroup$2;
            }
        }, "DeleteConsumerGroupInZK should not delete unrelated consumer group directories", TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    @Test
    public void testGroupTopicWideDeleteInZKForGroupConsumingOneTopic() {
        String topic = "test";
        String groupToDelete = "groupToDelete";
        String otherGroup = "otherGroup";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topic, groupToDelete, "consumer", 0, 10, false);
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topic, otherGroup, "consumer", 0, 10, false);
        AdminUtils$.MODULE$.deleteConsumerGroupInfoForTopicInZK(this.zkUtils(), groupToDelete, topic);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, groupToDelete){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String groupToDelete$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupDirExists(new ZKGroupDirs(this.groupToDelete$3));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.groupToDelete$3 = groupToDelete$3;
            }
        }, "DeleteConsumerGroupInfoForTopicInZK should delete the provided consumer group's directory if it just consumes from one topic", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, otherGroup){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String topic$1;
            private final String otherGroup$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(new ZKGroupTopicDirs(this.otherGroup$3, this.topic$1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.otherGroup$3 = otherGroup$3;
            }
        }, "DeleteConsumerGroupInfoForTopicInZK should not delete unrelated consumer group owner and offset directories", TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    @Test
    public void testGroupTopicWideDeleteInZKForGroupConsumingMultipleTopics() {
        String topicToDelete = "topicToDelete";
        String otherTopic = "otherTopic";
        String groupToDelete = "groupToDelete";
        String otherGroup = "otherGroup";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicToDelete, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), otherTopic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topicToDelete, groupToDelete, "consumer", 0, 10, false);
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(otherTopic, groupToDelete, "consumer", 0, 10, false);
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topicToDelete, otherGroup, "consumer", 0, 10, false);
        AdminUtils$.MODULE$.deleteConsumerGroupInfoForTopicInZK(this.zkUtils(), groupToDelete, topicToDelete);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicToDelete, groupToDelete){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String topicToDelete$1;
            private final String groupToDelete$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(new ZKGroupTopicDirs(this.groupToDelete$4, this.topicToDelete$1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicToDelete$1 = topicToDelete$1;
                this.groupToDelete$4 = groupToDelete$4;
            }
        }, "DeleteConsumerGroupInfoForTopicInZK should delete the provided consumer group's owner and offset directories for the given topic", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, otherTopic, groupToDelete){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String otherTopic$1;
            private final String groupToDelete$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(new ZKGroupTopicDirs(this.groupToDelete$4, this.otherTopic$1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.otherTopic$1 = otherTopic$1;
                this.groupToDelete$4 = groupToDelete$4;
            }
        }, "DeleteConsumerGroupInfoForTopicInZK should not delete the provided consumer group's owner and offset directories for unrelated topics", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicToDelete, otherGroup){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String topicToDelete$1;
            private final String otherGroup$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(new ZKGroupTopicDirs(this.otherGroup$4, this.topicToDelete$1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicToDelete$1 = topicToDelete$1;
                this.otherGroup$4 = otherGroup$4;
            }
        }, "DeleteConsumerGroupInfoForTopicInZK should not delete unrelated consumer group owner and offset directories", TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    @Test
    public void testGroupTopicWideDeleteInZKDoesNothingForActiveGroupConsumingMultipleTopics() {
        String topicToDelete = "topicToDelete";
        String otherTopic = "otherTopic";
        String group = "group";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicToDelete, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), otherTopic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topicToDelete, group, "consumer", 0, 10, true);
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(otherTopic, group, "consumer", 0, 10, true);
        AdminUtils$.MODULE$.deleteConsumerGroupInfoForTopicInZK(this.zkUtils(), group, topicToDelete);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicToDelete, group){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String topicToDelete$2;
            private final String group$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(new ZKGroupTopicDirs(this.group$1, this.topicToDelete$2));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicToDelete$2 = topicToDelete$2;
                this.group$1 = group$1;
            }
        }, "DeleteConsumerGroupInfoForTopicInZK should not delete the provided consumer group's owner and offset directories for the given topic if the consumer group is still active", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, otherTopic, group){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String otherTopic$2;
            private final String group$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(new ZKGroupTopicDirs(this.group$1, this.otherTopic$2));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.otherTopic$2 = otherTopic$2;
                this.group$1 = group$1;
            }
        }, "DeleteConsumerGroupInfoForTopicInZK should not delete the provided consumer group's owner and offset directories for unrelated topics", TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    @Test
    public void testTopicWideDeleteInZK() {
        String topicToDelete = "topicToDelete";
        String otherTopic = "otherTopic";
        Seq groups = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"group1", "group2"}));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicToDelete, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), otherTopic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Seq groupTopicDirsForTopicToDelete = (Seq)groups.map((Function1)new Serializable(this, topicToDelete){
            public static final long serialVersionUID = 0L;
            private final String topicToDelete$3;

            public final ZKGroupTopicDirs apply(String group) {
                return new ZKGroupTopicDirs(group, this.topicToDelete$3);
            }
            {
                this.topicToDelete$3 = topicToDelete$3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq groupTopicDirsForOtherTopic = (Seq)groups.map((Function1)new Serializable(this, otherTopic){
            public static final long serialVersionUID = 0L;
            private final String otherTopic$3;

            public final ZKGroupTopicDirs apply(String group) {
                return new ZKGroupTopicDirs(group, this.otherTopic$3);
            }
            {
                this.otherTopic$3 = otherTopic$3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        groupTopicDirsForTopicToDelete.foreach((Function1)new Serializable(this, topicToDelete){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String topicToDelete$3;

            public final void apply(ZKGroupTopicDirs dir) {
                this.$outer.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(this.topicToDelete$3, dir.group(), "consumer", 0, 10, false);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicToDelete$3 = topicToDelete$3;
            }
        });
        groupTopicDirsForOtherTopic.foreach((Function1)new Serializable(this, otherTopic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final String otherTopic$3;

            public final void apply(ZKGroupTopicDirs dir) {
                this.$outer.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(this.otherTopic$3, dir.group(), "consumer", 0, 10, false);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.otherTopic$3 = otherTopic$3;
            }
        });
        AdminUtils$.MODULE$.deleteAllConsumerGroupInfoForTopicInZK(this.zkUtils(), topicToDelete);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, groupTopicDirsForTopicToDelete){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final Seq groupTopicDirsForTopicToDelete$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.groupTopicDirsForTopicToDelete$1.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testTopicWideDeleteInZK$1 $outer;

                    public final boolean apply(ZKGroupTopicDirs dir) {
                        return this.$outer.kafka$admin$DeleteConsumerGroupTest$$anonfun$$$outer().kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(dir);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ DeleteConsumerGroupTest kafka$admin$DeleteConsumerGroupTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.groupTopicDirsForTopicToDelete$1 = groupTopicDirsForTopicToDelete$1;
            }
        }, "Consumer group info on deleted topic topic should be deleted by DeleteAllConsumerGroupInfoForTopicInZK", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, groupTopicDirsForOtherTopic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final Seq groupTopicDirsForOtherTopic$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.groupTopicDirsForOtherTopic$1.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testTopicWideDeleteInZK$2 $outer;

                    public final boolean apply(ZKGroupTopicDirs dir) {
                        return this.$outer.kafka$admin$DeleteConsumerGroupTest$$anonfun$$$outer().kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(dir);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ DeleteConsumerGroupTest kafka$admin$DeleteConsumerGroupTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.groupTopicDirsForOtherTopic$1 = groupTopicDirsForOtherTopic$1;
            }
        }, "Consumer group info on unrelated topics should not be deleted by DeleteAllConsumerGroupInfoForTopicInZK", TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    @Test
    public void testConsumptionOnRecreatedTopicAfterTopicWideDeleteInZK() {
        String topic = "topic";
        String group = "group";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ZKGroupTopicDirs dir = new ZKGroupTopicDirs(group, topic);
        this.kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(topic, dir.group(), "consumer", 0, 10, false);
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, (Seq<KafkaServer>)this.servers());
        AdminUtils$.MODULE$.deleteAllConsumerGroupInfoForTopicInZK(this.zkUtils(), topic);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, dir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final ZKGroupTopicDirs dir$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupDirExists((ZKGroupDirs)this.dir$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dir$1 = dir$1;
            }
        }, "Consumer group info on related topics should be deleted by DeleteAllConsumerGroupInfoForTopicInZK", TestUtils$.MODULE$.waitUntilTrue$default$3());
        KafkaProducer producer = TestUtils$.MODULE$.createNewProducer(this.brokerList(), TestUtils$.MODULE$.createNewProducer$default$2(), TestUtils$.MODULE$.createNewProducer$default$3(), TestUtils$.MODULE$.createNewProducer$default$4(), TestUtils$.MODULE$.createNewProducer$default$5(), TestUtils$.MODULE$.createNewProducer$default$6(), TestUtils$.MODULE$.createNewProducer$default$7(), TestUtils$.MODULE$.createNewProducer$default$8(), TestUtils$.MODULE$.createNewProducer$default$9(), TestUtils$.MODULE$.createNewProducer$default$10(), TestUtils$.MODULE$.createNewProducer$default$11(), TestUtils$.MODULE$.createNewProducer$default$12(), TestUtils$.MODULE$.createNewProducer$default$13());
        this.produceEvents(producer, topic, (List<String>)((List)List$.MODULE$.fill(10, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "test";
            }
        })));
        Properties consumerProps = TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), group, "consumer", TestUtils$.MODULE$.createConsumerProperties$default$4());
        consumerProps.put("auto.commit.enable", "false");
        consumerProps.put("auto.offset.reset", "smallest");
        consumerProps.put("consumer.timeout.ms", "2000");
        consumerProps.put("fetch.wait.max.ms", "0");
        ConsumerConfig consumerConfig = new ConsumerConfig(consumerProps);
        ConsumerConnector consumerConnector = Consumer$.MODULE$.create(consumerConfig);
        KafkaStream messageStream = (KafkaStream)((IterableLike)consumerConnector.createMessageStreams((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToInteger((int)1))}))).apply((Object)topic)).head();
        this.consumeEvents((KafkaStream<byte[], byte[]>)messageStream, 5);
        consumerConnector.commitOffsets(false);
        producer.close();
        consumerConnector.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, dir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupTest $outer;
            private final ZKGroupTopicDirs dir$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(this.dir$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dir$1 = dir$1;
            }
        }, "Consumer group info should exist after consuming from a recreated topic", TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    public void kafka$admin$DeleteConsumerGroupTest$$fillInConsumerGroupInfo(String topic, String group, String consumerId, int partition, int offset, boolean registerConsumer) {
        Properties consumerProps = TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), group, consumerId, TestUtils$.MODULE$.createConsumerProperties$default$4());
        ConsumerConfig consumerConfig = new ConsumerConfig(consumerProps);
        ZKGroupTopicDirs dir = new ZKGroupTopicDirs(group, topic);
        TestUtils$.MODULE$.updateConsumerOffset(consumerConfig, new StringBuilder().append((Object)dir.consumerOffsetDir()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)partition)).toString(), offset);
        ZkUtils qual$1 = this.zkUtils();
        String x$2 = this.zkUtils().getConsumerPartitionOwnerPath(group, topic, partition);
        String x$3 = "";
        java.util.List x$4 = qual$1.createEphemeralPathExpectConflict$default$3();
        qual$1.createEphemeralPathExpectConflict(x$2, x$3, x$4);
        ZkUtils qual$2 = this.zkUtils();
        String x$5 = dir.consumerRegistryDir();
        java.util.List x$6 = qual$2.makeSurePersistentPathExists$default$2();
        qual$2.makeSurePersistentPathExists(x$5, x$6);
        if (registerConsumer) {
            ZkUtils qual$3 = this.zkUtils();
            String x$7 = new StringBuilder().append((Object)dir.consumerRegistryDir()).append((Object)"/").append((Object)consumerId).toString();
            String x$8 = "";
            java.util.List x$9 = qual$3.createEphemeralPathExpectConflict$default$3();
            qual$3.createEphemeralPathExpectConflict(x$7, x$8, x$9);
        }
    }

    public boolean kafka$admin$DeleteConsumerGroupTest$$groupDirExists(ZKGroupDirs dir) {
        return this.zkUtils().pathExists(dir.consumerGroupDir());
    }

    public boolean kafka$admin$DeleteConsumerGroupTest$$groupTopicOffsetAndOwnerDirsExist(ZKGroupTopicDirs dir) {
        return this.zkUtils().pathExists(dir.consumerOffsetDir()) && this.zkUtils().pathExists(dir.consumerOwnerDir());
    }

    private void produceEvents(KafkaProducer<byte[], byte[]> producer, String topic, List<String> messages2) {
        messages2.foreach((Function1)new Serializable(this, producer, topic){
            public static final long serialVersionUID = 0L;
            private final KafkaProducer producer$1;
            private final String topic$2;

            public final Future<RecordMetadata> apply(String message) {
                return this.producer$1.send(new ProducerRecord(this.topic$2, (Object)message.getBytes()));
            }
            {
                this.producer$1 = producer$1;
                this.topic$2 = topic$2;
            }
        });
    }

    private void consumeEvents(KafkaStream<byte[], byte[]> messageStream, int n) {
        ConsumerIterator iter = messageStream.iterator();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach((Function1)new Serializable(this, iter){
            public static final long serialVersionUID = 0L;
            private final ConsumerIterator iter$1;

            public final MessageAndMetadata<byte[], byte[]> apply(int x$1) {
                return this.iter$1.next();
            }
            {
                this.iter$1 = iter$1;
            }
        });
    }

    public DeleteConsumerGroupTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
    }
}

