/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.admin.AclCommand$;
import kafka.api.Both$;
import kafka.api.EndToEndAuthorizationTest;
import kafka.api.EndToEndAuthorizationTest$;
import kafka.api.ZkSasl$;
import kafka.common.TopicAndPartition;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Describe$;
import kafka.security.auth.Group$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.Topic$;
import kafka.security.auth.Write$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.Assertions;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public abstract class EndToEndAuthorizationTest$class {
    public static Some trustStoreFile(EndToEndAuthorizationTest $this) {
        return new Some((Object)File.createTempFile("truststore", ".jks"));
    }

    public static String kafkaClientSaslMechanism(EndToEndAuthorizationTest $this) {
        return "GSSAPI";
    }

    public static List kafkaServerSaslMechanisms(EndToEndAuthorizationTest $this) {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GSSAPI"}));
    }

    public static String[] clusterAclArgs(EndToEndAuthorizationTest $this) {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--cluster"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=ClusterAction"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.kafkaPrincipalType(), $this.kafkaPrincipal()}))});
    }

    public static String[] topicBrokerReadAclArgs(EndToEndAuthorizationTest $this) {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.topicWildcard()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=Read"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.kafkaPrincipalType(), $this.kafkaPrincipal()}))});
    }

    public static String[] produceAclArgs(EndToEndAuthorizationTest $this) {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.topic()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--producer"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.kafkaPrincipalType(), $this.clientPrincipal()}))});
    }

    public static String[] consumeAclArgs(EndToEndAuthorizationTest $this) {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.topic()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--group=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.group()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--consumer"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.kafkaPrincipalType(), $this.clientPrincipal()}))});
    }

    public static String[] groupAclArgs(EndToEndAuthorizationTest $this) {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--group=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.group()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=Read"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.kafkaPrincipalType(), $this.clientPrincipal()}))});
    }

    public static Set ClusterActionAcl(EndToEndAuthorizationTest $this) {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal($this.kafkaPrincipalType(), $this.kafkaPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)ClusterAction$.MODULE$)}));
    }

    public static Set TopicBrokerReadAcl(EndToEndAuthorizationTest $this) {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal($this.kafkaPrincipalType(), $this.kafkaPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public static Set GroupReadAcl(EndToEndAuthorizationTest $this) {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal($this.kafkaPrincipalType(), $this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public static Set TopicReadAcl(EndToEndAuthorizationTest $this) {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal($this.kafkaPrincipalType(), $this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public static Set TopicWriteAcl(EndToEndAuthorizationTest $this) {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal($this.kafkaPrincipalType(), $this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$)}));
    }

    public static Set TopicDescribeAcl(EndToEndAuthorizationTest $this) {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal($this.kafkaPrincipalType(), $this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$)}));
    }

    @Before
    public static void setUp(EndToEndAuthorizationTest $this) {
        SecurityProtocol securityProtocol = $this.securityProtocol();
        SecurityProtocol securityProtocol2 = SecurityProtocol.SSL;
        SecurityProtocol securityProtocol3 = securityProtocol;
        if (!(securityProtocol2 != null ? !securityProtocol2.equals(securityProtocol3) : securityProtocol3 != null)) {
            $this.startSasl(ZkSasl$.MODULE$, null, null);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            $this.startSasl(Both$.MODULE$, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.kafkaClientSaslMechanism()})), $this.kafkaServerSaslMechanisms());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        $this.kafka$api$EndToEndAuthorizationTest$$super$setUp();
        AclCommand$.MODULE$.main($this.topicBrokerReadAclArgs());
        $this.servers().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;

            public final boolean apply(KafkaServer s) {
                return TestUtils$.MODULE$.waitAndVerifyAcls(this.$outer.TopicBrokerReadAcl(), (Authorizer)s.apis().authorizer().get(), new Resource((ResourceType)Topic$.MODULE$, "*"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        TestUtils$.MODULE$.createTopic($this.zkUtils(), $this.topic(), 1, 3, (Seq<KafkaServer>)$this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @After
    public static void tearDown(EndToEndAuthorizationTest $this) {
        $this.kafka$api$EndToEndAuthorizationTest$$super$tearDown();
        $this.closeSasl();
    }

    @Test
    public static void testProduceConsume(EndToEndAuthorizationTest $this) {
        AclCommand$.MODULE$.main($this.produceAclArgs());
        AclCommand$.MODULE$.main($this.consumeAclArgs());
        $this.servers().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;

            public final boolean apply(KafkaServer s) {
                TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)this.$outer.TopicReadAcl().$plus$plus(this.$outer.TopicWriteAcl()).$plus$plus(this.$outer.TopicDescribeAcl())), (Authorizer)s.apis().authorizer().get(), this.$outer.topicResource());
                return TestUtils$.MODULE$.waitAndVerifyAcls(this.$outer.GroupReadAcl(), (Authorizer)s.apis().authorizer().get(), this.$outer.groupResource());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        $this.debug((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting to send records";
            }
        });
        EndToEndAuthorizationTest$class.sendRecords($this, $this.numRecords(), $this.tp());
        $this.debug((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Finished sending and starting to consume records";
            }
        });
        ((KafkaConsumer)$this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{$this.tp()}))).asJava());
        EndToEndAuthorizationTest$class.consumeRecords($this, (Consumer)$this.consumers().head(), $this.numRecords(), EndToEndAuthorizationTest$class.consumeRecords$default$3($this), EndToEndAuthorizationTest$class.consumeRecords$default$4($this), EndToEndAuthorizationTest$class.consumeRecords$default$5($this));
        $this.debug((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Finished consuming";
            }
        });
    }

    @Test
    public static void testNoProduceAcl(EndToEndAuthorizationTest $this) {
        $this.debug((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting to send records";
            }
        });
        try {
            EndToEndAuthorizationTest$class.sendRecords($this, $this.numRecords(), $this.tp());
            throw ((Assertions)$this).fail("Topic authorization exception expected");
        }
        catch (TopicAuthorizationException topicAuthorizationException) {
            return;
        }
    }

    @Test
    public static void testNoConsumeAcl(EndToEndAuthorizationTest $this) {
        AclCommand$.MODULE$.main($this.produceAclArgs());
        AclCommand$.MODULE$.main($this.groupAclArgs());
        $this.servers().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;

            public final boolean apply(KafkaServer s) {
                TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)this.$outer.TopicWriteAcl().$plus$plus(this.$outer.TopicDescribeAcl())), (Authorizer)s.apis().authorizer().get(), this.$outer.topicResource());
                return TestUtils$.MODULE$.waitAndVerifyAcls(this.$outer.GroupReadAcl(), (Authorizer)((KafkaServer)this.$outer.servers().head()).apis().authorizer().get(), this.$outer.groupResource());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        $this.debug((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting to send records";
            }
        });
        EndToEndAuthorizationTest$class.sendRecords($this, $this.numRecords(), $this.tp());
        $this.debug((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Finished sending and starting to consume records";
            }
        });
        ((KafkaConsumer)$this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{$this.tp()}))).asJava());
        try {
            EndToEndAuthorizationTest$class.consumeRecords($this, (Consumer)$this.consumers().head(), EndToEndAuthorizationTest$class.consumeRecords$default$2($this), EndToEndAuthorizationTest$class.consumeRecords$default$3($this), EndToEndAuthorizationTest$class.consumeRecords$default$4($this), EndToEndAuthorizationTest$class.consumeRecords$default$5($this));
            throw ((Assertions)$this).fail("Topic authorization exception expected");
        }
        catch (TopicAuthorizationException topicAuthorizationException) {
            return;
        }
    }

    @Test
    public static void testNoGroupAcl(EndToEndAuthorizationTest $this) {
        AclCommand$.MODULE$.main($this.produceAclArgs());
        $this.servers().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;

            public final boolean apply(KafkaServer s) {
                return TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)this.$outer.TopicWriteAcl().$plus$plus(this.$outer.TopicDescribeAcl())), (Authorizer)s.apis().authorizer().get(), this.$outer.topicResource());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        $this.debug((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting to send records";
            }
        });
        EndToEndAuthorizationTest$class.sendRecords($this, $this.numRecords(), $this.tp());
        $this.debug((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Finished sending and starting to consume records";
            }
        });
        ((KafkaConsumer)$this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{$this.tp()}))).asJava());
        try {
            EndToEndAuthorizationTest$class.consumeRecords($this, (Consumer)$this.consumers().head(), EndToEndAuthorizationTest$class.consumeRecords$default$2($this), EndToEndAuthorizationTest$class.consumeRecords$default$3($this), EndToEndAuthorizationTest$class.consumeRecords$default$4($this), EndToEndAuthorizationTest$class.consumeRecords$default$5($this));
            throw ((Assertions)$this).fail("Topic authorization exception expected");
        }
        catch (GroupAuthorizationException groupAuthorizationException) {
            return;
        }
    }

    private static void sendRecords(EndToEndAuthorizationTest $this, int numRecords, TopicPartition tp) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable($this, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;
            private final TopicPartition tp$1;

            public final Future<RecordMetadata> apply(int i) {
                ProducerRecord record = new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
                this.$outer.debug((Function0)new Serializable(this, record){
                    public static final long serialVersionUID = 0L;
                    private final ProducerRecord record$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending this record: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.record$1}));
                    }
                    {
                        this.record$1 = record$1;
                    }
                });
                return ((KafkaProducer)this.$outer.producers().head()).send(record);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.tp$1 = tp$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        try {
            futures.foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$1) {
                    return x$1.get();
                }
            });
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private static void consumeRecords(EndToEndAuthorizationTest $this, Consumer consumer, int numRecords, int startingOffset, String topic, int part) {
        ArrayList records = new ArrayList();
        int maxIters = numRecords * 50;
        int iters = 0;
        while (records.size() < numRecords) {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)consumer.poll(50L)).asScala()).foreach((Function1)new Serializable($this, records){
                public static final long serialVersionUID = 0L;
                private final ArrayList records$1;

                public final boolean apply(ConsumerRecord<byte[], byte[]> record) {
                    return this.records$1.add(record);
                }
                {
                    this.records$1 = records$1;
                }
            });
            if (iters > maxIters) {
                throw new IllegalStateException(new StringBuilder().append((Object)"Failed to consume the expected records after ").append((Object)BoxesRunTime.boxToInteger((int)iters)).append((Object)" iterations.").toString());
            }
            ++iters;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)new Serializable($this, startingOffset, topic, part, records){
            public static final long serialVersionUID = 0L;
            private final int startingOffset$1;
            private final String topic$1;
            private final int part$1;
            private final ArrayList records$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ConsumerRecord record = (ConsumerRecord)this.records$1.get(i);
                int offset = this.startingOffset$1 + i;
                Assert.assertEquals((Object)this.topic$1, (Object)record.topic());
                Assert.assertEquals((long)this.part$1, (long)record.partition());
                Assert.assertEquals((long)offset, (long)record.offset());
            }
            {
                this.startingOffset$1 = startingOffset$1;
                this.topic$1 = topic$1;
                this.part$1 = part$1;
                this.records$1 = records$1;
            }
        });
    }

    private static int consumeRecords$default$2(EndToEndAuthorizationTest $this) {
        return 1;
    }

    private static int consumeRecords$default$3(EndToEndAuthorizationTest $this) {
        return 0;
    }

    private static String consumeRecords$default$4(EndToEndAuthorizationTest $this) {
        return $this.topic();
    }

    private static int consumeRecords$default$5(EndToEndAuthorizationTest $this) {
        return $this.part();
    }

    public static void $init$(EndToEndAuthorizationTest $this) {
        $this.kafka$api$EndToEndAuthorizationTest$_setter_$producerCount_$eq(1);
        $this.kafka$api$EndToEndAuthorizationTest$_setter_$consumerCount_$eq(2);
        $this.kafka$api$EndToEndAuthorizationTest$_setter_$serverCount_$eq(3);
        $this.kafka$api$EndToEndAuthorizationTest$_setter_$setClusterAcl_$eq(new Some((Object)new EndToEndAuthorizationTest$.anonfun.1($this)));
        $this.kafka$api$EndToEndAuthorizationTest$_setter_$numRecords_$eq(1);
        $this.kafka$api$EndToEndAuthorizationTest$_setter_$group_$eq("group");
        $this.kafka$api$EndToEndAuthorizationTest$_setter_$topic_$eq("e2etopic");
        $this.kafka$api$EndToEndAuthorizationTest$_setter_$topicWildcard_$eq("*");
        $this.kafka$api$EndToEndAuthorizationTest$_setter_$part_$eq(0);
        $this.kafka$api$EndToEndAuthorizationTest$_setter_$tp_$eq(new TopicPartition($this.topic(), $this.part()));
        $this.kafka$api$EndToEndAuthorizationTest$_setter_$topicAndPartition_$eq(new TopicAndPartition($this.topic(), $this.part()));
        $this.kafka$api$EndToEndAuthorizationTest$_setter_$saslProperties_$eq(new Some((Object)$this.kafkaSaslProperties($this.kafkaClientSaslMechanism(), (Option)new Some($this.kafkaServerSaslMechanisms()))));
        $this.kafka$api$EndToEndAuthorizationTest$_setter_$topicResource_$eq(new Resource((ResourceType)Topic$.MODULE$, $this.topic()));
        $this.kafka$api$EndToEndAuthorizationTest$_setter_$groupResource_$eq(new Resource((ResourceType)Group$.MODULE$, $this.group()));
        $this.kafka$api$EndToEndAuthorizationTest$_setter_$clusterResource_$eq(Resource$.MODULE$.ClusterResource());
        $this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "true");
        $this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), SimpleAclAuthorizer.class.getName());
        $this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        $this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        $this.serverConfig().setProperty(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), "3");
        $this.consumerConfig().setProperty("group.id", "group");
    }
}

