/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import kafka.api.BaseConsumerTest;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.MockProducerInterceptor;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\rd\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003\u00157bS:$X\r\u001f;D_:\u001cX/\\3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0011\u0005\u0006\u001cXmQ8ogVlWM\u001d+fgRDQ!\u0004\u0001\u0005\u00029\ta\u0001P5oSRtD#A\b\u0011\u0005%\u0001\u0001\"B\t\u0001\t\u0003\u0011\u0012A\u0005;fgRl\u0015\r\u001f)pY2\u0014VmY8sIN$\u0012a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0005+:LG\u000f\u000b\u0002\u00115A\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002?\u0005\u0019qN]4\n\u0005\u0005b\"\u0001\u0002+fgRDQa\t\u0001\u0005\u0002I\tQ\u0003^3ti\u0006+Ho\\\"p[6LGo\u00148DY>\u001cX\r\u000b\u0002#5!)a\u0005\u0001C\u0001%\u0005\u0001C/Z:u\u0003V$xnQ8n[&$xJ\\\"m_N,\u0017I\u001a;fe^\u000b7.Z;qQ\t)#\u0004C\u0003*\u0001\u0011\u0005!#A\nuKN$\u0018)\u001e;p\u001f\u001a47/\u001a;SKN,G\u000f\u000b\u0002)5!)A\u0006\u0001C\u0001%\u0005!B/Z:u\u000fJ|W\u000f]\"p]N,X\u000e\u001d;j_:D#a\u000b\u000e\t\u000b=\u0002A\u0011\u0001\n\u0002/Q,7\u000f\u001e)biR,'O\\*vEN\u001c'/\u001b9uS>t\u0007F\u0001\u0018\u001b\u0011\u0015\u0011\u0004\u0001\"\u0001\u0013\u0003e!Xm\u001d;QCR$XM\u001d8V]N,(m]2sSB$\u0018n\u001c8)\u0005ER\u0002\"B\u001b\u0001\t\u0003\u0011\u0012A\u0005;fgR\u001cu.\\7ji6+G/\u00193bi\u0006D#\u0001\u000e\u000e\t\u000ba\u0002A\u0011\u0001\n\u0002\u001fQ,7\u000f^!ts:\u001c7i\\7nSRD#a\u000e\u000e\t\u000bm\u0002A\u0011\u0001\n\u0002?Q,7\u000f^#ya\u0006tG-\u001b8h)>\u0004\u0018nY*vEN\u001c'/\u001b9uS>t7\u000f\u000b\u0002;5!)a\b\u0001C\u0001%\u0005yB/Z:u'\"\u0014\u0018N\\6j]\u001e$v\u000e]5d'V\u00147o\u0019:jaRLwN\\:)\u0005uR\u0002\"B!\u0001\t\u0003\u0011\u0012!\u0005;fgR\u0004\u0016M\u001d;ji&|gn\u001d$pe\"\u0012\u0001I\u0007\u0005\u0006\t\u0002!\tAE\u0001\u001ci\u0016\u001cH\u000fU1si&$\u0018n\u001c8t\r>\u0014\u0018)\u001e;p\u0007J,\u0017\r^3)\u0005\rS\u0002\"B$\u0001\t\u0003\u0011\u0012!\b;fgR\u0004\u0016M\u001d;ji&|gn\u001d$pe&sg/\u00197jIR{\u0007/[2)\t\u0019S\u0012JS\u0001\tKb\u0004Xm\u0019;fI\u000e\n1\n\u0005\u0002M)6\tQJ\u0003\u0002O\u001f\u00061QM\u001d:peNT!\u0001U)\u0002\r\r|W.\\8o\u0015\t)!K\u0003\u0002T=\u00051\u0011\r]1dQ\u0016L!!V'\u0003+%sg/\u00197jIR{\u0007/[2Fq\u000e,\u0007\u000f^5p]\")q\u000b\u0001C\u0001%\u0005AA/Z:u'\u0016,7\u000e\u000b\u0002W5!)!\f\u0001C\u00057\u000612/\u001a8e\u0007>l\u0007O]3tg\u0016$W*Z:tC\u001e,7\u000fF\u0002\u00149\u0006DQ!X-A\u0002y\u000b!B\\;n%\u0016\u001cwN\u001d3t!\t!r,\u0003\u0002a+\t\u0019\u0011J\u001c;\t\u000b\tL\u0006\u0019A2\u0002\u0005Q\u0004\bC\u00013f\u001b\u0005y\u0015B\u00014P\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DQ\u0001\u001b\u0001\u0005\u0002I\tQ\u0003^3tiB{7/\u001b;j_:\fe\u000eZ\"p[6LG\u000f\u000b\u0002h5!)1\u000e\u0001C\u0001%\u0005YB/Z:u!\u0006\u0014H/\u001b;j_:\u0004\u0016-^:f\u0003:$'+Z:v[\u0016D#A\u001b\u000e\t\u000b9\u0004A\u0011\u0001\n\u0002-Q,7\u000f\u001e$fi\u000eD\u0017J\u001c<bY&$wJ\u001a4tKRD#!\u001c\u000e\t\u000bE\u0004A\u0011\u0001\n\u0002/Q,7\u000f\u001e$fi\u000eD'+Z2pe\u0012$vn\u001c'be\u001e,\u0007F\u00019\u001b\u0011\u0015!\b\u0001\"\u0001\u0013\u0003a!Xm\u001d;S_VtGMU8cS:\f5o]5h]6,g\u000e\u001e\u0015\u0003gjAQa\u001e\u0001\u0005\u0002I\tQ\u0005^3ti6+H\u000e^5D_:\u001cX/\\3s%>,h\u000e\u001a*pE&t\u0017i]:jO:lWM\u001c;)\u0005YT\u0002\"\u0002>\u0001\t\u0003\u0011\u0012A\t;fgRlU\u000f\u001c;j\u0007>t7/^7fe\u0012+g-Y;mi\u0006\u001b8/[4o[\u0016tG\u000f\u000b\u0002z5!)Q\u0010\u0001C\u0001%\u0005aC/Z:u\u001bVdG/[\"p]N,X.\u001a:TKN\u001c\u0018n\u001c8US6,w.\u001e;P]N#x\u000e\u001d)pY2Lgn\u001a\u0015\u0003yjAa!!\u0001\u0001\t\u0003\u0011\u0012A\n;fgRlU\u000f\u001c;j\u0007>t7/^7feN+7o]5p]RKW.Z8vi>s7\t\\8tK\"\u0012qP\u0007\u0005\u0007\u0003\u000f\u0001A\u0011\u0001\n\u0002!Q,7\u000f^%oi\u0016\u00148-\u001a9u_J\u001c\bfAA\u00035!1\u0011Q\u0002\u0001\u0005\u0002I\tq\u0003^3ti\u0006+Ho\\\"p[6LG/\u00138uKJ\u001cW\r\u001d;)\u0007\u0005-!\u0004\u0003\u0004\u0002\u0014\u0001!\tAE\u0001\"i\u0016\u001cH/\u00138uKJ\u001cW\r\u001d;peN<\u0016\u000e\u001e5Xe>twmS3z-\u0006dW/\u001a\u0015\u0004\u0003#Q\u0002BBA\r\u0001\u0011\u0005!#A\u0011uKN$8i\u001c8tk6,W*Z:tC\u001e,7oV5uQ\u000e\u0013X-\u0019;f)&lW\r\u0003\u0004\u0002\u001e\u0001!\tAE\u0001%i\u0016\u001cHoQ8ogVlW-T3tg\u0006<Wm],ji\"dunZ!qa\u0016tG\rV5nK\"\u001a\u00111\u0004\u000e\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&\u0005\u0011#/\u001e8Nk2$\u0018nQ8ogVlWM]*fgNLwN\u001c+j[\u0016|W\u000f\u001e+fgR$2aEA\u0014\u0011!\tI#!\tA\u0002\u0005-\u0012!D2m_N,7i\u001c8tk6,'\u000fE\u0002\u0015\u0003[I1!a\f\u0016\u0005\u001d\u0011un\u001c7fC:Dq!a\r\u0001\t\u0003\t)$A\rde\u0016\fG/\u001a+pa&\u001c\u0017I\u001c3TK:$'+Z2pe\u0012\u001cH\u0003CA\u001c\u0003\u000b\ny%a\u0015\u0011\u000b\u0005e\u0012qH2\u000f\u0007Q\tY$C\u0002\u0002>U\ta\u0001\u0015:fI\u00164\u0017\u0002BA!\u0003\u0007\u00121aU3u\u0015\r\ti$\u0006\u0005\t\u0003\u000f\n\t\u00041\u0001\u0002J\u0005IAo\u001c9jG:\u000bW.\u001a\t\u0005\u0003s\tY%\u0003\u0003\u0002N\u0005\r#AB*ue&tw\rC\u0004\u0002R\u0005E\u0002\u0019\u00010\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011\u001d\t)&!\rA\u0002y\u000b1C]3d_J$7\u000fU3s!\u0006\u0014H/\u001b;j_:Dq!!\u0017\u0001\t\u0003\tY&\u0001\u0011tk\n\u001c8M]5cK\u000e{gn];nKJ\fe\u000eZ*uCJ$\bk\u001c7mS:<GCBA/\u0003K\n\u0019\t\u0005\u0003\u0002`\u0005\u0005T\"\u0001\u0001\n\u0007\u0005\r$B\u0001\rD_:\u001cX/\\3s\u0003N\u001c\u0018n\u001a8nK:$\bk\u001c7mKJD\u0001\"a\u001a\u0002X\u0001\u0007\u0011\u0011N\u0001\tG>t7/^7feBA\u00111NA:\u0003o\n9(\u0004\u0002\u0002n)!\u0011qMA8\u0015\r\t\t(U\u0001\bG2LWM\u001c;t\u0013\u0011\t)(!\u001c\u0003\u0011\r{gn];nKJ\u0004R\u0001FA=\u0003{J1!a\u001f\u0016\u0005\u0015\t%O]1z!\r!\u0012qP\u0005\u0004\u0003\u0003+\"\u0001\u0002\"zi\u0016D\u0001\"!\"\u0002X\u0001\u0007\u0011qQ\u0001\u0012i>\u0004\u0018nY:U_N+(m]2sS\n,\u0007CBAE\u00033\u000bIE\u0004\u0003\u0002\f\u0006Ue\u0002BAG\u0003'k!!a$\u000b\u0007\u0005Ee!\u0001\u0004=e>|GOP\u0005\u0002-%\u0019\u0011qS\u000b\u0002\u000fA\f7m[1hK&!\u00111TAO\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005]U\u0003C\u0004\u0002\"\u0002!\t!a)\u0002MM,(m]2sS\n,7i\u001c8tk6,'o]!oI^\u000b\u0017\u000e\u001e$pe\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0005\u0002&\u0006U\u0016\u0011YAb!\u0019\t9+!-\u0002^5\u0011\u0011\u0011\u0016\u0006\u0005\u0003W\u000bi+A\u0004nkR\f'\r\\3\u000b\u0007\u0005=V#\u0001\u0006d_2dWm\u0019;j_:LA!a-\u0002*\n1!)\u001e4gKJD\u0001\"a.\u0002 \u0002\u0007\u0011\u0011X\u0001\u000eG>t7/^7fe\u001e\u0013x.\u001e9\u0011\r\u0005\u001d\u0016\u0011WA^!!\tY'!0\u0002x\u0005]\u0014\u0002BA`\u0003[\u0012QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\b\u0002CAC\u0003?\u0003\r!a\"\t\u0011\u0005\u0015\u0017q\u0014a\u0001\u0003o\tQb];cg\u000e\u0014\u0018\u000e\u001d;j_:\u001c\bbBAe\u0001\u0011\u0005\u00111Z\u0001(GJ,\u0017\r^3D_:\u001cX/\\3s\u000fJ|W\u000f]!oI^\u000b\u0017\u000e\u001e$pe\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0005\u0002N\u0006M\u0017q[Am!\u001d!\u0012qZA]\u0003KK1!!5\u0016\u0005\u0019!V\u000f\u001d7fe!9\u0011Q[Ad\u0001\u0004q\u0016!D2p]N,X.\u001a:D_VtG\u000f\u0003\u0005\u0002\u0006\u0006\u001d\u0007\u0019AAD\u0011!\t)-a2A\u0002\u0005]\u0002bBAo\u0001\u0011\u0005\u0011q\\\u0001-C\u0012$7i\u001c8tk6,'o\u001d+p\u000fJ|W\u000f]!oI^\u000b\u0017\u000e\u001e$pe\u001e\u0013x.\u001e9BgNLwM\\7f]R$2bEAq\u0003K\f9/a;\u0002n\"9\u00111]An\u0001\u0004q\u0016a\u00058v[>37i\u001c8tk6,'o\u001d+p\u0003\u0012$\u0007\u0002CA\\\u00037\u0004\r!!/\t\u0011\u0005%\u00181\u001ca\u0001\u0003K\u000bqbY8ogVlWM\u001d)pY2,'o\u001d\u0005\t\u0003\u000b\u000bY\u000e1\u0001\u0002\b\"A\u0011QYAn\u0001\u0004\t9\u0004C\u0004\u0002r\u0002!\t!a=\u0002/Y\fG.\u001b3bi\u0016<%o\\;q\u0003N\u001c\u0018n\u001a8nK:$H#C\n\u0002v\u0006]\u0018\u0011`A\u007f\u0011!\tI/a<A\u0002\u0005\u0015\u0006\u0002CAc\u0003_\u0004\r!a\u000e\t\u0011\u0005m\u0018q\u001ea\u0001\u0003\u0013\n1!\\:h\u0011)\ty0a<\u0011\u0002\u0003\u0007!\u0011A\u0001\to\u0006LG\u000fV5nKB\u0019ACa\u0001\n\u0007\t\u0015QC\u0001\u0003M_:<\u0007b\u0002B\u0005\u0001\u0011\u0005!1B\u00015G\"\fgnZ3D_:\u001cX/\\3s\u000fJ|W\u000f]*vEN\u001c'/\u001b9uS>t\u0017I\u001c3WC2LG-\u0019;f\u0003N\u001c\u0018n\u001a8nK:$HcB\n\u0003\u000e\t=!\u0011\u0003\u0005\t\u0003S\u00149\u00011\u0001\u0002&\"A\u0011Q\u0011B\u0004\u0001\u0004\t9\t\u0003\u0005\u0002F\n\u001d\u0001\u0019AA\u001c\u0011\u001d\u0011)\u0002\u0001C\u0001\u0005/\tqf\u00195b]\u001e,7i\u001c8tk6,'oU;cg\u000e\u0014\u0018\u000e\u001d;j_:\fe\u000e\u001a,bY&$\u0017\r^3BgNLwM\\7f]R,bA!\u0007\u0003$\t]B#C\n\u0003\u001c\tm\"Q\bB \u0011!\t9Ga\u0005A\u0002\tu\u0001\u0003CA6\u0003g\u0012yB!\u000e\u0011\t\t\u0005\"1\u0005\u0007\u0001\t!\u0011)Ca\u0005C\u0002\t\u001d\"!A&\u0012\t\t%\"q\u0006\t\u0004)\t-\u0012b\u0001B\u0017+\t9aj\u001c;iS:<\u0007c\u0001\u000b\u00032%\u0019!1G\u000b\u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u0003\"\t]B\u0001\u0003B\u001d\u0005'\u0011\rAa\n\u0003\u0003YC\u0001\"!\"\u0003\u0014\u0001\u0007\u0011q\u0011\u0005\t\u0003\u000b\u0014\u0019\u00021\u0001\u00028!A!\u0011\tB\n\u0001\u0004\u0011\u0019%A\tsK\n\fG.\u00198dK2K7\u000f^3oKJ\u0004B!a\u001b\u0003F%!!qIA7\u0005e\u0019uN\\:v[\u0016\u0014(+\u001a2bY\u0006t7-\u001a'jgR,g.\u001a:\t\u0013\t-\u0003!%A\u0005\u0002\t5\u0013!\t<bY&$\u0017\r^3He>,\b/Q:tS\u001etW.\u001a8uI\u0011,g-Y;mi\u0012\"TC\u0001B(U\u0011\u0011\tA!\u0015,\u0005\tM\u0003\u0003\u0002B+\u0005?j!Aa\u0016\u000b\t\te#1L\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0018\u0016\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005C\u00129FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class PlaintextConsumerTest
extends BaseConsumerTest {
    @Test
    public void testMaxPollRecords() {
        int maxPollRecords = 2;
        int numRecords = 10000;
        this.sendRecords(numRecords);
        this.consumerConfig().setProperty("max.poll.records", ((Object)BoxesRunTime.boxToInteger((int)maxPollRecords)).toString());
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        consumer0.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        KafkaConsumer x$5 = consumer0;
        int x$6 = numRecords;
        int x$7 = 0;
        int x$8 = maxPollRecords;
        int x$9 = this.consumeAndVerifyRecords$default$4();
        long x$10 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$11 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$12 = this.consumeAndVerifyRecords$default$7();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$5, x$6, x$7, x$9, x$10, x$11, x$12, x$8);
    }

    @Test
    public void testAutoCommitOnClose() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        int numRecords = 10000;
        this.sendRecords(numRecords);
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, assignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$1;
            private final scala.collection.immutable.Set assignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$1.poll(50L);
                java.util.Set set = this.consumer0$1.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$1 = consumer0$1;
                this.assignment$1 = assignment$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)assignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        consumer0.seek(this.tp(), 300L);
        consumer0.seek(this.tp2(), 500L);
        consumer0.close();
        Assert.assertEquals((long)300L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()).offset());
        Assert.assertEquals((long)500L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp2()).offset());
    }

    @Test
    public void testAutoCommitOnCloseAfterWakeup() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        int numRecords = 10000;
        this.sendRecords(numRecords);
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, assignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$2;
            private final scala.collection.immutable.Set assignment$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$2.poll(50L);
                java.util.Set set = this.consumer0$2.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$2).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$2 = consumer0$2;
                this.assignment$2 = assignment$2;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)assignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        consumer0.seek(this.tp(), 300L);
        consumer0.seek(this.tp2(), 500L);
        consumer0.wakeup();
        consumer0.close();
        Assert.assertEquals((long)300L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()).offset());
        Assert.assertEquals((long)500L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp2()).offset());
    }

    @Test
    public void testAutoOffsetReset() {
        this.sendRecords(1);
        ((KafkaConsumer)this.consumers().apply(0)).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(0)), 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testGroupConsumption() {
        this.sendRecords(10);
        ((KafkaConsumer)this.consumers().apply(0)).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(0)), 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testPatternSubscription() {
        int numRecords = 10000;
        this.sendRecords(numRecords);
        String topic1 = "tblablac";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic1, 0));
        this.sendRecords(1000, new TopicPartition(topic1, 1));
        String topic2 = "tblablak";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic2, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic2, 0));
        this.sendRecords(1000, new TopicPartition(topic2, 1));
        String topic3 = "tblab1";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic3, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic3, 0));
        this.sendRecords(1000, new TopicPartition(topic3, 1));
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().apply(0)).assignment().size());
        Pattern pattern = Pattern.compile("t.*c");
        ((KafkaConsumer)this.consumers().apply(0)).subscribe(pattern, (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener());
        ((KafkaConsumer)this.consumers().apply(0)).poll(50L);
        ObjectRef subscriptions = new ObjectRef((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final ObjectRef subscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$1.elem)).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.subscriptions$1 = subscriptions$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)subscriptions.elem)).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        String topic4 = "tsomec";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic4, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic4, 0));
        this.sendRecords(1000, new TopicPartition(topic4, 1));
        subscriptions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)subscriptions.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic4, 0), new TopicPartition(topic4, 1)})));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final ObjectRef subscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$1.elem)).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.subscriptions$1 = subscriptions$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)subscriptions.elem)).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        ((KafkaConsumer)this.consumers().apply(0)).unsubscribe();
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().apply(0)).assignment().size());
    }

    @Test
    public void testPatternUnsubscription() {
        int numRecords = 10000;
        this.sendRecords(numRecords);
        String topic1 = "tblablac";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic1, 0));
        this.sendRecords(1000, new TopicPartition(topic1, 1));
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().apply(0)).assignment().size());
        ((KafkaConsumer)this.consumers().apply(0)).subscribe(Pattern.compile("t.*c"), (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener());
        ((KafkaConsumer)this.consumers().apply(0)).poll(50L);
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set subscriptions$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$2).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.subscriptions$2 = subscriptions$2;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        ((KafkaConsumer)this.consumers().apply(0)).unsubscribe();
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().apply(0)).assignment().size());
    }

    @Test
    public void testCommitMetadata() {
        ((KafkaConsumer)this.consumers().apply(0)).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        OffsetAndMetadata syncMetadata = new OffsetAndMetadata(5L, "foo");
        ((KafkaConsumer)this.consumers().apply(0)).commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)syncMetadata)}))).asJava());
        Assert.assertEquals((Object)syncMetadata, (Object)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()));
        OffsetAndMetadata asyncMetadata = new OffsetAndMetadata(10L, "bar");
        BaseConsumerTest.CountConsumerCommitCallback callback = new BaseConsumerTest.CountConsumerCommitCallback();
        ((KafkaConsumer)this.consumers().apply(0)).commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)asyncMetadata)}))).asJava(), (OffsetCommitCallback)callback);
        this.awaitCommitCallback((Consumer)this.consumers().apply(0), callback, this.awaitCommitCallback$default$3());
        Assert.assertEquals((Object)asyncMetadata, (Object)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()));
        OffsetAndMetadata nullMetadata = new OffsetAndMetadata(5L, null);
        ((KafkaConsumer)this.consumers().apply(0)).commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)nullMetadata)}))).asJava());
        Assert.assertEquals((Object)nullMetadata, (Object)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()));
    }

    @Test
    public void testAsyncCommit() {
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().apply(0);
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.poll(0L);
        BaseConsumerTest.CountConsumerCommitCallback callback = new BaseConsumerTest.CountConsumerCommitCallback();
        int count = 5;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).foreach$mVc$sp((Function1)new Serializable(this, consumer, callback){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaConsumer consumer$1;
            private final BaseConsumerTest.CountConsumerCommitCallback callback$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.consumer$1.commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.tp()), (Object)new OffsetAndMetadata((long)i))}))).asJava(), (OffsetCommitCallback)this.callback$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.consumer$1 = consumer$1;
                this.callback$1 = callback$1;
            }
        });
        this.awaitCommitCallback(consumer, callback, count);
        Assert.assertEquals((Object)new OffsetAndMetadata((long)count), (Object)consumer.committed(this.tp()));
    }

    @Test
    public void testExpandingTopicSubscriptions() {
        String otherTopic = "other";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)})));
        ((KafkaConsumer)this.consumers().apply(0)).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set subscriptions$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$3).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.subscriptions$3 = subscriptions$3;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), otherTopic, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ((KafkaConsumer)this.consumers().apply(0)).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), otherTopic}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, expandedSubscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set expandedSubscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expandedSubscriptions$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.expandedSubscriptions$1 = expandedSubscriptions$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)expandedSubscriptions).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    @Test
    public void testShrinkingTopicSubscriptions() {
        String otherTopic = "other";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), otherTopic, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)}));
        scala.collection.immutable.Set shrunkenSubscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        ((KafkaConsumer)this.consumers().apply(0)).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), otherTopic}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set subscriptions$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$4).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.subscriptions$4 = subscriptions$4;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        ((KafkaConsumer)this.consumers().apply(0)).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, shrunkenSubscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set shrunkenSubscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.shrunkenSubscriptions$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.shrunkenSubscriptions$1 = shrunkenSubscriptions$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)shrunkenSubscriptions).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    @Test
    public void testPartitionsFor() {
        int numParts = 2;
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "part-test", numParts, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        java.util.List parts = ((KafkaConsumer)this.consumers().apply(0)).partitionsFor("part-test");
        Assert.assertNotNull((Object)parts);
        Assert.assertEquals((long)2L, (long)parts.size());
    }

    @Test
    public void testPartitionsForAutoCreate() {
        java.util.List partitions = ((KafkaConsumer)this.consumers().apply(0)).partitionsFor("non-exist-topic");
        Assert.assertFalse((boolean)partitions.isEmpty());
    }

    @Test(expected=InvalidTopicException.class)
    public void testPartitionsForInvalidTopic() {
        ((KafkaConsumer)this.consumers().apply(0)).partitionsFor(";3# ads,{234");
    }

    @Test
    public void testSeek() {
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().apply(0);
        long totalRecords = 50L;
        long mid = totalRecords / 2L;
        this.sendRecords((int)totalRecords, this.tp());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.seekToEnd((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((long)totalRecords, (long)consumer.position(this.tp()));
        Assert.assertFalse((boolean)consumer.poll(totalRecords).iterator().hasNext());
        consumer.seekToBeginning((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((float)0.0f, (float)consumer.position(this.tp()), (float)0.0f);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        consumer.seek(this.tp(), mid);
        Assert.assertEquals((long)mid, (long)consumer.position(this.tp()));
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, (int)mid, (int)mid, mid, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.sendCompressedMessages((int)totalRecords, this.tp2());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        consumer.seekToEnd((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        Assert.assertEquals((long)totalRecords, (long)consumer.position(this.tp2()));
        Assert.assertFalse((boolean)consumer.poll(totalRecords).iterator().hasNext());
        consumer.seekToBeginning((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        Assert.assertEquals((float)0.0f, (float)consumer.position(this.tp2()), (float)0.0f);
        KafkaConsumer x$13 = consumer;
        int x$14 = 1;
        int x$15 = 0;
        TopicPartition x$16 = this.tp2();
        int x$17 = this.consumeAndVerifyRecords$default$4();
        long x$18 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$19 = this.consumeAndVerifyRecords$default$6();
        int x$20 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$13, x$14, x$15, x$17, x$18, x$19, x$16, x$20);
        consumer.seek(this.tp2(), mid);
        Assert.assertEquals((long)mid, (long)consumer.position(this.tp2()));
        KafkaConsumer x$21 = consumer;
        int x$22 = 1;
        int x$23 = (int)mid;
        int x$24 = (int)mid;
        long x$25 = mid;
        TopicPartition x$26 = this.tp2();
        TimestampType x$27 = this.consumeAndVerifyRecords$default$6();
        int x$28 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$21, x$22, x$23, x$24, x$25, x$27, x$26, x$28);
    }

    private void sendCompressedMessages(int numRecords, TopicPartition tp) {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", CompressionType.GZIP.name);
        producerProps.setProperty("linger.ms", ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        String x$29 = this.brokerList();
        SecurityProtocol x$30 = this.securityProtocol();
        Option<File> x$31 = this.trustStoreFile();
        Option<Properties> x$32 = this.saslProperties();
        int x$33 = 0;
        long x$34 = Long.MAX_VALUE;
        Some x$35 = new Some((Object)producerProps);
        int x$36 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$37 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$38 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$39 = TestUtils$.MODULE$.createNewProducer$default$7();
        ByteArraySerializer x$40 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$41 = TestUtils$.MODULE$.createNewProducer$default$12();
        KafkaProducer producer = TestUtils$.MODULE$.createNewProducer(x$29, x$36, x$37, x$38, x$33, x$34, x$39, x$30, x$31, x$32, x$40, x$41, (Option<Properties>)x$35);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(this, tp, producer){
            public static final long serialVersionUID = 0L;
            private final TopicPartition tp$1;
            private final KafkaProducer producer$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.producer$1.send(new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), Predef$.MODULE$.long2Long((long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes()));
            }
            {
                this.tp$1 = tp$1;
                this.producer$1 = producer$1;
            }
        });
        producer.close();
    }

    @Test
    public void testPositionAndCommit() {
        this.sendRecords(5);
        Assert.assertNull((Object)((KafkaConsumer)this.consumers().apply(0)).committed(new TopicPartition(this.topic(), 15)));
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return ((KafkaConsumer)this.$outer.consumers().apply(0)).position(new TopicPartition(this.$outer.topic(), 15));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
        ((KafkaConsumer)this.consumers().apply(0)).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((String)"position() on a partition that we are subscribed to should reset the offset", (long)0L, (long)((KafkaConsumer)this.consumers().apply(0)).position(this.tp()));
        ((KafkaConsumer)this.consumers().apply(0)).commitSync();
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()).offset());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(0)), 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        Assert.assertEquals((String)"After consuming 5 records, position should be 5", (long)5L, (long)((KafkaConsumer)this.consumers().apply(0)).position(this.tp()));
        ((KafkaConsumer)this.consumers().apply(0)).commitSync();
        Assert.assertEquals((String)"Committed offset should be returned", (long)5L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()).offset());
        this.sendRecords(1);
        ((KafkaConsumer)this.consumers().apply(1)).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(1)), 1, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testPartitionPauseAndResume() {
        java.util.List partitions = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava();
        this.sendRecords(5);
        ((KafkaConsumer)this.consumers().apply(0)).assign((Collection)partitions);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(0)), 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        ((KafkaConsumer)this.consumers().apply(0)).pause((Collection)partitions);
        this.sendRecords(5);
        Assert.assertTrue((boolean)((KafkaConsumer)this.consumers().apply(0)).poll(0L).isEmpty());
        ((KafkaConsumer)this.consumers().apply(0)).resume((Collection)partitions);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(0)), 5, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testFetchInvalidOffset() {
        this.consumerConfig().setProperty("auto.offset.reset", "none");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        int totalRecords = 2;
        this.sendRecords(totalRecords, this.tp());
        consumer0.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.intercept((Function0)new Serializable(this, consumer0){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$3;

            public final ConsumerRecords<byte[], byte[]> apply() {
                return this.consumer0$3.poll(50L);
            }
            {
                this.consumer0$3 = consumer0$3;
            }
        }, ManifestFactory$.MODULE$.classType(NoOffsetForPartitionException.class));
        int outOfRangePos = totalRecords + 1;
        consumer0.seek(this.tp(), (long)outOfRangePos);
        OffsetOutOfRangeException e = (OffsetOutOfRangeException)this.intercept((Function0)new Serializable(this, consumer0){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$3;

            public final ConsumerRecords<byte[], byte[]> apply() {
                return this.consumer0$3.poll(20000L);
            }
            {
                this.consumer0$3 = consumer0$3;
            }
        }, ManifestFactory$.MODULE$.classType(OffsetOutOfRangeException.class));
        java.util.Map outOfRangePartitions = e.offsetOutOfRangePartitions();
        Assert.assertNotNull((Object)outOfRangePartitions);
        Assert.assertEquals((long)1L, (long)outOfRangePartitions.size());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)outOfRangePos), outOfRangePartitions.get(this.tp()));
    }

    @Test
    public void testFetchRecordTooLarge() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxFetchBytes)).toString());
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)new byte[maxFetchBytes + 1]);
        ((KafkaProducer)this.producers().apply(0)).send(record);
        consumer0.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        RecordTooLargeException e = (RecordTooLargeException)this.intercept((Function0)new Serializable(this, consumer0){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$4;

            public final ConsumerRecords<byte[], byte[]> apply() {
                return this.consumer0$4.poll(20000L);
            }
            {
                this.consumer0$4 = consumer0$4;
            }
        }, ManifestFactory$.MODULE$.classType(RecordTooLargeException.class));
        java.util.Map oversizedPartitions = e.recordTooLargePartitions();
        Assert.assertNotNull((Object)oversizedPartitions);
        Assert.assertEquals((long)1L, (long)oversizedPartitions.size());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), oversizedPartitions.get(this.tp()));
    }

    @Test
    public void testRoundRobinAssignment() {
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        String topic1 = "topic1";
        String topic2 = "topic2";
        scala.collection.immutable.Set expectedAssignment = (scala.collection.immutable.Set)this.createTopicAndSendRecords(topic1, 2, 100).$plus$plus(this.createTopicAndSendRecords(topic2, 2, 100));
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, expectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$5;
            private final scala.collection.immutable.Set expectedAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$5.poll(50L);
                java.util.Set set = this.consumer0$5.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expectedAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$5 = consumer0$5;
                this.expectedAssignment$1 = expectedAssignment$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)expectedAssignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        String topic3 = "topic3";
        this.createTopicAndSendRecords(topic3, 2, 100);
        scala.collection.immutable.Set newExpectedAssignment = (scala.collection.immutable.Set)expectedAssignment.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic3, 0), new TopicPartition(topic3, 1)})));
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, newExpectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$5;
            private final scala.collection.immutable.Set newExpectedAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$5.poll(50L);
                java.util.Set set = this.consumer0$5.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.newExpectedAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$5 = consumer0$5;
                this.newExpectedAssignment$1 = newExpectedAssignment$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)newExpectedAssignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, expectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$5;
            private final scala.collection.immutable.Set expectedAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$5.poll(50L);
                java.util.Set set = this.consumer0$5.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expectedAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$5 = consumer0$5;
                this.expectedAssignment$1 = expectedAssignment$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)expectedAssignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        consumer0.unsubscribe();
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
    }

    @Test
    public void testMultiConsumerRoundRobinAssignment() {
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        String topic1 = "topic1";
        String topic2 = "topic2";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)this.createTopicAndSendRecords(topic1, 5, 100).$plus$plus(this.createTopicAndSendRecords(topic2, 8, 100));
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<BaseConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(10, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Buffer rrConsumers = (Buffer)tuple2._1();
            Buffer consumerPollers = (Buffer)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)rrConsumers, (Object)consumerPollers);
            Buffer rrConsumers2 = (Buffer)tuple23._1();
            Buffer consumerPollers2 = (Buffer)tuple23._2();
            this.addConsumersToGroupAndWaitForGroupAssignment(1, this.consumers(), (Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
            consumerPollers2.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                    poller.shutdown();
                }
            });
            this.consumers().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaConsumer<byte[], byte[]> consumer) {
                    consumer.unsubscribe();
                }
            });
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testMultiConsumerDefaultAssignment() {
        this.sendRecords(100, this.tp());
        this.sendRecords(100, this.tp2());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(topic1, 5, 100));
        Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumersAndWaitForAssignment(this.consumers(), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        this.addConsumersToGroupAndWaitForGroupAssignment(2, this.consumers(), consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        String topic2 = "topic2";
        scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus(this.createTopicAndSendRecords(topic2, 3, 100));
        this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)expandedSubscriptions);
        this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        consumerPollers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                poller.shutdown();
            }
        });
        this.consumers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaConsumer<byte[], byte[]> consumer) {
                consumer.unsubscribe();
            }
        });
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnStopPolling() {
        this.runMultiConsumerSessionTimeoutTest(false);
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnClose() {
        this.runMultiConsumerSessionTimeoutTest(true);
    }

    @Test
    public void testInterceptors() {
        String appendStr = "mock";
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.brokerList());
        producerProps.put("interceptor.classes", "org.apache.kafka.test.MockProducerInterceptor");
        producerProps.put("mock.interceptor.append", appendStr);
        KafkaProducer testProducer = new KafkaProducer(producerProps, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        int numRecords = 10;
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, testProducer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaProducer testProducer$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.testProducer$1.send(new ProducerRecord(this.$outer.tp().topic(), Predef$.MODULE$.int2Integer(this.$outer.tp().partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.testProducer$1 = testProducer$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$2) {
                return x$2.get();
            }
        });
        Assert.assertEquals((long)numRecords, (long)MockProducerInterceptor.ONSEND_COUNT.intValue());
        Assert.assertEquals((long)numRecords, (long)MockProducerInterceptor.ON_SUCCESS_COUNT.intValue());
        try {
            testProducer.send(null, null);
            throw this.fail("Should not allow sending a null record");
        }
        catch (Throwable throwable) {
            Assert.assertEquals((String)"Interceptor should be notified about exception", (long)1L, (long)MockProducerInterceptor.ON_ERROR_COUNT.intValue());
            Assert.assertEquals((String)"Interceptor should not receive metadata with an exception when record is null", (long)0L, (long)MockProducerInterceptor.ON_ERROR_WITH_METADATA_COUNT.intValue());
            this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
            KafkaConsumer testConsumer = new KafkaConsumer(this.consumerConfig(), (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            testConsumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
            testConsumer.seek(this.tp(), 0L);
            ArrayList records = this.consumeRecords(testConsumer, numRecords, this.consumeRecords$default$3());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)new Serializable(this, appendStr, records){
                public static final long serialVersionUID = 0L;
                private final String appendStr$1;
                private final ArrayList records$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    ConsumerRecord record = (ConsumerRecord)this.records$1.get(i);
                    Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new String((String)record.key()));
                    Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), this.appendStr$1})).toUpperCase(Locale.ROOT), (Object)new String((String)record.value()));
                }
                {
                    this.appendStr$1 = appendStr$1;
                    this.records$1 = records$1;
                }
            });
            int commitCountBefore = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
            testConsumer.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(2L))}))).asJava());
            Assert.assertEquals((long)2L, (long)testConsumer.committed(this.tp()).offset());
            Assert.assertEquals((long)(commitCountBefore + 1), (long)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
            BaseConsumerTest.CountConsumerCommitCallback commitCallback = new BaseConsumerTest.CountConsumerCommitCallback();
            testConsumer.commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(5L))}))).asJava(), (OffsetCommitCallback)commitCallback);
            this.awaitCommitCallback(testConsumer, commitCallback, this.awaitCommitCallback$default$3());
            Assert.assertEquals((long)5L, (long)testConsumer.committed(this.tp()).offset());
            Assert.assertEquals((long)(commitCountBefore + 2), (long)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
            testConsumer.close();
            testProducer.close();
            MockConsumerInterceptor.resetCounters();
            MockProducerInterceptor.resetCounters();
            return;
        }
    }

    @Test
    public void testAutoCommitIntercept() {
        String topic2 = "topic2";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic2, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int numRecords = 100;
        KafkaProducer testProducer = new KafkaProducer(this.producerConfig(), (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, testProducer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaProducer testProducer$2;

            public final Future<RecordMetadata> apply(int i) {
                return this.testProducer$2.send(new ProducerRecord(this.$outer.tp().topic(), Predef$.MODULE$.int2Integer(this.$outer.tp().partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.testProducer$2 = testProducer$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$3) {
                return x$3.get();
            }
        });
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = new KafkaConsumer(this.consumerConfig(), (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(this, testConsumer){
            private final KafkaConsumer testConsumer$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.testConsumer$1.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.testConsumer$1 = testConsumer$1;
            }
        };
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))), rebalanceListener);
        testConsumer.seek(this.tp(), 10L);
        testConsumer.seek(this.tp2(), 20L);
        int commitCountBeforeRebalance = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2})), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}))), rebalanceListener);
        Assert.assertEquals((long)10L, (long)testConsumer.committed(this.tp()).offset());
        Assert.assertEquals((long)20L, (long)testConsumer.committed(this.tp2()).offset());
        Assert.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeRebalance ? 1 : 0) != 0);
        int commitCountBeforeClose = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        testConsumer.close();
        Assert.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeClose ? 1 : 0) != 0);
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
    }

    @Test
    public void testInterceptorsWithWrongKeyValue() {
        String appendStr = "mock";
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.brokerList());
        producerProps.put("interceptor.classes", "org.apache.kafka.test.MockProducerInterceptor");
        producerProps.put("mock.interceptor.append", appendStr);
        KafkaProducer testProducer = new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
        this.producers().$plus$eq((Object)testProducer);
        testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})).s((Seq)Nil$.MODULE$).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value will not be modified"})).s((Seq)Nil$.MODULE$).getBytes()));
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)testConsumer);
        testConsumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        testConsumer.seek(this.tp(), 0L);
        ArrayList records = this.consumeRecords(testConsumer, 1, this.consumeRecords$default$3());
        ConsumerRecord record = records.get(0);
        Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value will not be modified"})).s((Seq)Nil$.MODULE$), (Object)new String((byte[])record.value()));
    }

    public void testConsumeMessagesWithCreateTime() {
        int numRecords = 50;
        this.sendRecords(numRecords, this.tp());
        ((KafkaConsumer)this.consumers().apply(0)).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(0)), numRecords, 0, 0, 0L, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.sendCompressedMessages(numRecords, this.tp2());
        ((KafkaConsumer)this.consumers().apply(0)).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        KafkaConsumer x$42 = (KafkaConsumer)this.consumers().apply(0);
        int x$43 = numRecords;
        TopicPartition x$44 = this.tp2();
        int x$45 = 0;
        int x$46 = 0;
        long x$47 = 0L;
        TimestampType x$48 = this.consumeAndVerifyRecords$default$6();
        int x$49 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$42, x$43, x$45, x$46, x$47, x$48, x$44, x$49);
    }

    @Test
    public void testConsumeMessagesWithLogAppendTime() {
        String topicName = "testConsumeMessagesWithLogAppendTime";
        Properties topicProps = new Properties();
        topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime");
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicName, 2, 2, (Seq<KafkaServer>)this.servers(), topicProps);
        long startTime = System.currentTimeMillis();
        int numRecords = 50;
        TopicPartition tp1 = new TopicPartition(topicName, 0);
        this.sendRecords(numRecords, tp1);
        ((KafkaConsumer)this.consumers().apply(0)).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1}))).asJava());
        KafkaConsumer x$50 = (KafkaConsumer)this.consumers().apply(0);
        int x$51 = numRecords;
        TopicPartition x$52 = tp1;
        int x$53 = 0;
        int x$54 = 0;
        long x$55 = startTime;
        TimestampType x$56 = TimestampType.LOG_APPEND_TIME;
        int x$57 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$50, x$51, x$53, x$54, x$55, x$56, x$52, x$57);
        TopicPartition tp2 = new TopicPartition(topicName, 1);
        this.sendCompressedMessages(numRecords, tp2);
        ((KafkaConsumer)this.consumers().apply(0)).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2}))).asJava());
        KafkaConsumer x$58 = (KafkaConsumer)this.consumers().apply(0);
        int x$59 = numRecords;
        TopicPartition x$60 = tp2;
        int x$61 = 0;
        int x$62 = 0;
        long x$63 = startTime;
        TimestampType x$64 = TimestampType.LOG_APPEND_TIME;
        int x$65 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$58, x$59, x$61, x$62, x$63, x$64, x$60, x$65);
    }

    public void runMultiConsumerSessionTimeoutTest(boolean closeConsumer) {
        this.sendRecords(100, this.tp());
        this.sendRecords(100, this.tp2());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(topic1, 6, 100));
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.consumers().foreach((Function1)new Serializable(this, topic1, consumerPollers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final String topic1$1;
            private final Buffer consumerPollers$3;

            public final Buffer<BaseConsumerTest.ConsumerAssignmentPoller> apply(KafkaConsumer<byte[], byte[]> consumer) {
                return this.consumerPollers$3.$plus$eq((Object)((Object)this.$outer.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.topic(), this.topic1$1})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic1$1 = topic1$1;
                this.consumerPollers$3 = consumerPollers$3;
            }
        });
        KafkaConsumer timeoutConsumer = new KafkaConsumer(this.consumerConfig());
        Object object = closeConsumer ? BoxedUnit.UNIT : this.consumers().$plus$eq((Object)timeoutConsumer);
        BaseConsumerTest.ConsumerAssignmentPoller timeoutPoller = this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)timeoutConsumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})));
        consumerPollers.$plus$eq((Object)timeoutPoller);
        this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid initial assignment for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()})), this.validateGroupAssignment$default$4());
        timeoutPoller.shutdown();
        if (closeConsumer) {
            timeoutConsumer.close();
        }
        long maxSessionTimeout = new StringOps(Predef$.MODULE$.augmentString(this.serverConfig().getProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp()))).toLong();
        this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after one consumer left"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()})), 3L * maxSessionTimeout);
        consumerPollers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                poller.shutdown();
            }
        });
    }

    public scala.collection.immutable.Set<TopicPartition> createTopicAndSendRecords(String topicName, int numPartitions, int recordsPerPartition) {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicName, numPartitions, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ObjectRef parts = new ObjectRef((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)new Serializable(this, topicName, recordsPerPartition, parts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final String topicName$1;
            private final int recordsPerPartition$1;
            private final ObjectRef parts$1;

            public final void apply(int partition) {
                this.apply$mcVI$sp(partition);
            }

            public void apply$mcVI$sp(int partition) {
                TopicPartition tp = new TopicPartition(this.topicName$1, partition);
                this.$outer.sendRecords(this.recordsPerPartition$1, tp);
                this.parts$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)this.parts$1.elem).$plus((Object)tp);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicName$1 = topicName$1;
                this.recordsPerPartition$1 = recordsPerPartition$1;
                this.parts$1 = parts$1;
            }
        });
        return (scala.collection.immutable.Set)parts.elem;
    }

    /*
     * WARNING - void declaration
     */
    public BaseConsumerTest.ConsumerAssignmentPoller subscribeConsumerAndStartPolling(Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
        void var3_3;
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        BaseConsumerTest.ConsumerAssignmentPoller consumerPoller = new BaseConsumerTest.ConsumerAssignmentPoller(this, consumer, topicsToSubscribe);
        consumerPoller.start();
        return var3_3;
    }

    public Buffer<BaseConsumerTest.ConsumerAssignmentPoller> subscribeConsumersAndWaitForAssignment(Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumerGroup.foreach((Function1)new Serializable(this, topicsToSubscribe, consumerPollers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final List topicsToSubscribe$2;
            private final Buffer consumerPollers$5;

            public final Buffer<BaseConsumerTest.ConsumerAssignmentPoller> apply(KafkaConsumer<byte[], byte[]> consumer) {
                return this.consumerPollers$5.$plus$eq((Object)((Object)this.$outer.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)this.topicsToSubscribe$2)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicsToSubscribe$2 = topicsToSubscribe$2;
                this.consumerPollers$5 = consumerPollers$5;
            }
        });
        this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers, subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid initial assignment for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava()})), this.validateGroupAssignment$default$4());
        return consumerPollers;
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<BaseConsumerTest.ConsumerAssignmentPoller>> createConsumerGroupAndWaitForAssignment(int consumerCount, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Assert.assertTrue((consumerCount <= subscriptions.size() ? 1 : 0) != 0);
        Buffer consumerGroup = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), consumerCount).foreach((Function1)new Serializable(this, consumerGroup){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final Buffer consumerGroup$2;

            public final Buffer<KafkaConsumer<byte[], byte[]>> apply(int i) {
                return this.consumerGroup$2.$plus$eq((Object)new KafkaConsumer(this.$outer.consumerConfig()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.consumerGroup$2 = consumerGroup$2;
            }
        });
        this.consumers().$plus$plus$eq((TraversableOnce)consumerGroup);
        Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumersAndWaitForAssignment((Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup, topicsToSubscribe, subscriptions);
        return new Tuple2((Object)consumerGroup, consumerPollers);
    }

    public void addConsumersToGroupAndWaitForGroupAssignment(int numOfConsumersToAdd, Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Assert.assertTrue((consumerGroup.size() + numOfConsumersToAdd <= subscriptions.size() ? 1 : 0) != 0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numOfConsumersToAdd).foreach((Function1)new Serializable(this, consumerGroup, consumerPollers, topicsToSubscribe){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final Buffer consumerGroup$1;
            private final Buffer consumerPollers$1;
            private final List topicsToSubscribe$1;

            public final Buffer<BaseConsumerTest.ConsumerAssignmentPoller> apply(int i) {
                KafkaConsumer newConsumer = new KafkaConsumer(this.$outer.consumerConfig());
                this.consumerGroup$1.$plus$eq((Object)newConsumer);
                return this.consumerPollers$1.$plus$eq((Object)((Object)this.$outer.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)newConsumer, (List<String>)this.topicsToSubscribe$1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.consumerGroup$1 = consumerGroup$1;
                this.consumerPollers$1 = consumerPollers$1;
                this.topicsToSubscribe$1 = topicsToSubscribe$1;
            }
        });
        this.validateGroupAssignment(consumerPollers, subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after we added ", " consumer(s)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava(), BoxesRunTime.boxToInteger((int)numOfConsumersToAdd)})), this.validateGroupAssignment$default$4());
    }

    public void validateGroupAssignment(Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, scala.collection.immutable.Set<TopicPartition> subscriptions, String msg, long waitTime) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerPollers, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final Buffer consumerPollers$4;
            private final scala.collection.immutable.Set subscriptions$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Buffer assignments = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.consumerPollers$4.foreach((Function1)new Serializable(this, assignments){
                    public static final long serialVersionUID = 0L;
                    private final Buffer assignments$1;

                    public final Buffer<scala.collection.immutable.Set<TopicPartition>> apply(BaseConsumerTest.ConsumerAssignmentPoller x$4) {
                        return this.assignments$1.$plus$eq(x$4.consumerAssignment());
                    }
                    {
                        this.assignments$1 = assignments$1;
                    }
                });
                return this.$outer.isPartitionAssignmentValid((Buffer<scala.collection.immutable.Set<TopicPartition>>)assignments, (scala.collection.immutable.Set<TopicPartition>)this.subscriptions$6);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.consumerPollers$4 = consumerPollers$4;
                this.subscriptions$6 = subscriptions$6;
            }
        }, msg, waitTime);
    }

    public long validateGroupAssignment$default$4() {
        return 10000L;
    }

    public void changeConsumerGroupSubscriptionAndValidateAssignment(Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        consumerPollers.foreach((Function1)new Serializable(this, topicsToSubscribe){
            public static final long serialVersionUID = 0L;
            private final List topicsToSubscribe$3;

            public final void apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                poller.subscribe((List<String>)this.topicsToSubscribe$3);
            }
            {
                this.topicsToSubscribe$3 = topicsToSubscribe$3;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerPollers){
            public static final long serialVersionUID = 0L;
            private final Buffer consumerPollers$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.consumerPollers$2.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                        return poller.isSubscribeRequestProcessed();
                    }
                });
            }
            {
                this.consumerPollers$2 = consumerPollers$2;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to call subscribe on all consumers in the group for subscription ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{subscriptions})), 1000L);
        this.validateGroupAssignment(consumerPollers, subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after we changed subscription"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava()})), this.validateGroupAssignment$default$4());
    }

    public <K, V> void changeConsumerSubscriptionAndValidateAssignment(Consumer<K, V> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions, ConsumerRebalanceListener rebalanceListener) {
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), rebalanceListener);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, subscriptions){
            public static final long serialVersionUID = 0L;
            private final Consumer consumer$2;
            private final scala.collection.immutable.Set subscriptions$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ConsumerRecords records = this.consumer$2.poll(50L);
                java.util.Set set = this.consumer$2.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$5).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer$2 = consumer$2;
                this.subscriptions$5 = subscriptions$5;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava(), consumer.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
    }
}

