/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.io.File;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import kafka.common.MessageStreamsExistException;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.ConsumerThreadId;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.consumer.PartitionTopicInfo;
import kafka.consumer.ZookeeperConsumerConnector;
import kafka.consumer.ZookeeperConsumerConnectorTest$;
import kafka.consumer.ZookeeperConsumerConnectorTest$$anonfun$testConsumerDecoder$2$;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.javaapi.consumer.ConsumerRebalanceListener;
import kafka.message.CompressionCodec;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.serializer.Decoder;
import kafka.serializer.StringDecoder;
import kafka.serializer.StringDecoder$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.TestUtils$;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\rc\u0001B\u0001\u0003\u0001\u001d\u0011aDW8pW\u0016,\u0007/\u001a:D_:\u001cX/\\3s\u0007>tg.Z2u_J$Vm\u001d;\u000b\u0005\r!\u0011\u0001C2p]N,X.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u0011IA\u0002CA\u0005\u0011\u001b\u0005Q!BA\u0006\r\u0003\u0015QWO\\5u\u0015\tia\"A\u0005tG\u0006d\u0017\r^3ti*\tq\"A\u0002pe\u001eL!!\u0005\u0006\u0003\u0015)+f.\u001b;Tk&$X\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0013\t9BC\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\tIB$D\u0001\u001b\u0015\tYB!A\u0003vi&d7/\u0003\u0002\u001e5\t9Aj\\4hS:<\u0007\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\bF\u0001\"!\t\u0011\u0003!D\u0001\u0003\u0011\u001d!\u0003A1A\u0005\u0002\u0015\n!CU3cC2\fgnY3CC\u000e\\wN\u001a4NgV\ta\u0005\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003FA\u0002J]RDa!\f\u0001!\u0002\u00131\u0013a\u0005*fE\u0006d\u0017M\\2f\u0005\u0006\u001c7n\u001c4g\u001bN\u0004\u0003bB\u0018\u0001\u0001\u0004%\t\u0001M\u0001\u0005I&\u00148/F\u00012!\tI\"'\u0003\u000245\t\u0001\"lS$s_V\u0004Hk\u001c9jG\u0012K'o\u001d\u0005\bk\u0001\u0001\r\u0011\"\u00017\u0003!!\u0017N]:`I\u0015\fHCA\u001c;!\t9\u0003(\u0003\u0002:Q\t!QK\\5u\u0011\u001dYD'!AA\u0002E\n1\u0001\u001f\u00132\u0011\u0019i\u0004\u0001)Q\u0005c\u0005)A-\u001b:tA!9q\b\u0001b\u0001\n\u0003)\u0013\u0001\u00038v[:{G-Z:\t\r\u0005\u0003\u0001\u0015!\u0003'\u0003%qW/\u001c(pI\u0016\u001c\b\u0005C\u0004D\u0001\t\u0007I\u0011A\u0013\u0002\u00119,X\u000eU1siNDa!\u0012\u0001!\u0002\u00131\u0013!\u00038v[B\u000b'\u000f^:!\u0011\u001d9\u0005A1A\u0005\u0002!\u000bQ\u0001^8qS\u000e,\u0012!\u0013\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000bA\u0001\\1oO*\ta*\u0001\u0003kCZ\f\u0017B\u0001)L\u0005\u0019\u0019FO]5oO\"1!\u000b\u0001Q\u0001\n%\u000ba\u0001^8qS\u000e\u0004\u0003b\u0002+\u0001\u0005\u0004%\t!V\u0001\u0010_Z,'O]5eS:<\u0007K]8qgV\ta\u000b\u0005\u0002X56\t\u0001L\u0003\u0002Z\u001b\u0006!Q\u000f^5m\u0013\tY\u0006L\u0001\u0006Qe>\u0004XM\u001d;jKNDa!\u0018\u0001!\u0002\u00131\u0016\u0001E8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:!\u0011\u0015y\u0006\u0001\"\u0011a\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cH#A1\u0011\u0007\tTWN\u0004\u0002dQ:\u0011AmZ\u0007\u0002K*\u0011aMB\u0001\u0007yI|w\u000e\u001e \n\u0003%J!!\u001b\u0015\u0002\u000fA\f7m[1hK&\u00111\u000e\u001c\u0002\u0004'\u0016\f(BA5)!\tq\u0017/D\u0001p\u0015\t\u0001H!\u0001\u0004tKJ4XM]\u0005\u0003e>\u00141bS1gW\u0006\u001cuN\u001c4jO\"9A\u000f\u0001b\u0001\n\u0003A\u0015!B4s_V\u0004\bB\u0002<\u0001A\u0003%\u0011*\u0001\u0004he>,\b\u000f\t\u0005\bq\u0002\u0011\r\u0011\"\u0001I\u0003%\u0019wN\\:v[\u0016\u0014\b\u0007\u0003\u0004{\u0001\u0001\u0006I!S\u0001\u000bG>t7/^7feB\u0002\u0003b\u0002?\u0001\u0005\u0004%\t\u0001S\u0001\nG>t7/^7feFBaA \u0001!\u0002\u0013I\u0015AC2p]N,X.\u001a:2A!A\u0011\u0011\u0001\u0001C\u0002\u0013\u0005\u0001*A\u0005d_:\u001cX/\\3se!9\u0011Q\u0001\u0001!\u0002\u0013I\u0015AC2p]N,X.\u001a:3A!A\u0011\u0011\u0002\u0001C\u0002\u0013\u0005\u0001*A\u0005d_:\u001cX/\\3sg!9\u0011Q\u0002\u0001!\u0002\u0013I\u0015AC2p]N,X.\u001a:4A!A\u0011\u0011\u0003\u0001C\u0002\u0013\u0005Q%A\u0005o\u001b\u0016\u001c8/Y4fg\"9\u0011Q\u0003\u0001!\u0002\u00131\u0013A\u00038NKN\u001c\u0018mZ3tA!9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0011!B:fiV\u0003H#A\u001c)\t\u0005]\u0011q\u0004\t\u0005\u0003C\t)#\u0004\u0002\u0002$)\u00111BD\u0005\u0005\u0003O\t\u0019C\u0001\u0004CK\u001a|'/\u001a\u0005\b\u0003W\u0001A\u0011IA\u000e\u0003!!X-\u0019:E_^t\u0007\u0006BA\u0015\u0003_\u0001B!!\t\u00022%!\u00111GA\u0012\u0005\u0015\te\r^3s\u0011\u001d\t9\u0004\u0001C\u0001\u00037\t\u0011\u0002^3ti\n\u000b7/[2)\t\u0005U\u00121\b\t\u0005\u0003C\ti$\u0003\u0003\u0002@\u0005\r\"\u0001\u0002+fgRDq!a\u0011\u0001\t\u0003\tY\"A\buKN$8i\\7qe\u0016\u001c8/[8oQ\u0011\t\t%a\u000f\t\u000f\u0005%\u0003\u0001\"\u0001\u0002\u001c\u0005iB/Z:u\u0007>l\u0007O]3tg&|gnU3u\u0007>t7/^7qi&|g\u000e\u000b\u0003\u0002H\u0005m\u0002bBA(\u0001\u0011\u0005\u00111D\u0001\u0014i\u0016\u001cHoQ8ogVlWM\u001d#fG>$WM\u001d\u0015\u0005\u0003\u001b\nY\u0004C\u0004\u0002V\u0001!\t!a\u0007\u0002?Q,7\u000f\u001e'fC\u0012,'oU3mK\u000e$\u0018n\u001c8G_J\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0003\u0002T\u0005m\u0002bBA.\u0001\u0011\u0005\u00111D\u0001\u001ei\u0016\u001cHoQ8ogVlWM\u001d*fE\u0006d\u0017M\\2f\u0019&\u001cH/\u001a8fe\"\"\u0011\u0011LA\u001e\u0011\u001d\t\t\u0007\u0001C\u0001\u0003G\n1cZ3u5.\u001b\u0005.\u001b7ee\u0016tg+\u00197vKN$B!!\u001a\u0002\u0002B1\u0011qMA7\u0003_j!!!\u001b\u000b\u0007\u0005-\u0004&\u0001\u0006d_2dWm\u0019;j_:L1a[A5!\u001d9\u0013\u0011OA;\u0003kJ1!a\u001d)\u0005\u0019!V\u000f\u001d7feA!\u0011qOA?\u001d\r9\u0013\u0011P\u0005\u0004\u0003wB\u0013A\u0002)sK\u0012,g-C\u0002Q\u0003\u007fR1!a\u001f)\u0011!\t\u0019)a\u0018A\u0002\u0005U\u0014\u0001\u00029bi\"4a!a\"\u0001\t\u0005%%!\b+fgR\u001cuN\\:v[\u0016\u0014(+\u001a2bY\u0006t7-\u001a'jgR,g.\u001a:\u0014\r\u0005\u0015\u00151RAI!\rQ\u0015QR\u0005\u0004\u0003\u001f[%AB(cU\u0016\u001cG\u000f\u0005\u0003\u0002\u0014\u0006mUBAAK\u0015\r\u0019\u0011q\u0013\u0006\u0004\u00033#\u0011a\u00026bm\u0006\f\u0007/[\u0005\u0005\u0003;\u000b)JA\rD_:\u001cX/\\3s%\u0016\u0014\u0017\r\\1oG\u0016d\u0015n\u001d;f]\u0016\u0014\bbB\u0010\u0002\u0006\u0012\u0005\u0011\u0011\u0015\u000b\u0003\u0003G\u0003B!!*\u0002\u00066\t\u0001\u0001\u0003\u0006\u0002*\u0006\u0015\u0005\u0019!C\u0001\u0003W\u000bqDY3g_J,'+\u001a7fCNLgn\u001a)beRLG/[8og\u000e\u000bG\u000e\\3e+\t\ti\u000bE\u0002(\u0003_K1!!-)\u0005\u001d\u0011un\u001c7fC:D!\"!.\u0002\u0006\u0002\u0007I\u0011AA\\\u0003\r\u0012WMZ8sKJ+G.Z1tS:<\u0007+\u0019:uSRLwN\\:DC2dW\rZ0%KF$2aNA]\u0011%Y\u00141WA\u0001\u0002\u0004\ti\u000bC\u0005\u0002>\u0006\u0015\u0005\u0015)\u0003\u0002.\u0006\u0001#-\u001a4pe\u0016\u0014V\r\\3bg&tw\rU1si&$\u0018n\u001c8t\u0007\u0006dG.\u001a3!\u0011)\t\t-!\"A\u0002\u0013\u0005\u00111V\u0001\u001dE\u00164wN]3Ti\u0006\u0014H/\u001b8h\r\u0016$8\r[3sg\u000e\u000bG\u000e\\3e\u0011)\t)-!\"A\u0002\u0013\u0005\u0011qY\u0001!E\u00164wN]3Ti\u0006\u0014H/\u001b8h\r\u0016$8\r[3sg\u000e\u000bG\u000e\\3e?\u0012*\u0017\u000fF\u00028\u0003\u0013D\u0011bOAb\u0003\u0003\u0005\r!!,\t\u0013\u00055\u0017Q\u0011Q!\n\u00055\u0016!\b2fM>\u0014Xm\u0015;beRLgn\u001a$fi\u000eDWM]:DC2dW\r\u001a\u0011\t\u0015\u0005E\u0017Q\u0011a\u0001\n\u0003\t\u0019.\u0001\u0006d_:\u001cX/\\3s\u0013\u0012,\"!!\u001e\t\u0015\u0005]\u0017Q\u0011a\u0001\n\u0003\tI.\u0001\bd_:\u001cX/\\3s\u0013\u0012|F%Z9\u0015\u0007]\nY\u000eC\u0005<\u0003+\f\t\u00111\u0001\u0002v!I\u0011q\\ACA\u0003&\u0011QO\u0001\fG>t7/^7fe&#\u0007\u0005\u0003\u0006\u0002d\u0006\u0015\u0005\u0019!C\u0001\u0003K\f!\u0003]1si&$\u0018n\u001c8Po:,'o\u001d5jaV\u0011\u0011q\u001d\t\b/\u0006%\u0018QOAw\u0013\r\tY\u000f\u0017\u0002\u0004\u001b\u0006\u0004\b#B,\u0002p\u0006M\u0018bAAy1\n\u00191+\u001a;\u0011\u0007)\u000b)0C\u0002\u0002x.\u0013q!\u00138uK\u001e,'\u000f\u0003\u0006\u0002|\u0006\u0015\u0005\u0019!C\u0001\u0003{\fa\u0003]1si&$\u0018n\u001c8Po:,'o\u001d5ja~#S-\u001d\u000b\u0004o\u0005}\b\"C\u001e\u0002z\u0006\u0005\t\u0019AAt\u0011%\u0011\u0019!!\"!B\u0013\t9/A\nqCJ$\u0018\u000e^5p]>;h.\u001a:tQ&\u0004\b\u0005\u0003\u0006\u0003\b\u0005\u0015\u0005\u0019!C\u0001\u0005\u0013\t\u0001d\u001a7pE\u0006d\u0007+\u0019:uSRLwN\\(x]\u0016\u00148\u000f[5q+\t\u0011Y\u0001E\u0004X\u0003S\f)H!\u0004\u0011\u000f]\u000bI/a=\u0003\u0010A\u0019!E!\u0005\n\u0007\tM!A\u0001\tD_:\u001cX/\\3s)\"\u0014X-\u00193JI\"Q!qCAC\u0001\u0004%\tA!\u0007\u00029\u001ddwNY1m!\u0006\u0014H/\u001b;j_:|uO\\3sg\"L\u0007o\u0018\u0013fcR\u0019qGa\u0007\t\u0013m\u0012)\"!AA\u0002\t-\u0001\"\u0003B\u0010\u0003\u000b\u0003\u000b\u0015\u0002B\u0006\u0003e9Gn\u001c2bYB\u000b'\u000f^5uS>twj\u001e8feND\u0017\u000e\u001d\u0011\t\u0011\t\r\u0012Q\u0011C!\u0005K\t\u0011DY3g_J,'+\u001a7fCNLgn\u001a)beRLG/[8ogR\u0019qGa\n\t\u0011\u0005\r(\u0011\u0005a\u0001\u0003OD\u0001Ba\u000b\u0002\u0006\u0012\u0005#QF\u0001\u0017E\u00164wN]3Ti\u0006\u0014H/\u001b8h\r\u0016$8\r[3sgR)qGa\f\u00032!A\u0011\u0011\u001bB\u0015\u0001\u0004\t)\b\u0003\u0005\u0003\b\t%\u0002\u0019\u0001B\u0006Q\u001d\u0001!Q\u0007B\u001e\u0005\u007f\u00012a\nB\u001c\u0013\r\u0011I\u0004\u000b\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017E\u0001B\u001f\u0003!#\u0006.[:!i\u0016\u001cH\u000f\t5bg\u0002\u0012W-\u001a8!I\u0016\u0004(/Z2bi\u0016$\u0007%\u00198eA%$\be^5mY\u0002\u0012W\r\t:f[>4X\r\u001a\u0011j]\u0002\n\u0007EZ;ukJ,\u0007E]3mK\u0006\u001cX-\t\u0002\u0003B\u0005A\u0001GL\u00191]Ar\u0003\u0007")
public class ZookeeperConsumerConnectorTest
extends JUnitSuite
implements KafkaServerTestHarness {
    private final int RebalanceBackoffMs;
    private ZKGroupTopicDirs dirs;
    private final int numNodes;
    private final int numParts;
    private final String topic;
    private final Properties overridingProps;
    private final String group;
    private final String consumer0;
    private final String consumer1;
    private final String consumer2;
    private final String consumer3;
    private final int nMessages;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final Option<Function0<BoxedUnit>> setClusterAcl;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public Option<Function0<BoxedUnit>> setClusterAcl() {
        return this.setClusterAcl;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$setClusterAcl_$eq(Option x$1) {
        this.setClusterAcl = x$1;
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> saslProperties() {
        return KafkaServerTestHarness$class.saslProperties(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ZookeeperConsumerConnectorTest zookeeperConsumerConnectorTest = this;
        synchronized (zookeeperConsumerConnectorTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public int RebalanceBackoffMs() {
        return this.RebalanceBackoffMs;
    }

    public ZKGroupTopicDirs dirs() {
        return this.dirs;
    }

    public void dirs_$eq(ZKGroupTopicDirs x$1) {
        this.dirs = x$1;
    }

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public String topic() {
        return this.topic;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZookeeperConsumerConnectorTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public String group() {
        return this.group;
    }

    public String consumer0() {
        return this.consumer0;
    }

    public String consumer1() {
        return this.consumer1;
    }

    public String consumer2() {
        return this.consumer2;
    }

    public String consumer3() {
        return this.consumer3;
    }

    public int nMessages() {
        return this.nMessages;
    }

    @Override
    @Before
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
        this.dirs_$eq(new ZKGroupTopicDirs(this.group(), this.topic()));
    }

    @Override
    @After
    public void tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Test
    public void testBasic() {
        Logger requestHandlerLogger = Logger.getLogger(KafkaRequestHandler.class);
        requestHandlerLogger.setLevel(Level.FATAL);
        ConsumerConfig consumerConfig0 = new ConsumerConfig(this){
            private final int consumerTimeoutMs;

            public int consumerTimeoutMs() {
                return this.consumerTimeoutMs;
            }
            {
                this.consumerTimeoutMs = 200;
            }
        };
        ZookeeperConsumerConnector zkConsumerConnector0 = new ZookeeperConsumerConnector(consumerConfig0, true);
        Map topicMessageStreams0 = zkConsumerConnector0.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)new Serializable(this, topicMessageStreams0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZookeeperConsumerConnectorTest $outer;
            private final Map topicMessageStreams0$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                try {
                    TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)this.topicMessageStreams0$1, this.$outer.nMessages() * 2);
                    throw this.$outer.fail("should get an exception");
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                catch (ConsumerTimeoutException consumerTimeoutException) {
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicMessageStreams0$1 = topicMessageStreams0$1;
            }
        });
        zkConsumerConnector0.shutdown();
        List sentMessages1 = (List)TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), this.nMessages(), 0, TestUtils$.MODULE$.sendMessages$default$5()).$plus$plus(TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), this.nMessages(), 1, TestUtils$.MODULE$.sendMessages$default$5()), List$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        ConsumerConfig consumerConfig1 = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), this.group(), this.consumer1(), TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZookeeperConsumerConnector zkConsumerConnector1 = new ZookeeperConsumerConnector(consumerConfig1, true);
        Map topicMessageStreams1 = zkConsumerConnector1.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        List<String> receivedMessages1 = TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1, this.nMessages() * 2);
        Assert.assertEquals((Object)sentMessages1.sorted((Ordering)Ordering.String$.MODULE$), (Object)receivedMessages1.sorted((Ordering)Ordering.String$.MODULE$));
        Seq<Tuple2<String, String>> actual_1 = this.getZKChildrenValues(this.dirs().consumerOwnerDir());
        List expected_1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"0", (Object)"group1_consumer1-0"), new Tuple2((Object)"1", (Object)"group1_consumer1-0")}));
        Assert.assertEquals((Object)expected_1, actual_1);
        zkConsumerConnector1.commitOffsets(true);
        ConsumerConfig consumerConfig2 = new ConsumerConfig(this){
            private final int rebalanceBackoffMs;

            public int rebalanceBackoffMs() {
                return this.rebalanceBackoffMs;
            }
            {
                this.rebalanceBackoffMs = $outer.RebalanceBackoffMs();
            }
        };
        ZookeeperConsumerConnector zkConsumerConnector2 = new ZookeeperConsumerConnector(consumerConfig2, true);
        Map topicMessageStreams2 = zkConsumerConnector2.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        List sentMessages2 = (List)TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), this.nMessages(), 0, TestUtils$.MODULE$.sendMessages$default$5()).$plus$plus(TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), this.nMessages(), 1, TestUtils$.MODULE$.sendMessages$default$5()), List$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        List receivedMessages2 = (List)TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1, this.nMessages()).$plus$plus(TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)topicMessageStreams2, this.nMessages()), List$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)sentMessages2.sorted((Ordering)Ordering.String$.MODULE$), (Object)receivedMessages2.sorted((Ordering)Ordering.String$.MODULE$));
        Seq<Tuple2<String, String>> actual_2 = this.getZKChildrenValues(this.dirs().consumerOwnerDir());
        List expected_2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"0", (Object)"group1_consumer1-0"), new Tuple2((Object)"1", (Object)"group1_consumer2-0")}));
        Assert.assertEquals((Object)expected_2, actual_2);
        ConsumerConfig consumerConfig3 = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), this.group(), this.consumer3(), TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZookeeperConsumerConnector zkConsumerConnector3 = new ZookeeperConsumerConnector(consumerConfig3, true);
        Map topicMessageStreams3 = zkConsumerConnector3.createMessageStreams((Map)new HashMap());
        List sentMessages3 = (List)TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), this.nMessages(), 0, TestUtils$.MODULE$.sendMessages$default$5()).$plus$plus(TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), this.nMessages(), 1, TestUtils$.MODULE$.sendMessages$default$5()), List$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        List receivedMessages3 = (List)TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1, this.nMessages()).$plus$plus(TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)topicMessageStreams2, this.nMessages()), List$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)sentMessages3.sorted((Ordering)Ordering.String$.MODULE$), (Object)receivedMessages3.sorted((Ordering)Ordering.String$.MODULE$));
        Seq<Tuple2<String, String>> actual_3 = this.getZKChildrenValues(this.dirs().consumerOwnerDir());
        Assert.assertEquals((Object)expected_2, actual_3);
        try {
            Map topicMessageStreams4 = zkConsumerConnector3.createMessageStreams((Map)new HashMap());
            throw this.fail("Should fail with MessageStreamsExistException");
        }
        catch (MessageStreamsExistException messageStreamsExistException) {
            zkConsumerConnector1.shutdown();
            zkConsumerConnector2.shutdown();
            zkConsumerConnector3.shutdown();
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "all consumer connectors stopped";
                }
            });
            requestHandlerLogger.setLevel(Level.ERROR);
            return;
        }
    }

    @Test
    public void testCompression() {
        Logger requestHandlerLogger = Logger.getLogger(KafkaRequestHandler.class);
        requestHandlerLogger.setLevel(Level.FATAL);
        List sentMessages1 = (List)TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), this.nMessages(), 0, (CompressionCodec)GZIPCompressionCodec$.MODULE$).$plus$plus(TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), this.nMessages(), 1, (CompressionCodec)GZIPCompressionCodec$.MODULE$), List$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        ConsumerConfig consumerConfig1 = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), this.group(), this.consumer1(), TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZookeeperConsumerConnector zkConsumerConnector1 = new ZookeeperConsumerConnector(consumerConfig1, true);
        Map topicMessageStreams1 = zkConsumerConnector1.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        List<String> receivedMessages1 = TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1, this.nMessages() * 2);
        Assert.assertEquals((Object)sentMessages1.sorted((Ordering)Ordering.String$.MODULE$), (Object)receivedMessages1.sorted((Ordering)Ordering.String$.MODULE$));
        Seq<Tuple2<String, String>> actual_1 = this.getZKChildrenValues(this.dirs().consumerOwnerDir());
        List expected_1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"0", (Object)"group1_consumer1-0"), new Tuple2((Object)"1", (Object)"group1_consumer1-0")}));
        Assert.assertEquals((Object)expected_1, actual_1);
        zkConsumerConnector1.commitOffsets(true);
        ConsumerConfig consumerConfig2 = new ConsumerConfig(this){
            private final int rebalanceBackoffMs;

            public int rebalanceBackoffMs() {
                return this.rebalanceBackoffMs;
            }
            {
                this.rebalanceBackoffMs = $outer.RebalanceBackoffMs();
            }
        };
        ZookeeperConsumerConnector zkConsumerConnector2 = new ZookeeperConsumerConnector(consumerConfig2, true);
        Map topicMessageStreams2 = zkConsumerConnector2.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        List sentMessages2 = (List)TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), this.nMessages(), 0, (CompressionCodec)GZIPCompressionCodec$.MODULE$).$plus$plus(TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), this.nMessages(), 1, (CompressionCodec)GZIPCompressionCodec$.MODULE$), List$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        List receivedMessages2 = (List)TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1, this.nMessages()).$plus$plus(TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)topicMessageStreams2, this.nMessages()), List$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)sentMessages2.sorted((Ordering)Ordering.String$.MODULE$), (Object)receivedMessages2.sorted((Ordering)Ordering.String$.MODULE$));
        Seq<Tuple2<String, String>> actual_2 = this.getZKChildrenValues(this.dirs().consumerOwnerDir());
        List expected_2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"0", (Object)"group1_consumer1-0"), new Tuple2((Object)"1", (Object)"group1_consumer2-0")}));
        Assert.assertEquals((Object)expected_2, actual_2);
        ConsumerConfig consumerConfig3 = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), this.group(), this.consumer3(), TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZookeeperConsumerConnector zkConsumerConnector3 = new ZookeeperConsumerConnector(consumerConfig3, true);
        Map topicMessageStreams3 = zkConsumerConnector3.createMessageStreams((Map)new HashMap(), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        List sentMessages3 = (List)TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), this.nMessages(), 0, (CompressionCodec)GZIPCompressionCodec$.MODULE$).$plus$plus(TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), this.nMessages(), 1, (CompressionCodec)GZIPCompressionCodec$.MODULE$), List$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        List receivedMessages3 = (List)TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1, this.nMessages()).$plus$plus(TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)topicMessageStreams2, this.nMessages()), List$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)sentMessages3.sorted((Ordering)Ordering.String$.MODULE$), (Object)receivedMessages3.sorted((Ordering)Ordering.String$.MODULE$));
        Seq<Tuple2<String, String>> actual_3 = this.getZKChildrenValues(this.dirs().consumerOwnerDir());
        Assert.assertEquals((Object)expected_2, actual_3);
        zkConsumerConnector1.shutdown();
        zkConsumerConnector2.shutdown();
        zkConsumerConnector3.shutdown();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "all consumer connectors stopped";
            }
        });
        requestHandlerLogger.setLevel(Level.ERROR);
    }

    @Test
    public void testCompressionSetConsumption() {
        List sentMessages = (List)TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), 200, 0, (CompressionCodec)DefaultCompressionCodec$.MODULE$).$plus$plus(TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), 200, 1, (CompressionCodec)DefaultCompressionCodec$.MODULE$), List$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        ConsumerConfig consumerConfig1 = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), this.group(), this.consumer0(), TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZookeeperConsumerConnector zkConsumerConnector1 = new ZookeeperConsumerConnector(consumerConfig1, true);
        Map topicMessageStreams1 = zkConsumerConnector1.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        List<String> receivedMessages = TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1, 400);
        Assert.assertEquals((Object)sentMessages.sorted((Ordering)Ordering.String$.MODULE$), (Object)receivedMessages.sorted((Ordering)Ordering.String$.MODULE$));
        Seq<Tuple2<String, String>> actual_2 = this.getZKChildrenValues(this.dirs().consumerOwnerDir());
        List expected_2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"0", (Object)"group1_consumer0-0"), new Tuple2((Object)"1", (Object)"group1_consumer0-0")}));
        Assert.assertEquals((Object)expected_2, actual_2);
        zkConsumerConnector1.shutdown();
    }

    @Test
    public void testConsumerDecoder() {
        Logger requestHandlerLogger = Logger.getLogger(KafkaRequestHandler.class);
        requestHandlerLogger.setLevel(Level.FATAL);
        List sentMessages = (List)TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), this.nMessages(), 0, (CompressionCodec)NoCompressionCodec$.MODULE$).$plus$plus(TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), this.nMessages(), 1, (CompressionCodec)NoCompressionCodec$.MODULE$), List$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        ConsumerConfig consumerConfig = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), this.group(), this.consumer1(), TestUtils$.MODULE$.createConsumerProperties$default$4()));
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        ZookeeperConsumerConnector zkConsumerConnector = new ZookeeperConsumerConnector(consumerConfig, true);
        Map topicMessageStreams = zkConsumerConnector.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        ObjectRef receivedMessages = new ObjectRef((Object)Nil$.MODULE$);
        topicMessageStreams.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, List<KafkaStream<String, String>>> check$ifrefutable$1) {
                Tuple2<String, List<KafkaStream<String, String>>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, receivedMessages){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZookeeperConsumerConnectorTest $outer;
            public final ObjectRef receivedMessages$1;

            public final void apply(Tuple2<String, List<KafkaStream<String, String>>> x$2) {
                Tuple2<String, List<KafkaStream<String, String>>> tuple2 = x$2;
                if (tuple2 != null) {
                    List messageStreams = (List)tuple2._2();
                    messageStreams.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testConsumerDecoder$2 $outer;

                        public final void apply(KafkaStream<String, String> messageStream) {
                            ConsumerIterator iterator = messageStream.iterator();
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$consumer$ZookeeperConsumerConnectorTest$$anonfun$$$outer().nMessages() * 2).foreach$mVc$sp((Function1)new Serializable(this, iterator){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$testConsumerDecoder$2$$anonfun$apply$2 $outer;
                                private final ConsumerIterator iterator$1;

                                public final void apply(int i) {
                                    this.apply$mcVI$sp(i);
                                }

                                public void apply$mcVI$sp(int i) {
                                    Assert.assertTrue((boolean)this.iterator$1.hasNext());
                                    String message = (String)this.iterator$1.next().message();
                                    this.$outer.kafka$consumer$ZookeeperConsumerConnectorTest$$anonfun$$anonfun$$$outer().receivedMessages$1.elem = ((List)this.$outer.kafka$consumer$ZookeeperConsumerConnectorTest$$anonfun$$anonfun$$$outer().receivedMessages$1.elem).$colon$colon((Object)message);
                                    this.$outer.kafka$consumer$ZookeeperConsumerConnectorTest$$anonfun$$anonfun$$$outer().kafka$consumer$ZookeeperConsumerConnectorTest$$anonfun$$$outer().debug((Function0<String>)new Serializable(this, message){
                                        public static final long serialVersionUID = 0L;
                                        private final String message$1;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)"received message: ").append((Object)this.message$1).toString();
                                        }
                                        {
                                            this.message$1 = message$1;
                                        }
                                    });
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.iterator$1 = iterator$1;
                                }
                            });
                        }

                        public /* synthetic */ $anonfun$testConsumerDecoder$2 kafka$consumer$ZookeeperConsumerConnectorTest$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ZookeeperConsumerConnectorTest kafka$consumer$ZookeeperConsumerConnectorTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.receivedMessages$1 = receivedMessages$1;
            }
        });
        Assert.assertEquals((Object)sentMessages.sorted((Ordering)Ordering.String$.MODULE$), (Object)((List)receivedMessages.elem).sorted((Ordering)Ordering.String$.MODULE$));
        zkConsumerConnector.shutdown();
        requestHandlerLogger.setLevel(Level.ERROR);
    }

    @Test
    public void testLeaderSelectionForPartition() {
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), 6000, 30000, false);
        TestUtils$.MODULE$.createTopic(zkUtils, this.topic(), 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        List<String> sentMessages1 = TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), this.nMessages(), TestUtils$.MODULE$.sendMessages$default$4(), TestUtils$.MODULE$.sendMessages$default$5());
        ConsumerConfig consumerConfig1 = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), this.group(), this.consumer1(), TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZookeeperConsumerConnector zkConsumerConnector1 = new ZookeeperConsumerConnector(consumerConfig1, true);
        Map topicMessageStreams1 = zkConsumerConnector1.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        Pool topicRegistry = zkConsumerConnector1.getTopicRegistry();
        Assert.assertEquals((long)1L, (long)((TraversableOnce)topicRegistry.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Pool<Object, PartitionTopicInfo>> r) {
                return (String)r._1();
            }
        }, Iterable$.MODULE$.canBuildFrom())).size());
        Assert.assertEquals((Object)this.topic(), (Object)((IterableLike)topicRegistry.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Pool<Object, PartitionTopicInfo>> r) {
                return (String)r._1();
            }
        }, Iterable$.MODULE$.canBuildFrom())).head());
        Iterable topicsAndPartitionsInRegistry = (Iterable)topicRegistry.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Iterable<PartitionTopicInfo>> apply(Tuple2<String, Pool<Object, PartitionTopicInfo>> r) {
                return new Tuple2(r._1(), ((TraversableLike)r._2()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PartitionTopicInfo apply(Tuple2<Object, PartitionTopicInfo> p) {
                        return (PartitionTopicInfo)p._2();
                    }
                }, Iterable$.MODULE$.canBuildFrom()));
            }
        }, Iterable$.MODULE$.canBuildFrom());
        PartitionTopicInfo brokerPartition = (PartitionTopicInfo)((IterableLike)((Tuple2)topicsAndPartitionsInRegistry.head())._2()).head();
        Assert.assertEquals((long)0L, (long)brokerPartition.partitionId());
        Seq<Tuple2<String, String>> actual_1 = this.getZKChildrenValues(this.dirs().consumerOwnerDir());
        List expected_1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"0", (Object)"group1_consumer1-0")}));
        Assert.assertEquals((Object)expected_1, actual_1);
        List<String> receivedMessages1 = TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1, this.nMessages());
        Assert.assertEquals(sentMessages1, receivedMessages1);
        zkConsumerConnector1.shutdown();
        zkUtils.close();
    }

    @Test
    public void testConsumerRebalanceListener() {
        TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), this.nMessages(), 0, TestUtils$.MODULE$.sendMessages$default$5());
        TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), this.topic(), this.nMessages(), 1, TestUtils$.MODULE$.sendMessages$default$5());
        ConsumerConfig consumerConfig1 = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), this.group(), this.consumer1(), TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZookeeperConsumerConnector zkConsumerConnector1 = new ZookeeperConsumerConnector(consumerConfig1, true);
        TestConsumerRebalanceListener rebalanceListener1 = new TestConsumerRebalanceListener();
        zkConsumerConnector1.setConsumerRebalanceListener((ConsumerRebalanceListener)rebalanceListener1);
        Map topicMessageStreams1 = zkConsumerConnector1.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)rebalanceListener1.beforeReleasingPartitionsCalled()));
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)rebalanceListener1.beforeStartingFetchersCalled()));
        Assert.assertEquals(null, rebalanceListener1.partitionOwnership().get(this.topic()));
        Assert.assertEquals((Object)"group1_consumer1", (Object)rebalanceListener1.globalPartitionOwnership().get(this.topic()).get(BoxesRunTime.boxToInteger((int)0)).consumer());
        Assert.assertEquals((Object)"group1_consumer1", (Object)rebalanceListener1.globalPartitionOwnership().get(this.topic()).get(BoxesRunTime.boxToInteger((int)1)).consumer());
        Assert.assertEquals((long)0L, (long)rebalanceListener1.globalPartitionOwnership().get(this.topic()).get(BoxesRunTime.boxToInteger((int)0)).threadId());
        Assert.assertEquals((long)0L, (long)rebalanceListener1.globalPartitionOwnership().get(this.topic()).get(BoxesRunTime.boxToInteger((int)1)).threadId());
        Assert.assertEquals((Object)"group1_consumer1", (Object)rebalanceListener1.consumerId());
        rebalanceListener1.beforeReleasingPartitionsCalled_$eq(false);
        rebalanceListener1.beforeStartingFetchersCalled_$eq(false);
        Seq<Tuple2<String, String>> actual_1 = this.getZKChildrenValues(this.dirs().consumerOwnerDir());
        List expected_1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"0", (Object)"group1_consumer1-0"), new Tuple2((Object)"1", (Object)"group1_consumer1-0")}));
        Assert.assertEquals((Object)expected_1, actual_1);
        ConsumerConfig consumerConfig2 = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), this.group(), this.consumer2(), TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZookeeperConsumerConnector zkConsumerConnector2 = new ZookeeperConsumerConnector(consumerConfig2, true);
        TestConsumerRebalanceListener rebalanceListener2 = new TestConsumerRebalanceListener();
        zkConsumerConnector2.setConsumerRebalanceListener((ConsumerRebalanceListener)rebalanceListener2);
        Map topicMessageStreams2 = zkConsumerConnector2.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1, this.nMessages());
        Seq<Tuple2<String, String>> actual_2 = this.getZKChildrenValues(this.dirs().consumerOwnerDir());
        List expected_2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"0", (Object)"group1_consumer1-0"), new Tuple2((Object)"1", (Object)"group1_consumer2-0")}));
        Assert.assertEquals((Object)expected_2, actual_2);
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)rebalanceListener1.beforeReleasingPartitionsCalled()));
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)rebalanceListener1.beforeStartingFetchersCalled()));
        Assert.assertEquals((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), rebalanceListener1.partitionOwnership().get(this.topic()));
        Assert.assertEquals((Object)"group1_consumer1", (Object)rebalanceListener1.globalPartitionOwnership().get(this.topic()).get(BoxesRunTime.boxToInteger((int)0)).consumer());
        Assert.assertEquals((Object)"group1_consumer2", (Object)rebalanceListener1.globalPartitionOwnership().get(this.topic()).get(BoxesRunTime.boxToInteger((int)1)).consumer());
        Assert.assertEquals((long)0L, (long)rebalanceListener1.globalPartitionOwnership().get(this.topic()).get(BoxesRunTime.boxToInteger((int)0)).threadId());
        Assert.assertEquals((long)0L, (long)rebalanceListener1.globalPartitionOwnership().get(this.topic()).get(BoxesRunTime.boxToInteger((int)1)).threadId());
        Assert.assertEquals((Object)"group1_consumer1", (Object)rebalanceListener1.consumerId());
        Assert.assertEquals((Object)"group1_consumer2", (Object)rebalanceListener2.consumerId());
        Assert.assertEquals(rebalanceListener1.globalPartitionOwnership(), rebalanceListener2.globalPartitionOwnership());
        zkConsumerConnector1.shutdown();
        zkConsumerConnector2.shutdown();
    }

    public Seq<Tuple2<String, String>> getZKChildrenValues(String path) {
        java.util.List children = this.zkUtils().zkClient().getChildren(path);
        Collections.sort(children);
        Seq childrenAsSeq = JavaConversions$.MODULE$.asScalaBuffer(children).toSeq();
        return (Seq)childrenAsSeq.map((Function1)new Serializable(this, path){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZookeeperConsumerConnectorTest $outer;
            private final String path$1;

            public final Tuple2<String, String> apply(String partition) {
                return new Tuple2((Object)partition, (Object)((String)this.$outer.zkUtils().zkClient().readData(new StringBuilder().append((Object)this.path$1).append((Object)"/").append((Object)partition).toString())));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.path$1 = path$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public ZookeeperConsumerConnectorTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        this.RebalanceBackoffMs = 5000;
        this.dirs = null;
        this.numNodes = 2;
        this.numParts = 2;
        this.topic = "topic1";
        this.overridingProps = new Properties();
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numParts())).toString());
        this.group = "group1";
        this.consumer0 = "consumer0";
        this.consumer1 = "consumer1";
        this.consumer2 = "consumer2";
        this.consumer3 = "consumer3";
        this.nMessages = 2;
    }

    public class TestConsumerRebalanceListener
    implements ConsumerRebalanceListener {
        private boolean beforeReleasingPartitionsCalled;
        private boolean beforeStartingFetchersCalled;
        private String consumerId;
        private java.util.Map<String, Set<Integer>> partitionOwnership;
        private java.util.Map<String, java.util.Map<Integer, ConsumerThreadId>> globalPartitionOwnership;

        public boolean beforeReleasingPartitionsCalled() {
            return this.beforeReleasingPartitionsCalled;
        }

        public void beforeReleasingPartitionsCalled_$eq(boolean x$1) {
            this.beforeReleasingPartitionsCalled = x$1;
        }

        public boolean beforeStartingFetchersCalled() {
            return this.beforeStartingFetchersCalled;
        }

        public void beforeStartingFetchersCalled_$eq(boolean x$1) {
            this.beforeStartingFetchersCalled = x$1;
        }

        public String consumerId() {
            return this.consumerId;
        }

        public void consumerId_$eq(String x$1) {
            this.consumerId = x$1;
        }

        public java.util.Map<String, Set<Integer>> partitionOwnership() {
            return this.partitionOwnership;
        }

        public void partitionOwnership_$eq(java.util.Map<String, Set<Integer>> x$1) {
            this.partitionOwnership = x$1;
        }

        public java.util.Map<String, java.util.Map<Integer, ConsumerThreadId>> globalPartitionOwnership() {
            return this.globalPartitionOwnership;
        }

        public void globalPartitionOwnership_$eq(java.util.Map<String, java.util.Map<Integer, ConsumerThreadId>> x$1) {
            this.globalPartitionOwnership = x$1;
        }

        public void beforeReleasingPartitions(java.util.Map<String, Set<Integer>> partitionOwnership) {
            this.beforeReleasingPartitionsCalled_$eq(true);
            this.partitionOwnership_$eq(partitionOwnership);
        }

        public void beforeStartingFetchers(String consumerId, java.util.Map<String, java.util.Map<Integer, ConsumerThreadId>> globalPartitionOwnership) {
            this.beforeStartingFetchersCalled_$eq(true);
            this.consumerId_$eq(consumerId);
            this.globalPartitionOwnership_$eq(globalPartitionOwnership);
        }

        public /* synthetic */ ZookeeperConsumerConnectorTest kafka$consumer$ZookeeperConsumerConnectorTest$TestConsumerRebalanceListener$$$outer() {
            return ZookeeperConsumerConnectorTest.this;
        }

        public TestConsumerRebalanceListener() {
            if (ZookeeperConsumerConnectorTest.this == null) {
                throw new NullPointerException();
            }
            this.beforeReleasingPartitionsCalled = false;
            this.beforeStartingFetchersCalled = false;
            this.consumerId = "";
            this.partitionOwnership = null;
            this.globalPartitionOwnership = null;
        }
    }
}

