/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Collection;
import java.util.Properties;
import kafka.common.TopicAndPartition;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerIntegrationTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.message.MessageAndOffset;
import kafka.message.NoCompressionCodec$;
import kafka.server.OffsetCheckpoint;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0004T8h\u00072,\u0017M\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u0011=\u0001!\u0011!Q\u0001\nA\t\u0001cY8naJ,7o]5p]\u000e{G-Z2\u0011\u0005E!bBA\u0005\u0013\u0013\t\u0019\"\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003+Y\u0011aa\u0015;sS:<'BA\n\u000b\u0011\u0015A\u0002\u0001\"\u0001\u001a\u0003\u0019a\u0014N\\5u}Q\u0011!\u0004\b\t\u00037\u0001i\u0011A\u0001\u0005\u0006\u001f]\u0001\r\u0001\u0005\u0005\b=\u0001\u0011\r\u0011\"\u0001 \u0003\u0011!\u0018.\\3\u0016\u0003\u0001\u0002\"!\t\u0013\u000e\u0003\tR!a\t\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0015\u0012#\u0001C'pG.$\u0016.\\3\t\r\u001d\u0002\u0001\u0015!\u0003!\u0003\u0015!\u0018.\\3!\u0011\u001dI\u0003A1A\u0005\u0002)\n1b]3h[\u0016tGoU5{KV\t1\u0006\u0005\u0002\nY%\u0011QF\u0003\u0002\u0004\u0013:$\bBB\u0018\u0001A\u0003%1&\u0001\u0007tK\u001elWM\u001c;TSj,\u0007\u0005C\u00042\u0001\t\u0007I\u0011\u0001\u0016\u0002\u0017\u0011,G.\u001a;f\t\u0016d\u0017-\u001f\u0005\u0007g\u0001\u0001\u000b\u0011B\u0016\u0002\u0019\u0011,G.\u001a;f\t\u0016d\u0017-\u001f\u0011\t\u000fU\u0002!\u0019!C\u0001m\u00059An\\4OC6,W#A\u001c\u0011\u0005ajT\"A\u001d\u000b\u0005iZ\u0014\u0001\u00027b]\u001eT\u0011\u0001P\u0001\u0005U\u00064\u0018-\u0003\u0002\u0016s!1q\b\u0001Q\u0001\n]\n\u0001\u0002\\8h\u001d\u0006lW\r\t\u0005\b\u0003\u0002\u0011\r\u0011\"\u0001C\u0003\u0019awn\u001a#jeV\t1\t\u0005\u0002E\u000f6\tQI\u0003\u0002Gw\u0005\u0011\u0011n\\\u0005\u0003\u0011\u0016\u0013AAR5mK\"1!\n\u0001Q\u0001\n\r\u000bq\u0001\\8h\t&\u0014\b\u0005C\u0004M\u0001\u0001\u0007I\u0011\u0001\u0016\u0002\u000f\r|WO\u001c;fe\"9a\n\u0001a\u0001\n\u0003y\u0015aC2pk:$XM]0%KF$\"\u0001U*\u0011\u0005%\t\u0016B\u0001*\u000b\u0005\u0011)f.\u001b;\t\u000fQk\u0015\u0011!a\u0001W\u0005\u0019\u0001\u0010J\u0019\t\rY\u0003\u0001\u0015)\u0003,\u0003!\u0019w.\u001e8uKJ\u0004\u0003b\u0002-\u0001\u0005\u0004%\t!W\u0001\u0007i>\u0004\u0018nY:\u0016\u0003i\u00032!C.^\u0013\ta&BA\u0003BeJ\f\u0017\u0010\u0005\u0002_C6\tqL\u0003\u0002a\t\u000511m\\7n_:L!AY0\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004e\u0001\u0001\u0006IAW\u0001\bi>\u0004\u0018nY:!\u0011\u00151\u0007\u0001\"\u0001h\u0003-\u0019G.Z1oKJ$Vm\u001d;\u0015\u0003AC#!Z5\u0011\u0005)|W\"A6\u000b\u00051l\u0017!\u00026v]&$(\"\u00018\u0002\u0007=\u0014x-\u0003\u0002qW\n!A+Z:u\u0011\u0015\u0011\b\u0001\"\u0001t\u0003-\u0011X-\u00193Ge>lGj\\4\u0015\u0005Ql\bcA;yu6\taO\u0003\u0002x\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005e4(\u0001C%uKJ\f'\r\\3\u0011\t%Y8fK\u0005\u0003y*\u0011a\u0001V;qY\u0016\u0014\u0004\"B\u0002r\u0001\u0004q\bCA\u000e\u0000\u0013\r\t\tA\u0001\u0002\u0004\u0019><\u0007bBA\u0003\u0001\u0011\u0005\u0011qA\u0001\noJLG/\u001a#vaN$\"\"!\u0003\u0002\u0010\u0005M\u0011qCA\r!\u0011)\u00181\u0002>\n\u0007\u00055aOA\u0002TKFDq!!\u0005\u0002\u0004\u0001\u00071&A\u0004ok6\\U-_:\t\u000f\u0005U\u00111\u0001a\u0001W\u00059a.^7EkB\u001c\bBB\u0002\u0002\u0004\u0001\u0007a\u0010\u0003\u0005\u0002\u001c\u0005\r\u0001\u0019AA\u000f\u0003\u0015\u0019w\u000eZ3d!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012\t\u00059Q.Z:tC\u001e,\u0017\u0002BA\u0014\u0003C\u0011\u0001cQ8naJ,7o]5p]\u000e{G-Z2\t\r\u0005-\u0002\u0001\"\u0001h\u0003!!X-\u0019:e_^t\u0007\u0006BA\u0015\u0003_\u00012A[A\u0019\u0013\r\t\u0019d\u001b\u0002\u0006\u0003\u001a$XM\u001d\u0005\b\u0003o\u0001A\u0011AA\u001d\u0003-i\u0017m[3DY\u0016\fg.\u001a:\u0015\u0019\u0005m\u0012\u0011IA#\u0003\u001f\n\u0019&a\u0016\u0011\u0007m\ti$C\u0002\u0002@\t\u0011!\u0002T8h\u00072,\u0017M\\3s\u0011\u001d\t\u0019%!\u000eA\u0002-\nQ\u0001]1siND!\"a\u0012\u00026A\u0005\t\u0019AA%\u0003Yi\u0017N\\\"mK\u0006t\u0017M\u00197f\t&\u0014H/\u001f*bi&|\u0007cA\u0005\u0002L%\u0019\u0011Q\n\u0006\u0003\u000b\u0019cw.\u0019;\t\u0013\u0005E\u0013Q\u0007I\u0001\u0002\u0004Y\u0013A\u00038v[RC'/Z1eg\"I\u0011QKA\u001b!\u0003\u0005\r\u0001E\u0001\u000eI\u00164\u0017-\u001e7u!>d\u0017nY=\t\u0015\u0005e\u0013Q\u0007I\u0001\u0002\u0004\tY&A\bq_2L7-_(wKJ\u0014\u0018\u000eZ3t!\u0015)\u0018Q\f\t\u0011\u0013\r\tyF\u001e\u0002\u0004\u001b\u0006\u0004\b\"CA2\u0001E\u0005I\u0011AA3\u0003Ui\u0017m[3DY\u0016\fg.\u001a:%I\u00164\u0017-\u001e7uII*\"!a\u001a+\t\u0005%\u0013\u0011N\u0016\u0003\u0003W\u0002B!!\u001c\u0002x5\u0011\u0011q\u000e\u0006\u0005\u0003c\n\u0019(A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u000f\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002z\u0005=$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011Q\u0010\u0001\u0012\u0002\u0013\u0005\u0011qP\u0001\u0016[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tIK\u0002,\u0003SB\u0011\"!\"\u0001#\u0003%\t!a\"\u0002+5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011\u0011\u0012\u0016\u0004!\u0005%\u0004\"CAG\u0001E\u0005I\u0011AAH\u0003Ui\u0017m[3DY\u0016\fg.\u001a:%I\u00164\u0017-\u001e7uIU*\"!!%+\t\u0005m\u0013\u0011\u000e\u0015\b\u0001\u0005U\u0015\u0011UAR!\u0011\t9*!(\u000e\u0005\u0005e%bAANW\u00061!/\u001e8oKJLA!a(\u0002\u001a\n9!+\u001e8XSRD\u0017!\u0002<bYV,7EAAS!\u0011\t9+!,\u000e\u0005\u0005%&bAAVW\u00069!/\u001e8oKJ\u001c\u0018\u0002BAX\u0003S\u0013Q\u0002U1sC6,G/\u001a:ju\u0016$waBAZ\u0005!\u0005\u0011QW\u0001\u001a\u0019><7\t\\3b]\u0016\u0014\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fE\u0002\u001c\u0003o3a!\u0001\u0002\t\u0002\u0005e6cAA\\\u0011!9\u0001$a.\u0005\u0002\u0005uFCAA[\u0011!\t\t-a.\u0005\u0002\u0005\r\u0017A\u00039be\u0006lW\r^3sgV\u0011\u0011Q\u0019\t\u0007\u0003\u000f\fi-!5\u000e\u0005\u0005%'bAAfw\u0005!Q\u000f^5m\u0013\u0011\ty-!3\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u0002\n7BAC!a0\u0002VB!\u0011q[Ax\u001d\u0011\tI.a;\u000f\t\u0005m\u0017\u0011\u001e\b\u0005\u0003;\f9O\u0004\u0003\u0002`\u0006\u0015XBAAq\u0015\r\t\u0019OB\u0001\u0007yI|w\u000e\u001e \n\u00039L!\u0001\\7\n\u0007\u0005-6.\u0003\u0003\u0002n\u0006%\u0016!\u0004)be\u0006lW\r^3sSj,G-\u0003\u0003\u0002r\u0006M(A\u0003)be\u0006lW\r^3sg*!\u0011Q^AU\u0001")
public class LogCleanerIntegrationTest {
    private final String compressionCodec;
    private final MockTime time;
    private final int segmentSize;
    private final int deleteDelay;
    private final String logName;
    private final File logDir;
    private int counter;
    private final TopicAndPartition[] topics;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return LogCleanerIntegrationTest$.MODULE$.parameters();
    }

    public MockTime time() {
        return this.time;
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    public int deleteDelay() {
        return this.deleteDelay;
    }

    public String logName() {
        return this.logName;
    }

    public File logDir() {
        return this.logDir;
    }

    public int counter() {
        return this.counter;
    }

    public void counter_$eq(int x$1) {
        this.counter = x$1;
    }

    public TopicAndPartition[] topics() {
        return this.topics;
    }

    @Test
    public void cleanerTest() {
        LogCleaner cleaner = this.makeCleaner(3, this.makeCleaner$default$2(), this.makeCleaner$default$3(), this.makeCleaner$default$4(), this.makeCleaner$default$5());
        Log log = (Log)cleaner.logs().get((Object)this.topics()[0]);
        Seq<Tuple2<Object, Object>> appends = this.writeDups(100, 3, log, CompressionCodec$.MODULE$.getCompressionCodec(this.compressionCodec));
        long startSize = log.size();
        cleaner.startup();
        long firstDirty = log.activeSegment().baseOffset();
        cleaner.awaitCleaned("log", 0, firstDirty, cleaner.awaitCleaned$default$4());
        long compactedSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)log.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$1) {
                return x$1.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long lastCleaned = BoxesRunTime.unboxToLong((Object)cleaner.cleanerManager().allCleanerCheckpoints().get((Object)new TopicAndPartition("log", 0)).get());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log cleaner should have processed up to offset ", ", but lastCleaned=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstDirty), BoxesRunTime.boxToLong((long)lastCleaned)})), (lastCleaned >= firstDirty ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted:  startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToLong((long)compactedSize)})), (startSize > compactedSize ? 1 : 0) != 0);
        Iterable<Tuple2<Object, Object>> read = this.readFromLog(log);
        Assert.assertEquals((String)"Contents of the map shouldn't change.", (Object)appends.toMap(Predef$.MODULE$.conforms()), (Object)read.toMap(Predef$.MODULE$.conforms()));
        Assert.assertTrue((startSize > log.size() ? 1 : 0) != 0);
        Seq appends2 = (Seq)appends.$plus$plus(this.writeDups(100, 3, log, CompressionCodec$.MODULE$.getCompressionCodec(this.compressionCodec)), Seq$.MODULE$.canBuildFrom());
        long firstDirty2 = log.activeSegment().baseOffset();
        cleaner.awaitCleaned("log", 0, firstDirty2, cleaner.awaitCleaned$default$4());
        long lastCleaned2 = BoxesRunTime.unboxToLong((Object)cleaner.cleanerManager().allCleanerCheckpoints().get((Object)new TopicAndPartition("log", 0)).get());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log cleaner should have processed up to offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstDirty2)})), (lastCleaned2 >= firstDirty2 ? 1 : 0) != 0);
        Iterable<Tuple2<Object, Object>> read2 = this.readFromLog(log);
        Assert.assertEquals((String)"Contents of the map shouldn't change.", (Object)appends2.toMap(Predef$.MODULE$.conforms()), (Object)read2.toMap(Predef$.MODULE$.conforms()));
        cleaner.logs().remove((Object)this.topics()[0]);
        cleaner.updateCheckpoints(this.logDir());
        Map checkpoints = new OffsetCheckpoint(new File(this.logDir(), cleaner.cleanerManager().offsetCheckpointFile())).read();
        Predef$.MODULE$.assert(!checkpoints.contains((Object)this.topics()[0]));
        cleaner.shutdown();
    }

    public Iterable<Tuple2<Object, Object>> readFromLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<Object, Object>> apply(LogSegment segment) {
                return (Iterable)segment.log().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterator<Tuple2<Object, Object>> apply(MessageAndOffset entry) {
                        CompressionCodec compressionCodec = entry.message().compressionCodec();
                        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                        return (!(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null) ? Stream.cons$.MODULE$.apply((Object)entry, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Stream<Nothing$> apply() {
                                return package$.MODULE$.Stream().empty();
                            }
                        }).iterator() : ByteBufferMessageSet$.MODULE$.deepIterator(entry)).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Object> apply(MessageAndOffset messageAndOffset) {
                                int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(messageAndOffset.message().key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                                int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(messageAndOffset.message().payload(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
                            }
                        });
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log, CompressionCodec codec) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, log, codec){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;
            private final int numKeys$1;
            public final Log log$1;
            public final CompressionCodec codec$1;

            public final IndexedSeq<Tuple2<Object, Object>> apply(int dup) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeDups$1 $outer;

                    public final Tuple2<Object, Object> apply(int key) {
                        int count = this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter();
                        this.$outer.log$1.append(TestUtils$.MODULE$.singleMessageSet(((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter())).toString().getBytes(), this.$outer.codec$1, ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), TestUtils$.MODULE$.singleMessageSet$default$4()), true);
                        this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter_$eq(this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter() + 1);
                        return new Tuple2.mcII.sp(key, count);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ LogCleanerIntegrationTest kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.numKeys$1 = numKeys$1;
                this.log$1 = log$1;
                this.codec$1 = codec$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    @After
    public void teardown() {
        this.time().scheduler().shutdown();
        Utils.delete((File)this.logDir());
    }

    public LogCleaner makeCleaner(int parts, float minCleanableDirtyRatio, int numThreads, String defaultPolicy, Map<String, String> policyOverrides) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), parts).foreach((Function1)new Serializable(this, minCleanableDirtyRatio, logs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;
            private final float minCleanableDirtyRatio$1;
            private final Pool logs$1;

            public final Log apply(int i) {
                File dir = new File(this.$outer.logDir(), new StringBuilder().append((Object)"log-").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                dir.mkdirs();
                Properties logProps = new Properties();
                logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(this.$outer.segmentSize()));
                logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(102400));
                logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(this.$outer.deleteDelay()));
                logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
                logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.float2Float(this.minCleanableDirtyRatio$1));
                Log log = new Log(dir, new LogConfig((java.util.Map)logProps), 0L, (Scheduler)this.$outer.time().scheduler(), (Time)this.$outer.time());
                return (Log)this.logs$1.put((Object)new TopicAndPartition("log", i), (Object)log);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.minCleanableDirtyRatio$1 = minCleanableDirtyRatio$1;
                this.logs$1 = logs$1;
            }
        });
        return new LogCleaner(new CleanerConfig(numThreads, CleanerConfig$.MODULE$.apply$default$2(), CleanerConfig$.MODULE$.apply$default$3(), CleanerConfig$.MODULE$.apply$default$4(), CleanerConfig$.MODULE$.apply$default$5(), CleanerConfig$.MODULE$.apply$default$6(), CleanerConfig$.MODULE$.apply$default$7(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9()), (File[])((Object[])new File[]{this.logDir()}), logs, (Time)this.time());
    }

    public float makeCleaner$default$2() {
        return 0.0f;
    }

    public int makeCleaner$default$3() {
        return 1;
    }

    public String makeCleaner$default$4() {
        return "compact";
    }

    public Map<String, String> makeCleaner$default$5() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public LogCleanerIntegrationTest(String compressionCodec) {
        this.compressionCodec = compressionCodec;
        this.time = new MockTime();
        this.segmentSize = 100;
        this.deleteDelay = 1000;
        this.logName = "log";
        this.logDir = TestUtils$.MODULE$.tempDir();
        this.counter = 0;
        this.topics = (TopicAndPartition[])((Object[])new TopicAndPartition[]{new TopicAndPartition("log", 0), new TopicAndPartition("log", 1), new TopicAndPartition("log", 2)});
    }
}

