/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.network.SocketServer;
import kafka.server.BrokerShuttingDown$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.NotRunning$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.TraitSetter;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\re!B\u0001\u0003\u0003\u00039!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u0013!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002\u0018)\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005!9a\u0004\u0001a\u0001\n\u0013y\u0012!D2peJ,G.\u0019;j_:LE-F\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\rIe\u000e\u001e\u0005\bO\u0001\u0001\r\u0011\"\u0003)\u0003E\u0019wN\u001d:fY\u0006$\u0018n\u001c8JI~#S-\u001d\u000b\u0003S1\u0002\"!\t\u0016\n\u0005-\u0012#\u0001B+oSRDq!\f\u0014\u0002\u0002\u0003\u0007\u0001%A\u0002yIEBaa\f\u0001!B\u0013\u0001\u0013AD2peJ,G.\u0019;j_:LE\r\t\u0005\u0006c\u0001!\tbH\u0001\u000b]Vl'I]8lKJ\u001c\b\"B\u001a\u0001\t#!\u0014!\u00059s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u0011\u0011&\u000e\u0005\u0006mI\u0002\raN\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bC\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\u0011)H/\u001b7\u000b\u0003q\nAA[1wC&\u0011a(\u000f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"\u0002!\u0001\t\u0003\t\u0015aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0015\u0003\t\u00032aQ&O\u001d\t!\u0015J\u0004\u0002F\u00116\taI\u0003\u0002H\r\u00051AH]8pizJ\u0011aI\u0005\u0003\u0015\n\nq\u0001]1dW\u0006<W-\u0003\u0002M\u001b\n\u00191+Z9\u000b\u0005)\u0013\u0003C\u0001\u000fP\u0013\t\u0001&AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\"\u0002*\u0001\t\u0003\u001a\u0016!B:fiV\u0003H#A\u0015)\u0005E+\u0006C\u0001,Y\u001b\u00059&BA\u0006\u000f\u0013\tIvK\u0001\u0004CK\u001a|'/\u001a\u0005\u00067\u0002!\t\u0001X\u0001\rg>\u001c7.\u001a;TKJ4XM]\u000b\u0002;B\u0011a,Y\u0007\u0002?*\u0011\u0001\rB\u0001\b]\u0016$xo\u001c:l\u0013\t\u0011wL\u0001\u0007T_\u000e\\W\r^*feZ,'\u000fC\u0003e\u0001\u0011\u0005Q-A\u0004d_:tWm\u0019;\u0015\u0007\u0019dg\u000e\u0005\u0002hU6\t\u0001N\u0003\u0002jw\u0005\u0019a.\u001a;\n\u0005-D'AB*pG.,G\u000fC\u0004nGB\u0005\t\u0019A/\u0002\u0003MDqa\\2\u0011\u0002\u0003\u0007\u0001/\u0001\u0005qe>$xnY8m!\t\t\b0D\u0001s\u0015\ty7O\u0003\u0002uk\u000611m\\7n_:T!!\u0002<\u000b\u0005]t\u0011AB1qC\u000eDW-\u0003\u0002ze\n\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u0005\u0006w\u0002!I\u0001`\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000fF\u0002*{~DQA >A\u0002\u0019\faa]8dW\u0016$\bbBA\u0001u\u0002\u0007\u00111A\u0001\be\u0016\fX/Z:u!\u0015\t\u0013QAA\u0005\u0013\r\t9A\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004C\u0005-\u0011bAA\u0007E\t!!)\u001f;f\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'\tqB]3dK&4XMU3ta>t7/\u001a\u000b\u0005\u0003\u0007\t)\u0002\u0003\u0004\u007f\u0003\u001f\u0001\rA\u001a\u0005\b\u00033\u0001A\u0011AA\u000e\u0003E\u0011X-];fgR\fe\u000e\u001a*fG\u0016Lg/\u001a\u000b\u0007\u0003\u0007\ti\"a\b\t\ry\f9\u00021\u0001g\u0011!\t\t!a\u0006A\u0002\u0005\r\u0001bBA\u0012\u0001\u0011\u0005\u0011QE\u0001\u0005g\u0016tG\r\u0006\u0005\u0002(\u0005M\u0012\u0011IA&!\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u0017w\u0005\u0019a.[8\n\t\u0005E\u00121\u0006\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\u0002CA\u0001\u0003C\u0001\r!!\u000e\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000ft\u0003!\u0011X-];fgR\u001c\u0018\u0002BA \u0003s\u0011q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e\u0005\t\u0003\u0007\n\t\u00031\u0001\u0002F\u00051\u0011\r]5LKf\u00042!]A$\u0013\r\tIE\u001d\u0002\b\u0003BL7*Z=t\u0011!\ti%!\tA\u0002\u0005=\u0013a\u0002<feNLwN\u001c\t\u0004C\u0005E\u0013bAA*E\t)1\u000b[8si\"9\u00111\u0005\u0001\u0005\u0002\u0005]CCCA\u0014\u00033\nY&!\u0018\u0002`!1a0!\u0016A\u0002\u0019D\u0001\"!\u0001\u0002V\u0001\u0007\u0011Q\u0007\u0005\t\u0003\u0007\n)\u00061\u0001\u0002F!A\u0011QJA+\u0001\u0004\ty\u0005C\u0005\u0002d\u0001\t\n\u0011\"\u0001\u0002f\u0005\t2m\u001c8oK\u000e$H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d$fA/\u0002j-\u0012\u00111\u000e\t\u0005\u0003[\n9(\u0004\u0002\u0002p)!\u0011\u0011OA:\u0003%)hn\u00195fG.,GMC\u0002\u0002v\t\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI(a\u001c\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002~\u0001\t\n\u0011\"\u0001\u0002\u0000\u0005\t2m\u001c8oK\u000e$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0005%f\u00019\u0002j\u0001")
public abstract class BaseRequestTest
extends JUnitSuite
implements KafkaServerTestHarness {
    private int correlationId;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final Option<Function0<BoxedUnit>> setClusterAcl;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    @TraitSetter
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    @TraitSetter
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    @TraitSetter
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    @TraitSetter
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public Option<Function0<BoxedUnit>> setClusterAcl() {
        return this.setClusterAcl;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$setClusterAcl_$eq(Option x$1) {
        this.setClusterAcl = x$1;
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> saslProperties() {
        return KafkaServerTestHarness$class.saslProperties(this);
    }

    @Override
    @After
    public void tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        BaseRequestTest baseRequestTest = this;
        synchronized (baseRequestTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    private int correlationId() {
        return this.correlationId;
    }

    private void correlationId_$eq(int x$1) {
        this.correlationId = x$1;
    }

    public int numBrokers() {
        return 3;
    }

    public void propertyOverrides(Properties properties) {
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$2 = this.numBrokers();
        String x$3 = this.zkConnect();
        boolean x$4 = false;
        Some x$5 = new Some((Object)this.securityProtocol());
        Option<File> x$6 = this.trustStoreFile();
        Option<Properties> x$7 = this.saslProperties();
        boolean x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        Seq<Properties> props = TestUtils$.MODULE$.createBrokerConfigs(x$2, x$3, x$4, x$8, (Option<SecurityProtocol>)x$5, x$6, x$7, x$9, x$10, x$11, x$12, x$13);
        props.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseRequestTest $outer;

            public final void apply(Properties properties) {
                this.$outer.propertyOverrides(properties);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        return (Seq)props.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @Before
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseRequestTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((KafkaServer)this.$outer.servers().head()).metadataCache().getAliveBrokers().size() == this.$outer.numBrokers();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "Wait for cache to update", TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    public SocketServer socketServer() {
        return (SocketServer)this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer server) {
                byte state = server.brokerState().currentState();
                return state != NotRunning$.MODULE$.state() && state != BrokerShuttingDown$.MODULE$.state();
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SocketServer apply(KafkaServer x$1) {
                return x$1.socketServer();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("No live broker is available");
            }
        });
    }

    public Socket connect(SocketServer s, SecurityProtocol protocol) {
        return new Socket("localhost", s.boundPort(protocol));
    }

    public SocketServer connect$default$1() {
        return this.socketServer();
    }

    public SecurityProtocol connect$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    private void sendRequest(Socket socket, byte[] request) {
        DataOutputStream outgoing = new DataOutputStream(socket.getOutputStream());
        outgoing.writeInt(request.length);
        outgoing.write(request);
        outgoing.flush();
    }

    private byte[] receiveResponse(Socket socket) {
        DataInputStream incoming = new DataInputStream(socket.getInputStream());
        int len = incoming.readInt();
        byte[] response = new byte[len];
        incoming.readFully(response);
        return response;
    }

    public byte[] requestAndReceive(Socket socket, byte[] request) {
        this.sendRequest(socket, request);
        return this.receiveResponse(socket);
    }

    public ByteBuffer send(AbstractRequest request, ApiKeys apiKey, short version) {
        try (Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());){
            return this.send(socket, request, apiKey, version);
        }
    }

    public ByteBuffer send(Socket socket, AbstractRequest request, ApiKeys apiKey, short version) {
        this.correlationId_$eq(this.correlationId() + 1);
        RequestHeader header = new RequestHeader(apiKey.id, version, "", this.correlationId());
        ByteBuffer byteBuffer = ByteBuffer.allocate(header.sizeOf() + request.sizeOf());
        header.writeTo(byteBuffer);
        request.writeTo(byteBuffer);
        byte[] serializedBytes = byteBuffer.array();
        byte[] response = this.requestAndReceive(socket, serializedBytes);
        ByteBuffer responseBuffer = ByteBuffer.wrap(response);
        ResponseHeader.parse((ByteBuffer)responseBuffer);
        return responseBuffer;
    }

    public BaseRequestTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        this.correlationId = 0;
    }
}

