/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_8_2$;
import kafka.cluster.EndPoint;
import kafka.message.Message$;
import kafka.message.SnappyCompressionCodec$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaConfigTest$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u0001\u001d\u0011qbS1gW\u0006\u001cuN\u001c4jOR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001\"\u0002\u000b\u0001\t\u0003)\u0012!\t;fgRdun\u001a*fi\u0016tG/[8o)&lW\rS8veN\u0004&o\u001c<jI\u0016$G#\u0001\f\u0011\u0005%9\u0012B\u0001\r\u000b\u0005\u0011)f.\u001b;)\u0005MQ\u0002CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0015QWO\\5u\u0015\u0005y\u0012aA8sO&\u0011\u0011\u0005\b\u0002\u0005)\u0016\u001cH\u000fC\u0003$\u0001\u0011\u0005Q#A\u0012uKN$Hj\\4SKR,g\u000e^5p]RKW.Z'j]V$Xm\u001d)s_ZLG-\u001a3)\u0005\tR\u0002\"\u0002\u0014\u0001\t\u0003)\u0012A\b;fgRdun\u001a*fi\u0016tG/[8o)&lW-T:Qe>4\u0018\u000eZ3eQ\t)#\u0004C\u0003*\u0001\u0011\u0005Q#\u0001\u0013uKN$Hj\\4SKR,g\u000e^5p]RKW.\u001a(p\u0007>tg-[4Qe>4\u0018\u000eZ3eQ\tA#\u0004C\u0003-\u0001\u0011\u0005Q#A\u0018uKN$Hj\\4SKR,g\u000e^5p]RKW.\u001a\"pi\"l\u0015N\\;uKN\fe\u000e\u001a%pkJ\u001c\bK]8wS\u0012,G\r\u000b\u0002,5!)q\u0006\u0001C\u0001+\u0005aC/Z:u\u0019><'+\u001a;f]RLwN\u001c+j[\u0016\u0014u\u000e\u001e5NS:,H/Z:B]\u0012l5\u000f\u0015:pm&$W\r\u001a\u0015\u0003]iAQA\r\u0001\u0005\u0002U\t\u0011\u0004^3ti2{wMU3uK:$\u0018n\u001c8V]2LW.\u001b;fI\"\u0012\u0011G\u0007\u0005\u0006k\u0001!\tAN\u0001\u0016i\u0016\u001cH\u000fT8h%\u0016$XM\u001c;j_:4\u0016\r\\5e+\u00051\u0002F\u0001\u001b\u001b\u0011\u0015I\u0004\u0001\"\u0001\u0016\u0003U!Xm\u001d;BIZ,'\u000f^5tK\u0012+g-Y;miND#\u0001\u000f\u000e\t\u000bq\u0002A\u0011A\u000b\u0002/Q,7\u000f^!em\u0016\u0014H/[:f\u0007>tg-[4ve\u0016$\u0007FA\u001e\u001b\u0011\u0015y\u0004\u0001\"\u0001\u0016\u0003a!Xm\u001d;BIZ,'\u000f^5tKB{'\u000f\u001e#fM\u0006,H\u000e\u001e\u0015\u0003}iAQA\u0011\u0001\u0005\u0002U\tA\u0004^3ti\u0006#g/\u001a:uSN,\u0007j\\:u\u001d\u0006lW\rR3gCVdG\u000f\u000b\u0002B5!)Q\t\u0001C\u0001+\u00051B/Z:u\tV\u0004H.[2bi\u0016d\u0015n\u001d;f]\u0016\u00148\u000f\u000b\u0002E5!)\u0001\n\u0001C\u0001+\u00059B/Z:u\u0005\u0006$G*[:uK:,'\u000f\u0015:pi>\u001cw\u000e\u001c\u0015\u0003\u000fjAQa\u0013\u0001\u0005\u0002U\t1\u0005^3ti\u000e\u000b7/Z%og\u0016t7/\u001b;jm\u0016d\u0015n\u001d;f]\u0016\u0014\bK]8u_\u000e|G\u000e\u000b\u0002K5!)a\n\u0001C\u0001+\u0005!B/Z:u\u0019&\u001cH/\u001a8fe\u0012+g-Y;miND#!\u0014\u000e\t\u000bE\u0003A\u0011A\u000b\u00021Q,7\u000f\u001e,feNLwN\\\"p]\u001aLw-\u001e:bi&|g\u000e\u000b\u0002Q5!)A\u000b\u0001C\u0005+\u0006\u0011\u0012n\u001d,bY&$7*\u00194lC\u000e{gNZ5h)\t1\u0016\f\u0005\u0002\n/&\u0011\u0001L\u0003\u0002\b\u0005>|G.Z1o\u0011\u0015Q6\u000b1\u0001\\\u0003\u0015\u0001(o\u001c9t!\ta\u0016-D\u0001^\u0015\tqv,\u0001\u0003vi&d'\"\u00011\u0002\t)\fg/Y\u0005\u0003Ev\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0015!\u0007\u0001\"\u0001\u0016\u0003\u0001\"Xm\u001d;V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8EK\u001a\fW\u000f\u001c;)\u0005\rT\u0002\"B4\u0001\t\u0003)\u0012a\u0007;fgR,fn\u00197fC:,E.Z2uS>tG)[:bE2,G\r\u000b\u0002g5!)!\u000e\u0001C\u0001+\u0005QB/Z:u+:\u001cG.Z1o\u000b2,7\r^5p]\u0016s\u0017M\u00197fI\"\u0012\u0011N\u0007\u0005\u0006[\u0002!\t!F\u0001\u001bi\u0016\u001cH/\u00168dY\u0016\fg.\u00127fGRLwN\\%om\u0006d\u0017\u000e\u001a\u0015\u0003YjAQ\u0001\u001d\u0001\u0005\u0002U\t\u0011\u0004^3ti2{wMU8mYRKW.Z't!J|g/\u001b3fI\"\u0012qN\u0007\u0005\u0006g\u0002!\t!F\u0001&i\u0016\u001cH\u000fT8h%>dG\u000eV5nK\n{G\u000f['t\u0003:$\u0007j\\;sgB\u0013xN^5eK\u0012D#A\u001d\u000e\t\u000bY\u0004A\u0011A\u000b\u0002?Q,7\u000f\u001e'pOJ{G\u000e\u001c+j[\u0016tunQ8oM&<\u0007K]8wS\u0012,G\r\u000b\u0002v5!)\u0011\u0010\u0001C\u0001+\u0005QB/Z:u\t\u00164\u0017-\u001e7u\u0007>l\u0007O]3tg&|g\u000eV=qK\"\u0012\u0001P\u0007\u0005\u0006y\u0002!\t!F\u0001\u0019i\u0016\u001cHOV1mS\u0012\u001cu.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0007FA>\u001b\u0011\u0015y\b\u0001\"\u0001\u0016\u0003i!Xm\u001d;J]Z\fG.\u001b3D_6\u0004(/Z:tS>tG+\u001f9fQ\tq(\u0004\u0003\u0004\u0002\u0006\u0001!\t!F\u0001'i\u0016\u001cH/\u00138wC2LG-\u00138uKJ\u0014%o\\6feN+7-\u001e:jif\u0004&o\u001c;pG>d\u0007fAA\u00025!1\u00111\u0002\u0001\u0005\u0002U\tA\u0005^3ti\u0016\u000bX/\u00197BIZ,'\u000f^5tK\u0012d\u0015n\u001d;f]\u0016\u00148\u000f\u0015:pi>\u001cw\u000e\u001c\u0015\u0004\u0003\u0013Q\u0002BBA\t\u0001\u0011\u0005Q#\u0001\u0014uKN$\u0018J\u001c<bY&$\u0017\t\u001a<feRL7/\u001a3MSN$XM\\3sgB\u0013x\u000e^8d_2D3!a\u0004\u001b\u0011\u0019\t9\u0002\u0001C\u0001+\u0005!B/Z:u\rJ|W\u000e\u0015:paNLeN^1mS\u0012D3!!\u0006\u001b\u0011\u0019\ti\u0002\u0001C\u0001+\u00051B/Z:u'B,7-\u001b4jGB\u0013x\u000e]3si&,7\u000fK\u0002\u0002\u001ciAq!a\t\u0001\t\u0013\t)#A\u000bbgN,'\u000f\u001e)s_B,'\u000f^=J]Z\fG.\u001b3\u0015\u000fY\t9#!\r\u0002D!I\u0011\u0011FA\u0011\t\u0003\u0007\u00111F\u0001\u0013m\u0006d\u0017\u000e\u001a*fcVL'/\u001a3Qe>\u00048\u000f\u0005\u0003\n\u0003[Y\u0016bAA\u0018\u0015\tAAHY=oC6,g\b\u0003\u0005\u00024\u0005\u0005\u0002\u0019AA\u001b\u0003\u0011q\u0017-\\3\u0011\t\u0005]\u0012Q\b\b\u0004\u0013\u0005e\u0012bAA\u001e\u0015\u00051\u0001K]3eK\u001aLA!a\u0010\u0002B\t11\u000b\u001e:j]\u001eT1!a\u000f\u000b\u0011!\t)%!\tA\u0002\u0005\u001d\u0013A\u0002<bYV,7\u000fE\u0003\n\u0003\u0013\ni%C\u0002\u0002L)\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?!\rI\u0011qJ\u0005\u0004\u0003#R!aA!os\u0002")
public class KafkaConfigTest {
    @Test
    public void testLogRetentionTimeHoursProvided() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "1");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((long)3600000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeMinutesProvided() {
        int x$17 = 0;
        String x$18 = TestUtils$.MODULE$.MockZkConnect();
        int x$19 = 8181;
        boolean x$20 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$22 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$23 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$24 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$25 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$26 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$27 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$28 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$29 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$30 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$31 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$32 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$17, x$18, x$20, x$21, x$19, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32);
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp(), "30");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeMsProvided() {
        int x$33 = 0;
        String x$34 = TestUtils$.MODULE$.MockZkConnect();
        int x$35 = 8181;
        boolean x$36 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$37 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$38 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$39 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$40 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$41 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$42 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$43 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$44 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$45 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$46 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$47 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$48 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$33, x$34, x$36, x$37, x$35, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48);
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "1800000");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeNoConfigProvided() {
        int x$49 = 0;
        String x$50 = TestUtils$.MODULE$.MockZkConnect();
        int x$51 = 8181;
        boolean x$52 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$53 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$54 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$55 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$56 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$57 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$58 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$59 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$60 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$61 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$62 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$63 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$64 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$49, x$50, x$52, x$53, x$51, x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64);
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((long)604800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeBothMinutesAndHoursProvided() {
        int x$65 = 0;
        String x$66 = TestUtils$.MODULE$.MockZkConnect();
        int x$67 = 8181;
        boolean x$68 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$69 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$70 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$71 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$72 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$73 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$74 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$75 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$76 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$77 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$78 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$79 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$80 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$65, x$66, x$68, x$69, x$67, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, x$80);
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp(), "30");
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "1");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeBothMinutesAndMsProvided() {
        int x$81 = 0;
        String x$82 = TestUtils$.MODULE$.MockZkConnect();
        int x$83 = 8181;
        boolean x$84 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$85 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$86 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$87 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$88 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$89 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$90 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$91 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$92 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$93 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$94 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$95 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$96 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$81, x$82, x$84, x$85, x$83, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95, x$96);
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "1800000");
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp(), "10");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionUnlimited() {
        int x$97 = 0;
        String x$98 = TestUtils$.MODULE$.MockZkConnect();
        int x$99 = 8181;
        boolean x$100 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$101 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$102 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$103 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$104 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$105 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$106 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$107 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$108 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$109 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$110 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$111 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$112 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(x$97, x$98, x$100, x$101, x$99, x$102, x$103, x$104, x$105, x$106, x$107, x$108, x$109, x$110, x$111, x$112);
        int x$113 = 0;
        String x$114 = TestUtils$.MODULE$.MockZkConnect();
        int x$115 = 8181;
        boolean x$116 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$117 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$118 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$119 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$120 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$121 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$122 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$123 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$124 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$125 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$126 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$127 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$128 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(x$113, x$114, x$116, x$117, x$115, x$118, x$119, x$120, x$121, x$122, x$123, x$124, x$125, x$126, x$127, x$128);
        int x$129 = 0;
        String x$130 = TestUtils$.MODULE$.MockZkConnect();
        int x$131 = 8181;
        boolean x$132 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$133 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$134 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$135 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$136 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$137 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$138 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$139 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$140 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$141 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$142 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$143 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$144 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(x$129, x$130, x$132, x$133, x$131, x$134, x$135, x$136, x$137, x$138, x$139, x$140, x$141, x$142, x$143, x$144);
        int x$145 = 0;
        String x$146 = TestUtils$.MODULE$.MockZkConnect();
        int x$147 = 8181;
        boolean x$148 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$149 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$150 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$151 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$152 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$153 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$154 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$155 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$156 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$157 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$158 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$159 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$160 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props4 = TestUtils$.MODULE$.createBrokerConfig(x$145, x$146, x$148, x$149, x$147, x$150, x$151, x$152, x$153, x$154, x$155, x$156, x$157, x$158, x$159, x$160);
        int x$161 = 0;
        String x$162 = TestUtils$.MODULE$.MockZkConnect();
        int x$163 = 8181;
        boolean x$164 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$165 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$166 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$167 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$168 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$169 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$170 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$171 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$172 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$173 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$174 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$175 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$176 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props5 = TestUtils$.MODULE$.createBrokerConfig(x$161, x$162, x$164, x$165, x$163, x$166, x$167, x$168, x$169, x$170, x$171, x$172, x$173, x$174, x$175, x$176);
        props1.put("log.retention.ms", "-1");
        props2.put("log.retention.minutes", "-1");
        props3.put("log.retention.hours", "-1");
        KafkaConfig cfg1 = KafkaConfig$.MODULE$.fromProps(props1);
        KafkaConfig cfg2 = KafkaConfig$.MODULE$.fromProps(props2);
        KafkaConfig cfg3 = KafkaConfig$.MODULE$.fromProps(props3);
        Assert.assertEquals((String)"Should be -1", (long)-1L, (long)cfg1.logRetentionTimeMillis());
        Assert.assertEquals((String)"Should be -1", (long)-1L, (long)cfg2.logRetentionTimeMillis());
        Assert.assertEquals((String)"Should be -1", (long)-1L, (long)cfg3.logRetentionTimeMillis());
        props4.put("log.retention.ms", "-1");
        props4.put("log.retention.minutes", "30");
        KafkaConfig cfg4 = KafkaConfig$.MODULE$.fromProps(props4);
        Assert.assertEquals((String)"Should be -1", (long)-1L, (long)cfg4.logRetentionTimeMillis());
        props5.put("log.retention.ms", "0");
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, props5){
            public static final long serialVersionUID = 0L;
            private final Properties props5$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.props5$1);
            }
            {
                this.props5$1 = props5$1;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
    }

    @Test
    public void testLogRetentionValid() {
        int x$177 = 0;
        String x$178 = TestUtils$.MODULE$.MockZkConnect();
        int x$179 = 8181;
        boolean x$180 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$181 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$182 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$183 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$184 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$185 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$186 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$187 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$188 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$189 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$190 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$191 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$192 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(x$177, x$178, x$180, x$181, x$179, x$182, x$183, x$184, x$185, x$186, x$187, x$188, x$189, x$190, x$191, x$192);
        int x$193 = 0;
        String x$194 = TestUtils$.MODULE$.MockZkConnect();
        int x$195 = 8181;
        boolean x$196 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$197 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$198 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$199 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$200 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$201 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$202 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$203 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$204 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$205 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$206 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$207 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$208 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(x$193, x$194, x$196, x$197, x$195, x$198, x$199, x$200, x$201, x$202, x$203, x$204, x$205, x$206, x$207, x$208);
        int x$209 = 0;
        String x$210 = TestUtils$.MODULE$.MockZkConnect();
        int x$211 = 8181;
        boolean x$212 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$213 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$214 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$215 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$216 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$217 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$218 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$219 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$220 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$221 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$222 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$223 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$224 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(x$209, x$210, x$212, x$213, x$211, x$214, x$215, x$216, x$217, x$218, x$219, x$220, x$221, x$222, x$223, x$224);
        props1.put("log.retention.ms", "0");
        props2.put("log.retention.minutes", "0");
        props3.put("log.retention.hours", "0");
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, props1){
            public static final long serialVersionUID = 0L;
            private final Properties props1$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.props1$1);
            }
            {
                this.props1$1 = props1$1;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, props2){
            public static final long serialVersionUID = 0L;
            private final Properties props2$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.props2$1);
            }
            {
                this.props2$1 = props2$1;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, props3){
            public static final long serialVersionUID = 0L;
            private final Properties props3$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.props3$1);
            }
            {
                this.props3$1 = props3$1;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
    }

    @Test
    public void testAdvertiseDefaults() {
        String port = "9999";
        String hostName = "fake-host";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.remove(KafkaConfig$.MODULE$.ListenersProp());
        props.put(KafkaConfig$.MODULE$.HostNameProp(), hostName);
        props.put(KafkaConfig$.MODULE$.PortProp(), port);
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Map endpoints = serverConfig.advertisedListeners();
        EndPoint endpoint = (EndPoint)endpoints.get((Object)SecurityProtocol.PLAINTEXT).get();
        Assert.assertEquals((Object)endpoint.host(), (Object)hostName);
        Assert.assertEquals((long)endpoint.port(), (long)new StringOps(Predef$.MODULE$.augmentString(port)).toInt());
    }

    @Test
    public void testAdvertiseConfigured() {
        String advertisedHostName = "routable-host";
        String advertisedPort = "1234";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put(KafkaConfig$.MODULE$.AdvertisedHostNameProp(), advertisedHostName);
        props.put(KafkaConfig$.MODULE$.AdvertisedPortProp(), advertisedPort);
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Map endpoints = serverConfig.advertisedListeners();
        EndPoint endpoint = (EndPoint)endpoints.get((Object)SecurityProtocol.PLAINTEXT).get();
        Assert.assertEquals((Object)endpoint.host(), (Object)advertisedHostName);
        Assert.assertEquals((long)endpoint.port(), (long)new StringOps(Predef$.MODULE$.augmentString(advertisedPort)).toInt());
    }

    @Test
    public void testAdvertisePortDefault() {
        String advertisedHostName = "routable-host";
        String port = "9999";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put(KafkaConfig$.MODULE$.AdvertisedHostNameProp(), advertisedHostName);
        props.put(KafkaConfig$.MODULE$.PortProp(), port);
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Map endpoints = serverConfig.advertisedListeners();
        EndPoint endpoint = (EndPoint)endpoints.get((Object)SecurityProtocol.PLAINTEXT).get();
        Assert.assertEquals((Object)endpoint.host(), (Object)advertisedHostName);
        Assert.assertEquals((long)endpoint.port(), (long)new StringOps(Predef$.MODULE$.augmentString(port)).toInt());
    }

    @Test
    public void testAdvertiseHostNameDefault() {
        String hostName = "routable-host";
        String advertisedPort = "9999";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put(KafkaConfig$.MODULE$.HostNameProp(), hostName);
        props.put(KafkaConfig$.MODULE$.AdvertisedPortProp(), advertisedPort);
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Map endpoints = serverConfig.advertisedListeners();
        EndPoint endpoint = (EndPoint)endpoints.get((Object)SecurityProtocol.PLAINTEXT).get();
        Assert.assertEquals((Object)endpoint.host(), (Object)hostName);
        Assert.assertEquals((long)endpoint.port(), (long)new StringOps(Predef$.MODULE$.augmentString(advertisedPort)).toInt());
    }

    @Test
    public void testDuplicateListeners() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://localhost:9091,TRACE://localhost:9091");
        Predef$.MODULE$.assert(!this.isValidKafkaConfig(props));
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://localhost:9091,PLAINTEXT://localhost:9092");
        Predef$.MODULE$.assert(!this.isValidKafkaConfig(props));
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), "PLAINTEXT://localhost:9091,TRACE://localhost:9091");
        Predef$.MODULE$.assert(!this.isValidKafkaConfig(props));
    }

    @Test
    public void testBadListenerProtocol() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "BAD://localhost:9091");
        Predef$.MODULE$.assert(!this.isValidKafkaConfig(props));
    }

    @Test
    public void testCaseInsensitiveListenerProtocol() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "plaintext://localhost:9091,SsL://localhost:9092");
        Predef$.MODULE$.assert(this.isValidKafkaConfig(props));
    }

    @Test
    public void testListenerDefaults() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.HostNameProp(), "myhost");
        props.put(KafkaConfig$.MODULE$.PortProp(), "1111");
        KafkaConfig conf = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)CoreUtils$.MODULE$.listenerListToEndPoints("PLAINTEXT://myhost:1111"), (Object)conf.listeners());
        props.remove(KafkaConfig$.MODULE$.HostNameProp());
        KafkaConfig conf2 = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)CoreUtils$.MODULE$.listenerListToEndPoints("PLAINTEXT://:1111"), (Object)conf2.listeners());
        Assert.assertEquals((Object)CoreUtils$.MODULE$.listenerListToEndPoints("PLAINTEXT://:1111"), (Object)conf2.advertisedListeners());
        Assert.assertEquals(null, (Object)((EndPoint)conf2.listeners().apply((Object)SecurityProtocol.PLAINTEXT)).host());
        props.put(KafkaConfig$.MODULE$.AdvertisedHostNameProp(), "otherhost");
        props.put(KafkaConfig$.MODULE$.AdvertisedPortProp(), "2222");
        KafkaConfig conf3 = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)conf3.advertisedListeners(), (Object)CoreUtils$.MODULE$.listenerListToEndPoints("PLAINTEXT://otherhost:2222"));
    }

    @Test
    public void testVersionConfiguration() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        KafkaConfig conf = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)ApiVersion$.MODULE$.latestVersion(), (Object)conf.interBrokerProtocolVersion());
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.8.2.0");
        props.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.8.2.0");
        KafkaConfig conf2 = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)KAFKA_0_8_2$.MODULE$, (Object)conf2.interBrokerProtocolVersion());
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.8.2.1");
        props.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.8.2.1");
        KafkaConfig conf3 = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)KAFKA_0_8_2$.MODULE$, (Object)conf3.interBrokerProtocolVersion());
        Predef$.MODULE$.assert(ApiVersion$.MODULE$.latestVersion().$greater$eq((Object)conf3.interBrokerProtocolVersion()));
    }

    private boolean isValidKafkaConfig(Properties props) {
        boolean bl;
        try {
            KafkaConfig$.MODULE$.fromProps(props);
            bl = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        return bl;
    }

    @Test
    public void testUncleanLeaderElectionDefault() {
        int x$225 = 0;
        String x$226 = TestUtils$.MODULE$.MockZkConnect();
        int x$227 = 8181;
        boolean x$228 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$229 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$230 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$231 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$232 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$233 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$234 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$235 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$236 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$237 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$238 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$239 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$240 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$225, x$226, x$228, x$229, x$227, x$230, x$231, x$232, x$233, x$234, x$235, x$236, x$237, x$238, x$239, x$240);
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)serverConfig.uncleanLeaderElectionEnable(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    @Test
    public void testUncleanElectionDisabled() {
        int x$241 = 0;
        String x$242 = TestUtils$.MODULE$.MockZkConnect();
        int x$243 = 8181;
        boolean x$244 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$245 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$246 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$247 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$248 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$249 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$250 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$251 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$252 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$253 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$254 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$255 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$256 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$241, x$242, x$244, x$245, x$243, x$246, x$247, x$248, x$249, x$250, x$251, x$252, x$253, x$254, x$255, x$256);
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), String.valueOf(false));
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)serverConfig.uncleanLeaderElectionEnable(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Test
    public void testUncleanElectionEnabled() {
        int x$257 = 0;
        String x$258 = TestUtils$.MODULE$.MockZkConnect();
        int x$259 = 8181;
        boolean x$260 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$261 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$262 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$263 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$264 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$265 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$266 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$267 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$268 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$269 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$270 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$271 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$272 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$257, x$258, x$260, x$261, x$259, x$262, x$263, x$264, x$265, x$266, x$267, x$268, x$269, x$270, x$271, x$272);
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), String.valueOf(true));
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)serverConfig.uncleanLeaderElectionEnable(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    @Test
    public void testUncleanElectionInvalid() {
        int x$273 = 0;
        String x$274 = TestUtils$.MODULE$.MockZkConnect();
        int x$275 = 8181;
        boolean x$276 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$277 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$278 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$279 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$280 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$281 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$282 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$283 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$284 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$285 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$286 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$287 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$288 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$273, x$274, x$276, x$277, x$275, x$278, x$279, x$280, x$281, x$282, x$283, x$284, x$285, x$286, x$287, x$288);
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "invalid");
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final KafkaConfig apply() {
                return KafkaConfig$.MODULE$.fromProps(this.props$1);
            }
            {
                this.props$1 = props$1;
            }
        }, ManifestFactory$.MODULE$.classType(ConfigException.class));
    }

    @Test
    public void testLogRollTimeMsProvided() {
        int x$289 = 0;
        String x$290 = TestUtils$.MODULE$.MockZkConnect();
        int x$291 = 8181;
        boolean x$292 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$293 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$294 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$295 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$296 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$297 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$298 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$299 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$300 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$301 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$302 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$303 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$304 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$289, x$290, x$292, x$293, x$291, x$294, x$295, x$296, x$297, x$298, x$299, x$300, x$301, x$302, x$303, x$304);
        props.put(KafkaConfig$.MODULE$.LogRollTimeMillisProp(), "1800000");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)1800000L), (Object)cfg.logRollTimeMillis());
    }

    @Test
    public void testLogRollTimeBothMsAndHoursProvided() {
        int x$305 = 0;
        String x$306 = TestUtils$.MODULE$.MockZkConnect();
        int x$307 = 8181;
        boolean x$308 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$309 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$310 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$311 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$312 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$313 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$314 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$315 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$316 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$317 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$318 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$319 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$320 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$305, x$306, x$308, x$309, x$307, x$310, x$311, x$312, x$313, x$314, x$315, x$316, x$317, x$318, x$319, x$320);
        props.put(KafkaConfig$.MODULE$.LogRollTimeMillisProp(), "1800000");
        props.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "1");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)1800000L), (Object)cfg.logRollTimeMillis());
    }

    @Test
    public void testLogRollTimeNoConfigProvided() {
        int x$321 = 0;
        String x$322 = TestUtils$.MODULE$.MockZkConnect();
        int x$323 = 8181;
        boolean x$324 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$325 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$326 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$327 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$328 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$329 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$330 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$331 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$332 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$333 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$334 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$335 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$336 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$321, x$322, x$324, x$325, x$323, x$326, x$327, x$328, x$329, x$330, x$331, x$332, x$333, x$334, x$335, x$336);
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)604800000L), (Object)cfg.logRollTimeMillis());
    }

    @Test
    public void testDefaultCompressionType() {
        int x$337 = 0;
        String x$338 = TestUtils$.MODULE$.MockZkConnect();
        int x$339 = 8181;
        boolean x$340 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$341 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$342 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$343 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$344 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$345 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$346 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$347 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$348 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$349 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$350 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$351 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$352 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$337, x$338, x$340, x$341, x$339, x$342, x$343, x$344, x$345, x$346, x$347, x$348, x$349, x$350, x$351, x$352);
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)serverConfig.compressionType(), (Object)"producer");
    }

    @Test
    public void testValidCompressionType() {
        int x$353 = 0;
        String x$354 = TestUtils$.MODULE$.MockZkConnect();
        int x$355 = 8181;
        boolean x$356 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$357 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$358 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$359 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$360 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$361 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$362 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$363 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$364 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$365 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$366 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$367 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$368 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$353, x$354, x$356, x$357, x$355, x$358, x$359, x$360, x$361, x$362, x$363, x$364, x$365, x$366, x$367, x$368);
        props.put("compression.type", "gzip");
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)serverConfig.compressionType(), (Object)"gzip");
    }

    @Test
    public void testInvalidCompressionType() {
        int x$369 = 0;
        String x$370 = TestUtils$.MODULE$.MockZkConnect();
        int x$371 = 8181;
        boolean x$372 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$373 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$374 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$375 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$376 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$377 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$378 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$379 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$380 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$381 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$382 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$383 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$384 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$369, x$370, x$372, x$373, x$371, x$374, x$375, x$376, x$377, x$378, x$379, x$380, x$381, x$382, x$383, x$384);
        props.put(KafkaConfig$.MODULE$.CompressionTypeProp(), "abc");
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$2;

            public final KafkaConfig apply() {
                return KafkaConfig$.MODULE$.fromProps(this.props$2);
            }
            {
                this.props$2 = props$2;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
    }

    @Test
    public void testInvalidInterBrokerSecurityProtocol() {
        int x$385 = 0;
        String x$386 = TestUtils$.MODULE$.MockZkConnect();
        int x$387 = 8181;
        boolean x$388 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$389 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$390 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$391 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$392 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$393 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$394 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$395 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$396 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$397 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$398 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$399 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$400 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$385, x$386, x$388, x$389, x$387, x$390, x$391, x$392, x$393, x$394, x$395, x$396, x$397, x$398, x$399, x$400);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "SSL://localhost:0");
        props.put(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp(), SecurityProtocol.PLAINTEXT.toString());
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$3;

            public final KafkaConfig apply() {
                return KafkaConfig$.MODULE$.fromProps(this.props$3);
            }
            {
                this.props$3 = props$3;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
    }

    @Test
    public void testEqualAdvertisedListenersProtocol() {
        int x$401 = 0;
        String x$402 = TestUtils$.MODULE$.MockZkConnect();
        int x$403 = 8181;
        boolean x$404 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$405 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$406 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$407 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$408 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$409 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$410 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$411 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$412 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$413 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$414 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$415 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$416 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$401, x$402, x$404, x$405, x$403, x$406, x$407, x$408, x$409, x$410, x$411, x$412, x$413, x$414, x$415, x$416);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://localhost:9092,SSL://localhost:9093");
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), "PLAINTEXT://localhost:9092,SSL://localhost:9093");
        KafkaConfig$.MODULE$.fromProps(props);
    }

    @Test
    public void testInvalidAdvertisedListenersProtocol() {
        int x$417 = 0;
        String x$418 = TestUtils$.MODULE$.MockZkConnect();
        int x$419 = 8181;
        boolean x$420 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$421 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$422 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$423 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$424 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$425 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$426 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$427 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$428 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$429 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$430 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$431 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$432 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$417, x$418, x$420, x$421, x$419, x$422, x$423, x$424, x$425, x$426, x$427, x$428, x$429, x$430, x$431, x$432);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "TRACE://localhost:9091,SSL://localhost:9093");
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), "PLAINTEXT://localhost:9092");
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$4;

            public final KafkaConfig apply() {
                return KafkaConfig$.MODULE$.fromProps(this.props$4);
            }
            {
                this.props$4 = props$4;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
    }

    @Test
    public void testFromPropsInvalid() {
        KafkaConfig$.MODULE$.fromProps(this.kafka$server$KafkaConfigTest$$getBaseProperties$1());
        KafkaConfig$.MODULE$.configNames().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaConfigTest $outer;

            public final void apply(String name) {
                String string = name;
                String string2 = KafkaConfig$.MODULE$.ZkConnectProp();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string4 = KafkaConfig$.MODULE$.ZkSessionTimeoutMsProp();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                            public final Properties apply() {
                                return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String string6 = KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp();
                        String string7 = string;
                        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                            this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                public final Properties apply() {
                                    return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            String string8 = KafkaConfig$.MODULE$.ZkSyncTimeMsProp();
                            String string9 = string;
                            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                                this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                    public final Properties apply() {
                                        return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                String string10 = KafkaConfig$.MODULE$.ZkEnableSecureAclsProp();
                                String string11 = string;
                                if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                        public final Properties apply() {
                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean"}));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    String string12 = KafkaConfig$.MODULE$.BrokerIdProp();
                                    String string13 = string;
                                    if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                        this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                            public final Properties apply() {
                                                return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                            }
                                        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        String string14 = KafkaConfig$.MODULE$.NumNetworkThreadsProp();
                                        String string15 = string;
                                        if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                            this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                public final Properties apply() {
                                                    return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw new NullPointerException();
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            String string16 = KafkaConfig$.MODULE$.NumIoThreadsProp();
                                            String string17 = string;
                                            if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                                                this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                    public final Properties apply() {
                                                        return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw new NullPointerException();
                                                        }
                                                        this.$outer = $outer;
                                                    }
                                                }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                String string18 = KafkaConfig$.MODULE$.BackgroundThreadsProp();
                                                String string19 = string;
                                                if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;
                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                        public final Properties apply() {
                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw new NullPointerException();
                                                            }
                                                            this.$outer = $outer;
                                                        }
                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                } else {
                                                    String string20 = KafkaConfig$.MODULE$.QueuedMaxRequestsProp();
                                                    String string21 = string;
                                                    if (!(string20 != null ? !string20.equals(string21) : string21 != null)) {
                                                        this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                            public static final long serialVersionUID = 0L;
                                                            private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                            public final Properties apply() {
                                                                return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                            }
                                                            {
                                                                if ($outer == null) {
                                                                    throw new NullPointerException();
                                                                }
                                                                this.$outer = $outer;
                                                            }
                                                        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    } else {
                                                        String string22 = KafkaConfig$.MODULE$.RequestTimeoutMsProp();
                                                        String string23 = string;
                                                        if (!(string22 != null ? !string22.equals(string23) : string23 != null)) {
                                                            this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                public static final long serialVersionUID = 0L;
                                                                private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                public final Properties apply() {
                                                                    return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                }
                                                                {
                                                                    if ($outer == null) {
                                                                        throw new NullPointerException();
                                                                    }
                                                                    this.$outer = $outer;
                                                                }
                                                            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        } else {
                                                            String string24 = KafkaConfig$.MODULE$.AuthorizerClassNameProp();
                                                            String string25 = string;
                                                            if (!(string24 != null ? !string24.equals(string25) : string25 != null)) {
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            } else {
                                                                String string26 = KafkaConfig$.MODULE$.PortProp();
                                                                String string27 = string;
                                                                if (!(string26 != null ? !string26.equals(string27) : string27 != null)) {
                                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                        public static final long serialVersionUID = 0L;
                                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                        public final Properties apply() {
                                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                        }
                                                                        {
                                                                            if ($outer == null) {
                                                                                throw new NullPointerException();
                                                                            }
                                                                            this.$outer = $outer;
                                                                        }
                                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                } else {
                                                                    String string28 = KafkaConfig$.MODULE$.HostNameProp();
                                                                    String string29 = string;
                                                                    if (!(string28 != null ? !string28.equals(string29) : string29 != null)) {
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                    } else {
                                                                        String string30 = KafkaConfig$.MODULE$.AdvertisedHostNameProp();
                                                                        String string31 = string;
                                                                        if (!(string30 != null ? !string30.equals(string31) : string31 != null)) {
                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                        } else {
                                                                            String string32 = KafkaConfig$.MODULE$.AdvertisedPortProp();
                                                                            String string33 = string;
                                                                            if (!(string32 != null ? !string32.equals(string33) : string33 != null)) {
                                                                                this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                    public static final long serialVersionUID = 0L;
                                                                                    private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                    public final Properties apply() {
                                                                                        return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                    }
                                                                                    {
                                                                                        if ($outer == null) {
                                                                                            throw new NullPointerException();
                                                                                        }
                                                                                        this.$outer = $outer;
                                                                                    }
                                                                                }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            } else {
                                                                                String string34 = KafkaConfig$.MODULE$.SocketSendBufferBytesProp();
                                                                                String string35 = string;
                                                                                if (!(string34 != null ? !string34.equals(string35) : string35 != null)) {
                                                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                        public static final long serialVersionUID = 0L;
                                                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                        public final Properties apply() {
                                                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                        }
                                                                                        {
                                                                                            if ($outer == null) {
                                                                                                throw new NullPointerException();
                                                                                            }
                                                                                            this.$outer = $outer;
                                                                                        }
                                                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                } else {
                                                                                    String string36 = KafkaConfig$.MODULE$.SocketReceiveBufferBytesProp();
                                                                                    String string37 = string;
                                                                                    if (!(string36 != null ? !string36.equals(string37) : string37 != null)) {
                                                                                        this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                            public static final long serialVersionUID = 0L;
                                                                                            private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                            public final Properties apply() {
                                                                                                return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                            }
                                                                                            {
                                                                                                if ($outer == null) {
                                                                                                    throw new NullPointerException();
                                                                                                }
                                                                                                this.$outer = $outer;
                                                                                            }
                                                                                        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                    } else {
                                                                                        String string38 = KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp();
                                                                                        String string39 = string;
                                                                                        if (!(string38 != null ? !string38.equals(string39) : string39 != null)) {
                                                                                            this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                public static final long serialVersionUID = 0L;
                                                                                                private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                public final Properties apply() {
                                                                                                    return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                }
                                                                                                {
                                                                                                    if ($outer == null) {
                                                                                                        throw new NullPointerException();
                                                                                                    }
                                                                                                    this.$outer = $outer;
                                                                                                }
                                                                                            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"127.0.0.1:not_a_number"}));
                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                        } else {
                                                                                            String string40 = KafkaConfig$.MODULE$.ConnectionsMaxIdleMsProp();
                                                                                            String string41 = string;
                                                                                            if (!(string40 != null ? !string40.equals(string41) : string41 != null)) {
                                                                                                this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                    private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                    public final Properties apply() {
                                                                                                        return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                    }
                                                                                                    {
                                                                                                        if ($outer == null) {
                                                                                                            throw new NullPointerException();
                                                                                                        }
                                                                                                        this.$outer = $outer;
                                                                                                    }
                                                                                                }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                            } else {
                                                                                                String string42 = KafkaConfig$.MODULE$.NumPartitionsProp();
                                                                                                String string43 = string;
                                                                                                if (!(string42 != null ? !string42.equals(string43) : string43 != null)) {
                                                                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                        public final Properties apply() {
                                                                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                        }
                                                                                                        {
                                                                                                            if ($outer == null) {
                                                                                                                throw new NullPointerException();
                                                                                                            }
                                                                                                            this.$outer = $outer;
                                                                                                        }
                                                                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                } else {
                                                                                                    String string44 = KafkaConfig$.MODULE$.LogDirsProp();
                                                                                                    String string45 = string;
                                                                                                    if (!(string44 != null ? !string44.equals(string45) : string45 != null)) {
                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                    } else {
                                                                                                        String string46 = KafkaConfig$.MODULE$.LogDirProp();
                                                                                                        String string47 = string;
                                                                                                        if (!(string46 != null ? !string46.equals(string47) : string47 != null)) {
                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                        } else {
                                                                                                            String string48 = KafkaConfig$.MODULE$.LogSegmentBytesProp();
                                                                                                            String string49 = string;
                                                                                                            if (!(string48 != null ? !string48.equals(string49) : string49 != null)) {
                                                                                                                this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                    private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                    public final Properties apply() {
                                                                                                                        return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                    }
                                                                                                                    {
                                                                                                                        if ($outer == null) {
                                                                                                                            throw new NullPointerException();
                                                                                                                        }
                                                                                                                        this.$outer = $outer;
                                                                                                                    }
                                                                                                                }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", BoxesRunTime.boxToInteger((int)(Message$.MODULE$.MinMessageOverhead() - 1))}));
                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                            } else {
                                                                                                                String string50 = KafkaConfig$.MODULE$.LogRollTimeMillisProp();
                                                                                                                String string51 = string;
                                                                                                                if (!(string50 != null ? !string50.equals(string51) : string51 != null)) {
                                                                                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                        public final Properties apply() {
                                                                                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                        }
                                                                                                                        {
                                                                                                                            if ($outer == null) {
                                                                                                                                throw new NullPointerException();
                                                                                                                            }
                                                                                                                            this.$outer = $outer;
                                                                                                                        }
                                                                                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                } else {
                                                                                                                    String string52 = KafkaConfig$.MODULE$.LogRollTimeHoursProp();
                                                                                                                    String string53 = string;
                                                                                                                    if (!(string52 != null ? !string52.equals(string53) : string53 != null)) {
                                                                                                                        this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                            private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                            public final Properties apply() {
                                                                                                                                return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                            }
                                                                                                                            {
                                                                                                                                if ($outer == null) {
                                                                                                                                    throw new NullPointerException();
                                                                                                                                }
                                                                                                                                this.$outer = $outer;
                                                                                                                            }
                                                                                                                        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                    } else {
                                                                                                                        String string54 = KafkaConfig$.MODULE$.LogRetentionTimeMillisProp();
                                                                                                                        String string55 = string;
                                                                                                                        if (!(string54 != null ? !string54.equals(string55) : string55 != null)) {
                                                                                                                            this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                public final Properties apply() {
                                                                                                                                    return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                }
                                                                                                                                {
                                                                                                                                    if ($outer == null) {
                                                                                                                                        throw new NullPointerException();
                                                                                                                                    }
                                                                                                                                    this.$outer = $outer;
                                                                                                                                }
                                                                                                                            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                        } else {
                                                                                                                            String string56 = KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp();
                                                                                                                            String string57 = string;
                                                                                                                            if (!(string56 != null ? !string56.equals(string57) : string57 != null)) {
                                                                                                                                this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                    private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                    public final Properties apply() {
                                                                                                                                        return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                    }
                                                                                                                                    {
                                                                                                                                        if ($outer == null) {
                                                                                                                                            throw new NullPointerException();
                                                                                                                                        }
                                                                                                                                        this.$outer = $outer;
                                                                                                                                    }
                                                                                                                                }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                            } else {
                                                                                                                                String string58 = KafkaConfig$.MODULE$.LogRetentionTimeHoursProp();
                                                                                                                                String string59 = string;
                                                                                                                                if (!(string58 != null ? !string58.equals(string59) : string59 != null)) {
                                                                                                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                        public final Properties apply() {
                                                                                                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                        }
                                                                                                                                        {
                                                                                                                                            if ($outer == null) {
                                                                                                                                                throw new NullPointerException();
                                                                                                                                            }
                                                                                                                                            this.$outer = $outer;
                                                                                                                                        }
                                                                                                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                } else {
                                                                                                                                    String string60 = KafkaConfig$.MODULE$.LogRetentionBytesProp();
                                                                                                                                    String string61 = string;
                                                                                                                                    if (!(string60 != null ? !string60.equals(string61) : string61 != null)) {
                                                                                                                                        this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                            private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                            public final Properties apply() {
                                                                                                                                                return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                            }
                                                                                                                                            {
                                                                                                                                                if ($outer == null) {
                                                                                                                                                    throw new NullPointerException();
                                                                                                                                                }
                                                                                                                                                this.$outer = $outer;
                                                                                                                                            }
                                                                                                                                        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                    } else {
                                                                                                                                        String string62 = KafkaConfig$.MODULE$.LogCleanupIntervalMsProp();
                                                                                                                                        String string63 = string;
                                                                                                                                        if (!(string62 != null ? !string62.equals(string63) : string63 != null)) {
                                                                                                                                            this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                public final Properties apply() {
                                                                                                                                                    return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                }
                                                                                                                                                {
                                                                                                                                                    if ($outer == null) {
                                                                                                                                                        throw new NullPointerException();
                                                                                                                                                    }
                                                                                                                                                    this.$outer = $outer;
                                                                                                                                                }
                                                                                                                                            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                        } else {
                                                                                                                                            String string64 = KafkaConfig$.MODULE$.LogCleanupPolicyProp();
                                                                                                                                            String string65 = string;
                                                                                                                                            if (!(string64 != null ? !string64.equals(string65) : string65 != null)) {
                                                                                                                                                this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                    private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                    public final Properties apply() {
                                                                                                                                                        return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                    }
                                                                                                                                                    {
                                                                                                                                                        if ($outer == null) {
                                                                                                                                                            throw new NullPointerException();
                                                                                                                                                        }
                                                                                                                                                        this.$outer = $outer;
                                                                                                                                                    }
                                                                                                                                                }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"unknown_policy", "0"}));
                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                            } else {
                                                                                                                                                String string66 = KafkaConfig$.MODULE$.LogCleanerIoMaxBytesPerSecondProp();
                                                                                                                                                String string67 = string;
                                                                                                                                                if (!(string66 != null ? !string66.equals(string67) : string67 != null)) {
                                                                                                                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                        public final Properties apply() {
                                                                                                                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                        }
                                                                                                                                                        {
                                                                                                                                                            if ($outer == null) {
                                                                                                                                                                throw new NullPointerException();
                                                                                                                                                            }
                                                                                                                                                            this.$outer = $outer;
                                                                                                                                                        }
                                                                                                                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                } else {
                                                                                                                                                    String string68 = KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp();
                                                                                                                                                    String string69 = string;
                                                                                                                                                    if (!(string68 != null ? !string68.equals(string69) : string69 != null)) {
                                                                                                                                                        this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                            private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                            public final Properties apply() {
                                                                                                                                                                return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                            }
                                                                                                                                                            {
                                                                                                                                                                if ($outer == null) {
                                                                                                                                                                    throw new NullPointerException();
                                                                                                                                                                }
                                                                                                                                                                this.$outer = $outer;
                                                                                                                                                            }
                                                                                                                                                        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "1024"}));
                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                    } else {
                                                                                                                                                        String string70 = KafkaConfig$.MODULE$.LogCleanerDedupeBufferLoadFactorProp();
                                                                                                                                                        String string71 = string;
                                                                                                                                                        if (!(string70 != null ? !string70.equals(string71) : string71 != null)) {
                                                                                                                                                            this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                public final Properties apply() {
                                                                                                                                                                    return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                }
                                                                                                                                                                {
                                                                                                                                                                    if ($outer == null) {
                                                                                                                                                                        throw new NullPointerException();
                                                                                                                                                                    }
                                                                                                                                                                    this.$outer = $outer;
                                                                                                                                                                }
                                                                                                                                                            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                        } else {
                                                                                                                                                            String string72 = KafkaConfig$.MODULE$.LogCleanerEnableProp();
                                                                                                                                                            String string73 = string;
                                                                                                                                                            if (!(string72 != null ? !string72.equals(string73) : string73 != null)) {
                                                                                                                                                                this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                                    private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                    public final Properties apply() {
                                                                                                                                                                        return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                    }
                                                                                                                                                                    {
                                                                                                                                                                        if ($outer == null) {
                                                                                                                                                                            throw new NullPointerException();
                                                                                                                                                                        }
                                                                                                                                                                        this.$outer = $outer;
                                                                                                                                                                    }
                                                                                                                                                                }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean"}));
                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                            } else {
                                                                                                                                                                String string74 = KafkaConfig$.MODULE$.LogCleanerDeleteRetentionMsProp();
                                                                                                                                                                String string75 = string;
                                                                                                                                                                if (!(string74 != null ? !string74.equals(string75) : string75 != null)) {
                                                                                                                                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                        public final Properties apply() {
                                                                                                                                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                        }
                                                                                                                                                                        {
                                                                                                                                                                            if ($outer == null) {
                                                                                                                                                                                throw new NullPointerException();
                                                                                                                                                                            }
                                                                                                                                                                            this.$outer = $outer;
                                                                                                                                                                        }
                                                                                                                                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                } else {
                                                                                                                                                                    String string76 = KafkaConfig$.MODULE$.LogCleanerMinCleanRatioProp();
                                                                                                                                                                    String string77 = string;
                                                                                                                                                                    if (!(string76 != null ? !string76.equals(string77) : string77 != null)) {
                                                                                                                                                                        this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                            private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                            public final Properties apply() {
                                                                                                                                                                                return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                            }
                                                                                                                                                                            {
                                                                                                                                                                                if ($outer == null) {
                                                                                                                                                                                    throw new NullPointerException();
                                                                                                                                                                                }
                                                                                                                                                                                this.$outer = $outer;
                                                                                                                                                                            }
                                                                                                                                                                        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                    } else {
                                                                                                                                                                        String string78 = KafkaConfig$.MODULE$.LogIndexSizeMaxBytesProp();
                                                                                                                                                                        String string79 = string;
                                                                                                                                                                        if (!(string78 != null ? !string78.equals(string79) : string79 != null)) {
                                                                                                                                                                            this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                public final Properties apply() {
                                                                                                                                                                                    return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                }
                                                                                                                                                                                {
                                                                                                                                                                                    if ($outer == null) {
                                                                                                                                                                                        throw new NullPointerException();
                                                                                                                                                                                    }
                                                                                                                                                                                    this.$outer = $outer;
                                                                                                                                                                                }
                                                                                                                                                                            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "3"}));
                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                        } else {
                                                                                                                                                                            String string80 = KafkaConfig$.MODULE$.LogFlushIntervalMessagesProp();
                                                                                                                                                                            String string81 = string;
                                                                                                                                                                            if (!(string80 != null ? !string80.equals(string81) : string81 != null)) {
                                                                                                                                                                                this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                                                    private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                    public final Properties apply() {
                                                                                                                                                                                        return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                    }
                                                                                                                                                                                    {
                                                                                                                                                                                        if ($outer == null) {
                                                                                                                                                                                            throw new NullPointerException();
                                                                                                                                                                                        }
                                                                                                                                                                                        this.$outer = $outer;
                                                                                                                                                                                    }
                                                                                                                                                                                }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                            } else {
                                                                                                                                                                                String string82 = KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp();
                                                                                                                                                                                String string83 = string;
                                                                                                                                                                                if (!(string82 != null ? !string82.equals(string83) : string83 != null)) {
                                                                                                                                                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                        public final Properties apply() {
                                                                                                                                                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                        }
                                                                                                                                                                                        {
                                                                                                                                                                                            if ($outer == null) {
                                                                                                                                                                                                throw new NullPointerException();
                                                                                                                                                                                            }
                                                                                                                                                                                            this.$outer = $outer;
                                                                                                                                                                                        }
                                                                                                                                                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                } else {
                                                                                                                                                                                    String string84 = KafkaConfig$.MODULE$.LogFlushIntervalMsProp();
                                                                                                                                                                                    String string85 = string;
                                                                                                                                                                                    if (!(string84 != null ? !string84.equals(string85) : string85 != null)) {
                                                                                                                                                                                        this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                            private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                            public final Properties apply() {
                                                                                                                                                                                                return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                            }
                                                                                                                                                                                            {
                                                                                                                                                                                                if ($outer == null) {
                                                                                                                                                                                                    throw new NullPointerException();
                                                                                                                                                                                                }
                                                                                                                                                                                                this.$outer = $outer;
                                                                                                                                                                                            }
                                                                                                                                                                                        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                    } else {
                                                                                                                                                                                        String string86 = KafkaConfig$.MODULE$.NumRecoveryThreadsPerDataDirProp();
                                                                                                                                                                                        String string87 = string;
                                                                                                                                                                                        if (!(string86 != null ? !string86.equals(string87) : string87 != null)) {
                                                                                                                                                                                            this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                                private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                public final Properties apply() {
                                                                                                                                                                                                    return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                }
                                                                                                                                                                                                {
                                                                                                                                                                                                    if ($outer == null) {
                                                                                                                                                                                                        throw new NullPointerException();
                                                                                                                                                                                                    }
                                                                                                                                                                                                    this.$outer = $outer;
                                                                                                                                                                                                }
                                                                                                                                                                                            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                        } else {
                                                                                                                                                                                            String string88 = KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp();
                                                                                                                                                                                            String string89 = string;
                                                                                                                                                                                            if (!(string88 != null ? !string88.equals(string89) : string89 != null)) {
                                                                                                                                                                                                this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                                                                    private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                    public final Properties apply() {
                                                                                                                                                                                                        return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                    }
                                                                                                                                                                                                    {
                                                                                                                                                                                                        if ($outer == null) {
                                                                                                                                                                                                            throw new NullPointerException();
                                                                                                                                                                                                        }
                                                                                                                                                                                                        this.$outer = $outer;
                                                                                                                                                                                                    }
                                                                                                                                                                                                }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean", "0"}));
                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                            } else {
                                                                                                                                                                                                String string90 = KafkaConfig$.MODULE$.MinInSyncReplicasProp();
                                                                                                                                                                                                String string91 = string;
                                                                                                                                                                                                if (!(string90 != null ? !string90.equals(string91) : string91 != null)) {
                                                                                                                                                                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                        public final Properties apply() {
                                                                                                                                                                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                        }
                                                                                                                                                                                                        {
                                                                                                                                                                                                            if ($outer == null) {
                                                                                                                                                                                                                throw new NullPointerException();
                                                                                                                                                                                                            }
                                                                                                                                                                                                            this.$outer = $outer;
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    String string92 = KafkaConfig$.MODULE$.ControllerSocketTimeoutMsProp();
                                                                                                                                                                                                    String string93 = string;
                                                                                                                                                                                                    if (!(string92 != null ? !string92.equals(string93) : string93 != null)) {
                                                                                                                                                                                                        this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                                            private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                            public final Properties apply() {
                                                                                                                                                                                                                return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                            }
                                                                                                                                                                                                            {
                                                                                                                                                                                                                if ($outer == null) {
                                                                                                                                                                                                                    throw new NullPointerException();
                                                                                                                                                                                                                }
                                                                                                                                                                                                                this.$outer = $outer;
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        String string94 = KafkaConfig$.MODULE$.DefaultReplicationFactorProp();
                                                                                                                                                                                                        String string95 = string;
                                                                                                                                                                                                        if (!(string94 != null ? !string94.equals(string95) : string95 != null)) {
                                                                                                                                                                                                            this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                public final Properties apply() {
                                                                                                                                                                                                                    return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                }
                                                                                                                                                                                                                {
                                                                                                                                                                                                                    if ($outer == null) {
                                                                                                                                                                                                                        throw new NullPointerException();
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    this.$outer = $outer;
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            String string96 = KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp();
                                                                                                                                                                                                            String string97 = string;
                                                                                                                                                                                                            if (!(string96 != null ? !string96.equals(string97) : string97 != null)) {
                                                                                                                                                                                                                this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                    private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                    public final Properties apply() {
                                                                                                                                                                                                                        return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    {
                                                                                                                                                                                                                        if ($outer == null) {
                                                                                                                                                                                                                            throw new NullPointerException();
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        this.$outer = $outer;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                String string98 = KafkaConfig$.MODULE$.ReplicaSocketTimeoutMsProp();
                                                                                                                                                                                                                String string99 = string;
                                                                                                                                                                                                                if (!(string98 != null ? !string98.equals(string99) : string99 != null)) {
                                                                                                                                                                                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                        public final Properties apply() {
                                                                                                                                                                                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        {
                                                                                                                                                                                                                            if ($outer == null) {
                                                                                                                                                                                                                                throw new NullPointerException();
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            this.$outer = $outer;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "-2"}));
                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    String string100 = KafkaConfig$.MODULE$.ReplicaSocketReceiveBufferBytesProp();
                                                                                                                                                                                                                    String string101 = string;
                                                                                                                                                                                                                    if (!(string100 != null ? !string100.equals(string101) : string101 != null)) {
                                                                                                                                                                                                                        this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                            private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                            public final Properties apply() {
                                                                                                                                                                                                                                return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            {
                                                                                                                                                                                                                                if ($outer == null) {
                                                                                                                                                                                                                                    throw new NullPointerException();
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                this.$outer = $outer;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        String string102 = KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp();
                                                                                                                                                                                                                        String string103 = string;
                                                                                                                                                                                                                        if (!(string102 != null ? !string102.equals(string103) : string103 != null)) {
                                                                                                                                                                                                                            this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                public final Properties apply() {
                                                                                                                                                                                                                                    return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                {
                                                                                                                                                                                                                                    if ($outer == null) {
                                                                                                                                                                                                                                        throw new NullPointerException();
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    this.$outer = $outer;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            String string104 = KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp();
                                                                                                                                                                                                                            String string105 = string;
                                                                                                                                                                                                                            if (!(string104 != null ? !string104.equals(string105) : string105 != null)) {
                                                                                                                                                                                                                                this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                    private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                    public final Properties apply() {
                                                                                                                                                                                                                                        return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    {
                                                                                                                                                                                                                                        if ($outer == null) {
                                                                                                                                                                                                                                            throw new NullPointerException();
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        this.$outer = $outer;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                String string106 = KafkaConfig$.MODULE$.ReplicaFetchMinBytesProp();
                                                                                                                                                                                                                                String string107 = string;
                                                                                                                                                                                                                                if (!(string106 != null ? !string106.equals(string107) : string107 != null)) {
                                                                                                                                                                                                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                        public final Properties apply() {
                                                                                                                                                                                                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        {
                                                                                                                                                                                                                                            if ($outer == null) {
                                                                                                                                                                                                                                                throw new NullPointerException();
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            this.$outer = $outer;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    String string108 = KafkaConfig$.MODULE$.NumReplicaFetchersProp();
                                                                                                                                                                                                                                    String string109 = string;
                                                                                                                                                                                                                                    if (!(string108 != null ? !string108.equals(string109) : string109 != null)) {
                                                                                                                                                                                                                                        this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                            private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                            public final Properties apply() {
                                                                                                                                                                                                                                                return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            {
                                                                                                                                                                                                                                                if ($outer == null) {
                                                                                                                                                                                                                                                    throw new NullPointerException();
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                this.$outer = $outer;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                        String string110 = KafkaConfig$.MODULE$.ReplicaHighWatermarkCheckpointIntervalMsProp();
                                                                                                                                                                                                                                        String string111 = string;
                                                                                                                                                                                                                                        if (!(string110 != null ? !string110.equals(string111) : string111 != null)) {
                                                                                                                                                                                                                                            this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                public final Properties apply() {
                                                                                                                                                                                                                                                    return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                {
                                                                                                                                                                                                                                                    if ($outer == null) {
                                                                                                                                                                                                                                                        throw new NullPointerException();
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    this.$outer = $outer;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            String string112 = KafkaConfig$.MODULE$.FetchPurgatoryPurgeIntervalRequestsProp();
                                                                                                                                                                                                                                            String string113 = string;
                                                                                                                                                                                                                                            if (!(string112 != null ? !string112.equals(string113) : string113 != null)) {
                                                                                                                                                                                                                                                this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                    private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                    public final Properties apply() {
                                                                                                                                                                                                                                                        return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    {
                                                                                                                                                                                                                                                        if ($outer == null) {
                                                                                                                                                                                                                                                            throw new NullPointerException();
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        this.$outer = $outer;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                String string114 = KafkaConfig$.MODULE$.ProducerPurgatoryPurgeIntervalRequestsProp();
                                                                                                                                                                                                                                                String string115 = string;
                                                                                                                                                                                                                                                if (!(string114 != null ? !string114.equals(string115) : string115 != null)) {
                                                                                                                                                                                                                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                        public final Properties apply() {
                                                                                                                                                                                                                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        {
                                                                                                                                                                                                                                                            if ($outer == null) {
                                                                                                                                                                                                                                                                throw new NullPointerException();
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            this.$outer = $outer;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                    String string116 = KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp();
                                                                                                                                                                                                                                                    String string117 = string;
                                                                                                                                                                                                                                                    if (!(string116 != null ? !string116.equals(string117) : string117 != null)) {
                                                                                                                                                                                                                                                        this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                            private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                            public final Properties apply() {
                                                                                                                                                                                                                                                                return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            {
                                                                                                                                                                                                                                                                if ($outer == null) {
                                                                                                                                                                                                                                                                    throw new NullPointerException();
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                this.$outer = $outer;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean", "0"}));
                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                        String string118 = KafkaConfig$.MODULE$.LeaderImbalancePerBrokerPercentageProp();
                                                                                                                                                                                                                                                        String string119 = string;
                                                                                                                                                                                                                                                        if (!(string118 != null ? !string118.equals(string119) : string119 != null)) {
                                                                                                                                                                                                                                                            this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                public final Properties apply() {
                                                                                                                                                                                                                                                                    return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                {
                                                                                                                                                                                                                                                                    if ($outer == null) {
                                                                                                                                                                                                                                                                        throw new NullPointerException();
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    this.$outer = $outer;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                            String string120 = KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp();
                                                                                                                                                                                                                                                            String string121 = string;
                                                                                                                                                                                                                                                            if (!(string120 != null ? !string120.equals(string121) : string121 != null)) {
                                                                                                                                                                                                                                                                this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                    private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                    public final Properties apply() {
                                                                                                                                                                                                                                                                        return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    {
                                                                                                                                                                                                                                                                        if ($outer == null) {
                                                                                                                                                                                                                                                                            throw new NullPointerException();
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        this.$outer = $outer;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                String string122 = KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp();
                                                                                                                                                                                                                                                                String string123 = string;
                                                                                                                                                                                                                                                                if (!(string122 != null ? !string122.equals(string123) : string123 != null)) {
                                                                                                                                                                                                                                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                        public final Properties apply() {
                                                                                                                                                                                                                                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        {
                                                                                                                                                                                                                                                                            if ($outer == null) {
                                                                                                                                                                                                                                                                                throw new NullPointerException();
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            this.$outer = $outer;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean", "0"}));
                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                    String string124 = KafkaConfig$.MODULE$.ControlledShutdownMaxRetriesProp();
                                                                                                                                                                                                                                                                    String string125 = string;
                                                                                                                                                                                                                                                                    if (!(string124 != null ? !string124.equals(string125) : string125 != null)) {
                                                                                                                                                                                                                                                                        this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                            private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                            public final Properties apply() {
                                                                                                                                                                                                                                                                                return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            {
                                                                                                                                                                                                                                                                                if ($outer == null) {
                                                                                                                                                                                                                                                                                    throw new NullPointerException();
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                this.$outer = $outer;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                        String string126 = KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp();
                                                                                                                                                                                                                                                                        String string127 = string;
                                                                                                                                                                                                                                                                        if (!(string126 != null ? !string126.equals(string127) : string127 != null)) {
                                                                                                                                                                                                                                                                            this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                public final Properties apply() {
                                                                                                                                                                                                                                                                                    return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                {
                                                                                                                                                                                                                                                                                    if ($outer == null) {
                                                                                                                                                                                                                                                                                        throw new NullPointerException();
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    this.$outer = $outer;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                            String string128 = KafkaConfig$.MODULE$.ControlledShutdownEnableProp();
                                                                                                                                                                                                                                                                            String string129 = string;
                                                                                                                                                                                                                                                                            if (!(string128 != null ? !string128.equals(string129) : string129 != null)) {
                                                                                                                                                                                                                                                                                this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                    private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                    public final Properties apply() {
                                                                                                                                                                                                                                                                                        return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    {
                                                                                                                                                                                                                                                                                        if ($outer == null) {
                                                                                                                                                                                                                                                                                            throw new NullPointerException();
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        this.$outer = $outer;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean", "0"}));
                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                String string130 = KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp();
                                                                                                                                                                                                                                                                                String string131 = string;
                                                                                                                                                                                                                                                                                if (!(string130 != null ? !string130.equals(string131) : string131 != null)) {
                                                                                                                                                                                                                                                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                        public final Properties apply() {
                                                                                                                                                                                                                                                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        {
                                                                                                                                                                                                                                                                                            if ($outer == null) {
                                                                                                                                                                                                                                                                                                throw new NullPointerException();
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            this.$outer = $outer;
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                    String string132 = KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp();
                                                                                                                                                                                                                                                                                    String string133 = string;
                                                                                                                                                                                                                                                                                    if (!(string132 != null ? !string132.equals(string133) : string133 != null)) {
                                                                                                                                                                                                                                                                                        this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                            private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                            public final Properties apply() {
                                                                                                                                                                                                                                                                                                return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            {
                                                                                                                                                                                                                                                                                                if ($outer == null) {
                                                                                                                                                                                                                                                                                                    throw new NullPointerException();
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                this.$outer = $outer;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                        String string134 = KafkaConfig$.MODULE$.OffsetMetadataMaxSizeProp();
                                                                                                                                                                                                                                                                                        String string135 = string;
                                                                                                                                                                                                                                                                                        if (!(string134 != null ? !string134.equals(string135) : string135 != null)) {
                                                                                                                                                                                                                                                                                            this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                                public final Properties apply() {
                                                                                                                                                                                                                                                                                                    return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                {
                                                                                                                                                                                                                                                                                                    if ($outer == null) {
                                                                                                                                                                                                                                                                                                        throw new NullPointerException();
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    this.$outer = $outer;
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                            String string136 = KafkaConfig$.MODULE$.OffsetsLoadBufferSizeProp();
                                                                                                                                                                                                                                                                                            String string137 = string;
                                                                                                                                                                                                                                                                                            if (!(string136 != null ? !string136.equals(string137) : string137 != null)) {
                                                                                                                                                                                                                                                                                                this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                    private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                                    public final Properties apply() {
                                                                                                                                                                                                                                                                                                        return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    {
                                                                                                                                                                                                                                                                                                        if ($outer == null) {
                                                                                                                                                                                                                                                                                                            throw new NullPointerException();
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        this.$outer = $outer;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                String string138 = KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp();
                                                                                                                                                                                                                                                                                                String string139 = string;
                                                                                                                                                                                                                                                                                                if (!(string138 != null ? !string138.equals(string139) : string139 != null)) {
                                                                                                                                                                                                                                                                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                                        public final Properties apply() {
                                                                                                                                                                                                                                                                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        {
                                                                                                                                                                                                                                                                                                            if ($outer == null) {
                                                                                                                                                                                                                                                                                                                throw new NullPointerException();
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            this.$outer = $outer;
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                    String string140 = KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp();
                                                                                                                                                                                                                                                                                                    String string141 = string;
                                                                                                                                                                                                                                                                                                    if (!(string140 != null ? !string140.equals(string141) : string141 != null)) {
                                                                                                                                                                                                                                                                                                        this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                            private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                                            public final Properties apply() {
                                                                                                                                                                                                                                                                                                                return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            {
                                                                                                                                                                                                                                                                                                                if ($outer == null) {
                                                                                                                                                                                                                                                                                                                    throw new NullPointerException();
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                this.$outer = $outer;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                        String string142 = KafkaConfig$.MODULE$.OffsetsTopicSegmentBytesProp();
                                                                                                                                                                                                                                                                                                        String string143 = string;
                                                                                                                                                                                                                                                                                                        if (!(string142 != null ? !string142.equals(string143) : string143 != null)) {
                                                                                                                                                                                                                                                                                                            this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                                                public final Properties apply() {
                                                                                                                                                                                                                                                                                                                    return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                {
                                                                                                                                                                                                                                                                                                                    if ($outer == null) {
                                                                                                                                                                                                                                                                                                                        throw new NullPointerException();
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    this.$outer = $outer;
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                            String string144 = KafkaConfig$.MODULE$.OffsetsTopicCompressionCodecProp();
                                                                                                                                                                                                                                                                                                            String string145 = string;
                                                                                                                                                                                                                                                                                                            if (!(string144 != null ? !string144.equals(string145) : string145 != null)) {
                                                                                                                                                                                                                                                                                                                this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                    private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                                                    public final Properties apply() {
                                                                                                                                                                                                                                                                                                                        return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    {
                                                                                                                                                                                                                                                                                                                        if ($outer == null) {
                                                                                                                                                                                                                                                                                                                            throw new NullPointerException();
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        this.$outer = $outer;
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "-1"}));
                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                String string146 = KafkaConfig$.MODULE$.OffsetsRetentionMinutesProp();
                                                                                                                                                                                                                                                                                                                String string147 = string;
                                                                                                                                                                                                                                                                                                                if (!(string146 != null ? !string146.equals(string147) : string147 != null)) {
                                                                                                                                                                                                                                                                                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                                                        public final Properties apply() {
                                                                                                                                                                                                                                                                                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        {
                                                                                                                                                                                                                                                                                                                            if ($outer == null) {
                                                                                                                                                                                                                                                                                                                                throw new NullPointerException();
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            this.$outer = $outer;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                    String string148 = KafkaConfig$.MODULE$.OffsetsRetentionCheckIntervalMsProp();
                                                                                                                                                                                                                                                                                                                    String string149 = string;
                                                                                                                                                                                                                                                                                                                    if (!(string148 != null ? !string148.equals(string149) : string149 != null)) {
                                                                                                                                                                                                                                                                                                                        this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                            private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                                                            public final Properties apply() {
                                                                                                                                                                                                                                                                                                                                return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            {
                                                                                                                                                                                                                                                                                                                                if ($outer == null) {
                                                                                                                                                                                                                                                                                                                                    throw new NullPointerException();
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                this.$outer = $outer;
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                        String string150 = KafkaConfig$.MODULE$.OffsetCommitTimeoutMsProp();
                                                                                                                                                                                                                                                                                                                        String string151 = string;
                                                                                                                                                                                                                                                                                                                        if (!(string150 != null ? !string150.equals(string151) : string151 != null)) {
                                                                                                                                                                                                                                                                                                                            this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                                private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                                                                public final Properties apply() {
                                                                                                                                                                                                                                                                                                                                    return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                {
                                                                                                                                                                                                                                                                                                                                    if ($outer == null) {
                                                                                                                                                                                                                                                                                                                                        throw new NullPointerException();
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    this.$outer = $outer;
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                            String string152 = KafkaConfig$.MODULE$.OffsetCommitRequiredAcksProp();
                                                                                                                                                                                                                                                                                                                            String string153 = string;
                                                                                                                                                                                                                                                                                                                            if (!(string152 != null ? !string152.equals(string153) : string153 != null)) {
                                                                                                                                                                                                                                                                                                                                this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                                    private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                                                                    public final Properties apply() {
                                                                                                                                                                                                                                                                                                                                        return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    {
                                                                                                                                                                                                                                                                                                                                        if ($outer == null) {
                                                                                                                                                                                                                                                                                                                                            throw new NullPointerException();
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        this.$outer = $outer;
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "-2"}));
                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                String string154 = KafkaConfig$.MODULE$.ProducerQuotaBytesPerSecondDefaultProp();
                                                                                                                                                                                                                                                                                                                                String string155 = string;
                                                                                                                                                                                                                                                                                                                                if (!(string154 != null ? !string154.equals(string155) : string155 != null)) {
                                                                                                                                                                                                                                                                                                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                                                                        public final Properties apply() {
                                                                                                                                                                                                                                                                                                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        {
                                                                                                                                                                                                                                                                                                                                            if ($outer == null) {
                                                                                                                                                                                                                                                                                                                                                throw new NullPointerException();
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                            this.$outer = $outer;
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                    String string156 = KafkaConfig$.MODULE$.ConsumerQuotaBytesPerSecondDefaultProp();
                                                                                                                                                                                                                                                                                                                                    String string157 = string;
                                                                                                                                                                                                                                                                                                                                    if (!(string156 != null ? !string156.equals(string157) : string157 != null)) {
                                                                                                                                                                                                                                                                                                                                        this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                                            private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                                                                            public final Properties apply() {
                                                                                                                                                                                                                                                                                                                                                return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                            {
                                                                                                                                                                                                                                                                                                                                                if ($outer == null) {
                                                                                                                                                                                                                                                                                                                                                    throw new NullPointerException();
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                this.$outer = $outer;
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                        String string158 = KafkaConfig$.MODULE$.NumQuotaSamplesProp();
                                                                                                                                                                                                                                                                                                                                        String string159 = string;
                                                                                                                                                                                                                                                                                                                                        if (!(string158 != null ? !string158.equals(string159) : string159 != null)) {
                                                                                                                                                                                                                                                                                                                                            this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                                                private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                                                                                public final Properties apply() {
                                                                                                                                                                                                                                                                                                                                                    return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                {
                                                                                                                                                                                                                                                                                                                                                    if ($outer == null) {
                                                                                                                                                                                                                                                                                                                                                        throw new NullPointerException();
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                    this.$outer = $outer;
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                            String string160 = KafkaConfig$.MODULE$.QuotaWindowSizeSecondsProp();
                                                                                                                                                                                                                                                                                                                                            String string161 = string;
                                                                                                                                                                                                                                                                                                                                            if (!(string160 != null ? !string160.equals(string161) : string161 != null)) {
                                                                                                                                                                                                                                                                                                                                                this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                                                    private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                                                                                    public final Properties apply() {
                                                                                                                                                                                                                                                                                                                                                        return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                    {
                                                                                                                                                                                                                                                                                                                                                        if ($outer == null) {
                                                                                                                                                                                                                                                                                                                                                            throw new NullPointerException();
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                        this.$outer = $outer;
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                String string162 = KafkaConfig$.MODULE$.DeleteTopicEnableProp();
                                                                                                                                                                                                                                                                                                                                                String string163 = string;
                                                                                                                                                                                                                                                                                                                                                if (!(string162 != null ? !string162.equals(string163) : string163 != null)) {
                                                                                                                                                                                                                                                                                                                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                                                                                        public final Properties apply() {
                                                                                                                                                                                                                                                                                                                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                        {
                                                                                                                                                                                                                                                                                                                                                            if ($outer == null) {
                                                                                                                                                                                                                                                                                                                                                                throw new NullPointerException();
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                            this.$outer = $outer;
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean", "0"}));
                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                    String string164 = KafkaConfig$.MODULE$.MetricNumSamplesProp();
                                                                                                                                                                                                                                                                                                                                                    String string165 = string;
                                                                                                                                                                                                                                                                                                                                                    if (!(string164 != null ? !string164.equals(string165) : string165 != null)) {
                                                                                                                                                                                                                                                                                                                                                        this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                                                            private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                                                                                            public final Properties apply() {
                                                                                                                                                                                                                                                                                                                                                                return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                            {
                                                                                                                                                                                                                                                                                                                                                                if ($outer == null) {
                                                                                                                                                                                                                                                                                                                                                                    throw new NullPointerException();
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                this.$outer = $outer;
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "-1", "0"}));
                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                        String string166 = KafkaConfig$.MODULE$.MetricSampleWindowMsProp();
                                                                                                                                                                                                                                                                                                                                                        String string167 = string;
                                                                                                                                                                                                                                                                                                                                                        if (!(string166 != null ? !string166.equals(string167) : string167 != null)) {
                                                                                                                                                                                                                                                                                                                                                            this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                                                                private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                                                                                                public final Properties apply() {
                                                                                                                                                                                                                                                                                                                                                                    return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                {
                                                                                                                                                                                                                                                                                                                                                                    if ($outer == null) {
                                                                                                                                                                                                                                                                                                                                                                        throw new NullPointerException();
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                    this.$outer = $outer;
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "-1", "0"}));
                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                            String string168 = KafkaConfig$.MODULE$.MetricReporterClassesProp();
                                                                                                                                                                                                                                                                                                                                                            String string169 = string;
                                                                                                                                                                                                                                                                                                                                                            if (!(string168 != null ? !string168.equals(string169) : string169 != null)) {
                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                String string170 = KafkaConfig$.MODULE$.RackProp();
                                                                                                                                                                                                                                                                                                                                                                String string171 = string;
                                                                                                                                                                                                                                                                                                                                                                if (!(string170 != null ? !string170.equals(string171) : string171 != null)) {
                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                    String string172 = KafkaConfig$.MODULE$.PrincipalBuilderClassProp();
                                                                                                                                                                                                                                                                                                                                                                    String string173 = string;
                                                                                                                                                                                                                                                                                                                                                                    if (!(string172 != null ? !string172.equals(string173) : string173 != null)) {
                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                        String string174 = KafkaConfig$.MODULE$.SslProtocolProp();
                                                                                                                                                                                                                                                                                                                                                                        String string175 = string;
                                                                                                                                                                                                                                                                                                                                                                        if (!(string174 != null ? !string174.equals(string175) : string175 != null)) {
                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                            String string176 = KafkaConfig$.MODULE$.SslProviderProp();
                                                                                                                                                                                                                                                                                                                                                                            String string177 = string;
                                                                                                                                                                                                                                                                                                                                                                            if (!(string176 != null ? !string176.equals(string177) : string177 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                String string178 = KafkaConfig$.MODULE$.SslEnabledProtocolsProp();
                                                                                                                                                                                                                                                                                                                                                                                String string179 = string;
                                                                                                                                                                                                                                                                                                                                                                                if (!(string178 != null ? !string178.equals(string179) : string179 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                    String string180 = KafkaConfig$.MODULE$.SslKeystoreTypeProp();
                                                                                                                                                                                                                                                                                                                                                                                    String string181 = string;
                                                                                                                                                                                                                                                                                                                                                                                    if (!(string180 != null ? !string180.equals(string181) : string181 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                        String string182 = KafkaConfig$.MODULE$.SslKeystoreLocationProp();
                                                                                                                                                                                                                                                                                                                                                                                        String string183 = string;
                                                                                                                                                                                                                                                                                                                                                                                        if (!(string182 != null ? !string182.equals(string183) : string183 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                            String string184 = KafkaConfig$.MODULE$.SslKeystorePasswordProp();
                                                                                                                                                                                                                                                                                                                                                                                            String string185 = string;
                                                                                                                                                                                                                                                                                                                                                                                            if (!(string184 != null ? !string184.equals(string185) : string185 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                String string186 = KafkaConfig$.MODULE$.SslKeyPasswordProp();
                                                                                                                                                                                                                                                                                                                                                                                                String string187 = string;
                                                                                                                                                                                                                                                                                                                                                                                                if (!(string186 != null ? !string186.equals(string187) : string187 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                    String string188 = KafkaConfig$.MODULE$.SslTruststoreTypeProp();
                                                                                                                                                                                                                                                                                                                                                                                                    String string189 = string;
                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string188 != null ? !string188.equals(string189) : string189 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                        String string190 = KafkaConfig$.MODULE$.SslTruststorePasswordProp();
                                                                                                                                                                                                                                                                                                                                                                                                        String string191 = string;
                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string190 != null ? !string190.equals(string191) : string191 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                            String string192 = KafkaConfig$.MODULE$.SslTruststoreLocationProp();
                                                                                                                                                                                                                                                                                                                                                                                                            String string193 = string;
                                                                                                                                                                                                                                                                                                                                                                                                            if (!(string192 != null ? !string192.equals(string193) : string193 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                String string194 = KafkaConfig$.MODULE$.SslKeyManagerAlgorithmProp();
                                                                                                                                                                                                                                                                                                                                                                                                                String string195 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                if (!(string194 != null ? !string194.equals(string195) : string195 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                    String string196 = KafkaConfig$.MODULE$.SslTrustManagerAlgorithmProp();
                                                                                                                                                                                                                                                                                                                                                                                                                    String string197 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string196 != null ? !string196.equals(string197) : string197 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                        String string198 = KafkaConfig$.MODULE$.SslClientAuthProp();
                                                                                                                                                                                                                                                                                                                                                                                                                        String string199 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string198 != null ? !string198.equals(string199) : string199 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                            String string200 = KafkaConfig$.MODULE$.SslEndpointIdentificationAlgorithmProp();
                                                                                                                                                                                                                                                                                                                                                                                                                            String string201 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (!(string200 != null ? !string200.equals(string201) : string201 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                String string202 = KafkaConfig$.MODULE$.SslCipherSuitesProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                String string203 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                if (!(string202 != null ? !string202.equals(string203) : string203 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                    String string204 = KafkaConfig$.MODULE$.SaslMechanismInterBrokerProtocolProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                    String string205 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string204 != null ? !string204.equals(string205) : string205 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                        String string206 = KafkaConfig$.MODULE$.SaslEnabledMechanismsProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                        String string207 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string206 != null ? !string206.equals(string207) : string207 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                            String string208 = KafkaConfig$.MODULE$.SaslKerberosServiceNameProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                            String string209 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!(string208 != null ? !string208.equals(string209) : string209 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                String string210 = KafkaConfig$.MODULE$.SaslKerberosKinitCmdProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                String string211 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!(string210 != null ? !string210.equals(string211) : string211 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string212 = KafkaConfig$.MODULE$.SaslKerberosTicketRenewWindowFactorProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string213 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string212 != null ? !string212.equals(string213) : string213 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string214 = KafkaConfig$.MODULE$.SaslKerberosTicketRenewJitterProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string215 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string214 != null ? !string214.equals(string215) : string215 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string216 = KafkaConfig$.MODULE$.SaslKerberosMinTimeBeforeReloginProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string217 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!(string216 != null ? !string216.equals(string217) : string217 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                String string218 = KafkaConfig$.MODULE$.SaslKerberosPrincipalToLocalRulesProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                String string219 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!(string218 != null ? !string218.equals(string219) : string219 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.$outer.kafka$server$KafkaConfigTest$$assertPropertyInvalid((Function0<Properties>)new Serializable(this){
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        private final /* synthetic */ $anonfun$testFromPropsInvalid$1 $outer;

                                                                                                                                                                                                                                                                                                                                                                                                                                                                        public final Properties apply() {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return this.$outer.kafka$server$KafkaConfigTest$$anonfun$$$outer().kafka$server$KafkaConfigTest$$getBaseProperties$1();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if ($outer == null) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                throw new NullPointerException();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.$outer = $outer;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "-1"}));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

            public /* synthetic */ KafkaConfigTest kafka$server$KafkaConfigTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testSpecificProperties() {
        Properties defaults = new Properties();
        defaults.put(KafkaConfig$.MODULE$.ZkConnectProp(), "127.0.0.1:2181");
        defaults.put(KafkaConfig$.MODULE$.ZkSessionTimeoutMsProp(), "1234");
        defaults.put(KafkaConfig$.MODULE$.BrokerIdGenerationEnableProp(), "false");
        defaults.put(KafkaConfig$.MODULE$.MaxReservedBrokerIdProp(), "1");
        defaults.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        defaults.put(KafkaConfig$.MODULE$.HostNameProp(), "127.0.0.1");
        defaults.put(KafkaConfig$.MODULE$.PortProp(), "1122");
        defaults.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "127.0.0.1:2, 127.0.0.2:3");
        defaults.put(KafkaConfig$.MODULE$.LogDirProp(), "/tmp1,/tmp2");
        defaults.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "12");
        defaults.put(KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), "11");
        defaults.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "10");
        defaults.put(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "123");
        defaults.put(KafkaConfig$.MODULE$.OffsetsTopicCompressionCodecProp(), ((Object)BoxesRunTime.boxToInteger((int)SnappyCompressionCodec$.MODULE$.codec())).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(defaults);
        Assert.assertEquals((Object)"127.0.0.1:2181", (Object)config.zkConnect());
        Assert.assertEquals((long)1234L, (long)config.zkConnectionTimeoutMs());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.brokerIdGenerationEnable()));
        Assert.assertEquals((long)1L, (long)config.maxReservedBrokerId());
        Assert.assertEquals((long)1L, (long)config.brokerId());
        Assert.assertEquals((Object)"127.0.0.1", (Object)config.hostName());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1122), (Object)config.advertisedPort());
        Assert.assertEquals((Object)"127.0.0.1", (Object)config.advertisedHostName());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"127.0.0.1"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"127.0.0.2"), (Object)BoxesRunTime.boxToInteger((int)3))})), (Object)config.maxConnectionsPerIpOverrides());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/tmp1", "/tmp2"})), (Object)config.logDirs());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)43200000L), (Object)config.logRollTimeMillis());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)39600000L), (Object)config.logRollTimeJitterMillis());
        Assert.assertEquals((long)36000000L, (long)config.logRetentionTimeMillis());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)123L), (Object)config.logFlushIntervalMs());
        Assert.assertEquals((Object)SnappyCompressionCodec$.MODULE$, (Object)config.offsetsTopicCompressionCodec());
    }

    public void kafka$server$KafkaConfigTest$$assertPropertyInvalid(Function0<Properties> validRequiredProps, String name, Seq<Object> values) {
        values.foreach((Function1)new Serializable(this, validRequiredProps, name){
            public static final long serialVersionUID = 0L;
            private final Function0 validRequiredProps$1;
            private final String name$1;

            public final Exception apply(Object value) {
                Properties props = (Properties)this.validRequiredProps$1.apply();
                props.setProperty(this.name$1, value.toString());
                return (Exception)Assertions$.MODULE$.intercept((Function0)new Serializable(this, props){
                    public static final long serialVersionUID = 0L;
                    private final Properties props$5;

                    public final KafkaConfig apply() {
                        return KafkaConfig$.MODULE$.fromProps(this.props$5);
                    }
                    {
                        this.props$5 = props$5;
                    }
                }, ManifestFactory$.MODULE$.classType(Exception.class));
            }
            {
                this.validRequiredProps$1 = validRequiredProps$1;
                this.name$1 = name$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final Properties kafka$server$KafkaConfigTest$$getBaseProperties$1() {
        void var1_1;
        Properties validRequiredProperties = new Properties();
        validRequiredProperties.put(KafkaConfig$.MODULE$.ZkConnectProp(), "127.0.0.1:2181");
        return var1_1;
    }
}

