/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import kafka.consumer.ConsumerConfig;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkPath$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.config.ConfigException;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001q3A!\u0001\u0002\u0001\u000f\tQ!l\u0013)bi\"$Vm\u001d;\u000b\u0005\r!\u0011A\u0001>l\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!\u0011\u0002CA\u0005\u0011\u001b\u0005Q!BA\u0006\r\u0003\u0015QWO\\5u\u0015\tia\"A\u0005tG\u0006d\u0017\r^3ti*\tq\"A\u0002pe\u001eL!!\u0005\u0006\u0003\u0015)+f.\u001b;Tk&$X\r\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgNDQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005M\u0001\u0001bB\u000e\u0001\u0005\u0004%\t\u0001H\u0001\u0005a\u0006$\b.F\u0001\u001e!\tq2%D\u0001 \u0015\t\u0001\u0013%\u0001\u0003mC:<'\"\u0001\u0012\u0002\t)\fg/Y\u0005\u0003I}\u0011aa\u0015;sS:<\u0007B\u0002\u0014\u0001A\u0003%Q$A\u0003qCRD\u0007\u0005C\u0004)\u0001\t\u0007I\u0011A\u0015\u0002%i\\7+Z:tS>tG+[7f_V$Xj]\u000b\u0002UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t\u0019\u0011J\u001c;\t\rE\u0002\u0001\u0015!\u0003+\u0003MQ8nU3tg&|g\u000eV5nK>,H/T:!\u0011\u0015\u0019\u0004\u0001\"\u00015\u0003aQ8nQ8o]\u0016\u001cGoV5uQ&sg/\u00197jIJ{w\u000e^\u000b\u0002kA\u0011a'\u000f\b\u0003W]J!\u0001\u000f\u0017\u0002\rA\u0013X\rZ3g\u0013\t!#H\u0003\u00029Y!)A\b\u0001C\u0001{\u00059C/Z:u\u0007J,\u0017\r^3QKJ\u001c\u0018n\u001d;f]R\u0004\u0016\r\u001e5UQJ|wo]#yG\u0016\u0004H/[8o+\u0005q\u0004CA\u0016@\u0013\t\u0001EF\u0001\u0003V]&$\bFA\u001eC!\t\u0019U)D\u0001E\u0015\tYa\"\u0003\u0002G\t\n!A+Z:u\u0011\u0015A\u0005\u0001\"\u0001>\u0003a!Xm\u001d;De\u0016\fG/\u001a)feNL7\u000f^3oiB\u000bG\u000f\u001b\u0015\u0003\u000f\nCQa\u0013\u0001\u0005\u0002u\nQ\u0006^3ti6\u000b7.Z*ve\u0016\u0004VM]:jgR\u001c\b+\u0019;i\u000bbL7\u000f^:UQJ|wo]#yG\u0016\u0004H/[8oQ\tQ%\tC\u0003O\u0001\u0011\u0005Q(\u0001\u0010uKN$X*Y6f'V\u0014X\rU3sg&\u001cHo\u001d)bi\",\u00050[:ug\"\u0012QJ\u0011\u0005\u0006#\u0002!\t!P\u0001'i\u0016\u001cHo\u0011:fCR,W\t\u001d5f[\u0016\u0014\u0018\r\u001c)bi\"$\u0006N]8xg\u0016C8-\u001a9uS>t\u0007F\u0001)C\u0011\u0015!\u0006\u0001\"\u0001>\u0003u!Xm\u001d;De\u0016\fG/Z#qQ\u0016lWM]1m!\u0006$\b.\u0012=jgR\u001c\bFA*C\u0011\u00159\u0006\u0001\"\u0001>\u00035\"Xm\u001d;De\u0016\fG/\u001a)feNL7\u000f^3oiN+\u0017/^3oi&\fG\u000e\u00165s_^\u001cX\t_2faRLwN\u001c\u0015\u0003-\nCQA\u0017\u0001\u0005\u0002u\nA\u0005^3ti\u000e\u0013X-\u0019;f!\u0016\u00148/[:uK:$8+Z9vK:$\u0018.\u00197Fq&\u001cHo\u001d\u0015\u00033\n\u0003")
public class ZKPathTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final String path;
    private final int zkSessionTimeoutMs;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ZKPathTest zKPathTest = this;
        synchronized (zKPathTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public String path() {
        return this.path;
    }

    public int zkSessionTimeoutMs() {
        return this.zkSessionTimeoutMs;
    }

    public String zkConnectWithInvalidRoot() {
        return new StringBuilder().append((Object)this.zkConnect()).append((Object)"/ghost").toString();
    }

    @Test
    public void testCreatePersistentPathThrowsException() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnectWithInvalidRoot(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnectWithInvalidRoot(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        try {
            ZkPath$.MODULE$.resetNamespaceCheckedState();
            zkUtils.createPersistentPath(this.path(), zkUtils.createPersistentPath$default$2(), zkUtils.createPersistentPath$default$3());
            throw this.fail("Failed to throw ConfigException for missing zookeeper root node");
        }
        catch (Throwable throwable) {
            throw this.fail("Should have thrown ConfigException");
        }
        catch (ConfigException configException) {
            zkUtils.close();
            return;
        }
    }

    @Test
    public void testCreatePersistentPath() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        try {
            ZkPath$.MODULE$.resetNamespaceCheckedState();
            zkUtils.createPersistentPath(this.path(), zkUtils.createPersistentPath$default$2(), zkUtils.createPersistentPath$default$3());
        }
        catch (Throwable throwable) {
            throw this.fail("Failed to create persistent path");
        }
        Assert.assertTrue((String)"Failed to create persistent path", (boolean)zkUtils.pathExists(this.path()));
        zkUtils.close();
    }

    @Test
    public void testMakeSurePersistsPathExistsThrowsException() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnectWithInvalidRoot(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnectWithInvalidRoot(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        try {
            ZkPath$.MODULE$.resetNamespaceCheckedState();
            zkUtils.makeSurePersistentPathExists(this.path(), zkUtils.makeSurePersistentPathExists$default$2());
            throw this.fail("Failed to throw ConfigException for missing zookeeper root node");
        }
        catch (Throwable throwable) {
            throw this.fail("Should have thrown ConfigException");
        }
        catch (ConfigException configException) {
            zkUtils.close();
            return;
        }
    }

    @Test
    public void testMakeSurePersistsPathExists() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        try {
            ZkPath$.MODULE$.resetNamespaceCheckedState();
            zkUtils.makeSurePersistentPathExists(this.path(), zkUtils.makeSurePersistentPathExists$default$2());
        }
        catch (Throwable throwable) {
            throw this.fail("Failed to create persistent path");
        }
        Assert.assertTrue((String)"Failed to create persistent path", (boolean)zkUtils.pathExists(this.path()));
        zkUtils.close();
    }

    @Test
    public void testCreateEphemeralPathThrowsException() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnectWithInvalidRoot(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnectWithInvalidRoot(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        try {
            ZkPath$.MODULE$.resetNamespaceCheckedState();
            zkUtils.createEphemeralPathExpectConflict(this.path(), "somedata", zkUtils.createEphemeralPathExpectConflict$default$3());
            throw this.fail("Failed to throw ConfigException for missing zookeeper root node");
        }
        catch (Throwable throwable) {
            throw this.fail("Should have thrown ConfigException");
        }
        catch (ConfigException configException) {
            zkUtils.close();
            return;
        }
    }

    @Test
    public void testCreateEphemeralPathExists() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        try {
            ZkPath$.MODULE$.resetNamespaceCheckedState();
            zkUtils.createEphemeralPathExpectConflict(this.path(), "somedata", zkUtils.createEphemeralPathExpectConflict$default$3());
        }
        catch (Throwable throwable) {
            throw this.fail("Failed to create ephemeral path");
        }
        Assert.assertTrue((String)"Failed to create ephemeral path", (boolean)zkUtils.pathExists(this.path()));
        zkUtils.close();
    }

    @Test
    public void testCreatePersistentSequentialThrowsException() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnectWithInvalidRoot(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnectWithInvalidRoot(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        try {
            ZkPath$.MODULE$.resetNamespaceCheckedState();
            zkUtils.createSequentialPersistentPath(this.path(), zkUtils.createSequentialPersistentPath$default$2(), zkUtils.createSequentialPersistentPath$default$3());
            throw this.fail("Failed to throw ConfigException for missing zookeeper root node");
        }
        catch (Throwable throwable) {
            throw this.fail("Should have thrown ConfigException");
        }
        catch (ConfigException configException) {
            zkUtils.close();
            return;
        }
    }

    @Test
    public void testCreatePersistentSequentialExists() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        String actualPath = "";
        try {
            ZkPath$.MODULE$.resetNamespaceCheckedState();
            actualPath = zkUtils.createSequentialPersistentPath(this.path(), zkUtils.createSequentialPersistentPath$default$2(), zkUtils.createSequentialPersistentPath$default$3());
        }
        catch (Throwable throwable) {
            throw this.fail("Failed to create persistent path");
        }
        Assert.assertTrue((String)"Failed to create persistent path", (boolean)zkUtils.pathExists(actualPath));
        zkUtils.close();
    }

    public ZKPathTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.path = "/some_dir";
        this.zkSessionTimeoutMs = 1000;
    }
}

