/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.common.LeaderElectionNotNeededException;
import kafka.common.NoReplicaOnlineException;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NoOpLeaderSelector;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderSelector;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine$DeleteTopicsListener$;
import kafka.controller.PartitionStateMachine$PartitionModificationsListener$;
import kafka.controller.PartitionStateMachine$TopicChangeListener$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ReplicationUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tmh\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tWM\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011\r\u0001!\u0011!Q\u0001\nU\u0001\"AF\f\u000e\u0003\tI!\u0001\u0007\u0002\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJDQA\u0007\u0001\u0005\u0002m\ta\u0001P5oSRtDC\u0001\u000f\u001e!\t1\u0002\u0001C\u0003\u00043\u0001\u0007Q\u0003C\u0004 \u0001\t\u0007I\u0011\u0002\u0011\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u0001\"!\t1\"%\u0003\u0002$\u0005\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\t\r\u0015\u0002\u0001\u0015!\u0003\"\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\t\u000f\u001d\u0002!\u0019!C\u0005Q\u0005a1m\u001c8ue>dG.\u001a:JIV\t\u0011\u0006\u0005\u0002\nU%\u00111F\u0003\u0002\u0004\u0013:$\bBB\u0017\u0001A\u0003%\u0011&A\u0007d_:$(o\u001c7mKJLE\r\t\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0003\u001dQ8.\u0016;jYN,\u0012!\r\t\u0003\u001fIJ!a\r\t\u0003\u000fi[W\u000b^5mg\"1Q\u0007\u0001Q\u0001\nE\n\u0001B_6Vi&d7\u000f\t\u0005\bo\u0001\u0011\r\u0011\"\u00039\u00039\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016,\u0012!\u000f\t\u0005u}\nu)D\u0001<\u0015\taT(A\u0004nkR\f'\r\\3\u000b\u0005yR\u0011AC2pY2,7\r^5p]&\u0011\u0001i\u000f\u0002\u0004\u001b\u0006\u0004\bC\u0001\"F\u001b\u0005\u0019%B\u0001#\u0005\u0003\u0019\u0019w.\\7p]&\u0011ai\u0011\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007C\u0001\fI\u0013\tI%A\u0001\bQCJ$\u0018\u000e^5p]N#\u0018\r^3\t\r-\u0003\u0001\u0015!\u0003:\u0003=\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u0004\u0003bB'\u0001\u0005\u0004%IAT\u0001\u0013EJ|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007.F\u0001P!\t1\u0002+\u0003\u0002R\u0005\ta2i\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007BB*\u0001A\u0003%q*A\nce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007\u0005C\u0004V\u0001\t\u0007I\u0011\u0002,\u0002\u0015!\f7o\u0015;beR,G-F\u0001X!\tA\u0016-D\u0001Z\u0015\tQ6,\u0001\u0004bi>l\u0017n\u0019\u0006\u00039v\u000b!bY8oGV\u0014(/\u001a8u\u0015\tqv,\u0001\u0003vi&d'\"\u00011\u0002\t)\fg/Y\u0005\u0003Ef\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007B\u00023\u0001A\u0003%q+A\u0006iCN\u001cF/\u0019:uK\u0012\u0004\u0003b\u00024\u0001\u0005\u0004%IaZ\u0001\u001c]>|\u0005\u000fU1si&$\u0018n\u001c8MK\u0006$WM]*fY\u0016\u001cGo\u001c:\u0016\u0003!\u0004\"AF5\n\u0005)\u0014!A\u0005(p\u001fBdU-\u00193feN+G.Z2u_JDa\u0001\u001c\u0001!\u0002\u0013A\u0017\u0001\b8p\u001fB\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u00148+\u001a7fGR|'\u000f\t\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0003M!x\u000e]5d\u0007\"\fgnZ3MSN$XM\\3s+\u0005\u0001\bCA9s\u001b\u0005\u0001a\u0001B:\u0001\u0001Q\u00141\u0003V8qS\u000e\u001c\u0005.\u00198hK2K7\u000f^3oKJ\u001cBA];|\u001dA\u0011a/_\u0007\u0002o*\u0011\u0001pX\u0001\u0005Y\u0006tw-\u0003\u0002{o\n1qJ\u00196fGR\u00042\u0001`A\u0004\u001b\u0005i(B\u0001@\u0000\u0003!Q8n\u00197jK:$(\u0002BA\u0001\u0003\u0007\ta!\u0013\u0019Ji\u0016\u001c'BAA\u0003\u0003\ry'oZ\u0005\u0004\u0003\u0013i(\u0001E%[W\u000eC\u0017\u000e\u001c3MSN$XM\\3s\u0011\u0019Q\"\u000f\"\u0001\u0002\u000eQ\t\u0001\u000fC\u0004\u0002\u0012I$\t!a\u0005\u0002#!\fg\u000e\u001a7f\u0007\"LG\u000eZ\"iC:<W\r\u0006\u0004\u0002\u0016\u0005m\u0011Q\u0006\t\u0004\u0013\u0005]\u0011bAA\r\u0015\t!QK\\5u\u0011!\ti\"a\u0004A\u0002\u0005}\u0011A\u00039be\u0016tG\u000fU1uQB!\u0011\u0011EA\u0014\u001d\rI\u00111E\u0005\u0004\u0003KQ\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002*\u0005-\"AB*ue&twMC\u0002\u0002&)A\u0001\"a\f\u0002\u0010\u0001\u0007\u0011\u0011G\u0001\tG\"LG\u000e\u001a:f]B1\u00111GA\u001b\u0003?i\u0011!X\u0005\u0004\u0003oi&\u0001\u0002'jgRDc!a\u0004\u0002<\u0005}\u0003#B\u0005\u0002>\u0005\u0005\u0013bAA \u0015\t1A\u000f\u001b:poN\u0004B!a\u0011\u0002F1\u0001AaBA$\u0001\t\u0007\u0011\u0011\n\u0002\u0002)F!\u00111JA)!\rI\u0011QJ\u0005\u0004\u0003\u001fR!a\u0002(pi\"Lgn\u001a\t\u0005\u0003'\nIFD\u0002\n\u0003+J1!a\u0016\u000b\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0017\u0002^\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003/R1EAA1!\u0011\t\u0019'a\u001c\u000f\t\u0005\u0015\u0014Q\u000b\b\u0005\u0003O\ni'\u0004\u0002\u0002j)\u0019\u00111\u000e\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011\u0002BA9\u0003;\u0012\u0011\"\u0012=dKB$\u0018n\u001c8\t\u000f\u0005U\u0004\u0001)A\u0005a\u0006!Bo\u001c9jG\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8fe\u0002B\u0011\"!\u001f\u0001\u0005\u0004%I!a\u001f\u0002)\u0011,G.\u001a;f)>\u0004\u0018nY:MSN$XM\\3s+\t\ti\bE\u0002r\u0003\u007f2a!!!\u0001\u0001\u0005\r%\u0001\u0006#fY\u0016$X\rV8qS\u000e\u001cH*[:uK:,'oE\u0003\u0002\u0000U\\h\u0002C\u0004\u001b\u0003\u007f\"\t!a\"\u0015\u0005\u0005u\u0004\u0002C\u0018\u0002\u0000\t\u0007I\u0011\u0001\u0019\t\u000fU\ny\b)A\u0005c!A\u0011\u0011CA@\t\u0003\ty\t\u0006\u0004\u0002\u0016\u0005E\u00151\u0013\u0005\t\u0003;\ti\t1\u0001\u0002 !A\u0011qFAG\u0001\u0004\t\t\u0004\u000b\u0004\u0002\u000e\u0006]\u0015q\f\t\u0006\u0013\u0005u\u0012\u0011\u0014\t\u0005\u0003\u0007\nY\nB\u0004\u0002H\u0001\u0011\r!!\u0013\t\u0011\u0005}\u0015q\u0010C\u0001\u0003C\u000b\u0011\u0003[1oI2,G)\u0019;b\t\u0016dW\r^3e)\u0011\t)\"a)\t\u0011\u0005\u0015\u0016Q\u0014a\u0001\u0003?\t\u0001\u0002Z1uCB\u000bG\u000f\u001b\u0015\u0007\u0003;\u000bI+a\u0018\u0011\u000b%\ti$a+\u0011\t\u0005\r\u0013Q\u0016\u0003\b\u0003\u000f\u0002!\u0019AA%\u0011!\t\t\f\u0001Q\u0001\n\u0005u\u0014!\u00063fY\u0016$X\rV8qS\u000e\u001cH*[:uK:,'\u000f\t\u0005\n\u0003k\u0003!\u0019!C\u0005\u0003o\u000bq\u0004]1si&$\u0018n\u001c8N_\u0012Lg-[2bi&|gn\u001d'jgR,g.\u001a:t+\t\tI\f\u0005\u0004;\u007f\u0005}\u00111\u0018\t\u0004c\u0006ufABA`\u0001\u0001\t\tM\u0001\u0010QCJ$\u0018\u000e^5p]6{G-\u001b4jG\u0006$\u0018n\u001c8t\u0019&\u001cH/\u001a8feN1\u0011QX;\u0002D:\u00012\u0001`Ac\u0013\r\t9- \u0002\u0010\u0013j[G)\u0019;b\u0019&\u001cH/\u001a8fe\"Y\u00111ZA_\u0005\u0003\u0005\u000b\u0011BA\u0010\u0003\u0015!x\u000e]5d\u0011\u001dQ\u0012Q\u0018C\u0001\u0003\u001f$B!a/\u0002R\"A\u00111ZAg\u0001\u0004\ty\u0002\u0003\u0005\u0002V\u0006uF\u0011AAl\u0003AA\u0017M\u001c3mK\u0012\u000bG/Y\"iC:<W\r\u0006\u0004\u0002\u0016\u0005e\u00171\u001c\u0005\t\u0003K\u000b\u0019\u000e1\u0001\u0002 !9\u0011Q\\Aj\u0001\u0004)\u0018\u0001\u00023bi\u0006Dc!a5\u0002b\u0006}\u0003#B\u0005\u0002>\u0005\r\b\u0003BA\"\u0003K$q!a\u0012\u0001\u0005\u0004\tI\u0005\u0003\u0005\u0002 \u0006uF\u0011AAu)\u0011\t)\"a;\t\u0011\u0005u\u0011q\u001da\u0001\u0003?Ac!a:\u0002p\u0006}\u0003#B\u0005\u0002>\u0005E\b\u0003BA\"\u0003g$q!a\u0012\u0001\u0005\u0004\tI\u0005\u0003\u0005\u0002x\u0002\u0001\u000b\u0011BA]\u0003\u0001\u0002\u0018M\u001d;ji&|g.T8eS\u001aL7-\u0019;j_:\u001cH*[:uK:,'o\u001d\u0011\t\u0013\u0005m\bA1A\u0005\n\u0005u\u0018!E:uCR,7\t[1oO\u0016dunZ4feV\u0011\u0011q \t\u0005\u0005\u0003\u00119AD\u0002\u0017\u0005\u0007I1A!\u0002\u0003\u0003=Y\u0015MZ6b\u0007>tGO]8mY\u0016\u0014\u0018\u0002\u0002B\u0005\u0005\u0017\u0011\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0015\r\u0011)A\u0001\u0005\t\u0005\u001f\u0001\u0001\u0015!\u0003\u0002\u0000\u0006\u00112\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:!\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u0005+\tqa\u001d;beR,\b\u000f\u0006\u0002\u0002\u0016!9!\u0011\u0004\u0001\u0005\u0002\tU\u0011!\u0005:fO&\u001cH/\u001a:MSN$XM\\3sg\"9!Q\u0004\u0001\u0005\u0002\tU\u0011a\u00053fe\u0016<\u0017n\u001d;fe2K7\u000f^3oKJ\u001c\bb\u0002B\u0011\u0001\u0011\u0005!QC\u0001\tg\",H\u000fZ8x]\"9!Q\u0005\u0001\u0005\u0002\tU\u0011!\t;sS\u001e<WM](oY&tW\rU1si&$\u0018n\u001c8Ti\u0006$Xm\u00115b]\u001e,\u0007b\u0002B\u0015\u0001\u0011\u0005!1F\u0001\u0012a\u0006\u0014H/\u001b;j_:\u001c\u0018J\\*uCR,G\u0003\u0002B\u0017\u0005k\u0001RAa\f\u00032\u0005k\u0011!P\u0005\u0004\u0005gi$aA*fi\"9!q\u0007B\u0014\u0001\u00049\u0015!B:uCR,\u0007b\u0002B\u001e\u0001\u0011\u0005!QH\u0001\u0013Q\u0006tG\r\\3Ti\u0006$Xm\u00115b]\u001e,7\u000f\u0006\u0006\u0002\u0016\t}\"1\tB$\u0005#B\u0001B!\u0011\u0003:\u0001\u0007!QF\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bb\u0002B#\u0005s\u0001\raR\u0001\fi\u0006\u0014x-\u001a;Ti\u0006$X\r\u0003\u0006\u0003J\te\u0002\u0013!a\u0001\u0005\u0017\na\u0002\\3bI\u0016\u00148+\u001a7fGR|'\u000fE\u0002\u0017\u0005\u001bJ1Aa\u0014\u0003\u0005]\u0001\u0016M\u001d;ji&|g\u000eT3bI\u0016\u00148+\u001a7fGR|'\u000f\u0003\u0006\u0003T\te\u0002\u0013!a\u0001\u0005+\n\u0011bY1mY\n\f7m[:\u0011\u0007Y\u00119&C\u0002\u0003Z\t\u0011\u0011bQ1mY\n\f7m[:\t\u000f\tu\u0003\u0001\"\u0003\u0003`\u0005\t\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3\u0015\u0019\u0005U!\u0011\rB2\u0005O\u0012IGa\u001b\t\u0011\u0005-'1\fa\u0001\u0003?AqA!\u001a\u0003\\\u0001\u0007\u0011&A\u0005qCJ$\u0018\u000e^5p]\"9!Q\tB.\u0001\u00049\u0005\u0002\u0003B%\u00057\u0002\rAa\u0013\t\u0011\tM#1\fa\u0001\u0005+BqAa\u001c\u0001\t\u0013\u0011)\"\u0001\rj]&$\u0018.\u00197ju\u0016\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016DqAa\u001d\u0001\t\u0013\u0011)(A\rbgN,'\u000f\u001e,bY&$\u0007K]3wS>,8o\u0015;bi\u0016\u001cH\u0003CA\u000b\u0005o\u0012YH!\"\t\u000f\te$\u0011\u000fa\u0001\u0003\u0006\tBo\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u0011\tu$\u0011\u000fa\u0001\u0005\u007f\n!B\u001a:p[N#\u0018\r^3t!\u0015\u0011yC!!H\u0013\r\u0011\u0019)\u0010\u0002\u0004'\u0016\f\bb\u0002B#\u0005c\u0002\ra\u0012\u0005\b\u0005\u0013\u0003A\u0011\u0002BF\u0003\tJg.\u001b;jC2L'0\u001a'fC\u0012,'/\u00118e\u0013N\u0014hi\u001c:QCJ$\u0018\u000e^5p]R!\u0011Q\u0003BG\u0011\u001d\u0011IHa\"A\u0002\u0005CqA!%\u0001\t\u0003\u0011\u0019*A\ffY\u0016\u001cG\u000fT3bI\u0016\u0014hi\u001c:QCJ$\u0018\u000e^5p]RA\u0011Q\u0003BK\u0005/\u0013I\n\u0003\u0005\u0002L\n=\u0005\u0019AA\u0010\u0011\u001d\u0011)Ga$A\u0002%B\u0001B!\u0013\u0003\u0010\u0002\u0007!1\n\u0005\b\u0005;\u0003A\u0011\u0002BP\u0003m\u0011XmZ5ti\u0016\u0014Hk\u001c9jG\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8feR\u0011!\u0011\u0015\t\u0007\u0003g\t)Da)\u0011\u0007Y\u0014)+C\u0002\u0002*]DqA!+\u0001\t\u0013\u0011)\"A\u000feKJ,w-[:uKJ$v\u000e]5d\u0007\"\fgnZ3MSN$XM\\3s\u0011\u001d\u0011i\u000b\u0001C\u0001\u0005_\u000bqD]3hSN$XM\u001d)beRLG/[8o\u0007\"\fgnZ3MSN$XM\\3s)\u0011\t)B!-\t\u0011\u0005-'1\u0016a\u0001\u0003?AqA!.\u0001\t\u0003\u00119,A\u0011eKJ,w-[:uKJ\u0004\u0016M\u001d;ji&|gn\u00115b]\u001e,G*[:uK:,'\u000f\u0006\u0003\u0003:\n}\u0006#B\u0005\u0003<\u0006m\u0016b\u0001B_\u0015\t1q\n\u001d;j_:D\u0001\"a3\u00034\u0002\u0007\u0011q\u0004\u0005\b\u0005\u0007\u0004A\u0011\u0002BP\u0003m\u0011XmZ5ti\u0016\u0014H)\u001a7fi\u0016$v\u000e]5d\u0019&\u001cH/\u001a8fe\"9!q\u0019\u0001\u0005\n\tU\u0011!\b3fe\u0016<\u0017n\u001d;fe\u0012+G.\u001a;f)>\u0004\u0018n\u0019'jgR,g.\u001a:\t\u000f\t-\u0007\u0001\"\u0003\u0003N\u0006!s-\u001a;MK\u0006$WM]%te\u0006sG-\u00129pG\"|%\u000f\u00165s_^,\u0005pY3qi&|g\u000e\u0006\u0004\u0003P\nU'q\u001b\t\u0004-\tE\u0017b\u0001Bj\u0005\tYB*Z1eKJL5O]!oI\u000e{g\u000e\u001e:pY2,'/\u00129pG\"D\u0001\"a3\u0003J\u0002\u0007\u0011q\u0004\u0005\b\u0005K\u0012I\r1\u0001*\u0011%\u0011Y\u000eAI\u0001\n\u0003\u0011i.\u0001\u000fiC:$G.Z*uCR,7\t[1oO\u0016\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t}'\u0006\u0002B&\u0005C\\#Aa9\u0011\t\t\u0015(q^\u0007\u0003\u0005OTAA!;\u0003l\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005[T\u0011AC1o]>$\u0018\r^5p]&!!\u0011\u001fBt\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005k\u0004\u0011\u0013!C\u0001\u0005o\fA\u0004[1oI2,7\u000b^1uK\u000eC\u0017M\\4fg\u0012\"WMZ1vYR$C'\u0006\u0002\u0003z*\"!Q\u000bBq\u0001")
public class PartitionStateMachine
implements Logging {
    public final KafkaController kafka$controller$PartitionStateMachine$$controller;
    private final ControllerContext kafka$controller$PartitionStateMachine$$controllerContext;
    private final int kafka$controller$PartitionStateMachine$$controllerId;
    private final ZkUtils kafka$controller$PartitionStateMachine$$zkUtils;
    private final Map<TopicAndPartition, PartitionState> kafka$controller$PartitionStateMachine$$partitionState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted;
    private final NoOpLeaderSelector noOpPartitionLeaderSelector;
    private final TopicChangeListener topicChangeListener;
    private final DeleteTopicsListener deleteTopicsListener;
    private final Map<String, PartitionModificationsListener> partitionModificationsListeners;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        PartitionStateMachine partitionStateMachine = this;
        synchronized (partitionStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ControllerContext kafka$controller$PartitionStateMachine$$controllerContext() {
        return this.kafka$controller$PartitionStateMachine$$controllerContext;
    }

    public int kafka$controller$PartitionStateMachine$$controllerId() {
        return this.kafka$controller$PartitionStateMachine$$controllerId;
    }

    public ZkUtils kafka$controller$PartitionStateMachine$$zkUtils() {
        return this.kafka$controller$PartitionStateMachine$$zkUtils;
    }

    public Map<TopicAndPartition, PartitionState> kafka$controller$PartitionStateMachine$$partitionState() {
        return this.kafka$controller$PartitionStateMachine$$partitionState;
    }

    private ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted() {
        return this.kafka$controller$PartitionStateMachine$$hasStarted;
    }

    private NoOpLeaderSelector noOpPartitionLeaderSelector() {
        return this.noOpPartitionLeaderSelector;
    }

    private TopicChangeListener topicChangeListener() {
        return this.topicChangeListener;
    }

    private DeleteTopicsListener deleteTopicsListener() {
        return this.deleteTopicsListener;
    }

    private Map<String, PartitionModificationsListener> partitionModificationsListeners() {
        return this.partitionModificationsListeners;
    }

    private KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializePartitionState();
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(true);
        this.triggerOnlinePartitionStateChange();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Started partition state machine with initial state -> ").append((Object)this.$outer.kafka$controller$PartitionStateMachine$$partitionState().toString()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void registerListeners() {
        this.registerTopicChangeListener();
        if (Predef$.MODULE$.Boolean2boolean(this.kafka$controller$PartitionStateMachine$$controller.config().deleteTopicEnable())) {
            this.registerDeleteTopicListener();
        }
    }

    public void deregisterListeners() {
        this.deregisterTopicChangeListener();
        this.partitionModificationsListeners().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final void apply(Tuple2<String, PartitionModificationsListener> x0$1) {
                Tuple2<String, PartitionModificationsListener> tuple2 = x0$1;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    PartitionModificationsListener listener = (PartitionModificationsListener)tuple2._2();
                    this.$outer.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().unsubscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), (IZkDataListener)listener);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.partitionModificationsListeners().clear();
        if (Predef$.MODULE$.Boolean2boolean(this.kafka$controller$PartitionStateMachine$$controller.config().deleteTopicEnable())) {
            this.deregisterDeleteTopicListener();
        }
    }

    public void shutdown() {
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(false);
        this.kafka$controller$PartitionStateMachine$$partitionState().clear();
        this.deregisterListeners();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped partition state machine";
            }
        });
    }

    public void triggerOnlinePartitionStateChange() {
        try {
            this.brokerRequestBatch().newBatch();
            this.kafka$controller$PartitionStateMachine$$partitionState().withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<TopicAndPartition, PartitionState> check$ifrefutable$1) {
                    Tuple2<TopicAndPartition, PartitionState> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;

                public final boolean apply(Tuple2<TopicAndPartition, PartitionState> x$1) {
                    Tuple2<TopicAndPartition, PartitionState> tuple2 = x$1;
                    if (tuple2 != null) {
                        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                        boolean bl = !this.$outer.kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().isTopicQueuedUpForDeletion(topicAndPartition.topic());
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;

                public final void apply(Tuple2<TopicAndPartition, PartitionState> x$2) {
                    Tuple2<TopicAndPartition, PartitionState> tuple2 = x$2;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                        PartitionState partitionState = (PartitionState)tuple2._2();
                        if (partitionState.equals(OfflinePartition$.MODULE$) || partitionState.equals(NewPartition$.MODULE$)) {
                            this.$outer.kafka$controller$PartitionStateMachine$$handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), OnlinePartition$.MODULE$, this.$outer.kafka$controller$PartitionStateMachine$$controller.offlinePartitionSelector(), new Callbacks.CallbackBuilder().build());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while moving some partitions to the online state";
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
        }
    }

    public Set<TopicAndPartition> partitionsInState(PartitionState state) {
        return ((MapLike)this.kafka$controller$PartitionStateMachine$$partitionState().filter((Function1)new Serializable(this, state){
            public static final long serialVersionUID = 0L;
            private final PartitionState state$1;

            public final boolean apply(Tuple2<TopicAndPartition, PartitionState> p) {
                Object object = p._2();
                PartitionState partitionState = this.state$1;
                return !(object != null ? !object.equals(partitionState) : partitionState != null);
            }
            {
                this.state$1 = state$1;
            }
        })).keySet();
    }

    public void handleStateChanges(Set<TopicAndPartition> partitions, PartitionState targetState, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        this.info((Function0<String>)new Serializable(this, partitions, targetState){
            public static final long serialVersionUID = 0L;
            private final Set partitions$1;
            private final PartitionState targetState$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Invoking state change to %s for partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1, this.partitions$1.mkString(",")}));
            }
            {
                this.partitions$1 = partitions$1;
                this.targetState$1 = targetState$1;
            }
        });
        try {
            this.brokerRequestBatch().newBatch();
            partitions.foreach((Function1)new Serializable(this, targetState, leaderSelector, callbacks){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;
                private final PartitionState targetState$1;
                private final PartitionLeaderSelector leaderSelector$1;
                private final Callbacks callbacks$1;

                public final void apply(TopicAndPartition topicAndPartition) {
                    this.$outer.kafka$controller$PartitionStateMachine$$handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), this.targetState$1, this.leaderSelector$1, this.callbacks$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.targetState$1 = targetState$1;
                    this.leaderSelector$1 = leaderSelector$1;
                    this.callbacks$1 = callbacks$1;
                }
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this, targetState){
                public static final long serialVersionUID = 0L;
                private final PartitionState targetState$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Error while moving some partitions to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                }
                {
                    this.targetState$1 = targetState$1;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void kafka$controller$PartitionStateMachine$$handleStateChange(String topic, int partition, PartitionState targetState, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        if (!this.kafka$controller$PartitionStateMachine$$hasStarted().get()) throw new StateChangeFailedException(new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s to %s failed because the partition state machine has not started")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, targetState})));
        PartitionState currState = (PartitionState)this.kafka$controller$PartitionStateMachine$$partitionState().getOrElseUpdate((Object)topicAndPartition, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NonExistentPartition$ apply() {
                return NonExistentPartition$.MODULE$;
            }
        });
        try {
            PartitionState partitionState = targetState;
            NewPartition$ newPartition$ = NewPartition$.MODULE$;
            PartitionState partitionState2 = partitionState;
            if (!(newPartition$ != null ? !newPartition$.equals(partitionState2) : partitionState2 != null)) {
                this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonExistentPartition$[]{NonExistentPartition$.MODULE$})), NewPartition$.MODULE$);
                this.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicAndPartition, (Object)NewPartition$.MODULE$);
                String assignedReplicas = ((TraversableOnce)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition)).mkString(",");
                this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, topicAndPartition, currState, assignedReplicas){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ PartitionStateMachine $outer;
                    private final PartitionState targetState$2;
                    private final TopicAndPartition topicAndPartition$1;
                    private final PartitionState currState$1;
                    private final String assignedReplicas$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s with assigned replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2, this.assignedReplicas$1}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.targetState$2 = targetState$2;
                        this.topicAndPartition$1 = topicAndPartition$1;
                        this.currState$1 = currState$1;
                        this.assignedReplicas$1 = assignedReplicas$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
                PartitionState partitionState3 = partitionState;
                if (!(onlinePartition$ != null ? !onlinePartition$.equals(partitionState3) : partitionState3 != null)) {
                    this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$, OfflinePartition$.MODULE$})), OnlinePartition$.MODULE$);
                    PartitionState partitionState4 = (PartitionState)this.kafka$controller$PartitionStateMachine$$partitionState().apply((Object)topicAndPartition);
                    NewPartition$ newPartition$2 = NewPartition$.MODULE$;
                    PartitionState partitionState5 = partitionState4;
                    if (!(newPartition$2 != null ? !newPartition$2.equals(partitionState5) : partitionState5 != null)) {
                        this.initializeLeaderAndIsrForPartition(topicAndPartition);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                        PartitionState partitionState6 = partitionState4;
                        if (!(offlinePartition$ != null ? !offlinePartition$.equals(partitionState6) : partitionState6 != null)) {
                            this.electLeaderForPartition(topic, partition, leaderSelector);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            OnlinePartition$ onlinePartition$2 = OnlinePartition$.MODULE$;
                            PartitionState partitionState7 = partitionState4;
                            if (!(onlinePartition$2 != null ? !onlinePartition$2.equals(partitionState7) : partitionState7 != null)) {
                                this.electLeaderForPartition(topic, partition, leaderSelector);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                    }
                    this.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicAndPartition, (Object)OnlinePartition$.MODULE$);
                    int leader = ((LeaderIsrAndControllerEpoch)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().apply((Object)topicAndPartition)).leaderAndIsr().leader();
                    this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, topicAndPartition, currState, leader){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ PartitionStateMachine $outer;
                        private final PartitionState targetState$2;
                        private final TopicAndPartition topicAndPartition$1;
                        private final PartitionState currState$1;
                        private final int leader$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s from %s to %s with leader %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2, BoxesRunTime.boxToInteger((int)this.leader$1)}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.targetState$2 = targetState$2;
                            this.topicAndPartition$1 = topicAndPartition$1;
                            this.currState$1 = currState$1;
                            this.leader$1 = leader$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else {
                    OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                    PartitionState partitionState8 = partitionState;
                    if (!(offlinePartition$ != null ? !offlinePartition$.equals(partitionState8) : partitionState8 != null)) {
                        this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$, OfflinePartition$.MODULE$})), OfflinePartition$.MODULE$);
                        this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, topicAndPartition, currState){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ PartitionStateMachine $outer;
                            private final PartitionState targetState$2;
                            private final TopicAndPartition topicAndPartition$1;
                            private final PartitionState currState$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.targetState$2 = targetState$2;
                                this.topicAndPartition$1 = topicAndPartition$1;
                                this.currState$1 = currState$1;
                            }
                        });
                        this.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicAndPartition, (Object)OfflinePartition$.MODULE$);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    } else {
                        NonExistentPartition$ nonExistentPartition$ = NonExistentPartition$.MODULE$;
                        PartitionState partitionState9 = partitionState;
                        if (nonExistentPartition$ != null ? !nonExistentPartition$.equals(partitionState9) : partitionState9 != null) throw new MatchError((Object)partitionState);
                        this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OfflinePartition$[]{OfflinePartition$.MODULE$})), NonExistentPartition$.MODULE$);
                        this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, topicAndPartition, currState){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ PartitionStateMachine $outer;
                            private final PartitionState targetState$2;
                            private final TopicAndPartition topicAndPartition$1;
                            private final PartitionState currState$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.targetState$2 = targetState$2;
                                this.topicAndPartition$1 = topicAndPartition$1;
                                this.currState$1 = currState$1;
                            }
                        });
                        this.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicAndPartition, (Object)NonExistentPartition$.MODULE$);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            this.stateChangeLogger().error((Function0<String>)new Serializable(this, targetState, topicAndPartition, currState){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;
                private final PartitionState targetState$2;
                private final TopicAndPartition topicAndPartition$1;
                private final PartitionState currState$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s from %s to %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.targetState$2 = targetState$2;
                    this.topicAndPartition$1 = topicAndPartition$1;
                    this.currState$1 = currState$1;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = t$1;
                }
            });
        }
    }

    public PartitionLeaderSelector handleStateChanges$default$3() {
        return this.noOpPartitionLeaderSelector();
    }

    public Callbacks handleStateChanges$default$4() {
        return new Callbacks.CallbackBuilder().build();
    }

    private void initializePartitionState() {
        this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> check$ifrefutable$2) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final Option<PartitionState> apply(Tuple2<TopicAndPartition, Seq<Object>> x$3) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2;
                block2: {
                    Option option;
                    block8: {
                        Option option2;
                        block7: {
                            TopicAndPartition topicPartition;
                            block3: {
                                boolean bl;
                                block6: {
                                    Option option3;
                                    block5: {
                                        block4: {
                                            tuple2 = x$3;
                                            if (tuple2 == null) break block2;
                                            topicPartition = (TopicAndPartition)tuple2._1();
                                            option = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicPartition);
                                            if (!(option instanceof Some)) break block3;
                                            Some some = (Some)option;
                                            LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                            bl = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)currentLeaderIsrAndEpoch.leaderAndIsr().leader()));
                                            if (!bl) break block4;
                                            option3 = this.$outer.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicPartition, (Object)OnlinePartition$.MODULE$);
                                            break block5;
                                        }
                                        if (bl) break block6;
                                        option3 = this.$outer.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicPartition, (Object)OfflinePartition$.MODULE$);
                                    }
                                    option2 = option3;
                                    break block7;
                                }
                                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                            }
                            None$ none$ = None$.MODULE$;
                            Option option4 = option;
                            if (none$ != null ? !none$.equals(option4) : option4 != null) break block8;
                            option2 = this.$outer.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicPartition, (Object)NewPartition$.MODULE$);
                        }
                        Option option5 = option2;
                        return option5;
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private void assertValidPreviousStates(TopicAndPartition topicAndPartition, Seq<PartitionState> fromStates, PartitionState targetState) {
        if (fromStates.contains(this.kafka$controller$PartitionStateMachine$$partitionState().apply((Object)topicAndPartition))) {
            return;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Partition %s should be in the %s states before moving to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, fromStates.mkString(","), targetState}))).append((Object)new StringOps(Predef$.MODULE$.augmentString(". Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$controller$PartitionStateMachine$$partitionState().apply((Object)topicAndPartition)}))).toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeLeaderAndIsrForPartition(TopicAndPartition topicAndPartition) {
        Seq replicaAssignment = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
        Seq liveAssignedReplicas = (Seq)replicaAssignment.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final boolean apply(int r) {
                return this.apply$mcZI$sp(r);
            }

            public boolean apply$mcZI$sp(int r) {
                return this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)r));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        int n = liveAssignedReplicas.size();
        switch (n) {
            default: {
                this.debug((Function0<String>)new Serializable(this, topicAndPartition, liveAssignedReplicas){
                    public static final long serialVersionUID = 0L;
                    private final TopicAndPartition topicAndPartition$2;
                    private final Seq liveAssignedReplicas$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Live assigned replicas for partition %s are: [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$2, this.liveAssignedReplicas$1}));
                    }
                    {
                        this.topicAndPartition$2 = topicAndPartition$2;
                        this.liveAssignedReplicas$1 = liveAssignedReplicas$1;
                    }
                });
                int leader = BoxesRunTime.unboxToInt((Object)liveAssignedReplicas.head());
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(leader, (List<Object>)liveAssignedReplicas.toList()), this.kafka$controller$PartitionStateMachine$$controller.epoch());
                this.debug((Function0<String>)new Serializable(this, topicAndPartition, leaderIsrAndControllerEpoch){
                    public static final long serialVersionUID = 0L;
                    private final TopicAndPartition topicAndPartition$2;
                    private final LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Initializing leader and isr for partition %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$2, this.leaderIsrAndControllerEpoch$1}));
                    }
                    {
                        this.topicAndPartition$2 = topicAndPartition$2;
                        this.leaderIsrAndControllerEpoch$1 = leaderIsrAndControllerEpoch$1;
                    }
                });
                try {
                    this.kafka$controller$PartitionStateMachine$$zkUtils().createPersistentPath(ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topicAndPartition.topic(), topicAndPartition.partition()), this.kafka$controller$PartitionStateMachine$$zkUtils().leaderAndIsrZkData(leaderIsrAndControllerEpoch.leaderAndIsr(), this.kafka$controller$PartitionStateMachine$$controller.epoch()), this.kafka$controller$PartitionStateMachine$$zkUtils().createPersistentPath$default$3());
                    this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)topicAndPartition, (Object)leaderIsrAndControllerEpoch);
                    this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)liveAssignedReplicas, topicAndPartition.topic(), topicAndPartition.partition(), leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                    return;
                }
                catch (ZkNodeExistsException zkNodeExistsException) {
                    LeaderIsrAndControllerEpoch leaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkUtils(), topicAndPartition.topic(), topicAndPartition.partition()).get();
                    String failMsg2 = new StringOps(Predef$.MODULE$.augmentString("encountered error while changing partition %s's state from New to Online since LeaderAndIsr path already exists with value %s and controller epoch %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, leaderIsrAndEpoch.leaderAndIsr().toString(), BoxesRunTime.boxToInteger((int)leaderIsrAndEpoch.controllerEpoch())}));
                    this.stateChangeLogger().error((Function0<String>)new Serializable(this, failMsg2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ PartitionStateMachine $outer;
                        private final String failMsg$2;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)this.failMsg$2).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.failMsg$2 = failMsg$2;
                        }
                    });
                    throw new StateChangeFailedException(failMsg2);
                }
            }
            case 0: 
        }
        String failMsg = new StringOps(Predef$.MODULE$.augmentString("encountered error during state change of partition %s from New to Online, assigned replicas are [%s], live brokers are [%s]. No assigned replica is alive.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, replicaAssignment.mkString(","), this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds()}));
        this.stateChangeLogger().error((Function0<String>)new Serializable(this, failMsg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;
            private final String failMsg$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)this.failMsg$1).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.failMsg$1 = failMsg$1;
            }
        });
        throw new StateChangeFailedException(failMsg);
    }

    /*
     * WARNING - void declaration
     */
    public void electLeaderForPartition(String topic, int partition, PartitionLeaderSelector leaderSelector) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        this.stateChangeLogger().trace((Function0<String>)new Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;
            private final TopicAndPartition topicAndPartition$3;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d started leader election for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$3}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicAndPartition$3 = topicAndPartition$3;
            }
        });
        try {
            Seq replicasForThisPartition;
            ObjectRef newLeaderAndIsr;
            block6: {
                Tuple2<LeaderAndIsr, Seq<Object>> tuple2;
                block7: {
                    Tuple2<Object, Object> tuple22;
                    boolean zookeeperPathUpdateSucceeded = false;
                    newLeaderAndIsr = new ObjectRef(null);
                    replicasForThisPartition = (Seq)Seq$.MODULE$.empty();
                    while (true) {
                        void var10_6;
                        Tuple2.mcZI.sp sp2;
                        Tuple2 tuple23;
                        if (zookeeperPathUpdateSucceeded) break block6;
                        LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = this.getLeaderIsrAndEpochOrThrowException(topic, partition);
                        LeaderAndIsr currentLeaderAndIsr = currentLeaderIsrAndEpoch.leaderAndIsr();
                        int controllerEpoch = currentLeaderIsrAndEpoch.controllerEpoch();
                        if (controllerEpoch > this.kafka$controller$PartitionStateMachine$$controller.epoch()) {
                            String failMsg = new StringOps(Predef$.MODULE$.augmentString("aborted leader election for partition [%s,%d] since the LeaderAndIsr path was already written by another controller. This probably means that the current controller %d went through a soft failure and another controller was elected with epoch %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)controllerEpoch)}));
                            this.stateChangeLogger().error((Function0<String>)new Serializable(this, failMsg){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ PartitionStateMachine $outer;
                                private final String failMsg$3;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)this.failMsg$3).toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.failMsg$3 = failMsg$3;
                                }
                            });
                            throw new StateChangeFailedException(failMsg);
                        }
                        tuple2 = leaderSelector.selectLeader(topicAndPartition, currentLeaderAndIsr);
                        if (tuple2 == null) break block7;
                        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._1();
                        Seq replicas = (Seq)tuple2._2();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)leaderAndIsr, (Object)replicas);
                        LeaderAndIsr leaderAndIsr2 = (LeaderAndIsr)tuple24._1();
                        Seq replicas2 = (Seq)tuple24._2();
                        tuple22 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.kafka$controller$PartitionStateMachine$$zkUtils(), topic, partition, leaderAndIsr2, this.kafka$controller$PartitionStateMachine$$controller.epoch(), currentLeaderAndIsr.zkVersion());
                        if (tuple22 == null) break;
                        boolean updateSucceeded = tuple22._1$mcZ$sp();
                        int newVersion = tuple22._2$mcI$sp();
                        Tuple2.mcZI.sp sp3 = sp2 = new Tuple2.mcZI.sp(updateSucceeded, newVersion);
                        boolean updateSucceeded2 = sp3._1$mcZ$sp();
                        int newVersion2 = sp3._2$mcI$sp();
                        var10_6.elem = leaderAndIsr2;
                        ((LeaderAndIsr)var10_6.elem).zkVersion_$eq(newVersion2);
                        boolean bl = updateSucceeded2;
                        Seq seq = replicas2;
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple2);
            }
            LeaderIsrAndControllerEpoch newLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch((LeaderAndIsr)newLeaderAndIsr.elem, this.kafka$controller$PartitionStateMachine$$controller.epoch());
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)new TopicAndPartition(topic, partition), (Object)newLeaderIsrAndControllerEpoch);
            this.stateChangeLogger().trace((Function0<String>)new Serializable(this, topicAndPartition, newLeaderAndIsr){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;
                private final TopicAndPartition topicAndPartition$3;
                private final ObjectRef newLeaderAndIsr$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d elected leader %d for Offline partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)((LeaderAndIsr)this.newLeaderAndIsr$1.elem).leader()), this.topicAndPartition$3}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.topicAndPartition$3 = topicAndPartition$3;
                    this.newLeaderAndIsr$1 = newLeaderAndIsr$1;
                }
            });
            Seq replicas = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)new TopicAndPartition(topic, partition));
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)replicasForThisPartition, topic, partition, newLeaderIsrAndControllerEpoch, (Seq<Object>)replicas, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
        }
        catch (Throwable throwable) {
            String failMsg = new StringOps(Predef$.MODULE$.augmentString("encountered error while electing leader for partition %s due to: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, throwable.getMessage()}));
            this.stateChangeLogger().error((Function0<String>)new Serializable(this, failMsg){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;
                private final String failMsg$4;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)this.failMsg$4).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.failMsg$4 = failMsg$4;
                }
            });
            throw new StateChangeFailedException(failMsg, throwable);
        }
        catch (NoReplicaOnlineException noReplicaOnlineException) {
            throw noReplicaOnlineException;
        }
        catch (LeaderElectionNotNeededException leaderElectionNotNeededException) {
            // empty catch block
        }
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("After leader election, leader cache is updated to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<TopicAndPartition, LeaderIsrAndControllerEpoch> apply(Tuple2<TopicAndPartition, LeaderIsrAndControllerEpoch> l) {
                        return new Tuple2(l._1(), l._2());
                    }
                }, Map$.MODULE$.canBuildFrom())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private java.util.List<String> registerTopicChangeListener() {
        return this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerTopicsPath(), (IZkChildListener)this.topicChangeListener());
    }

    private void deregisterTopicChangeListener() {
        this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().unsubscribeChildChanges(ZkUtils$.MODULE$.BrokerTopicsPath(), (IZkChildListener)this.topicChangeListener());
    }

    public void registerPartitionChangeListener(String topic) {
        this.partitionModificationsListeners().put((Object)topic, (Object)new PartitionModificationsListener(this, topic));
        this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().subscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), (IZkDataListener)this.partitionModificationsListeners().apply((Object)topic));
    }

    public Option<PartitionModificationsListener> deregisterPartitionChangeListener(String topic) {
        this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().unsubscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), (IZkDataListener)this.partitionModificationsListeners().apply((Object)topic));
        return this.partitionModificationsListeners().remove((Object)topic);
    }

    private java.util.List<String> registerDeleteTopicListener() {
        return this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().subscribeChildChanges(ZkUtils$.MODULE$.DeleteTopicsPath(), (IZkChildListener)this.deleteTopicsListener());
    }

    private void deregisterDeleteTopicListener() {
        this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().unsubscribeChildChanges(ZkUtils$.MODULE$.DeleteTopicsPath(), (IZkChildListener)this.deleteTopicsListener());
    }

    /*
     * WARNING - void declaration
     */
    private LeaderIsrAndControllerEpoch getLeaderIsrAndEpochOrThrowException(String topic, int partition) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        Option<LeaderIsrAndControllerEpoch> option = ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkUtils(), topic, partition);
        if (option instanceof Some) {
            LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch;
            Some some = (Some)option;
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.x();
            return leaderIsrAndControllerEpoch;
        }
        None$ none$ = None$.MODULE$;
        Option<LeaderIsrAndControllerEpoch> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            void var3_3;
            String failMsg = new StringOps(Predef$.MODULE$.augmentString("LeaderAndIsr information doesn't exist for partition %s in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var3_3, this.kafka$controller$PartitionStateMachine$$partitionState().apply((Object)var3_3)}));
            throw new StateChangeFailedException(failMsg);
        }
        throw new MatchError(option);
    }

    public PartitionStateMachine(KafkaController controller) {
        this.kafka$controller$PartitionStateMachine$$controller = controller;
        Logging$class.$init$(this);
        this.kafka$controller$PartitionStateMachine$$controllerContext = controller.controllerContext();
        this.kafka$controller$PartitionStateMachine$$controllerId = controller.config().brokerId();
        this.kafka$controller$PartitionStateMachine$$zkUtils = this.kafka$controller$PartitionStateMachine$$controllerContext().zkUtils();
        this.kafka$controller$PartitionStateMachine$$partitionState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller);
        this.kafka$controller$PartitionStateMachine$$hasStarted = new AtomicBoolean(false);
        this.noOpPartitionLeaderSelector = new NoOpLeaderSelector(this.kafka$controller$PartitionStateMachine$$controllerContext());
        this.topicChangeListener = new TopicChangeListener();
        this.deleteTopicsListener = new DeleteTopicsListener();
        this.partitionModificationsListeners = Map$.MODULE$.empty();
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
        this.logIdent_$eq(new StringBuilder().append((Object)"[Partition state machine on Controller ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controllerId())).append((Object)"]: ").toString());
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class TopicChangeListener
    implements IZkChildListener,
    Logging {
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            TopicChangeListener topicChangeListener = this;
            synchronized (topicChangeListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        @Override
        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging$class.trace(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging$class.trace(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.trace(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging$class.swallowTrace(this, action);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging$class.debug(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging$class.debug(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.debug(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging$class.swallowDebug(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging$class.info(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging$class.info(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.info(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging$class.swallowInfo(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging$class.warn(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging$class.warn(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.warn(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging$class.swallowWarn(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging$class.swallow(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging$class.error(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging$class.error(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.error(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging$class.swallowError(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging$class.fatal(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging$class.fatal(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.fatal(this, msg, e);
        }

        public void handleChildChange(String parentPath, java.util.List<String> children) throws Exception {
            CoreUtils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), new Serializable(this, parentPath, children){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicChangeListener $outer;
                public final String parentPath$1;
                public final java.util.List children$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    if (this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$hasStarted().get()) {
                        try {
                            this.$outer.debug((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ TopicChangeListener$$anonfun$handleChildChange$1 $outer;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Topic change listener fired for path %s with children %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.parentPath$1, JavaConversions$.MODULE$.asScalaBuffer(this.$outer.children$1).mkString(",")}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            scala.collection.immutable.Set currentChildren = JavaConversions$.MODULE$.asScalaBuffer(this.children$1).toSet();
                            scala.collection.immutable.Set newTopics = (scala.collection.immutable.Set)currentChildren.$minus$minus(this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics());
                            Set deletedTopics = (Set)this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics().$minus$minus((GenTraversableOnce)currentChildren);
                            this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics_$eq((Set<String>)currentChildren);
                            Map<TopicAndPartition, Seq<Object>> addedPartitionReplicaAssignment = this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$zkUtils().getReplicaAssignmentForTopics((Seq<String>)newTopics.toSeq());
                            this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment_$eq((Map<TopicAndPartition, Seq<Object>>)((Map)this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new Serializable(this, deletedTopics){
                                public static final long serialVersionUID = 0L;
                                private final Set deletedTopics$1;

                                public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                                    return !this.deletedTopics$1.contains((Object)((TopicAndPartition)p._1()).topic());
                                }
                                {
                                    this.deletedTopics$1 = deletedTopics$1;
                                }
                            })));
                            this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$plus$eq(addedPartitionReplicaAssignment);
                            this.$outer.info((Function0<String>)new Serializable(this, newTopics, deletedTopics, addedPartitionReplicaAssignment){
                                public static final long serialVersionUID = 0L;
                                private final scala.collection.immutable.Set newTopics$1;
                                private final Set deletedTopics$1;
                                private final Map addedPartitionReplicaAssignment$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("New topics: [%s], deleted topics: [%s], new partition replica assignment [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newTopics$1, this.deletedTopics$1, this.addedPartitionReplicaAssignment$1}));
                                }
                                {
                                    this.newTopics$1 = newTopics$1;
                                    this.deletedTopics$1 = deletedTopics$1;
                                    this.addedPartitionReplicaAssignment$1 = addedPartitionReplicaAssignment$1;
                                }
                            });
                            if (newTopics.size() > 0) {
                                this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controller.onNewTopicCreation((Set<String>)newTopics, (Set<TopicAndPartition>)addedPartitionReplicaAssignment.keySet().toSet());
                            }
                        }
                        catch (Throwable throwable) {
                            this.$outer.error((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Error while handling new topic";
                                }
                            }, (Function0<Throwable>)new Serializable(this, throwable){
                                public static final long serialVersionUID = 0L;
                                private final Throwable e$3;

                                public final Throwable apply() {
                                    return this.e$3;
                                }
                                {
                                    this.e$3 = e$3;
                                }
                            });
                        }
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.parentPath$1 = parentPath$1;
                    this.children$1 = children$1;
                }
            });
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer() {
            return PartitionStateMachine.this;
        }

        public TopicChangeListener() {
            if (PartitionStateMachine.this == null) {
                throw new NullPointerException();
            }
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[TopicChangeListener on Controller ").append((Object)BoxesRunTime.boxToInteger((int)PartitionStateMachine.this.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class DeleteTopicsListener
    implements IZkChildListener,
    Logging {
        private final ZkUtils zkUtils;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            DeleteTopicsListener deleteTopicsListener = this;
            synchronized (deleteTopicsListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        @Override
        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging$class.trace(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging$class.trace(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.trace(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging$class.swallowTrace(this, action);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging$class.debug(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging$class.debug(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.debug(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging$class.swallowDebug(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging$class.info(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging$class.info(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.info(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging$class.swallowInfo(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging$class.warn(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging$class.warn(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.warn(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging$class.swallowWarn(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging$class.swallow(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging$class.error(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging$class.error(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.error(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging$class.swallowError(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging$class.fatal(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging$class.fatal(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.fatal(this, msg, e);
        }

        public ZkUtils zkUtils() {
            return this.zkUtils;
        }

        public void handleChildChange(String parentPath, java.util.List<String> children) throws Exception {
            CoreUtils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), new Serializable(this, children){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DeleteTopicsListener $outer;
                private final java.util.List children$2;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    ObjectRef topicsToBeDeleted = new ObjectRef((Object)JavaConversions$.MODULE$.asScalaBuffer(this.children$2).toSet());
                    this.$outer.debug((Function0<String>)new Serializable(this, topicsToBeDeleted){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef topicsToBeDeleted$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Delete topics listener fired for topics %s to be deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((scala.collection.immutable.Set)this.topicsToBeDeleted$1.elem).mkString(",")}));
                        }
                        {
                            this.topicsToBeDeleted$1 = topicsToBeDeleted$1;
                        }
                    });
                    scala.collection.immutable.Set nonExistentTopics = (scala.collection.immutable.Set)((scala.collection.immutable.Set)topicsToBeDeleted.elem).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DeleteTopicsListener$$anonfun$handleChildChange$2 $outer;

                        public final boolean apply(String t) {
                            return !this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics().contains((Object)t);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    if (nonExistentTopics.size() > 0) {
                        this.$outer.warn((Function0<String>)new Serializable(this, nonExistentTopics){
                            public static final long serialVersionUID = 0L;
                            private final scala.collection.immutable.Set nonExistentTopics$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Ignoring request to delete non-existing topics ").append((Object)this.nonExistentTopics$1.mkString(",")).toString();
                            }
                            {
                                this.nonExistentTopics$1 = nonExistentTopics$1;
                            }
                        });
                        nonExistentTopics.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ DeleteTopicsListener$$anonfun$handleChildChange$2 $outer;

                            public final void apply(String topic) {
                                this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().zkUtils().deletePathRecursive(ZkUtils$.MODULE$.getDeleteTopicPath(topic));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    topicsToBeDeleted.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)topicsToBeDeleted.elem).$minus$minus((GenTraversableOnce)nonExistentTopics);
                    if (((scala.collection.immutable.Set)topicsToBeDeleted.elem).size() > 0) {
                        this.$outer.info((Function0<String>)new Serializable(this, topicsToBeDeleted){
                            public static final long serialVersionUID = 0L;
                            private final ObjectRef topicsToBeDeleted$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Starting topic deletion for topics ").append((Object)((scala.collection.immutable.Set)this.topicsToBeDeleted$1.elem).mkString(",")).toString();
                            }
                            {
                                this.topicsToBeDeleted$1 = topicsToBeDeleted$1;
                            }
                        });
                        ((scala.collection.immutable.Set)topicsToBeDeleted.elem).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ DeleteTopicsListener$$anonfun$handleChildChange$2 $outer;

                            public final void apply(String topic) {
                                boolean preferredReplicaElectionInProgress = ((SetLike)this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionsUndergoingPreferredReplicaElection().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(TopicAndPartition x$6) {
                                        return x$6.topic();
                                    }
                                }, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).contains((Object)topic);
                                boolean partitionReassignmentInProgress = ((SetLike)this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionsBeingReassigned().keySet().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(TopicAndPartition x$7) {
                                        return x$7.topic();
                                    }
                                }, Set$.MODULE$.canBuildFrom())).contains((Object)topic);
                                if (preferredReplicaElectionInProgress || partitionReassignmentInProgress) {
                                    this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().enqueueTopicsForDeletion((Set<String>)((scala.collection.immutable.Set)topicsToBeDeleted.elem));
                    }
                }

                public /* synthetic */ DeleteTopicsListener kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.children$2 = children$2;
                }
            });
        }

        public void handleDataDeleted(String dataPath) throws Exception {
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer() {
            return PartitionStateMachine.this;
        }

        public DeleteTopicsListener() {
            if (PartitionStateMachine.this == null) {
                throw new NullPointerException();
            }
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[DeleteTopicsListener on ").append((Object)BoxesRunTime.boxToInteger((int)PartitionStateMachine.this.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
            this.zkUtils = PartitionStateMachine.this.kafka$controller$PartitionStateMachine$$controllerContext().zkUtils();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class PartitionModificationsListener
    implements IZkDataListener,
    Logging {
        public final String kafka$controller$PartitionStateMachine$PartitionModificationsListener$$topic;
        public final /* synthetic */ PartitionStateMachine $outer;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            PartitionModificationsListener partitionModificationsListener = this;
            synchronized (partitionModificationsListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        @Override
        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging$class.trace(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging$class.trace(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.trace(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging$class.swallowTrace(this, action);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging$class.debug(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging$class.debug(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.debug(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging$class.swallowDebug(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging$class.info(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging$class.info(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.info(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging$class.swallowInfo(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging$class.warn(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging$class.warn(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.warn(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging$class.swallowWarn(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging$class.swallow(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging$class.error(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging$class.error(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.error(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging$class.swallowError(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging$class.fatal(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging$class.fatal(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.fatal(this, msg, e);
        }

        public void handleDataChange(String dataPath, Object data) throws Exception {
            CoreUtils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), new Serializable(this, dataPath, data){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionModificationsListener $outer;
                public final String dataPath$1;
                public final Object data$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    try {
                        this.$outer.info((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ PartitionModificationsListener$$anonfun$handleDataChange$1 $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition modification triggered ", " for path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.data$1, this.$outer.dataPath$1}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        Map<TopicAndPartition, Seq<Object>> partitionReplicaAssignment = this.$outer.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$$outer().kafka$controller$PartitionStateMachine$$zkUtils().getReplicaAssignmentForTopics((Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$topic})));
                        Map partitionsToBeAdded = (Map)partitionReplicaAssignment.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ PartitionModificationsListener$$anonfun$handleDataChange$1 $outer;

                            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                                return !this.$outer.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$PartitionModificationsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().contains(p._1());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        if (this.$outer.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().isTopicQueuedUpForDeletion(this.$outer.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$topic)) {
                            this.$outer.error((Function0<String>)new Serializable(this, partitionsToBeAdded){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ PartitionModificationsListener$$anonfun$handleDataChange$1 $outer;
                                private final Map partitionsToBeAdded$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Skipping adding partitions %s for topic %s since it is currently being deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.partitionsToBeAdded$1.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(Tuple2<TopicAndPartition, Seq<Object>> x$8) {
                                            return ((TopicAndPartition)x$8._1()).partition();
                                        }
                                    }, Iterable$.MODULE$.canBuildFrom())).mkString(","), this.$outer.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$PartitionModificationsListener$$topic}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.partitionsToBeAdded$1 = partitionsToBeAdded$1;
                                }
                            });
                        } else if (partitionsToBeAdded.size() > 0) {
                            this.$outer.info((Function0<String>)new Serializable(this, partitionsToBeAdded){
                                public static final long serialVersionUID = 0L;
                                private final Map partitionsToBeAdded$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("New partitions to be added %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionsToBeAdded$1}));
                                }
                                {
                                    this.partitionsToBeAdded$1 = partitionsToBeAdded$1;
                                }
                            });
                            this.$outer.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$plus$eq((TraversableOnce)partitionsToBeAdded);
                            this.$outer.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.onNewPartitionCreation((Set<TopicAndPartition>)partitionsToBeAdded.keySet().toSet());
                        }
                    }
                    catch (Throwable throwable) {
                        this.$outer.error((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ PartitionModificationsListener$$anonfun$handleDataChange$1 $outer;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Error while handling add partitions for data path ").append((Object)this.$outer.dataPath$1).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID = 0L;
                            private final Throwable e$4;

                            public final Throwable apply() {
                                return this.e$4;
                            }
                            {
                                this.e$4 = e$4;
                            }
                        });
                    }
                }

                public /* synthetic */ PartitionModificationsListener kafka$controller$PartitionStateMachine$PartitionModificationsListener$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.dataPath$1 = dataPath$1;
                    this.data$1 = data$1;
                }
            });
        }

        public void handleDataDeleted(String parentPath) throws Exception {
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$PartitionModificationsListener$$$outer() {
            return this.$outer;
        }

        public PartitionModificationsListener(PartitionStateMachine $outer, String topic) {
            this.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$topic = topic;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[AddPartitionsListener on ").append((Object)BoxesRunTime.boxToInteger((int)$outer.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }
}

