/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReplicationQuotaUtils$;
import kafka.common.AdminCommandFailedException;
import kafka.common.TopicAndPartition;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ParIterableLike;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0001\u0003\u0001\u001d\u0011QDU3bgNLwM\u001c)beRLG/[8og\u000ecWo\u001d;feR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0005\r\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u0011!BS+oSR\u001cV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0002{W&\u0011q\u0003\u0006\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005eaR\"\u0001\u000e\u000b\u0005m!\u0011!B;uS2\u001c\u0018BA\u000f\u001b\u0005\u001daunZ4j]\u001eDQa\b\u0001\u0005\u0002\u0001\na\u0001P5oSRtD#A\u0011\u0011\u0005\t\u0002Q\"\u0001\u0002\t\u000f\u0011\u0002!\u0019!C\u0001K\u0005Y\u0001/\u0019:uSRLwN\\%e+\u00051\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#aA%oi\"1Q\u0006\u0001Q\u0001\n\u0019\nA\u0002]1si&$\u0018n\u001c8JI\u0002Bqa\f\u0001A\u0002\u0013\u0005\u0001'A\u0004tKJ4XM]:\u0016\u0003E\u00022AM\u001b8\u001b\u0005\u0019$B\u0001\u001b)\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003mM\u00121aU3r!\tA4(D\u0001:\u0015\tQD!\u0001\u0004tKJ4XM]\u0005\u0003ye\u00121bS1gW\u0006\u001cVM\u001d<fe\"9a\b\u0001a\u0001\n\u0003y\u0014aC:feZ,'o]0%KF$\"\u0001Q\"\u0011\u0005\u001d\n\u0015B\u0001\")\u0005\u0011)f.\u001b;\t\u000f\u0011k\u0014\u0011!a\u0001c\u0005\u0019\u0001\u0010J\u0019\t\r\u0019\u0003\u0001\u0015)\u00032\u0003!\u0019XM\u001d<feN\u0004\u0003b\u0002%\u0001\u0005\u0004%\t!S\u0001\ni>\u0004\u0018n\u0019(b[\u0016,\u0012A\u0013\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bA\u0001\\1oO*\tq*\u0001\u0003kCZ\f\u0017BA)M\u0005\u0019\u0019FO]5oO\"11\u000b\u0001Q\u0001\n)\u000b!\u0002^8qS\u000et\u0015-\\3!\u0011\u0015)\u0006\u0001\"\u0011W\u0003\u0015\u0019X\r^+q)\u0005\u0001\u0005F\u0001+Y!\tI6,D\u0001[\u0015\tYa\"\u0003\u0002]5\n1!)\u001a4pe\u0016DQA\u0018\u0001\u0005\u0002}\u000bAb\u001d;beR\u0014%o\\6feN$\"\u0001\u00111\t\u000b\u0005l\u0006\u0019\u00012\u0002\u0013\t\u0014xn[3s\u0013\u0012\u001c\bc\u0001\u001a6M!)A\r\u0001C!-\u0006AA/Z1s\t><h\u000e\u000b\u0002dMB\u0011\u0011lZ\u0005\u0003Qj\u0013Q!\u00114uKJDQA\u001b\u0001\u0005\u0002-\f\u0011d\u001d5pk2$Wj\u001c<f'&tw\r\\3QCJ$\u0018\u000e^5p]V\t\u0001\t\u000b\u0002j[B\u0011\u0011L\\\u0005\u0003_j\u0013A\u0001V3ti\")\u0011\u000f\u0001C\u0001-\u0006\u00192\u000f[8vY\u0012,\u0005\u0010]1oI\u000ecWo\u001d;fe\"\u0012\u0001/\u001c\u0005\u0006i\u0002!\tAV\u0001\u0014g\"|W\u000f\u001c3TQJLgn[\"mkN$XM\u001d\u0015\u0003g6DQa\u001e\u0001\u0005\u0002Y\u000b!e\u001d5pk2$W\t_3dkR,G\u000b\u001b:piRdW\r\u001a*fCN\u001c\u0018n\u001a8nK:$\bF\u0001<n\u0011\u0015Q\b\u0001\"\u0001W\u0003\u0001\u001a\bn\\;mI>sG.\u001f+ie>$H\u000f\\3N_ZLgn\u001a*fa2L7-Y:)\u0005el\u0007\"B?\u0001\t\u00031\u0016\u0001L:i_VdGm\u00115b]\u001e,G\u000b\u001b:piRdWm\u00148SKJ,h.\u00118e%\u0016lwN^3P]Z+'/\u001b4zQ\taX\u000e\u0003\u0004\u0002\u0002\u0001!\tAV\u0001)g\"|W\u000f\u001c3GC&d\u0017J\u001a)s_B|7/\u001a3E_\u0016\u001chj\u001c;NCR\u001c\u0007.\u0012=jgRLgn\u001a\u0015\u0007\u007f6\f)!a\u0002\u0002\u0011\u0015D\b/Z2uK\u0012\u001c#!!\u0003\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004\u0005\u0003\u0019\u0019w.\\7p]&!\u00111CA\u0007\u0005m\tE-\\5o\u0007>lW.\u00198e\r\u0006LG.\u001a3Fq\u000e,\u0007\u000f^5p]\"1\u0011q\u0003\u0001\u0005\u0002Y\u000bQd^1ji\u001a{'OU3bgNLwM\\7f]R$vnQ8na2,G/\u001a\u0005\b\u00037\u0001A\u0011AA\u000f\u0003\u0011Q7o\u001c8\u0015\t\u0005}\u00111\u0006\t\u0005\u0003C\t9CD\u0002(\u0003GI1!!\n)\u0003\u0019\u0001&/\u001a3fM&\u0019\u0011+!\u000b\u000b\u0007\u0005\u0015\u0002\u0006\u0003\u0005\u0002.\u0005e\u0001\u0019AA\u0018\u0003\u0015!x\u000e]5d!\u00159\u0013\u0011GA\u0010\u0013\r\t\u0019\u0004\u000b\u0002\u000byI,\u0007/Z1uK\u0012t\u0004")
public class ReassignPartitionsClusterTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final int partitionId;
    private Seq<KafkaServer> servers;
    private final String topicName;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReassignPartitionsClusterTest reassignPartitionsClusterTest = this;
        synchronized (reassignPartitionsClusterTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public String topicName() {
        return this.topicName;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    public void startBrokers(Seq<Object> brokerIds) {
        this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)brokerIds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReassignPartitionsClusterTest $outer;

            public final Properties apply(int i) {
                return TestUtils$.MODULE$.createBrokerConfig(i, this.$outer.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties c) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(c), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @After
    public void tearDown() {
        ((ParIterableLike)this.servers().par()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$1) {
                x$1.shutdown();
            }
        });
        ((ParIterableLike)this.servers().par()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                CoreUtils$.MODULE$.delete(server.config().logDirs());
            }
        });
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void shouldMoveSinglePartition() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        int partition = 0;
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":0,\"replicas\":[101]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName()})), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$3());
        this.waitForReassignmentToComplete();
        Assert.assertEquals((Object)((MapLike)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).get((Object)this.topicName()).get()).apply((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101})));
    }

    @Test
    public void shouldExpandCluster() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.servers());
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkUtils(), (Seq)Predef$.MODULE$.wrapIntArray(brokers), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), ZkUtils$.MODULE$.formatAsReassignmentJson(newAssignment), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$3());
        this.waitForReassignmentToComplete();
        Map actual = (Map)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102})));
    }

    @Test
    public void shouldShrinkCluster() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 100})))}))), this.servers());
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkUtils(), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), ZkUtils$.MODULE$.formatAsReassignmentJson(newAssignment), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$3());
        this.waitForReassignmentToComplete();
        Map actual = (Map)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})));
    }

    @Test
    public void shouldExecuteThrottledReassignment() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.servers());
        long initialThrottle = 10000000L;
        int expectedDurationSecs = 5;
        int numMessages = 500;
        int msgSize = 100000;
        TestUtils$.MODULE$.produceMessages(this.servers(), this.topicName(), numMessages, 0, msgSize);
        Assert.assertEquals((long)expectedDurationSecs, (long)((long)(numMessages * msgSize) / initialThrottle));
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkUtils(), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        long start2 = System.currentTimeMillis();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), ZkUtils$.MODULE$.formatAsReassignmentJson(newAssignment), initialThrottle);
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(initialThrottle, this.servers(), this.topicName(), "0:100,0:101", "0:102");
        this.waitForReassignmentToComplete();
        long took = System.currentTimeMillis() - start2;
        Map actual = (Map)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected replication to be > ", " but was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)expectedDurationSecs * 0.9 * (double)1000)), BoxesRunTime.boxToLong((long)took)})), ((double)took > (double)expectedDurationSecs * 0.9 * (double)1000 ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected replication to be < ", " but was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(expectedDurationSecs * 2 * 1000)), BoxesRunTime.boxToLong((long)took)})), (took < (long)(expectedDurationSecs * 2 * 1000) ? 1 : 0) != 0);
    }

    @Test
    public void shouldOnlyThrottleMovingReplicas() {
        int[] brokers = new int[]{100, 101, 102, 103, 104, 105};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "topic1", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "topic2", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{104, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{104, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104})))}))), this.servers());
        long throttle = 1000000L;
        TestUtils$.MODULE$.produceMessages(this.servers(), "topic1", 100, 0, 100000);
        TestUtils$.MODULE$.produceMessages(this.servers(), "topic2", 100, 0, 100000);
        scala.collection.immutable.Map newAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic2", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic2", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104})))}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), ZkUtils$.MODULE$.formatAsReassignmentJson((Map)newAssignment), throttle);
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(throttle, this.servers(), "topic1", "1:100,1:101,0:100,0:101", "1:102,0:102");
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(throttle, this.servers(), "topic2", "1:104,1:105,0:104,0:105", "1:103,0:103");
    }

    @Test
    public void shouldChangeThrottleOnRerunAndRemoveOnVerify() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.servers());
        long initialThrottle = 1000000L;
        TestUtils$.MODULE$.produceMessages(this.servers(), this.topicName(), 200, 0, 100000);
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkUtils(), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), ZkUtils$.MODULE$.formatAsReassignmentJson(newAssignment), initialThrottle);
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(initialThrottle, this.servers(), this.topicName(), "0:100,0:101", "0:102");
        ReassignPartitionsCommand$.MODULE$.verifyAssignment(this.zkUtils(), ZkUtils$.MODULE$.formatAsReassignmentJson(newAssignment));
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(initialThrottle, this.servers(), this.topicName(), "0:100,0:101", "0:102");
        long newThrottle = initialThrottle * 1000L;
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), ZkUtils$.MODULE$.formatAsReassignmentJson(newAssignment), newThrottle);
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(newThrottle, this.servers(), this.topicName(), "0:100,0:101", "0:102");
        this.waitForReassignmentToComplete();
        ReassignPartitionsCommand$.MODULE$.verifyAssignment(this.zkUtils(), ZkUtils$.MODULE$.formatAsReassignmentJson(newAssignment));
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigRemovedFromZK(this.topicName(), this.servers());
        Map actual = (Map)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})));
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedDoesNotMatchExisting() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":1,\"replicas\":[101]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName()})), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$3());
    }

    public void waitForReassignmentToComplete() {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReassignPartitionsClusterTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkUtils().pathExists(ZkUtils$.MODULE$.ReassignPartitionsPath());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Znode ", " wasn't deleted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.ReassignPartitionsPath()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    public String json(Seq<String> topic) {
        String topicStr = ((TraversableOnce)topic.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String t) {
                return new StringBuilder().append((Object)"{\"topic\": \"").append((Object)t).append((Object)"\"}").toString();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"topics\": [", "],\"version\":1}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicStr}));
    }

    public ReassignPartitionsClusterTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.partitionId = 0;
        this.servers = null;
        this.topicName = "my-topic";
    }
}

