/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.common.LongRef;
import kafka.log.FileMessageSet;
import kafka.log.LogSegment;
import kafka.log.LogSegmentTest$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.NoCompressionCodec$;
import kafka.server.FetchDataInfo;
import kafka.utils.SystemTime$;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h'\u0016<W.\u001a8u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005A1/Z4nK:$8/F\u0001\u0017!\r9BDH\u0007\u00021)\u0011\u0011DG\u0001\b[V$\u0018M\u00197f\u0015\tY\"\"\u0001\u0006d_2dWm\u0019;j_:L!!\b\r\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003%}I!\u0001\t\u0002\u0003\u00151{wmU3h[\u0016tG\u000f\u0003\u0004#\u0001\u0001\u0006IAF\u0001\ng\u0016<W.\u001a8ug\u0002BQ\u0001\n\u0001\u0005\u0002\u0015\nQb\u0019:fCR,7+Z4nK:$Hc\u0001\u0010'W!)qe\ta\u0001Q\u00051qN\u001a4tKR\u0004\"!C\u0015\n\u0005)R!\u0001\u0002'p]\u001eDq\u0001L\u0012\u0011\u0002\u0003\u0007Q&\u0001\nj]\u0012,\u00070\u00138uKJ4\u0018\r\u001c\"zi\u0016\u001c\bCA\u0005/\u0013\ty#BA\u0002J]RDQ!\r\u0001\u0005\u0002I\n\u0001\"\\3tg\u0006<Wm\u001d\u000b\u0004geR\u0004C\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u0005\u0003\u001diWm]:bO\u0016L!\u0001O\u001b\u0003)\tKH/\u001a\"vM\u001a,'/T3tg\u0006<WmU3u\u0011\u00159\u0003\u00071\u0001)\u0011\u0015\t\u0004\u00071\u0001<!\rIAHP\u0005\u0003{)\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?!\ty$I\u0004\u0002\n\u0001&\u0011\u0011IC\u0001\u0007!J,G-\u001a4\n\u0005\r#%AB*ue&twM\u0003\u0002B\u0015!)a\t\u0001C\u0001\u000f\u0006AA/Z1sI><h\u000eF\u0001I!\tI\u0011*\u0003\u0002K\u0015\t!QK\\5uQ\t)E\n\u0005\u0002N%6\taJ\u0003\u0002P!\u0006)!.\u001e8ji*\t\u0011+A\u0002pe\u001eL!a\u0015(\u0003\u000b\u00053G/\u001a:\t\u000bU\u0003A\u0011A$\u0002-Q,7\u000f\u001e*fC\u0012|e.R7qif\u001cVmZ7f]RD#\u0001V,\u0011\u00055C\u0016BA-O\u0005\u0011!Vm\u001d;\t\u000bm\u0003A\u0011A$\u00023Q,7\u000f\u001e*fC\u0012\u0014UMZ8sK\u001aK'o\u001d;PM\u001a\u001cX\r\u001e\u0015\u00035^CQA\u0018\u0001\u0005\u0002\u001d\u000bQ\u0002^3ti6\u000b\u0007p\u00144gg\u0016$\bFA/X\u0011\u0015\t\u0007\u0001\"\u0001H\u0003E!Xm\u001d;SK\u0006$\u0017I\u001a;fe2\u000b7\u000f\u001e\u0015\u0003A^CQ\u0001\u001a\u0001\u0005\u0002\u001d\u000bq\u0002^3tiJ+\u0017\r\u001a$s_6<\u0015\r\u001d\u0015\u0003G^CQa\u001a\u0001\u0005\u0002\u001d\u000bA\u0002^3tiR\u0013XO\\2bi\u0016D#AZ,\t\u000b)\u0004A\u0011A$\u0002SQ,7\u000f\u001e*fY>\fG\rT1sO\u0016\u001cH\u000fV5nKN$\u0018-\u001c9BMR,'\u000f\u0016:v]\u000e\fG/[8oQ\tIw\u000bC\u0003n\u0001\u0011\u0005q)\u0001\tuKN$HK];oG\u0006$XMR;mY\"\u0012An\u0016\u0005\u0006a\u0002!\taR\u0001\u001ai\u0016\u001cHOR5oI>3gm]3u\u0005f$\u0016.\\3ti\u0006l\u0007\u000f\u000b\u0002p/\")1\u000f\u0001C\u0001\u000f\u0006IB/Z:u\u001d\u0016DHo\u00144gg\u0016$8)\u00197dk2\fG/[8oQ\t\u0011x\u000bC\u0003w\u0001\u0011\u0005q)\u0001\fuKN$8\t[1oO\u00164\u0015\u000e\\3Tk\u001a4\u0017\u000e_3tQ\t)x\u000bC\u0003z\u0001\u0011\u0005q)A\u000fuKN$(+Z2pm\u0016\u0014\u0018PR5yKN\u001cuN\u001d:vaRLe\u000eZ3yQ\tAx\u000bC\u0003}\u0001\u0011\u0005q)A\u0011uKN$(+Z2pm\u0016\u0014\u0018PR5yKN\u001cuN\u001d:vaR$\u0016.\\3J]\u0012,\u0007\u0010\u000b\u0002|/\")q\u0010\u0001C\u0001\u000f\u0006qB/Z:u%\u0016\u001cwN^3ss^KG\u000f[\"peJ,\b\u000f^'fgN\fw-\u001a\u0015\u0003}^Ca\u0001\n\u0001\u0005\u0002\u0005\u0015A#\u0003\u0010\u0002\b\u0005%\u00111CA\f\u0011\u00199\u00131\u0001a\u0001Q!A\u00111BA\u0002\u0001\u0004\ti!A\tgS2,\u0017\t\u001c:fC\u0012LX\t_5tiN\u00042!CA\b\u0013\r\t\tB\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\t)\"a\u0001A\u00025\nA\"\u001b8ji\u001aKG.Z*ju\u0016D\u0001\"!\u0007\u0002\u0004\u0001\u0007\u0011QB\u0001\faJ,\u0017\r\u001c7pG\u0006$X\r\u0003\u0004\u0002\u001e\u0001!\taR\u0001(i\u0016\u001cHo\u0011:fCR,w+\u001b;i\u0013:LGOR5mKNK'0Z!qa\u0016tG-T3tg\u0006<W\rK\u0002\u0002\u001c]Ca!a\t\u0001\t\u00039\u0015a\n;fgR\u001c%/Z1uK^KG\u000f[%oSR4\u0015\u000e\\3TSj,7\t\\3beNCW\u000f\u001e3po:D3!!\tX\u0011%\tI\u0003AI\u0001\n\u0003\tY#A\fde\u0016\fG/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0006\u0016\u0004[\u0005=2FAA\u0019!\u0011\t\u0019$!\u0010\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m\"\"\u0001\u0006b]:|G/\u0019;j_:LA!a\u0010\u00026\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class LogSegmentTest {
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);

    public ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    public LogSegment createSegment(long offset, int indexIntervalBytes) {
        File msFile = TestUtils$.MODULE$.tempFile();
        FileMessageSet ms = new FileMessageSet(msFile);
        File idxFile = TestUtils$.MODULE$.tempFile();
        File timeIdxFile = TestUtils$.MODULE$.tempFile();
        idxFile.delete();
        timeIdxFile.delete();
        OffsetIndex idx = new OffsetIndex(idxFile, offset, 1000);
        TimeIndex timeIdx = new TimeIndex(timeIdxFile, offset, 1500);
        LogSegment seg = new LogSegment(ms, idx, timeIdx, offset, indexIntervalBytes, 0L, (Time)SystemTime$.MODULE$);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public ByteBufferMessageSet messages(long offset, Seq<String> messages2) {
        return new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, new LongRef(offset), (Seq)messages2.map((Function1)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final long offset$1;

            public final Message apply(String s) {
                return new Message(s.getBytes(), this.offset$1 * 10L, Message$.MODULE$.MagicValue_V1());
            }
            {
                this.offset$1 = offset$1;
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    @After
    public void teardown() {
        this.segments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment seg) {
                seg.index().delete();
                return seg.log().delete();
            }
        });
    }

    @Test
    public void testReadOnEmptySegment() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        long x$3 = 40L;
        int x$4 = 300;
        None$ x$5 = None$.MODULE$;
        long x$6 = seg.read$default$4();
        boolean x$7 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$3, (Option)x$5, x$4, x$6, x$7);
        Assert.assertNull((String)"Read beyond the last offset in the segment should be null", (Object)read);
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        ByteBufferMessageSet ms = this.messages(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(50L, Message$.MODULE$.NoTimestamp(), -1L, ms);
        long x$8 = 41L;
        int x$9 = 300;
        None$ x$10 = None$.MODULE$;
        long x$11 = seg.read$default$4();
        boolean x$12 = seg.read$default$5();
        MessageSet read = seg.read(x$8, (Option)x$10, x$9, x$11, x$12).messageSet();
        Assert.assertEquals((Object)ms.toList(), (Object)read.toList());
    }

    @Test
    public void testMaxOffset() {
        int baseOffset = 50;
        LogSegment seg = this.createSegment(baseOffset, this.createSegment$default$2());
        ByteBufferMessageSet ms = this.messages(baseOffset, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "beautiful"}));
        seg.append((long)baseOffset, Message$.MODULE$.NoTimestamp(), -1L, ms);
        this.validate$1(50L, seg, ms);
        this.validate$1(51L, seg, ms);
        this.validate$1(52L, seg, ms);
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        ByteBufferMessageSet ms = this.messages(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, Message$.MODULE$.NoTimestamp(), -1L, ms);
        long x$18 = 52L;
        int x$19 = 200;
        None$ x$20 = None$.MODULE$;
        long x$21 = seg.read$default$4();
        boolean x$22 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$18, (Option)x$20, x$19, x$21, x$22);
        Assert.assertNull((String)"Read beyond the last offset in the segment should give null", (Object)read);
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        ByteBufferMessageSet ms = this.messages(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, Message$.MODULE$.NoTimestamp(), -1L, ms);
        ByteBufferMessageSet ms2 = this.messages(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(60L, Message$.MODULE$.NoTimestamp(), -1L, ms2);
        long x$23 = 55L;
        int x$24 = 200;
        None$ x$25 = None$.MODULE$;
        long x$26 = seg.read$default$4();
        boolean x$27 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$23, (Option)x$25, x$24, x$26, x$27);
        Assert.assertEquals((Object)ms2.toList(), (Object)read.messageSet().toList());
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        IntRef offset = new IntRef(40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)new Serializable(this, seg, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$2;
            private final IntRef offset$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ByteBufferMessageSet ms1 = this.$outer.messages(this.offset$3.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
                this.seg$2.append((long)this.offset$3.elem, Message$.MODULE$.NoTimestamp(), -1L, ms1);
                ByteBufferMessageSet ms2 = this.$outer.messages(this.offset$3.elem + 1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
                this.seg$2.append((long)(this.offset$3.elem + 1), Message$.MODULE$.NoTimestamp(), -1L, ms2);
                FetchDataInfo read = this.seg$2.read((long)this.offset$3.elem, (Option)None$.MODULE$, 10000, this.seg$2.read$default$4(), this.seg$2.read$default$5());
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MessageAndOffset[]{(MessageAndOffset)ms1.head(), (MessageAndOffset)ms2.head()})), (Object)read.messageSet().toList());
                this.seg$2.truncateTo((long)(this.offset$3.elem + 1));
                FetchDataInfo read2 = this.seg$2.read((long)this.offset$3.elem, (Option)None$.MODULE$, 10000, this.seg$2.read$default$4(), this.seg$2.read$default$5());
                Assert.assertEquals((long)1L, (long)read2.messageSet().size());
                Assert.assertEquals((Object)ms1.head(), (Object)read2.messageSet().head());
                ++this.offset$3.elem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.seg$2 = seg$2;
                this.offset$3 = offset$3;
            }
        });
    }

    @Test
    public void testReloadLargestTimestampAfterTruncation() {
        int numMessages = 30;
        LogSegment seg = this.createSegment(40L, 2 * this.messages(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})).sizeInBytes() - 1);
        IntRef offset = new IntRef(40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, seg, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$3;
            private final IntRef offset$4;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.seg$3.append((long)this.offset$4.elem, (long)this.offset$4.elem, (long)this.offset$4.elem, this.$outer.messages(this.offset$4.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
                ++this.offset$4.elem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.seg$3 = seg$3;
                this.offset$4 = offset$4;
            }
        });
        int expectedNumEntries = numMessages / 2 - 1;
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have ", " time indexes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedNumEntries)})), (long)expectedNumEntries, (long)seg.timeIndex().entries());
        seg.truncateTo(41L);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have 0 time indexes"})).s((Seq)Nil$.MODULE$), (long)0L, (long)seg.timeIndex().entries());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Largest timestamp should be 400"})).s((Seq)Nil$.MODULE$), (long)400L, (long)seg.largestTimestamp());
    }

    @Test
    public void testTruncateFull() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        seg.append(40L, Message$.MODULE$.NoTimestamp(), -1L, this.messages(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
        seg.truncateTo(0L);
        Assert.assertNull((String)"Segment should be empty.", (Object)seg.read(0L, (Option)None$.MODULE$, 1024, seg.read$default$4(), seg.read$default$5()));
        seg.append(40L, Message$.MODULE$.NoTimestamp(), -1L, this.messages(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testFindOffsetByTimestamp() {
        int messageSize = this.messages(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg00"})).s((Seq)Nil$.MODULE$)})).sizeInBytes();
        LogSegment seg = this.createSegment(40L, messageSize * 2 - 1);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(40), 50).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$4;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.seg$4.append((long)i, (long)(i * 10), (long)i, this.$outer.messages(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.seg$4 = seg$4;
            }
        });
        Assert.assertEquals((long)490L, (long)seg.largestTimestamp());
        Assert.assertEquals((long)42L, (long)((TimestampOffset)seg.findOffsetByTimestamp(420L).get()).offset());
        Assert.assertEquals((long)43L, (long)((TimestampOffset)seg.findOffsetByTimestamp(421L).get()).offset());
        Assert.assertEquals((long)43L, (long)((TimestampOffset)seg.findOffsetByTimestamp(430L).get()).offset());
        Assert.assertEquals((long)44L, (long)((TimestampOffset)seg.findOffsetByTimestamp(431L).get()).offset());
        Assert.assertEquals((Object)None$.MODULE$, (Object)seg.findOffsetByTimestamp(491L));
        Assert.assertEquals((long)41L, (long)((TimestampOffset)seg.findOffsetByTimestamp(401L).get()).offset());
        Assert.assertEquals((long)40L, (long)((TimestampOffset)seg.findOffsetByTimestamp(399L).get()).offset());
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        Assert.assertEquals((long)40L, (long)seg.nextOffset());
        seg.append(50L, Message$.MODULE$.NoTimestamp(), -1L, this.messages(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assert.assertEquals((long)53L, (long)seg.nextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        File logFile = seg.log().file();
        File indexFile = seg.index().file();
        seg.changeFileSuffixes("", ".deleted");
        Assert.assertEquals((Object)new StringBuilder().append((Object)logFile.getAbsolutePath()).append((Object)".deleted").toString(), (Object)seg.log().file().getAbsolutePath());
        Assert.assertEquals((Object)new StringBuilder().append((Object)indexFile.getAbsolutePath()).append((Object)".deleted").toString(), (Object)seg.index().file().getAbsolutePath());
        Assert.assertTrue((boolean)seg.log().file().exists());
        Assert.assertTrue((boolean)seg.index().file().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$5;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.seg$5.append((long)i, Message$.MODULE$.NoTimestamp(), -1L, this.$outer.messages(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.seg$5 = seg$5;
            }
        });
        File indexFile = seg.index().file();
        TestUtils$.MODULE$.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(65536);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final LogSegment seg$5;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)i, (long)((MessageAndOffset)this.seg$5.read((long)i, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(i + 1))), 1024, this.seg$5.read$default$4(), this.seg$5.read$default$5()).messageSet().head()).offset());
            }
            {
                this.seg$5 = seg$5;
            }
        });
    }

    @Test
    public void testRecoveryFixesCorruptTimeIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$6;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.seg$6.append((long)i, (long)(i * 10), (long)i, this.$outer.messages(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.seg$6 = seg$6;
            }
        });
        File timeIndexFile = seg.timeIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(timeIndexFile, 5L, (int)timeIndexFile.length());
        seg.recover(65536);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final LogSegment seg$6;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)i, (long)((TimestampOffset)this.seg$6.findOffsetByTimestamp((long)(i * 10)).get()).offset());
                if (i < 99) {
                    Assert.assertEquals((long)(i + 1), (long)((TimestampOffset)this.seg$6.findOffsetByTimestamp((long)(i * 10 + 1)).get()).offset());
                }
            }
            {
                this.seg$6 = seg$6;
            }
        });
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, messagesAppended){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final int messagesAppended$1;

            public final void apply(int iteration) {
                this.apply$mcVI$sp(iteration);
            }

            public void apply$mcVI$sp(int iteration) {
                LogSegment seg = this.$outer.createSegment(0L, this.$outer.createSegment$default$2());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.messagesAppended$1).foreach$mVc$sp((Function1)new Serializable(this, seg){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testRecoveryWithCorruptMessage$1 $outer;
                    private final LogSegment seg$7;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.seg$7.append((long)i, Message$.MODULE$.NoTimestamp(), -1L, this.$outer.kafka$log$LogSegmentTest$$anonfun$$$outer().messages(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.seg$7 = seg$7;
                    }
                });
                int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(this.messagesAppended$1);
                int position = ((OffsetPosition)seg.log().searchForOffsetWithSize((long)offsetToBeginCorruption, 0)._1()).position() + TestUtils$.MODULE$.random().nextInt(15);
                TestUtils$.MODULE$.writeNonsenseToFile(seg.log().file(), position, (int)seg.log().file().length() - position);
                seg.recover(65536);
                Assert.assertEquals((String)"Should have truncated off bad messages.", (Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), offsetToBeginCorruption).toList(), (Object)((TraversableOnce)seg.log().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(MessageAndOffset x$2) {
                        return x$2.offset();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toList());
                seg.delete();
            }

            public /* synthetic */ LogSegmentTest kafka$log$LogSegmentTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.messagesAppended$1 = messagesAppended$1;
            }
        });
    }

    public LogSegment createSegment(long offset, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogSegment seg = new LogSegment(tempDir, offset, 10, 1000, 0L, (Time)SystemTime$.MODULE$, fileAlreadyExists, initFileSize, preallocate);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public int createSegment$default$2() {
        return 10;
    }

    @Test
    public void testCreateWithInitFileSizeAppendMessage() {
        LogSegment seg = this.createSegment(40L, false, 0x20000000, true);
        ByteBufferMessageSet ms = this.messages(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, Message$.MODULE$.NoTimestamp(), -1L, ms);
        ByteBufferMessageSet ms2 = this.messages(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(60L, Message$.MODULE$.NoTimestamp(), -1L, ms2);
        long x$28 = 55L;
        int x$29 = 200;
        None$ x$30 = None$.MODULE$;
        long x$31 = seg.read$default$4();
        boolean x$32 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$28, (Option)x$30, x$29, x$31, x$32);
        Assert.assertEquals((Object)ms2.toList(), (Object)read.messageSet().toList());
    }

    @Test
    public void testCreateWithInitFileSizeClearShutdown() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogSegment seg = new LogSegment(tempDir, 40L, 10, 1000, 0L, (Time)SystemTime$.MODULE$, false, 0x20000000, true);
        ByteBufferMessageSet ms = this.messages(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, Message$.MODULE$.NoTimestamp(), -1L, ms);
        ByteBufferMessageSet ms2 = this.messages(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(60L, Message$.MODULE$.NoTimestamp(), -1L, ms2);
        long x$33 = 55L;
        int x$34 = 200;
        None$ x$35 = None$.MODULE$;
        long x$36 = seg.read$default$4();
        boolean x$37 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$33, (Option)x$35, x$34, x$36, x$37);
        Assert.assertEquals((Object)ms2.toList(), (Object)read.messageSet().toList());
        int oldSize = seg.log().sizeInBytes();
        long oldPosition = seg.log().channel().position();
        long oldFileSize = seg.log().file().length();
        Assert.assertEquals((long)0x20000000L, (long)oldFileSize);
        seg.close();
        Assert.assertEquals((long)oldSize, (long)seg.log().file().length());
        LogSegment segReopen = new LogSegment(tempDir, 40L, 10, 1000, 0L, (Time)SystemTime$.MODULE$, true, 0x20000000, true);
        this.segments().$plus$eq((Object)segReopen);
        long x$38 = 55L;
        int x$39 = 200;
        None$ x$40 = None$.MODULE$;
        long x$41 = segReopen.read$default$4();
        boolean x$42 = segReopen.read$default$5();
        FetchDataInfo readAgain = segReopen.read(x$38, (Option)x$40, x$39, x$41, x$42);
        Assert.assertEquals((Object)ms2.toList(), (Object)readAgain.messageSet().toList());
        int size2 = segReopen.log().sizeInBytes();
        long position = segReopen.log().channel().position();
        long fileSize = segReopen.log().file().length();
        Assert.assertEquals((long)oldPosition, (long)position);
        Assert.assertEquals((long)oldSize, (long)size2);
        Assert.assertEquals((long)size2, (long)fileSize);
    }

    private final void validate$1(long offset, LogSegment seg$1, ByteBufferMessageSet ms$1) {
        long x$13 = offset;
        int x$14 = 1024;
        Some x$15 = new Some((Object)BoxesRunTime.boxToLong((long)(offset + 1L)));
        long x$16 = seg$1.read$default$4();
        boolean x$17 = seg$1.read$default$5();
        Assert.assertEquals((Object)((TraversableOnce)ms$1.filter((Function1)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final long offset$2;

            public final boolean apply(MessageAndOffset x$1) {
                return x$1.offset() == this.offset$2;
            }
            {
                this.offset$2 = offset$2;
            }
        })).toList(), (Object)seg$1.read(x$13, (Option)x$15, x$14, x$16, x$17).messageSet().toList());
    }
}

