/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import kafka.admin.ConfigCommand$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaId$;
import kafka.server.QuotaType;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t%c\u0001B\u0001\u0003\u0001\u001d\u0011ac\u00117jK:$\u0018+^8uC6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%I!F\u0001\u0005i&lW-F\u0001\u0017!\t9\u0012%D\u0001\u0019\u0015\tI\"$A\u0003vi&d7O\u0003\u0002\u001c9\u000511m\\7n_:T!!B\u000f\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0005\u0003Ea\u0011\u0001\"T8dWRKW.\u001a\u0005\u0007I\u0001\u0001\u000b\u0011\u0002\f\u0002\u000bQLW.\u001a\u0011\t\u000f\u0019\u0002!\u0019!C\u0005O\u000511m\u001c8gS\u001e,\u0012\u0001\u000b\t\u0003%%J!A\u000b\u0002\u00031\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\"p]\u001aLw\r\u0003\u0004-\u0001\u0001\u0006I\u0001K\u0001\bG>tg-[4!\u0011\u001dq\u0003\u00011A\u0005\u0002=\nAB\\;n\u0007\u0006dGNY1dWN,\u0012\u0001\r\t\u0003\u0013EJ!A\r\u0006\u0003\u0007%sG\u000fC\u00045\u0001\u0001\u0007I\u0011A\u001b\u0002!9,XnQ1mY\n\f7m[:`I\u0015\fHC\u0001\u001c:!\tIq'\u0003\u00029\u0015\t!QK\\5u\u0011\u001dQ4'!AA\u0002A\n1\u0001\u001f\u00132\u0011\u0019a\u0004\u0001)Q\u0005a\u0005ia.^7DC2d'-Y2lg\u0002BQA\u0010\u0001\u0005\u0002}\n\u0001bY1mY\n\f7m\u001b\u000b\u0003m\u0001CQ!Q\u001fA\u0002A\n1\u0002Z3mCf$\u0016.\\3Ng\")1\t\u0001C\u0001\t\u0006a!-\u001a4pe\u0016lU\r\u001e5pIR\ta\u0007\u000b\u0002C\rB\u0011qIS\u0007\u0002\u0011*\u0011\u0011jH\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0017\"\u0013aAQ3g_J,\u0007\"B'\u0001\t\u0013q\u0015\u0001\u0005;fgR\fVo\u001c;b!\u0006\u00148/\u001b8h)%1t\nUAI\u0003+\u000bI\nC\u0003'\u0019\u0002\u0007\u0001\u0006C\u0003R\u0019\u0002\u0007!+A\u0004dY&,g\u000e^\u0019\u0011\u0005M#V\"\u0001\u0001\u0007\tU\u0003AI\u0016\u0002\u000b+N,'o\u00117jK:$8\u0003\u0002+\t/j\u0003\"!\u0003-\n\u0005eS!a\u0002)s_\u0012,8\r\u001e\t\u0003\u0013mK!\u0001\u0018\u0006\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011y#&Q3A\u0005\u0002}\u000bA!^:feV\t\u0001\r\u0005\u0002bI:\u0011\u0011BY\u0005\u0003G*\ta\u0001\u0015:fI\u00164\u0017BA3g\u0005\u0019\u0019FO]5oO*\u00111M\u0003\u0005\tQR\u0013\t\u0012)A\u0005A\u0006)Qo]3sA!A!\u000e\u0016BK\u0002\u0013\u0005q,\u0001\u0005dY&,g\u000e^%e\u0011!aGK!E!\u0002\u0013\u0001\u0017!C2mS\u0016tG/\u00133!\u0011!qGK!f\u0001\n\u0003y\u0017AC2p]\u001aLw-V:feV\t\u0001\u000fE\u0002\nc\u0002L!A\u001d\u0006\u0003\r=\u0003H/[8o\u0011!!HK!E!\u0002\u0013\u0001\u0018aC2p]\u001aLw-V:fe\u0002B\u0001B\u001e+\u0003\u0016\u0004%\ta\\\u0001\u000fG>tg-[4DY&,g\u000e^%e\u0011!AHK!E!\u0002\u0013\u0001\u0018aD2p]\u001aLwm\u00117jK:$\u0018\n\u001a\u0011\t\u000b=!F\u0011\u0001>\u0015\u000bI[H0 @\t\u000byK\b\u0019\u00011\t\u000b)L\b\u0019\u00011\t\u000f9L\b\u0013!a\u0001a\"9a/\u001fI\u0001\u0002\u0004\u0001\b\"CA\u0001)\u0006\u0005I\u0011AA\u0002\u0003\u0011\u0019w\u000e]=\u0015\u0013I\u000b)!a\u0002\u0002\n\u0005-\u0001b\u00020\u0000!\u0003\u0005\r\u0001\u0019\u0005\bU~\u0004\n\u00111\u0001a\u0011\u001dqw\u0010%AA\u0002ADqA^@\u0011\u0002\u0003\u0007\u0001\u000fC\u0005\u0002\u0010Q\u000b\n\u0011\"\u0001\u0002\u0012\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\nU\r\u0001\u0017QC\u0016\u0003\u0003/\u0001B!!\u0007\u0002$5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0005\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002&\u0005m!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011\u0011\u0006+\u0012\u0002\u0013\u0005\u0011\u0011C\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011%\ti\u0003VI\u0001\n\u0003\ty#\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005E\"f\u00019\u0002\u0016!I\u0011Q\u0007+\u0012\u0002\u0013\u0005\u0011qF\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0011%\tI\u0004VA\u0001\n\u0003\nY$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003{\u0001B!a\u0010\u0002J5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%\u0001\u0003mC:<'BAA$\u0003\u0011Q\u0017M^1\n\u0007\u0015\f\t\u0005\u0003\u0005\u0002NQ\u000b\t\u0011\"\u00010\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011%\t\t\u0006VA\u0001\n\u0003\t\u0019&\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005U\u00131\f\t\u0004\u0013\u0005]\u0013bAA-\u0015\t\u0019\u0011I\\=\t\u0011i\ny%!AA\u0002AB\u0011\"a\u0018U\u0003\u0003%\t%!\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0019\u0011\r\u0005\u0015\u00141NA+\u001b\t\t9GC\u0002\u0002j)\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti'a\u001a\u0003\u0011%#XM]1u_JD\u0011\"!\u001dU\u0003\u0003%\t!a\u001d\u0002\u0011\r\fg.R9vC2$B!!\u001e\u0002|A\u0019\u0011\"a\u001e\n\u0007\u0005e$BA\u0004C_>dW-\u00198\t\u0013i\ny'!AA\u0002\u0005U\u0003\"CA@)\u0006\u0005I\u0011IAA\u0003!A\u0017m\u001d5D_\u0012,G#\u0001\u0019\t\u0013\u0005\u0015E+!A\u0005B\u0005\u001d\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005u\u0002\"CAF)\u0006\u0005I\u0011IAG\u0003\u0019)\u0017/^1mgR!\u0011QOAH\u0011%Q\u0014\u0011RA\u0001\u0002\u0004\t)\u0006\u0003\u0004\u0002\u00142\u0003\rAU\u0001\bG2LWM\u001c;3\u0011\u0019\t9\n\u0014a\u0001%\u0006a!/\u00198e_6\u001cE.[3oi\"1\u00111\u0014'A\u0002I\u000b1\u0003Z3gCVdGoQ8oM&<7\t\\5f]RDa!a(\u0001\t\u0003!\u0015\u0001\u0007;fgR\u001cE.[3oi&#\u0017+^8uCB\u000b'o]5oO\"\"\u0011QTAR!\r9\u0015QU\u0005\u0004\u0003OC%\u0001\u0002+fgRDa!a+\u0001\t\u0003!\u0015\u0001\u0006;fgR,6/\u001a:Rk>$\u0018\rU1sg&tw\r\u000b\u0003\u0002*\u0006\r\u0006BBAY\u0001\u0011\u0005A)\u0001\u000fuKN$Xk]3s\u00072LWM\u001c;JIF+x\u000e^1QCJ\u001c\u0018N\\4)\t\u0005=\u00161\u0015\u0005\u0007\u0003o\u0003A\u0011\u0001#\u0002YQ,7\u000f^+tKJ\fVo\u001c;b!\u0006\u00148/\u001b8h/&$\b\u000eR3gCVdGo\u00117jK:$\u0018\nZ)v_R\f\u0007\u0006BA[\u0003GCa!!0\u0001\t\u0003!\u0015\u0001\u000e;fgR,6/\u001a:DY&,g\u000e^)v_R\f\u0007+\u0019:tS:<\u0017\nZ,ji\"$UMZ1vYR\u001cE.[3oi&#\u0017+^8uC\"\"\u00111XAR\u0011\u0019\t\u0019\r\u0001C\u0001\t\u0006IB/Z:u#V|G/Y\"p]\u001aLw\r\u0015:fG\u0016$WM\\2fQ\u0011\t\t-a)\t\r\u0005%\u0007\u0001\"\u0001E\u0003I!Xm\u001d;Rk>$\u0018MV5pY\u0006$\u0018n\u001c8)\t\u0005\u001d\u00171\u0015\u0005\u0007\u0003\u001f\u0004A\u0011\u0001#\u00029Q,7\u000f^#ya&\u0014X\r\u00165s_R$H.\u001a+j[\u0016\u001cVM\\:pe\"\"\u0011QZAR\u0011\u0019\t)\u000e\u0001C\u0001\t\u00061B/Z:u\u000bb\u0004\u0018N]3Rk>$\u0018mU3og>\u00148\u000f\u000b\u0003\u0002T\u0006\r\u0006BBAn\u0001\u0011\u0005A)A\u000buKN$\u0018+^8uCV\u001bXM]*b]&$\u0018N_3)\t\u0005e\u00171\u0015\u0005\b\u0003C\u0004A\u0011AAr\u0003)qWm^'fiJL7m]\u000b\u0003\u0003K\u0004B!a:\u0002n6\u0011\u0011\u0011\u001e\u0006\u0004\u0003WT\u0012aB7fiJL7m]\u0005\u0005\u0003_\fIOA\u0004NKR\u0014\u0018nY:\b\u0013\u0005M\b!!A\t\n\u0005U\u0018AC+tKJ\u001cE.[3oiB\u00191+a>\u0007\u0011U\u0003\u0011\u0011!E\u0005\u0003s\u001cR!a>\u0002|j\u0003\u0012\"!@\u0003\u0004\u0001\u0004\u0007\u000f\u001d*\u000e\u0005\u0005}(b\u0001B\u0001\u0015\u00059!/\u001e8uS6,\u0017\u0002\u0002B\u0003\u0003\u007f\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85\u0011\u001dy\u0011q\u001fC\u0001\u0005\u0013!\"!!>\t\u0015\u0005\u0015\u0015q_A\u0001\n\u000b\n9\t\u0003\u0006\u0003\u0010\u0005]\u0018\u0011!CA\u0005#\tQ!\u00199qYf$\u0012B\u0015B\n\u0005+\u00119B!\u0007\t\ry\u0013i\u00011\u0001a\u0011\u0019Q'Q\u0002a\u0001A\"AaN!\u0004\u0011\u0002\u0003\u0007\u0001\u000f\u0003\u0005w\u0005\u001b\u0001\n\u00111\u0001q\u0011)\u0011i\"a>\u0002\u0002\u0013\u0005%qD\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\tC!\u000b\u0011\t%\t(1\u0005\t\b\u0013\t\u0015\u0002\r\u00199q\u0013\r\u00119C\u0003\u0002\u0007)V\u0004H.\u001a\u001b\t\u0013\t-\"1DA\u0001\u0002\u0004\u0011\u0016a\u0001=%a!Q!qFA|#\u0003%\t!a\f\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIMB!Ba\r\u0002xF\u0005I\u0011AA\u0018\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0004B\u0003B\u001c\u0003o\f\n\u0011\"\u0001\u00020\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIMB!Ba\u000f\u0002xF\u0005I\u0011AA\u0018\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i!Q!qHA|\u0003\u0003%IA!\u0011\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u0007\u0002B!a\u0010\u0003F%!!qIA!\u0005\u0019y%M[3di\u0002")
public class ClientQuotaManagerTest {
    private final MockTime kafka$server$ClientQuotaManagerTest$$time = new MockTime();
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(500L, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
    private int numCallbacks = 0;
    private volatile ClientQuotaManagerTest$UserClient$ UserClient$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClientQuotaManagerTest$UserClient$ kafka$server$ClientQuotaManagerTest$$UserClient$lzycompute() {
        ClientQuotaManagerTest clientQuotaManagerTest = this;
        synchronized (clientQuotaManagerTest) {
            if (this.UserClient$module != null) return this.UserClient$module;
            this.UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            return this.UserClient$module;
        }
    }

    public MockTime kafka$server$ClientQuotaManagerTest$$time() {
        return this.kafka$server$ClientQuotaManagerTest$$time;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    public int numCallbacks() {
        return this.numCallbacks;
    }

    public void numCallbacks_$eq(int x$1) {
        this.numCallbacks = x$1;
    }

    public void callback(int delayTimeMs) {
        this.numCallbacks_$eq(this.numCallbacks() + 1);
    }

    @Before
    public void beforeMethod() {
        this.numCallbacks_$eq(0);
    }

    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(config, this.newMetrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time());
        try {
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientMetrics.updateQuota(client2.configUser(), client2.configClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)new StringBuilder().append((Object)"Default producer quota should be ").append((Object)BoxesRunTime.boxToLong((long)config.quotaBytesPerSecondDefault())).toString(), (Object)new Quota((double)config.quotaBytesPerSecondDefault(), true), (Object)clientMetrics.quota(randomClient.user(), randomClient.clientId()));
            Assert.assertEquals((String)"Should return the overridden value (2000)", (Object)new Quota(2000.0, true), (Object)clientMetrics.quota(client1.user(), client1.clientId()));
            Assert.assertEquals((String)"Should return the overridden value (4000)", (Object)new Quota(4000.0, true), (Object)clientMetrics.quota(client2.user(), client2.clientId()));
            int throttleTimeMs = clientMetrics.recordAndMaybeThrottle(client1.user(), client1.clientId(), 2500 * config.numQuotaSamples(), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (3000)", (Object)new Quota(3000.0, true), (Object)clientMetrics.quota(client1.user(), client1.clientId()));
            throttleTimeMs = clientMetrics.recordAndMaybeThrottle(client1.user(), client1.clientId(), 0, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (long)0L, (long)throttleTimeMs);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assert.assertEquals((String)"Should return the default value (500)", (Object)new Quota(500.0, true), (Object)clientMetrics.quota(client1.user(), client1.clientId()));
            throttleTimeMs = clientMetrics.recordAndMaybeThrottle(client1.user(), client1.clientId(), 0, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), (Option)None$.MODULE$);
            clientMetrics.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (4000)", (Object)new Quota(4000.0, true), (Object)clientMetrics.quota(client1.user(), client1.clientId()));
            throttleTimeMs = clientMetrics.recordAndMaybeThrottle(client1.user(), client1.clientId(), 1000 * config.numQuotaSamples(), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (long)0L, (long)throttleTimeMs);
            return;
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3()), this.newMetrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time());
        try {
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(2000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(3000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota$1("userA", "client1", 5000, 4500, false, quotaManager);
            this.checkQuota$1("userA", "client2", 4000, 4500, true, quotaManager);
            this.checkQuota$1("userA", "client3", 4000, 0, true, quotaManager);
            this.checkQuota$1("userA", "client1", 5000, 0, false, quotaManager);
            this.checkQuota$1("userB", "client1", 7000, 8000, true, quotaManager);
            this.checkQuota$1("userB", "client2", 8000, 7000, false, quotaManager);
            this.checkQuota$1("userB", "client3", 8000, 7000, false, quotaManager);
            this.checkQuota$1("userD", "client1", 3000, 3500, true, quotaManager);
            this.checkQuota$1("userD", "client2", 3000, 2500, false, quotaManager);
            this.checkQuota$1("userE", "client1", 3000, 2500, false, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$);
            this.checkQuota$1("userD", "client1", 1000, 0, false, quotaManager);
            this.checkQuota$1("userE", "client4", 1000, 1500, true, quotaManager);
            this.checkQuota$1("userF", "client4", 1000, 800, false, quotaManager);
            this.checkQuota$1("userF", "client5", 1000, 800, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota$1("userF", "client4", 2000, 0, false, quotaManager);
            this.checkQuota$1("userF", "client5", 2000, 0, false, quotaManager);
            this.checkQuota$1("userF", "client5", 2000, 2500, true, quotaManager);
            this.checkQuota$1("userG", "client5", 2000, 0, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota$1("userA", "client2", 8000, 0, false, quotaManager);
            this.checkQuota$1("userA", "client2", 8000, 4500, true, quotaManager);
            this.checkQuota$1("userA", "client1", 10000, 0, false, quotaManager);
            this.checkQuota$1("userA", "client1", 10000, 6000, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota$1("userA", "client6", 8000, 0, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota$1("userA", "client6", 11000, 8500, false, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(12000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota$1("userA", "client6", 12000, 4000, true, quotaManager);
            return;
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolation() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time());
        KafkaMetric queueSizeMetric = (KafkaMetric)metrics.metrics().get(metrics.metricName("queue-size", "Produce", ""));
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, clientMetrics){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager clientMetrics$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.clientMetrics$1.recordAndMaybeThrottle("ANONYMOUS", "unknown", 400, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testQuotaViolation$1 $outer;

                        public final void apply(int delayTimeMs) {
                            this.apply$mcVI$sp(delayTimeMs);
                        }

                        public void apply$mcVI$sp(int delayTimeMs) {
                            this.$outer.kafka$server$ClientQuotaManagerTest$$anonfun$$$outer().callback(delayTimeMs);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }

                public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.clientMetrics$1 = clientMetrics$1;
                }
            });
            Assert.assertEquals((long)10L, (long)this.numCallbacks());
            Assert.assertEquals((long)0L, (long)((int)queueSizeMetric.value()));
            this.kafka$server$ClientQuotaManagerTest$$time().sleep(500L);
            int sleepTime = clientMetrics.recordAndMaybeThrottle("ANONYMOUS", "unknown", 2300, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertEquals((String)"Should be throttled", (long)2100L, (long)sleepTime);
            Assert.assertEquals((long)1L, (long)((int)queueSizeMetric.value()));
            clientMetrics.throttledRequestReaper().doWork();
            Assert.assertEquals((long)10L, (long)this.numCallbacks());
            this.kafka$server$ClientQuotaManagerTest$$time().sleep((long)sleepTime);
            clientMetrics.throttledRequestReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)queueSizeMetric.value()));
            Assert.assertEquals((long)11L, (long)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, clientMetrics){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager clientMetrics$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.clientMetrics$1.recordAndMaybeThrottle("ANONYMOUS", "unknown", 400, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testQuotaViolation$2 $outer;

                        public final void apply(int delayTimeMs) {
                            this.apply$mcVI$sp(delayTimeMs);
                        }

                        public void apply$mcVI$sp(int delayTimeMs) {
                            this.$outer.kafka$server$ClientQuotaManagerTest$$anonfun$$$outer().callback(delayTimeMs);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }

                public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.clientMetrics$1 = clientMetrics$1;
                }
            });
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)clientMetrics.recordAndMaybeThrottle("ANONYMOUS", "unknown", 0, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }));
            return;
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testExpireThrottleTimeSensor() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time());
        try {
            clientMetrics.recordAndMaybeThrottle("ANONYMOUS", "client1", 100, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            metrics.removeSensor("ProduceThrottleTime-:client1");
            int throttleTime = clientMetrics.recordAndMaybeThrottle("ANONYMOUS", "client1", 10000, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = metrics.getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            return;
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testExpireQuotaSensors() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time());
        try {
            clientMetrics.recordAndMaybeThrottle("ANONYMOUS", "client1", 100, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            metrics.removeSensor("ProduceThrottleTime-:client1");
            metrics.removeSensor("Produce-ANONYMOUS:client1");
            int throttleTime = clientMetrics.recordAndMaybeThrottle("ANONYMOUS", "client1", 10000, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = metrics.getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = metrics.getSensor("Produce-:client1");
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
            return;
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testQuotaUserSanitize() {
        String principal = "CN=Some characters !@#$%&*()_-+=';:,/~";
        String sanitizedPrincipal = QuotaId$.MODULE$.sanitize(principal);
        ConfigCommand$.MODULE$.validateChars("sanitized-principal", sanitizedPrincipal.replace('%', '_'));
        Assert.assertEquals((Object)principal, (Object)QuotaId$.MODULE$.desanitize(sanitizedPrincipal));
    }

    public Metrics newMetrics() {
        return new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.kafka$server$ClientQuotaManagerTest$$time());
    }

    public ClientQuotaManagerTest$UserClient$ kafka$server$ClientQuotaManagerTest$$UserClient() {
        return this.UserClient$module == null ? this.kafka$server$ClientQuotaManagerTest$$UserClient$lzycompute() : this.UserClient$module;
    }

    private final void checkQuota$1(String user, String clientId, int expectedBound, int value, boolean expectThrottle, ClientQuotaManager quotaManager$1) {
        Assert.assertEquals((Object)new Quota((double)expectedBound, true), (Object)quotaManager$1.quota(user, clientId));
        int throttleTimeMs = quotaManager$1.recordAndMaybeThrottle(user, clientId, value * this.config().numQuotaSamples(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientQuotaManagerTest $outer;

            public final void apply(int delayTimeMs) {
                this.apply$mcVI$sp(delayTimeMs);
            }

            public void apply$mcVI$sp(int delayTimeMs) {
                this.$outer.callback(delayTimeMs);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        if (expectThrottle) {
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (long)0L, (long)throttleTimeMs);
        }
    }

    public class UserClient
    implements Product,
    Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 3: {
                    object = this.configClientId();
                    break;
                }
                case 2: {
                    object = this.configUser();
                    break;
                }
                case 1: {
                    object = this.clientId();
                    break;
                }
                case 0: {
                    object = this.user();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof UserClient)) return false;
            boolean bl = true;
            if (!bl) return false;
            UserClient userClient = (UserClient)x$1;
            String string = this.user();
            String string2 = userClient.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientId();
            String string4 = userClient.clientId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.configUser();
            Option<String> option2 = userClient.configUser();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.configClientId();
            Option<String> option4 = userClient.configClientId();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!userClient.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

