/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.common.TopicAndPartition;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.Constants$;
import kafka.server.DynamicConfig;
import kafka.server.DynamicConfigManager;
import kafka.server.DynamicConfigManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.TopicConfigHandler;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0001\u0003\u0001\u001d\u0011q\u0003R=oC6L7mQ8oM&<7\t[1oO\u0016$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u0013!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002\u0018)\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005!)a\u0004\u0001C\u0001?\u0005yq-\u001a8fe\u0006$XmQ8oM&<7\u000fF\u0001!!\r\t\u0003FK\u0007\u0002E)\u00111\u0005J\u0001\nS6lW\u000f^1cY\u0016T!!\n\u0014\u0002\u0015\r|G\u000e\\3di&|gNC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tI#E\u0001\u0003MSN$\bC\u0001\u000f,\u0013\ta#AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\"\u0002\u0018\u0001\t\u0003y\u0013\u0001\u0005;fgR\u001cuN\u001c4jO\u000eC\u0017M\\4f)\u0005\u0001\u0004CA\u00193\u001b\u00051\u0013BA\u001a'\u0005\u0011)f.\u001b;)\u00055*\u0004C\u0001\u001c9\u001b\u00059$BA\u0006\u000f\u0013\tItG\u0001\u0003UKN$\b\"B\u001e\u0001\t\u0013a\u0014!\u0006;fgR\fVo\u001c;b\u0007>tg-[4DQ\u0006tw-\u001a\u000b\u0006au2\u0005J\u0013\u0005\u0006}i\u0002\raP\u0001\u0005kN,'\u000f\u0005\u0002A\u0007:\u0011\u0011'Q\u0005\u0003\u0005\u001a\na\u0001\u0015:fI\u00164\u0017B\u0001#F\u0005\u0019\u0019FO]5oO*\u0011!I\n\u0005\u0006\u000fj\u0002\raP\u0001\tG2LWM\u001c;JI\")\u0011J\u000fa\u0001\u007f\u0005q!o\\8u\u000b:$\u0018\u000e^=UsB,\u0007\"B&;\u0001\u0004y\u0014\u0001E2p]\u001aLw-\u00128uSRLh*Y7f\u0011\u0015i\u0005\u0001\"\u00010\u0003u!Xm\u001d;DY&,g\u000e^%e#V|G/Y\"p]\u001aLwm\u00115b]\u001e,\u0007F\u0001'6\u0011\u0015\u0001\u0006\u0001\"\u00010\u0003e!Xm\u001d;Vg\u0016\u0014\u0018+^8uC\u000e{gNZ5h\u0007\"\fgnZ3)\u0005=+\u0004\"B*\u0001\t\u0003y\u0013a\u0007;fgR,6/\u001a:DY&,g\u000e^%e#V|G/Y\"iC:<W\r\u000b\u0002Sk!)a\u000b\u0001C\u0001_\u0005!C/Z:u\t\u00164\u0017-\u001e7u\u00072LWM\u001c;JIF+x\u000e^1D_:4\u0017nZ\"iC:<W\r\u000b\u0002Vk!)\u0011\f\u0001C\u0001_\u0005\u0001C/Z:u\t\u00164\u0017-\u001e7u+N,'/U;pi\u0006\u001cuN\u001c4jO\u000eC\u0017M\\4fQ\tAV\u0007C\u0003]\u0001\u0011\u0005q&\u0001\u0015uKN$H)\u001a4bk2$Xk]3s\u00072LWM\u001c;JIF+x\u000e^1D_:4\u0017nZ\"iC:<W\r\u000b\u0002\\k!)q\f\u0001C\u0001_\u00059B/Z:u#V|G/Y%oSRL\u0017\r\\5{CRLwN\u001c\u0015\u0003=VBQA\u0019\u0001\u0005\u0002=\n!\u0005^3ti\u000e{gNZ5h\u0007\"\fgnZ3P]:{g.\u0012=jgRLgn\u001a+pa&\u001c\u0007FA16\u0011\u0015)\u0007\u0001\"\u0001g\u0003]!Xm\u001d;Qe>\u001cWm]:O_RLg-[2bi&|g.F\u00011Q\t!W\u0007C\u0003j\u0001\u0011\u0005a-A\u0013tQ>,H\u000e\u001a)beN,'+\u001a9mS\u000e\fG/[8o#V|G/\u0019)s_B,'\u000f^5fg\"\u0012\u0001.\u000e\u0005\u0006Y\u0002!\tAZ\u0001.g\"|W\u000f\u001c3QCJ\u001cXmV5mI\u000e\f'\u000f\u001a*fa2L7-\u0019;j_:\fVo\u001c;b!J|\u0007/\u001a:uS\u0016\u001c\bFA66\u0011\u0015y\u0007\u0001\"\u0001g\u0003\u0001\u001a\bn\\;mIB\u000b'o]3SKBd\u0017nY1uS>t\u0017+^8uCJ+7/\u001a;)\u00059,\u0004\"\u0002:\u0001\t\u0003y\u0013!L:i_VdG\rU1sg\u0016\u0014VmZ1sI2,7o](g/\"LG/Z:qC\u000e,\u0017I]8v]\u00124\u0016\r\\;fg\"\u0012\u0011/\u000e\u0005\u0006k\u0002!\tA^\u0001\u0006a\u0006\u00148/\u001a\u000b\u0006o\u00065\u0011q\u0003\t\u0006q\u0006\u0005\u0011q\u0001\b\u0003szt!A_?\u000e\u0003mT!\u0001 \u0004\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0013BA@'\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0001\u0002\u0006\t\u00191+Z9\u000b\u0005}4\u0003cA\u0019\u0002\n%\u0019\u00111\u0002\u0014\u0003\u0007%sG\u000fC\u0004\u0002\u0010Q\u0004\r!!\u0005\u0002\u001b\r|gNZ5h\u0011\u0006tG\r\\3s!\ra\u00121C\u0005\u0004\u0003+\u0011!A\u0005+pa&\u001c7i\u001c8gS\u001eD\u0015M\u001c3mKJDa!!\u0007u\u0001\u0004y\u0014!\u0002<bYV,\u0007")
public class DynamicConfigChangeTest
extends JUnitSuite
implements KafkaServerTestHarness {
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    @TraitSetter
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    @TraitSetter
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    @TraitSetter
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    @TraitSetter
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void setAclsBeforeServersStart() {
        KafkaServerTestHarness$class.setAclsBeforeServersStart(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> saslProperties() {
        return KafkaServerTestHarness$class.saslProperties(this);
    }

    @Override
    @Before
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        DynamicConfigChangeTest dynamicConfigChangeTest = this;
        synchronized (dynamicConfigChangeTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public List<KafkaConfig> generateConfigs() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16()))}));
    }

    @Test
    public void testConfigChange() {
        Assert.assertTrue((String)"Should contain a ConfigHandler for topics", (boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)ConfigType$.MODULE$.Topic()));
        Long oldVal = Predef$.MODULE$.long2Long(100000L);
        Long newVal = Predef$.MODULE$.long2Long(200000L);
        TopicAndPartition tp = new TopicAndPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), oldVal.toString());
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), tp.topic(), 1, 1, logProps, AdminUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, oldVal, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConfigChangeTest $outer;
            private final Long oldVal$1;
            private final TopicAndPartition tp$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option logOpt = ((KafkaServer)this.$outer.servers().head()).logManager().getLog(this.tp$1);
                Assert.assertTrue((boolean)logOpt.isDefined());
                Assert.assertEquals((Object)this.oldVal$1, (Object)((Log)logOpt.get()).config().flushInterval());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.oldVal$1 = oldVal$1;
                this.tp$1 = tp$1;
            }
        });
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), newVal.toString());
        AdminUtils$.MODULE$.changeTopicConfig(this.zkUtils(), tp.topic(), logProps);
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, newVal, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConfigChangeTest $outer;
            private final Long newVal$1;
            private final TopicAndPartition tp$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Assert.assertEquals((Object)this.newVal$1, (Object)((Log)((KafkaServer)this.$outer.servers().head()).logManager().getLog(this.tp$1).get()).config().flushInterval());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newVal$1 = newVal$1;
                this.tp$1 = tp$1;
            }
        });
    }

    private void testQuotaConfigChange(String user, String clientId, String rootEntityType, String configEntityName) {
        Assert.assertTrue((String)new StringBuilder().append((Object)"Should contain a ConfigHandler for ").append((Object)rootEntityType).toString(), (boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)rootEntityType));
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "1000");
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "2000");
        QuotaFactory.QuotaManagers quotaManagers = ((KafkaServer)this.servers().head()).apis().quotas();
        String string = rootEntityType;
        String string2 = ConfigType$.MODULE$.Client();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            AdminUtils$.MODULE$.changeClientIdConfig(this.zkUtils(), configEntityName, props);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), configEntityName, props);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, user, clientId, quotaManagers){
            public static final long serialVersionUID = 0L;
            private final String user$1;
            private final String clientId$1;
            private final QuotaFactory.QuotaManagers quotaManagers$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Quota overrideProducerQuota = this.quotaManagers$1.produce().quota(this.user$1, this.clientId$1);
                Quota overrideConsumerQuota = this.quotaManagers$1.fetch().quota(this.user$1, this.clientId$1);
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", " clientId ", " must have overridden producer quota of 1000"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.user$1, this.clientId$1})), (Object)Quota.upperBound((double)1000.0), (Object)overrideProducerQuota);
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", " clientId ", " must have overridden consumer quota of 2000"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.user$1, this.clientId$1})), (Object)Quota.upperBound((double)2000.0), (Object)overrideConsumerQuota);
            }
            {
                this.user$1 = user$1;
                this.clientId$1 = clientId$1;
                this.quotaManagers$1 = quotaManagers$1;
            }
        });
        double defaultProducerQuota = Long.MAX_VALUE;
        double defaultConsumerQuota = Long.MAX_VALUE;
        Properties emptyProps = new Properties();
        String string4 = rootEntityType;
        String string5 = ConfigType$.MODULE$.Client();
        String string6 = string4;
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            AdminUtils$.MODULE$.changeClientIdConfig(this.zkUtils(), configEntityName, emptyProps);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), configEntityName, emptyProps);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, user, clientId, quotaManagers, defaultProducerQuota, defaultConsumerQuota){
            public static final long serialVersionUID = 0L;
            private final String user$1;
            private final String clientId$1;
            private final QuotaFactory.QuotaManagers quotaManagers$1;
            private final double defaultProducerQuota$1;
            private final double defaultConsumerQuota$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Quota producerQuota = this.quotaManagers$1.produce().quota(this.user$1, this.clientId$1);
                Quota consumerQuota = this.quotaManagers$1.fetch().quota(this.user$1, this.clientId$1);
                Assert.assertEquals((String)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", " clientId ", " must have reset producer quota to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.user$1, this.clientId$1}))).append((Object)BoxesRunTime.boxToDouble((double)this.defaultProducerQuota$1)).toString(), (Object)Quota.upperBound((double)this.defaultProducerQuota$1), (Object)producerQuota);
                Assert.assertEquals((String)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", " clientId ", " must have reset consumer quota to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.user$1, this.clientId$1}))).append((Object)BoxesRunTime.boxToDouble((double)this.defaultConsumerQuota$1)).toString(), (Object)Quota.upperBound((double)this.defaultConsumerQuota$1), (Object)consumerQuota);
            }
            {
                this.user$1 = user$1;
                this.clientId$1 = clientId$1;
                this.quotaManagers$1 = quotaManagers$1;
                this.defaultProducerQuota$1 = defaultProducerQuota$1;
                this.defaultConsumerQuota$1 = defaultConsumerQuota$1;
            }
        });
    }

    @Test
    public void testClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "testClient");
    }

    @Test
    public void testUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS");
    }

    @Test
    public void testUserClientIdQuotaChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS/clients/testClient");
    }

    @Test
    public void testDefaultClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "<default>");
    }

    @Test
    public void testDefaultUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>");
    }

    @Test
    public void testDefaultUserClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>/clients/<default>");
    }

    @Test
    public void testQuotaInitialization() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties clientIdProps = new Properties();
        server.shutdown();
        clientIdProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "1000");
        clientIdProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "2000");
        Properties userProps = new Properties();
        userProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "10000");
        userProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "20000");
        Properties userClientIdProps = new Properties();
        userClientIdProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "100000");
        userClientIdProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "200000");
        AdminUtils$.MODULE$.changeClientIdConfig(this.zkUtils(), "overriddenClientId", clientIdProps);
        AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), "overriddenUser", userProps);
        AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), "ANONYMOUS/clients/overriddenUserClientId", userClientIdProps);
        this.zkUtils().getChildren(ZkUtils$.MODULE$.EntityConfigChangesPath()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConfigChangeTest $outer;

            public final boolean apply(String p) {
                return this.$outer.zkUtils().deletePath(new StringBuilder().append((Object)ZkUtils$.MODULE$.EntityConfigChangesPath()).append((Object)"/").append((Object)p).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        server.startup();
        QuotaFactory.QuotaManagers quotaManagers = server.apis().quotas();
        Assert.assertEquals((Object)Quota.upperBound((double)1000.0), (Object)quotaManagers.produce().quota("someuser", "overriddenClientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)2000.0), (Object)quotaManagers.fetch().quota("someuser", "overriddenClientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)10000.0), (Object)quotaManagers.produce().quota("overriddenUser", "someclientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)20000.0), (Object)quotaManagers.fetch().quota("overriddenUser", "someclientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)100000.0), (Object)quotaManagers.produce().quota("ANONYMOUS", "overriddenUserClientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)200000.0), (Object)quotaManagers.fetch().quota("ANONYMOUS", "overriddenUserClientId"));
    }

    @Test
    public void testConfigChangeOnNonExistingTopic() {
        String topic = TestUtils$.MODULE$.tempTopic();
        try {
            Properties logProps = new Properties();
            logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), Predef$.MODULE$.int2Integer(10000));
            AdminUtils$.MODULE$.changeTopicConfig(this.zkUtils(), topic, logProps);
            throw this.fail("Should fail with AdminOperationException for topic doesn't exist");
        }
        catch (AdminOperationException adminOperationException) {
            return;
        }
    }

    @Test
    public void testProcessNotification() {
        Properties props = new Properties();
        props.put("a.b", "10");
        Capture entityArgument = EasyMock.newCapture();
        Capture propertiesArgument = EasyMock.newCapture();
        ConfigHandler handler = (ConfigHandler)EasyMock.createNiceMock(ConfigHandler.class);
        handler.processConfigChanges((String)EasyMock.and((Object)EasyMock.capture((Capture)entityArgument), (Object)EasyMock.isA(String.class)), (Properties)EasyMock.and((Object)EasyMock.capture((Capture)propertiesArgument), (Object)EasyMock.isA(Properties.class)));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{handler});
        DynamicConfigManager configManager = new DynamicConfigManager(this.zkUtils(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)ConfigType$.MODULE$.Topic()), (Object)handler)})), DynamicConfigManager$.MODULE$.$lessinit$greater$default$3(), DynamicConfigManager$.MODULE$.$lessinit$greater$default$4());
        configManager.ConfigChangedNotificationHandler().processNotification("not json");
        try {
            Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"v"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"x"), (Object)BoxesRunTime.boxToInteger((int)2))}));
            configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encode((Object)jsonMap));
            throw this.fail(new StringBuilder().append((Object)"Should have thrown an Exception while parsing incorrect notification ").append((Object)jsonMap).toString());
        }
        catch (Throwable throwable) {
            try {
                Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"entity_type"), (Object)"garbage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"entity_name"), (Object)"x")}));
                configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encode((Object)jsonMap));
                throw this.fail(new StringBuilder().append((Object)"Should have thrown an Exception while parsing incorrect notification ").append((Object)jsonMap).toString());
            }
            catch (Throwable throwable2) {
                try {
                    Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic())}));
                    configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encode((Object)jsonMap));
                    throw this.fail(new StringBuilder().append((Object)"Should have thrown an Exception while parsing incorrect notification ").append((Object)jsonMap).toString());
                }
                catch (Throwable throwable3) {
                    Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"entity_name"), (Object)"x")}));
                    configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encode((Object)jsonMap));
                    EasyMock.verify((Object[])new Object[]{handler});
                    return;
                }
            }
        }
    }

    @Test
    public void shouldParseReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:101,0:102,1:101,1:102");
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)configHandler.parseThrottledPartitions(props, 103, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
    }

    @Test
    public void shouldParseWildcardReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "*");
        Seq result = configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
        Assert.assertEquals((Object)Constants$.MODULE$.AllReplicas(), (Object)result);
    }

    @Test
    public void shouldParseReplicationQuotaReset() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "");
        Seq result = configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)result);
    }

    @Test
    public void shouldParseRegardlessOfWhitespaceAroundValues() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null);
        Assert.assertEquals((Object)Constants$.MODULE$.AllReplicas(), this.parse(configHandler, "* "));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), this.parse(configHandler, " "));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102"));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102 "));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, " 6:102"));
    }

    public Seq<Object> parse(TopicConfigHandler configHandler, String value) {
        return configHandler.parseThrottledPartitions(CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), value), 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
    }

    public DynamicConfigChangeTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
    }
}

