/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import kafka.common.MessageFormatter;
import kafka.consumer.BaseConsumer;
import kafka.consumer.BaseConsumerRecord;
import kafka.consumer.BaseConsumerRecord$;
import kafka.tools.ConsoleConsumer;
import kafka.tools.ConsoleConsumer$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.record.TimestampType;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m2A!\u0001\u0002\u0001\u000f\t\u00192i\u001c8t_2,7i\u001c8tk6,'\u000fV3ti*\u00111\u0001B\u0001\u0006i>|Gn\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001\u0005\u00061\u0001!\t!G\u0001\"g\"|W\u000f\u001c3MS6LGOU3bIN$v.T1y\u001b\u0016\u001c8/Y4f\u0019&l\u0017\u000e\u001e\u000b\u00025A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t!QK\\5uQ\t9\u0012\u0005\u0005\u0002#I5\t1E\u0003\u0002\f\u001d%\u0011Qe\t\u0002\u0005)\u0016\u001cH\u000fC\u0003(\u0001\u0011\u0005\u0011$A\u0012tQ>,H\u000eZ*u_B<\u0006.\u001a8PkR\u0004X\u000f^\"iK\u000e\\WI\u001d:pe\u001a\u000b\u0017\u000e\\:)\u0005\u0019\n\u0003\"\u0002\u0016\u0001\t\u0003I\u0012AJ:i_VdG\rU1sg\u00164\u0016\r\\5e\u001f2$7i\u001c8tk6,'OV1mS\u0012\u001cuN\u001c4jO\"\u0012\u0011&\t\u0005\u0006[\u0001!\t!G\u0001'g\"|W\u000f\u001c3QCJ\u001cXMV1mS\u0012tUm^\"p]N,X.\u001a:WC2LGmQ8oM&<\u0007F\u0001\u0017\"\u0011\u0015\u0001\u0004\u0001\"\u0001\u001a\u0003u\u001a\bn\\;mIB\u000b'o]3WC2LGMT3x'&l\u0007\u000f\\3D_:\u001cX/\\3s-\u0006d\u0017\u000eZ\"p]\u001aLwmV5uQ:+X.\u001a:jG>3gm]3uQ\ty\u0013\u0005C\u00034\u0001\u0011\u0005\u0011$A\nuKN$H)\u001a4bk2$8i\u001c8tk6,'\u000f\u000b\u00023C!)a\u0007\u0001C\u00013\u0005a4\u000f[8vY\u0012\u0004\u0016M]:f-\u0006d\u0017\u000e\u001a(foNKW\u000e\u001d7f\u0007>t7/^7feZ\u000bG.\u001b3D_:4\u0017nZ,ji\"\u001cFO]5oO>3gm]3uQ\t)\u0014\u0005C\u0003:\u0001\u0011\u0005\u0011$\u0001\u000etQ>,H\u000e\u001a)beN,7i\u001c8gS\u001e\u001chI]8n\r&dW\r\u000b\u00029C\u0001")
public class ConsoleConsumerTest
extends JUnitSuite {
    @Test
    public void shouldLimitReadsToMaxMessageLimit() {
        BaseConsumer consumer = (BaseConsumer)EasyMock.createNiceMock(BaseConsumer.class);
        MessageFormatter formatter = (MessageFormatter)EasyMock.createNiceMock(MessageFormatter.class);
        String x$1 = "foo";
        int x$2 = 1;
        long x$3 = 1L;
        byte[] x$4 = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
        byte[] x$5 = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
        long x$6 = BaseConsumerRecord$.MODULE$.$lessinit$greater$default$4();
        TimestampType x$7 = BaseConsumerRecord$.MODULE$.$lessinit$greater$default$5();
        BaseConsumerRecord record = new BaseConsumerRecord(x$1, x$2, x$3, x$6, x$7, x$4, x$5);
        int messageLimit = 10;
        formatter.writeTo((ConsumerRecord)EasyMock.anyObject(), (PrintStream)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).times(messageLimit);
        EasyMock.expect((Object)consumer.receive()).andReturn((Object)record).times(messageLimit);
        EasyMock.replay((Object[])new Object[]{consumer});
        EasyMock.replay((Object[])new Object[]{formatter});
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(messageLimit), formatter, consumer, System.out, true);
    }

    @Test
    public void shouldStopWhenOutputCheckErrorFails() {
        BaseConsumer consumer = (BaseConsumer)EasyMock.createNiceMock(BaseConsumer.class);
        MessageFormatter formatter = (MessageFormatter)EasyMock.createNiceMock(MessageFormatter.class);
        PrintStream printStream = (PrintStream)EasyMock.createNiceMock(PrintStream.class);
        String x$8 = "foo";
        int x$9 = 1;
        long x$10 = 1L;
        byte[] x$11 = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
        byte[] x$12 = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
        long x$13 = BaseConsumerRecord$.MODULE$.$lessinit$greater$default$4();
        TimestampType x$14 = BaseConsumerRecord$.MODULE$.$lessinit$greater$default$5();
        BaseConsumerRecord record = new BaseConsumerRecord(x$8, x$9, x$10, x$13, x$14, x$11, x$12);
        EasyMock.expect((Object)consumer.receive()).andReturn((Object)record);
        formatter.writeTo((ConsumerRecord)EasyMock.anyObject(), (PrintStream)EasyMock.eq((Object)printStream));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)printStream.checkError())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{consumer});
        EasyMock.replay((Object[])new Object[]{formatter});
        EasyMock.replay((Object[])new Object[]{printStream});
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(-1), formatter, consumer, printStream, true);
        EasyMock.verify((Object[])new Object[]{consumer, formatter, printStream});
    }

    @Test
    public void shouldParseValidOldConsumerValidConfig() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:2181", "--topic", "test", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertTrue((boolean)config.useOldConsumer());
        Assert.assertEquals((Object)"localhost:2181", (Object)config.zkConnectionStr());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldParseValidNewConsumerValidConfig() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning", "--new-consumer"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertFalse((boolean)config.useOldConsumer());
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldParseValidNewSimpleConsumerValidConfigWithNumericOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "3", "--new-consumer"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertFalse((boolean)config.useOldConsumer());
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)config.partitionArg().get()));
        Assert.assertEquals((long)3L, (long)config.offsetArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void testDefaultConsumer() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertFalse((boolean)config.useOldConsumer());
    }

    @Test
    public void shouldParseValidNewSimpleConsumerValidConfigWithStringOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "LatEst", "--new-consumer"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertFalse((boolean)config.useOldConsumer());
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)config.partitionArg().get()));
        Assert.assertEquals((long)-1L, (long)config.offsetArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldParseConfigsFromFile() {
        File propsFile = TestUtils$.MODULE$.tempFile();
        FileOutputStream propsStream = new FileOutputStream(propsFile);
        propsStream.write("request.timeout.ms=1000".getBytes());
        propsStream.close();
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer.config", propsFile.getAbsolutePath()});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertEquals((Object)"1000", (Object)config.consumerProps().getProperty("request.timeout.ms"));
    }
}

