/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.Properties;
import kafka.api.LeaderAndIsr;
import kafka.common.TopicAndPartition;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaManager;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ReplicationUtils$;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.log4j.Logger;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001\u000f\t!\"+\u001a9mS\u000e\fG/[8o+RLGn\u001d+fgRT!a\u0001\u0003\u0002\u000bU$\u0018\u000e\\:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011I\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\tQ8.\u0003\u0002\u0018)\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgNDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000fy\u0001!\u0019!C\u0001?\u0005)Ao\u001c9jGV\t\u0001\u0005\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005!A.\u00198h\u0015\u0005)\u0013\u0001\u00026bm\u0006L!a\n\u0012\u0003\rM#(/\u001b8h\u0011\u0019I\u0003\u0001)A\u0005A\u00051Ao\u001c9jG\u0002Bqa\u000b\u0001C\u0002\u0013\u0005A&A\u0006qCJ$\u0018\u000e^5p]&#W#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\u0007%sG\u000f\u0003\u00045\u0001\u0001\u0006I!L\u0001\ra\u0006\u0014H/\u001b;j_:LE\r\t\u0005\bm\u0001\u0011\r\u0011\"\u0001-\u0003!\u0011'o\\6fe&#\u0007B\u0002\u001d\u0001A\u0003%Q&A\u0005ce>\\WM]%eA!9!\b\u0001b\u0001\n\u0003a\u0013a\u00037fC\u0012,'/\u00129pG\"Da\u0001\u0010\u0001!\u0002\u0013i\u0013\u0001\u00047fC\u0012,'/\u00129pG\"\u0004\u0003b\u0002 \u0001\u0005\u0004%\t\u0001L\u0001\u0010G>tGO]8mY\u0016\u0014X\t]8dQ\"1\u0001\t\u0001Q\u0001\n5\n\u0001cY8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0011\t\u000f\t\u0003!\u0019!C\u0001Y\u0005I!p\u001b,feNLwN\u001c\u0005\u0007\t\u0002\u0001\u000b\u0011B\u0017\u0002\u0015i\\g+\u001a:tS>t\u0007\u0005C\u0004G\u0001\t\u0007I\u0011A\u0010\u0002\u0013Q|\u0007/[2QCRD\u0007B\u0002%\u0001A\u0003%\u0001%\u0001\u0006u_BL7\rU1uQ\u0002BqA\u0013\u0001C\u0002\u0013\u00051*A\u0005u_BL7\rR1uCV\tA\n\u0005\u0002N!:\u0011aFT\u0005\u0003\u001f>\na\u0001\u0015:fI\u00164\u0017BA\u0014R\u0015\tyu\u0006\u0003\u0004T\u0001\u0001\u0006I\u0001T\u0001\u000bi>\u0004\u0018n\u0019#bi\u0006\u0004\u0003bB+\u0001\u0005\u0004%\taS\u0001\u0019i>\u0004\u0018n\u0019#bi\u00064VM]:j_:l\u0015n]7bi\u000eD\u0007BB,\u0001A\u0003%A*A\ru_BL7\rR1uCZ+'o]5p]6K7/\\1uG\"\u0004\u0003bB-\u0001\u0005\u0004%\taS\u0001\u0012i>\u0004\u0018n\u0019#bi\u0006l\u0015n]7bi\u000eD\u0007BB.\u0001A\u0003%A*\u0001\nu_BL7\rR1uC6K7/\\1uG\"\u0004\u0003bB/\u0001\u0005\u0004%\tAX\u0001%i>\u0004\u0018n\u0019#bi\u0006dU-\u00193fe&\u001b(/\u00118e\u0007>tGO]8mY\u0016\u0014X\t]8dQV\tq\f\u0005\u0002aG6\t\u0011M\u0003\u0002c\t\u0005Q1m\u001c8ue>dG.\u001a:\n\u0005\u0011\f'a\u0007'fC\u0012,'/S:s\u0003:$7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000e\u0003\u0004g\u0001\u0001\u0006IaX\u0001&i>\u0004\u0018n\u0019#bi\u0006dU-\u00193fe&\u001b(/\u00118e\u0007>tGO]8mY\u0016\u0014X\t]8dQ\u0002BQ\u0001\u001b\u0001\u0005B%\fQa]3u+B$\u0012A\u001b\t\u0003]-L!\u0001\\\u0018\u0003\tUs\u0017\u000e\u001e\u0015\u0003O:\u0004\"a\\9\u000e\u0003AT!a\u0003\b\n\u0005I\u0004(A\u0002\"fM>\u0014X\rC\u0003u\u0001\u0011\u0005\u0011.\u0001\fuKN$X\u000b\u001d3bi\u0016dU-\u00193fe\u0006sG-S:sQ\t\u0019h\u000f\u0005\u0002po&\u0011\u0001\u0010\u001d\u0002\u0005)\u0016\u001cH\u000fC\u0003{\u0001\u0011\u0005\u0011.\u0001\u0013uKN$x)\u001a;MK\u0006$WM]%te\u0006sG-\u00129pG\"4uN\u001d)beRLG/[8oQ\tIh\u000f")
public class ReplicationUtilsTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final String topic;
    private final int partitionId;
    private final int brokerId;
    private final int leaderEpoch;
    private final int controllerEpoch;
    private final int zkVersion;
    private final String topicPath;
    private final String topicData;
    private final String topicDataVersionMismatch;
    private final String topicDataMismatch;
    private final LeaderIsrAndControllerEpoch topicDataLeaderIsrAndControllerEpoch;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    @After
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReplicationUtilsTest replicationUtilsTest = this;
        synchronized (replicationUtilsTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public int zkVersion() {
        return this.zkVersion;
    }

    public String topicPath() {
        return this.topicPath;
    }

    public String topicData() {
        return this.topicData;
    }

    public String topicDataVersionMismatch() {
        return this.topicDataVersionMismatch;
    }

    public String topicDataMismatch() {
        return this.topicDataMismatch;
    }

    public LeaderIsrAndControllerEpoch topicDataLeaderIsrAndControllerEpoch() {
        return this.topicDataLeaderIsrAndControllerEpoch;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        ZkUtils qual$1 = this.zkUtils();
        String x$4 = this.topicPath();
        String x$5 = this.topicData();
        java.util.List x$6 = qual$1.createPersistentPath$default$3();
        qual$1.createPersistentPath(x$4, x$5, x$6);
    }

    @Test
    public void testUpdateLeaderAndIsr() {
        Seq configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Log log = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)20L)).anyTimes();
        EasyMock.expect((Object)log);
        EasyMock.replay((Object[])new Object[]{log});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog(new TopicAndPartition(this.topic(), this.partitionId()))).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.config()).andReturn(configs.head());
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager);
        EasyMock.expect((Object)replicaManager.replicaFetcherManager()).andReturn(EasyMock.createMock(ReplicaFetcherManager.class));
        EasyMock.expect((Object)replicaManager.zkUtils()).andReturn((Object)this.zkUtils());
        EasyMock.replay((Object[])new Object[]{replicaManager});
        ZkUtils qual$2 = this.zkUtils();
        String x$7 = ZkUtils$.MODULE$.IsrChangeNotificationPath();
        java.util.List x$8 = qual$2.makeSurePersistentPathExists$default$2();
        qual$2.makeSurePersistentPathExists(x$7, x$8);
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        LeaderAndIsr newLeaderAndIsr1 = new LeaderAndIsr(this.brokerId(), this.leaderEpoch(), replicas, 0);
        Tuple2 tuple2 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkUtils(), "my-topic-test", this.partitionId(), newLeaderAndIsr1, this.controllerEpoch(), 0);
        if (tuple2 != null) {
            Tuple2.mcZI.sp sp2;
            boolean updateSucceeded1 = tuple2._1$mcZ$sp();
            int newZkVersion1 = tuple2._2$mcI$sp();
            Tuple2.mcZI.sp sp3 = sp2 = new Tuple2.mcZI.sp(updateSucceeded1, newZkVersion1);
            boolean updateSucceeded12 = sp3._1$mcZ$sp();
            int newZkVersion12 = sp3._2$mcI$sp();
            Assert.assertTrue((boolean)updateSucceeded12);
            Assert.assertEquals((long)newZkVersion12, (long)1L);
            LeaderAndIsr newLeaderAndIsr2 = new LeaderAndIsr(this.brokerId(), this.leaderEpoch(), replicas, this.zkVersion() + 1);
            Tuple2 tuple22 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkUtils(), "my-topic-test", this.partitionId(), newLeaderAndIsr2, this.controllerEpoch(), this.zkVersion() + 1);
            if (tuple22 != null) {
                Tuple2.mcZI.sp sp4;
                boolean updateSucceeded2 = tuple22._1$mcZ$sp();
                int newZkVersion2 = tuple22._2$mcI$sp();
                Tuple2.mcZI.sp sp5 = sp4 = new Tuple2.mcZI.sp(updateSucceeded2, newZkVersion2);
                boolean updateSucceeded22 = sp5._1$mcZ$sp();
                int newZkVersion22 = sp5._2$mcI$sp();
                Assert.assertTrue((boolean)updateSucceeded22);
                Assert.assertEquals((long)newZkVersion22, (long)1L);
                LeaderAndIsr newLeaderAndIsr3 = new LeaderAndIsr(this.brokerId(), this.leaderEpoch() + 1, replicas, this.zkVersion() + 1);
                Tuple2 tuple23 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkUtils(), "my-topic-test", this.partitionId(), newLeaderAndIsr3, this.controllerEpoch(), this.zkVersion() + 1);
                if (tuple23 != null) {
                    Tuple2.mcZI.sp sp6;
                    boolean updateSucceeded3 = tuple23._1$mcZ$sp();
                    int newZkVersion3 = tuple23._2$mcI$sp();
                    Tuple2.mcZI.sp sp7 = sp6 = new Tuple2.mcZI.sp(updateSucceeded3, newZkVersion3);
                    boolean updateSucceeded32 = sp7._1$mcZ$sp();
                    int newZkVersion32 = sp7._2$mcI$sp();
                    Assert.assertFalse((boolean)updateSucceeded32);
                    Assert.assertEquals((long)newZkVersion32, (long)-1L);
                    return;
                }
                throw new MatchError((Object)tuple23);
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testGetLeaderIsrAndEpochForPartition() {
        Option leaderIsrAndControllerEpoch = ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkUtils(), this.topic(), this.partitionId());
        Assert.assertEquals((Object)this.topicDataLeaderIsrAndControllerEpoch(), (Object)leaderIsrAndControllerEpoch.get());
        Assert.assertEquals((Object)None$.MODULE$, (Object)ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkUtils(), this.topic(), this.partitionId() + 1));
    }

    public ReplicationUtilsTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.topic = "my-topic-test";
        this.partitionId = 0;
        this.brokerId = 1;
        this.leaderEpoch = 1;
        this.controllerEpoch = 1;
        this.zkVersion = 1;
        this.topicPath = "/brokers/topics/my-topic-test/partitions/0/state";
        this.topicData = Json$.MODULE$.encode((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"versions"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"isr"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))})));
        this.topicDataVersionMismatch = Json$.MODULE$.encode((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"versions"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"isr"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))})));
        this.topicDataMismatch = Json$.MODULE$.encode((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"versions"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"isr"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))})));
        this.topicDataLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(1, this.leaderEpoch(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), 0), this.controllerEpoch());
    }
}

