/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.ArrayList;
import kafka.common.TopicAndPartition;
import kafka.utils.Json$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils;
import org.I0Itec.zkclient.IZkConnection;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.ZkConnection;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ZkUtils$ {
    public static final ZkUtils$ MODULE$;
    private final String ConsumersPath;
    private final String ClusterIdPath;
    private final String BrokerIdsPath;
    private final String BrokerTopicsPath;
    private final String ControllerPath;
    private final String ControllerEpochPath;
    private final String ReassignPartitionsPath;
    private final String DeleteTopicsPath;
    private final String PreferredReplicaLeaderElectionPath;
    private final String BrokerSequenceIdPath;
    private final String IsrChangeNotificationPath;
    private final String EntityConfigPath;
    private final String EntityConfigChangesPath;

    static {
        new ZkUtils$();
    }

    public String ConsumersPath() {
        return this.ConsumersPath;
    }

    public String ClusterIdPath() {
        return this.ClusterIdPath;
    }

    public String BrokerIdsPath() {
        return this.BrokerIdsPath;
    }

    public String BrokerTopicsPath() {
        return this.BrokerTopicsPath;
    }

    public String ControllerPath() {
        return this.ControllerPath;
    }

    public String ControllerEpochPath() {
        return this.ControllerEpochPath;
    }

    public String ReassignPartitionsPath() {
        return this.ReassignPartitionsPath;
    }

    public String DeleteTopicsPath() {
        return this.DeleteTopicsPath;
    }

    public String PreferredReplicaLeaderElectionPath() {
        return this.PreferredReplicaLeaderElectionPath;
    }

    public String BrokerSequenceIdPath() {
        return this.BrokerSequenceIdPath;
    }

    public String IsrChangeNotificationPath() {
        return this.IsrChangeNotificationPath;
    }

    public String EntityConfigPath() {
        return this.EntityConfigPath;
    }

    public String EntityConfigChangesPath() {
        return this.EntityConfigChangesPath;
    }

    public ZkUtils apply(String zkUrl, int sessionTimeout, int connectionTimeout, boolean isZkSecurityEnabled) {
        Tuple2<ZkClient, ZkConnection> tuple2 = this.createZkClientAndConnection(zkUrl, sessionTimeout, connectionTimeout);
        if (tuple2 != null) {
            Tuple2 tuple22;
            ZkClient zkClient = (ZkClient)tuple2._1();
            ZkConnection zkConnection = (ZkConnection)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)zkClient, (Object)zkConnection);
            ZkClient zkClient2 = (ZkClient)tuple23._1();
            ZkConnection zkConnection2 = (ZkConnection)tuple23._2();
            return new ZkUtils(zkClient2, zkConnection2, isZkSecurityEnabled);
        }
        throw new MatchError(tuple2);
    }

    public ZkUtils apply(ZkClient zkClient, boolean isZkSecurityEnabled) {
        return new ZkUtils(zkClient, null, isZkSecurityEnabled);
    }

    public ZkClient createZkClient(String zkUrl, int sessionTimeout, int connectionTimeout) {
        ZkClient zkClient = new ZkClient(zkUrl, sessionTimeout, connectionTimeout, (ZkSerializer)ZKStringSerializer$.MODULE$);
        return zkClient;
    }

    public Tuple2<ZkClient, ZkConnection> createZkClientAndConnection(String zkUrl, int sessionTimeout, int connectionTimeout) {
        ZkConnection zkConnection = new ZkConnection(zkUrl, sessionTimeout);
        ZkClient zkClient = new ZkClient((IZkConnection)zkConnection, connectionTimeout, (ZkSerializer)ZKStringSerializer$.MODULE$);
        return new Tuple2((Object)zkClient, (Object)zkConnection);
    }

    /*
     * WARNING - void declaration
     */
    public java.util.List<ACL> DefaultAcls(boolean isSecure) {
        ArrayList arrayList;
        if (isSecure) {
            void var2_2;
            ArrayList list2 = new ArrayList();
            list2.addAll(ZooDefs.Ids.CREATOR_ALL_ACL);
            list2.addAll(ZooDefs.Ids.READ_ACL_UNSAFE);
            arrayList = var2_2;
        } else {
            arrayList = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        }
        return arrayList;
    }

    public void maybeDeletePath(String zkUrl, String dir) {
        try {
            ZkClient zk = this.createZkClient(zkUrl, 30000, 30000);
            zk.deleteRecursive(dir);
            zk.close();
        }
        catch (Throwable throwable) {}
    }

    public String getTopicPath(String topic) {
        return new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)topic).toString();
    }

    public String getTopicPartitionsPath(String topic) {
        return new StringBuilder().append((Object)this.getTopicPath(topic)).append((Object)"/partitions").toString();
    }

    public String getTopicPartitionPath(String topic, int partitionId) {
        return new StringBuilder().append((Object)this.getTopicPartitionsPath(topic)).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)partitionId)).toString();
    }

    public String getTopicPartitionLeaderAndIsrPath(String topic, int partitionId) {
        return new StringBuilder().append((Object)this.getTopicPartitionPath(topic, partitionId)).append((Object)"/").append((Object)"state").toString();
    }

    public String getEntityConfigRootPath(String entityType) {
        return new StringBuilder().append((Object)this.EntityConfigPath()).append((Object)"/").append((Object)entityType).toString();
    }

    public String getEntityConfigPath(String entityType, String entity) {
        return new StringBuilder().append((Object)this.getEntityConfigRootPath(entityType)).append((Object)"/").append((Object)entity).toString();
    }

    public String getEntityConfigPath(String entityPath) {
        return new StringBuilder().append((Object)this.EntityConfigPath()).append((Object)"/").append((Object)entityPath).toString();
    }

    public String getDeleteTopicPath(String topic) {
        return new StringBuilder().append((Object)this.DeleteTopicsPath()).append((Object)"/").append((Object)topic).toString();
    }

    public Seq<Tuple2<TopicAndPartition, Seq<Object>>> parsePartitionReassignmentDataWithoutDedup(String jsonData) {
        Option<Object> option;
        block7: {
            Seq seq;
            block6: {
                block2: {
                    Option option2;
                    block5: {
                        Seq seq2;
                        block4: {
                            block3: {
                                option = Json$.MODULE$.parseFull(jsonData);
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                Object m = some.x();
                                option2 = ((Map)m).get((Object)"partitions");
                                if (!(option2 instanceof Some)) break block3;
                                Some some2 = (Some)option2;
                                Object partitionsSeq = some2.x();
                                seq2 = (Seq)((Seq)partitionsSeq).map((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final Tuple2<TopicAndPartition, Seq<Object>> apply(Map<String, Object> p) {
                                        String topic = (String)p.get((Object)"topic").get();
                                        int partition = BoxesRunTime.unboxToInt((Object)p.get((Object)"partition").get());
                                        Seq newReplicas = (Seq)p.get((Object)"replicas").get();
                                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(topic, partition)), (Object)newReplicas);
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                                break block4;
                            }
                            None$ none$ = None$.MODULE$;
                            Option option3 = option2;
                            if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                            seq2 = (Seq)Seq$.MODULE$.empty();
                        }
                        seq = seq2;
                        break block6;
                    }
                    throw new MatchError((Object)option2);
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block7;
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError(option);
    }

    public Map<TopicAndPartition, Seq<Object>> parsePartitionReassignmentData(String jsonData) {
        return this.parsePartitionReassignmentDataWithoutDedup(jsonData).toMap(Predef$.MODULE$.conforms());
    }

    public Seq<String> parseTopicsData(String jsonData) {
        Option<Object> option;
        block7: {
            ObjectRef topics;
            block6: {
                block2: {
                    Option option2;
                    block5: {
                        block4: {
                            block3: {
                                topics = new ObjectRef((Object)List$.MODULE$.empty());
                                option = Json$.MODULE$.parseFull(jsonData);
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                Object m = some.x();
                                option2 = ((Map)m).get((Object)"topics");
                                if (!(option2 instanceof Some)) break block3;
                                Some some2 = (Some)option2;
                                Object partitionsSeq = some2.x();
                                Seq mapPartitionSeq = (Seq)partitionsSeq;
                                mapPartitionSeq.foreach((Function1)new Serializable(topics){
                                    public static final long serialVersionUID = 0L;
                                    private final ObjectRef topics$1;

                                    public final void apply(Map<String, Object> p) {
                                        String topic = (String)p.get((Object)"topic").get();
                                        this.topics$1.elem = (List)((List)this.topics$1.elem).$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), List$.MODULE$.canBuildFrom());
                                    }
                                    {
                                        this.topics$1 = topics$1;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            None$ none$ = None$.MODULE$;
                            Option option3 = option2;
                            if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    throw new MatchError((Object)option2);
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block7;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return (List)topics.elem;
        }
        throw new MatchError(option);
    }

    public String formatAsReassignmentJson(Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned) {
        return Json$.MODULE$.encode(Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partitions"), partitionsToBeReassigned.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(Tuple2<TopicAndPartition, Seq<Object>> x0$1) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    if (topicAndPartition != null) {
                        String topic = topicAndPartition.topic();
                        int partition = topicAndPartition.partition();
                        Map map = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"topic"), (Object)topic), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)partition)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"replicas"), (Object)replicas)}));
                        return map;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom()))})));
    }

    private ZkUtils$() {
        MODULE$ = this;
        this.ConsumersPath = "/consumers";
        this.ClusterIdPath = "/cluster/id";
        this.BrokerIdsPath = "/brokers/ids";
        this.BrokerTopicsPath = "/brokers/topics";
        this.ControllerPath = "/controller";
        this.ControllerEpochPath = "/controller_epoch";
        this.ReassignPartitionsPath = "/admin/reassign_partitions";
        this.DeleteTopicsPath = "/admin/delete_topics";
        this.PreferredReplicaLeaderElectionPath = "/admin/preferred_replica_election";
        this.BrokerSequenceIdPath = "/brokers/seqid";
        this.IsrChangeNotificationPath = "/isr_change_notification";
        this.EntityConfigPath = "/config";
        this.EntityConfigChangesPath = "/config/changes";
    }
}

