/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Hashtable;
import java.util.Properties;
import junit.framework.Assert;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.DeleteTopicTest$;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentCompleted$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.ReassignmentStatus;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.FetchResponsePartitionData;
import kafka.api.OffsetFetchRequest;
import kafka.api.OffsetFetchRequest$;
import kafka.api.OffsetFetchResponse;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.OffsetResponse;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.common.ErrorMapping$;
import kafka.common.FailedToSendMessageException;
import kafka.common.OffsetMetadataAndError;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.controller.ReassignedPartitionsContext;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001\u000f\tyA)\u001a7fi\u0016$v\u000e]5d)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)\u0011\rZ7j]*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001A!\u0003\u0005\u0002\n!5\t!B\u0003\u0002\f\u0019\u0005)!.\u001e8ji*\u0011QBD\u0001\ng\u000e\fG.\u0019;fgRT\u0011aD\u0001\u0004_J<\u0017BA\t\u000b\u0005-QUK\\5ugM+\u0018\u000e^3\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011A\u0001>l\u0013\t9BC\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAQA\b\u0001\u0005\u0002}\t1\u0005^3ti\u0012+G.\u001a;f)>\u0004\u0018nY,ji\"\fE\u000e\\!mSZ,'+\u001a9mS\u000e\f7\u000fF\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0011)f.\u001b;)\u0005u9\u0003C\u0001\u0015+\u001b\u0005I#BA\u0006\u000f\u0013\tY\u0013F\u0001\u0003UKN$\b\"B\u0017\u0001\t\u0003y\u0012A\u000b;fgR\u0014Vm];nK\u0012+G.\u001a;f)>\u0004\u0018nY,ji\"\u0014VmY8wKJ,GMR8mY><XM\u001d\u0015\u0003Y\u001dBQ\u0001\r\u0001\u0005\u0002}\t\u0011\u0006^3tiJ+7/^7f\t\u0016dW\r^3U_BL7m\u00148D_:$(o\u001c7mKJ4\u0015-\u001b7pm\u0016\u0014\bFA\u0018(\u0011\u0015\u0019\u0004\u0001\"\u0001 \u0003\u0011\"Xm\u001d;SKF,Xm\u001d;IC:$G.\u001b8h\tV\u0014\u0018N\\4EK2,G/\u001a+pa&\u001c\u0007F\u0001\u001a(\u0011\u00151\u0004\u0001\"\u0001 \u00035\"Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC\u0016cWm\u0019;j_:$UO]5oO\u0012+G.\u001a;f)>\u0004\u0018n\u0019\u0015\u0003k\u001dBQ!\u000f\u0001\u0005\u0002}\tQ\u0006^3ti\u0012+G.\u001a;f)>\u0004\u0018n\u0019#ve&tw\r\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1FY\u0016\u001cG/[8oQ\tAt\u0005C\u0003=\u0001\u0011\u0005q$\u0001\u0016uKN$\b+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8nK:$H)\u001e:j]\u001e$U\r\\3uKR{\u0007/[2)\u0005m:\u0003\"B \u0001\t\u0003y\u0012A\u000b;fgR$U\r\\3uKR{\u0007/[2EkJLgn\u001a)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e\u0015\u0003}\u001dBQA\u0011\u0001\u0005\u0002}\t\u0011\u0005^3ti\u0012+G.\u001a;f)>\u0004\u0018n\u0019#ve&tw-\u00113e!\u0006\u0014H/\u001b;j_:D#!Q\u0014\t\u000b\u0015\u0003A\u0011A\u0010\u0002CQ,7\u000f^!eIB\u000b'\u000f^5uS>tG)\u001e:j]\u001e$U\r\\3uKR{\u0007/[2)\u0005\u0011;\u0003\"\u0002%\u0001\t\u0003y\u0012A\b;fgR\u0014Vm\u0019:fCR,Gk\u001c9jG\u00063G/\u001a:EK2,G/[8oQ\t9u\u0005C\u0003L\u0001\u0011\u0005q$A\u0014uKN$Hk\u001c9jG\u000e{gNZ5h\u0007\"\fgnZ3t\tV\u0014\u0018N\\4EK2,G/\u001a+pa&\u001c\u0007F\u0001&(\u0011\u0015q\u0005\u0001\"\u0001 \u0003y!Xm\u001d;BkR|7I]3bi\u0016\fe\r^3s\t\u0016dW\r^3U_BL7\r\u000b\u0002NO!)\u0011\u000b\u0001C\u0001?\u0005QB/Z:u\t\u0016dW\r^3O_:,\u00050[:uS:<Gk\u001c9jG\"\u0012\u0001k\n\u0005\u0006)\u0002!I!V\u0001\u001aGJ,\u0017\r^3UKN$Hk\u001c9jG\u0006sGm\u00117vgR,'\u000f\u0006\u0002WQB\u0019qk\u00182\u000f\u0005akfBA-]\u001b\u0005Q&BA.\u0007\u0003\u0019a$o\\8u}%\t1%\u0003\u0002_E\u00059\u0001/Y2lC\u001e,\u0017B\u00011b\u0005\r\u0019V-\u001d\u0006\u0003=\n\u0002\"a\u00194\u000e\u0003\u0011T!!\u001a\u0003\u0002\rM,'O^3s\u0013\t9GMA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\b\"B5T\u0001\u0004Q\u0017!\u0002;pa&\u001c\u0007CA6o\u001d\t\tC.\u0003\u0002nE\u00051\u0001K]3eK\u001aL!a\u001c9\u0003\rM#(/\u001b8h\u0015\ti'\u0005C\u0003s\u0001\u0011%1/A\nwKJLg-\u001f+pa&\u001cG)\u001a7fi&|g\u000eF\u0002!iVDQ![9A\u0002)DQA^9A\u0002Y\u000bqa]3sm\u0016\u00148\u000f")
public class DeleteTopicTest
extends JUnit3Suite
implements ZooKeeperTestHarness {
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void testDeleteTopicWithAllAliveReplicas() {
        TopicAndPartition topicAndPartition = new TopicAndPartition("test", 0);
        String topic = topicAndPartition.topic();
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic);
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        this.verifyTopicDeletion(topic, servers);
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$1) {
                x$1.shutdown();
            }
        });
    }

    @Test
    public void testResumeDeleteTopicWithRecoveredFollower() {
        TopicAndPartition topicAndPartition = new TopicAndPartition("test", 0);
        String topic = topicAndPartition.topic();
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic);
        Option leaderIdOpt = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), topic, 0);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)servers.filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final Option leaderIdOpt$1;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)this.leaderIdOpt$1.get());
            }
            {
                this.leaderIdOpt$1 = leaderIdOpt$1;
            }
        })).last();
        follower.shutdown();
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        Assert.assertTrue((String)"Replicas 0,1 have not deleted log in 1000ms", (boolean)TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicAndPartition, servers, follower){
            public static final long serialVersionUID = 0L;
            public final TopicAndPartition topicAndPartition$1;
            private final Seq servers$1;
            public final KafkaServer follower$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)this.servers$1.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testResumeDeleteTopicWithRecoveredFollower$1 $outer;

                    public final boolean apply(KafkaServer s) {
                        return s.config().brokerId() != this.$outer.follower$1.config().brokerId();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testResumeDeleteTopicWithRecoveredFollower$1 $outer;

                    public final boolean apply(boolean res, KafkaServer server) {
                        return res && server.getLogManager().getLog(this.$outer.topicAndPartition$1).isEmpty();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.topicAndPartition$1 = topicAndPartition$1;
                this.servers$1 = servers$1;
                this.follower$1 = follower$1;
            }
        }, 1000L));
        Assert.assertTrue((String)"Admin path /admin/delete_topic/test path deleted in 1000ms even when a follower replica is down", (boolean)TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ZkUtils$.MODULE$.pathExists(this.$outer.zkClient(), ZkUtils$.MODULE$.getDeleteTopicPath(this.topic$2));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
            }
        }, 500L));
        follower.startup();
        this.verifyTopicDeletion(topic, servers);
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$2) {
                x$2.shutdown();
            }
        });
    }

    @Test
    public void testResumeDeleteTopicOnControllerFailover() {
        TopicAndPartition topicAndPartition = new TopicAndPartition("test", 0);
        String topic = topicAndPartition.topic();
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic);
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        int controllerId = ZkUtils$.MODULE$.getController(this.zkClient());
        KafkaServer controller = (KafkaServer)((IterableLike)servers.filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
            }
        })).head();
        controller.shutdown();
        Assert.assertTrue((String)"Admin path /admin/delete_topic/test path deleted in 500ms even when a replica is down", (boolean)TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ZkUtils$.MODULE$.pathExists(this.$outer.zkClient(), ZkUtils$.MODULE$.getDeleteTopicPath(this.topic$3));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
            }
        }, 500L));
        controller.startup();
        Assert.assertTrue((String)"Admin path /admin/delete_topic/test path not deleted in 4000ms even after a follower replica is restarted", (boolean)TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !ZkUtils$.MODULE$.pathExists(this.$outer.zkClient(), ZkUtils$.MODULE$.getDeleteTopicPath(this.topic$3));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
            }
        }, 4000L));
        Assert.assertTrue((String)"Topic path /brokers/topics/test not deleted after /admin/delete_topic/test path is deleted", (boolean)TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !ZkUtils$.MODULE$.pathExists(this.$outer.zkClient(), ZkUtils$.MODULE$.getTopicPath(this.topic$3));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
            }
        }, 100L));
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)BoxesRunTime.unboxToBoolean((Object)servers.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final TopicAndPartition topicAndPartition$2;

            public final boolean apply(boolean res, KafkaServer server) {
                return res && server.getLogManager().getLog(this.topicAndPartition$2).isEmpty();
            }
            {
                this.topicAndPartition$2 = topicAndPartition$2;
            }
        })));
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$3) {
                x$3.shutdown();
            }
        });
    }

    @Test
    public void testRequestHandlingDuringDeleteTopic() {
        TopicAndPartition topicAndPartition = new TopicAndPartition("test", 0);
        String topic = topicAndPartition.topic();
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic);
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        ObjectRef leaderIdOpt = new ObjectRef((Object)ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)((Option)leaderIdOpt.elem).isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)servers.filter((Function1)new Serializable(this, leaderIdOpt){
            public static final long serialVersionUID = 0L;
            private final ObjectRef leaderIdOpt$2;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)((Option)this.leaderIdOpt$2.elem).get());
            }
            {
                this.leaderIdOpt$2 = leaderIdOpt$2;
            }
        })).last();
        follower.shutdown();
        Properties props1 = new Properties();
        ((Hashtable)props1).put("metadata.broker.list", ((TraversableOnce)servers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(KafkaServer s) {
                return new StringBuilder().append((Object)s.config().hostName()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)s.config().port())).toString();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(","));
        ((Hashtable)props1).put("serializer.class", "kafka.serializer.StringEncoder");
        ((Hashtable)props1).put("request.required.acks", "1");
        ProducerConfig producerConfig1 = new ProducerConfig(props1);
        Producer producer1 = new Producer(producerConfig1);
        try {
            try {
                producer1.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test1")}));
                throw this.fail("Test should fail because the topic is being deleted");
            }
            catch (Throwable throwable) {
                throw this.fail("fails with exception", throwable);
            }
            catch (FailedToSendMessageException failedToSendMessageException) {
            }
        }
        finally {
            producer1.close();
        }
        ((IterableLike)servers.filter((Function1)new Serializable(this, follower){
            public static final long serialVersionUID = 0L;
            private final KafkaServer follower$2;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != this.follower$2.config().brokerId();
            }
            {
                this.follower$2 = follower$2;
            }
        })).foreach((Function1)new Serializable(this, topicAndPartition, topic){
            public static final long serialVersionUID = 0L;
            private final TopicAndPartition topicAndPartition$3;
            private final String topic$4;

            public final void apply(KafkaServer server) {
                FetchRequest request;
                SimpleConsumer consumer = new SimpleConsumer(server.config().hostName(), server.config().port(), 1000000, 65536, "");
                FetchResponse fetched = consumer.fetch(request = new FetchRequestBuilder().clientId("test-client").addFetch(this.topic$4, 0, 0L, 10000).build());
                FetchResponsePartitionData fetchResponse = (FetchResponsePartitionData)fetched.data().apply((Object)this.topicAndPartition$3);
                Assert.assertTrue((String)"Fetch should fail with UnknownTopicOrPartitionCode", (fetchResponse.error() == ErrorMapping$.MODULE$.UnknownTopicOrPartitionCode() ? 1 : 0) != 0);
            }
            {
                this.topicAndPartition$3 = topicAndPartition$3;
                this.topic$4 = topic$4;
            }
        });
        ((IterableLike)servers.filter((Function1)new Serializable(this, follower){
            public static final long serialVersionUID = 0L;
            private final KafkaServer follower$2;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != this.follower$2.config().brokerId();
            }
            {
                this.follower$2 = follower$2;
            }
        })).foreach((Function1)new Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final TopicAndPartition topicAndPartition$3;

            public final void apply(KafkaServer server) {
                SimpleConsumer consumer = new SimpleConsumer(server.config().hostName(), server.config().port(), 1000000, 65536, "");
                OffsetRequest offsetRequest = new OffsetRequest((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topicAndPartition$3), (Object)new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.LatestTime(), 1))})), OffsetRequest$.MODULE$.$lessinit$greater$default$2(), OffsetRequest$.MODULE$.$lessinit$greater$default$3(), OffsetRequest$.MODULE$.$lessinit$greater$default$4(), OffsetRequest$.MODULE$.$lessinit$greater$default$5());
                OffsetResponse offsetResponse = consumer.getOffsetsBefore(offsetRequest);
                short errorCode = ((PartitionOffsetsResponse)offsetResponse.partitionErrorAndOffsets().apply((Object)this.topicAndPartition$3)).error();
                Assert.assertTrue((String)"Offset request should fail with UnknownTopicOrPartitionCode", (errorCode == ErrorMapping$.MODULE$.UnknownTopicOrPartitionCode() ? 1 : 0) != 0);
                OffsetFetchRequest offsetFetchRequest = new OffsetFetchRequest("test-group", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{this.topicAndPartition$3})), OffsetFetchRequest$.MODULE$.$lessinit$greater$default$3(), OffsetFetchRequest$.MODULE$.$lessinit$greater$default$4(), OffsetFetchRequest$.MODULE$.$lessinit$greater$default$5());
                OffsetFetchResponse offsetFetchResponse = consumer.fetchOffsets(offsetFetchRequest);
                short offsetFetchErrorCode = ((OffsetMetadataAndError)offsetFetchResponse.requestInfo().apply((Object)this.topicAndPartition$3)).error();
                Assert.assertTrue((String)"Offset fetch request should fail with UnknownTopicOrPartitionCode", (offsetFetchErrorCode == ErrorMapping$.MODULE$.UnknownTopicOrPartitionCode() ? 1 : 0) != 0);
            }
            {
                this.topicAndPartition$3 = topicAndPartition$3;
            }
        });
        follower.startup();
        this.verifyTopicDeletion(topic, servers);
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$4) {
                x$4.shutdown();
            }
        });
    }

    @Test
    public void testPreferredReplicaElectionDuringDeleteTopic() {
        TopicAndPartition topicAndPartition = new TopicAndPartition("test", 0);
        String topic = topicAndPartition.topic();
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic);
        Option leaderIdOpt = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), topic, 0);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        int preferredReplicaId = 0;
        KafkaServer preferredReplica = (KafkaServer)((IterableLike)servers.filter((Function1)new Serializable(this, preferredReplicaId){
            public static final long serialVersionUID = 0L;
            private final int preferredReplicaId$1;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.preferredReplicaId$1;
            }
            {
                this.preferredReplicaId$1 = preferredReplicaId$1;
            }
        })).head();
        preferredReplica.shutdown();
        preferredReplica.startup();
        Option<Object> newLeaderIdOpt = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, 3000L, (Option<Object>)leaderIdOpt);
        Assert.assertTrue((String)"New leader should be elected prior to delete topic", (boolean)newLeaderIdOpt.isDefined());
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        PreferredReplicaLeaderElectionCommand preferredReplicaElection = new PreferredReplicaLeaderElectionCommand(this.zkClient(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{topicAndPartition})));
        preferredReplicaElection.moveLeaderToPreferredReplica();
        Option<Object> leaderAfterPreferredReplicaElectionOpt = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, 1000L, newLeaderIdOpt);
        Assert.assertTrue((String)"Preferred replica election should not move leader during delete topic", (leaderAfterPreferredReplicaElectionOpt.isEmpty() || BoxesRunTime.unboxToInt((Object)leaderAfterPreferredReplicaElectionOpt.get()) == BoxesRunTime.unboxToInt((Object)newLeaderIdOpt.get()) ? 1 : 0) != 0);
        int newControllerId = ZkUtils$.MODULE$.getController(this.zkClient());
        KafkaServer newController = (KafkaServer)((IterableLike)servers.filter((Function1)new Serializable(this, newControllerId){
            public static final long serialVersionUID = 0L;
            private final int newControllerId$1;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.newControllerId$1;
            }
            {
                this.newControllerId$1 = newControllerId$1;
            }
        })).head();
        Assert.assertFalse((String)"Preferred replica election should fail", (boolean)newController.kafkaController().controllerContext().partitionsUndergoingPreferredReplicaElection().contains((Object)topicAndPartition));
        this.verifyTopicDeletion(topic, servers);
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$5) {
                x$5.shutdown();
            }
        });
    }

    @Test
    public void testDeleteTopicDuringPreferredReplicaElection() {
        String topic = "test";
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, 0);
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic);
        Option leaderIdOpt = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), topic, 0);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        int preferredReplicaId = 0;
        KafkaServer preferredReplica = (KafkaServer)((IterableLike)servers.filter((Function1)new Serializable(this, preferredReplicaId){
            public static final long serialVersionUID = 0L;
            private final int preferredReplicaId$2;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.preferredReplicaId$2;
            }
            {
                this.preferredReplicaId$2 = preferredReplicaId$2;
            }
        })).head();
        preferredReplica.shutdown();
        preferredReplica.startup();
        Option<Object> newLeaderIdOpt = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, 3000L, (Option<Object>)leaderIdOpt);
        Assert.assertTrue((String)"New leader should be elected prior to delete topic", (boolean)newLeaderIdOpt.isDefined());
        PreferredReplicaLeaderElectionCommand preferredReplicaElection = new PreferredReplicaLeaderElectionCommand(this.zkClient(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{topicAndPartition})));
        preferredReplicaElection.moveLeaderToPreferredReplica();
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        int newControllerId = ZkUtils$.MODULE$.getController(this.zkClient());
        KafkaServer newController = (KafkaServer)((IterableLike)servers.filter((Function1)new Serializable(this, newControllerId){
            public static final long serialVersionUID = 0L;
            private final int newControllerId$2;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.newControllerId$2;
            }
            {
                this.newControllerId$2 = newControllerId$2;
            }
        })).head();
        Assert.assertTrue((String)"Preferred replica election should succeed after 1000ms", (boolean)TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicAndPartition, newController){
            public static final long serialVersionUID = 0L;
            private final TopicAndPartition topicAndPartition$4;
            private final KafkaServer newController$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.newController$1.kafkaController().controllerContext().partitionsUndergoingPreferredReplicaElection().contains((Object)this.topicAndPartition$4);
            }
            {
                this.topicAndPartition$4 = topicAndPartition$4;
                this.newController$1 = newController$1;
            }
        }, 1000L));
        this.verifyTopicDeletion(topic, servers);
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$6) {
                x$6.shutdown();
            }
        });
    }

    @Test
    public void testPartitionReassignmentDuringDeleteTopic() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, 0);
        List<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4);
        brokerConfigs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Properties p) {
                return p.setProperty("delete.topic.enable", "true");
            }
        });
        List allServers = (List)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(new KafkaConfig(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, List$.MODULE$.canBuildFrom());
        List servers = (List)allServers.filter((Function1)new Serializable(this, expectedReplicaAssignment){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map expectedReplicaAssignment$1;

            public final boolean apply(KafkaServer s) {
                return ((LinearSeqOptimized)this.expectedReplicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
            }
            {
                this.expectedReplicaAssignment$1 = expectedReplicaAssignment$1;
            }
        });
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Assert.assertTrue((String)"Replicas for topic test not created in 1000ms", (boolean)TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicAndPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicAndPartition topicAndPartition$5;
            private final List servers$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.servers$2.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testPartitionReassignmentDuringDeleteTopic$1 $outer;

                    public final boolean apply(boolean res, KafkaServer server) {
                        return res && server.getLogManager().getLog(this.$outer.topicAndPartition$5).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.topicAndPartition$5 = topicAndPartition$5;
                this.servers$2 = servers$2;
            }
        }, 1000L));
        Option leaderIdOpt = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), topic, 0);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        Seq oldAssignedReplicas = ZkUtils$.MODULE$.getReplicasForPartition(this.zkClient(), topic, 0);
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkClient(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})));
        Assert.assertTrue((String)"Partition reassignment should fail for [test,0]", (boolean)reassignPartitionsCommand.reassignPartitions());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicAndPartition, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final TopicAndPartition topicAndPartition$5;
            private final Seq newReplicas$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map partitionsBeingReassigned = ZkUtils$.MODULE$.getPartitionsBeingReassigned(this.$outer.zkClient()).mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(ReassignedPartitionsContext x$7) {
                        return x$7.newReplicas();
                    }
                });
                ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkClient(), this.topicAndPartition$5, this.newReplicas$1, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topicAndPartition$5), (Object)this.newReplicas$1)})), partitionsBeingReassigned);
                ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
                return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentFailed$) : reassignmentFailed$ != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicAndPartition$5 = topicAndPartition$5;
                this.newReplicas$1 = newReplicas$1;
            }
        }, 1000L);
        int controllerId = ZkUtils$.MODULE$.getController(this.zkClient());
        KafkaServer controller = (KafkaServer)((IterableLike)servers.filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$2;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$2;
            }
            {
                this.controllerId$2 = controllerId$2;
            }
        })).head();
        Assert.assertFalse((String)"Partition reassignment should fail", (boolean)controller.kafkaController().controllerContext().partitionsBeingReassigned().contains((Object)topicAndPartition));
        Seq assignedReplicas = ZkUtils$.MODULE$.getReplicasForPartition(this.zkClient(), topic, 0);
        Assert.assertEquals((String)"Partition should not be reassigned to 0, 1, 2", (Object)oldAssignedReplicas, (Object)assignedReplicas);
        this.verifyTopicDeletion(topic, (Seq<KafkaServer>)servers);
        allServers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$8) {
                x$8.shutdown();
            }
        });
    }

    @Test
    public void testDeleteTopicDuringPartitionReassignment() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, 0);
        List<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4);
        brokerConfigs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Properties p) {
                return p.setProperty("delete.topic.enable", "true");
            }
        });
        List allServers = (List)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(new KafkaConfig(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, List$.MODULE$.canBuildFrom());
        List servers = (List)allServers.filter((Function1)new Serializable(this, expectedReplicaAssignment){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map expectedReplicaAssignment$2;

            public final boolean apply(KafkaServer s) {
                return ((LinearSeqOptimized)this.expectedReplicaAssignment$2.apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
            }
            {
                this.expectedReplicaAssignment$2 = expectedReplicaAssignment$2;
            }
        });
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Assert.assertTrue((String)"Replicas for topic test not created in 1000ms", (boolean)TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicAndPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicAndPartition topicAndPartition$6;
            private final List servers$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.servers$3.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDeleteTopicDuringPartitionReassignment$1 $outer;

                    public final boolean apply(boolean res, KafkaServer server) {
                        return res && server.getLogManager().getLog(this.$outer.topicAndPartition$6).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.topicAndPartition$6 = topicAndPartition$6;
                this.servers$3 = servers$3;
            }
        }, 1000L));
        Option leaderIdOpt = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), topic, 0);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkClient(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})));
        Assert.assertTrue((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions());
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicAndPartition, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final TopicAndPartition topicAndPartition$6;
            private final Seq newReplicas$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map partitionsBeingReassigned = ZkUtils$.MODULE$.getPartitionsBeingReassigned(this.$outer.zkClient()).mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(ReassignedPartitionsContext x$9) {
                        return x$9.newReplicas();
                    }
                });
                ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkClient(), this.topicAndPartition$6, this.newReplicas$2, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topicAndPartition$6), (Object)this.newReplicas$2)})), partitionsBeingReassigned);
                ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicAndPartition$6 = topicAndPartition$6;
                this.newReplicas$2 = newReplicas$2;
            }
        }, 1000L);
        int controllerId = ZkUtils$.MODULE$.getController(this.zkClient());
        KafkaServer controller = (KafkaServer)((IterableLike)servers.filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$3;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$3;
            }
            {
                this.controllerId$3 = controllerId$3;
            }
        })).head();
        Assert.assertFalse((String)"Partition reassignment should complete", (boolean)controller.kafkaController().controllerContext().partitionsBeingReassigned().contains((Object)topicAndPartition));
        Seq assignedReplicas = ZkUtils$.MODULE$.getReplicasForPartition(this.zkClient(), topic, 0);
        Assert.assertEquals((String)"Partition should be reassigned to 1,2,3", (Object)newReplicas, (Object)assignedReplicas);
        this.verifyTopicDeletion(topic, (Seq<KafkaServer>)allServers);
        allServers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$10) {
                x$10.shutdown();
            }
        });
    }

    @Test
    public void testDeleteTopicDuringAddPartition() {
        String topic = "test";
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic);
        TopicAndPartition newPartition = new TopicAndPartition(topic, 1);
        AdminUtils$.MODULE$.addPartitions(this.zkClient(), topic, 2, "0:1:2,0:1:2");
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        this.verifyTopicDeletion(topic, servers);
        Assert.assertTrue((String)"Replica logs not for new partition [test,1] not deleted after delete topic is complete", (boolean)TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, servers, newPartition){
            public static final long serialVersionUID = 0L;
            private final Seq servers$4;
            public final TopicAndPartition newPartition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.servers$4.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDeleteTopicDuringAddPartition$1 $outer;

                    public final boolean apply(boolean res, KafkaServer server) {
                        return res && server.getLogManager().getLog(this.$outer.newPartition$1).isEmpty();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.servers$4 = servers$4;
                this.newPartition$1 = newPartition$1;
            }
        }, 1000L));
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$11) {
                x$11.shutdown();
            }
        });
    }

    @Test
    public void testAddPartitionDuringDeleteTopic() {
        String topic = "test";
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, 0);
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic);
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        TopicAndPartition newPartition = new TopicAndPartition(topic, 1);
        AdminUtils$.MODULE$.addPartitions(this.zkClient(), topic, 2, "0:1:2,0:1:2");
        this.verifyTopicDeletion(topic, servers);
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)BoxesRunTime.unboxToBoolean((Object)servers.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this, newPartition){
            public static final long serialVersionUID = 0L;
            private final TopicAndPartition newPartition$2;

            public final boolean apply(boolean res, KafkaServer server) {
                return res && server.getLogManager().getLog(this.newPartition$2).isEmpty();
            }
            {
                this.newPartition$2 = newPartition$2;
            }
        })));
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$12) {
                x$12.shutdown();
            }
        });
    }

    @Test
    public void testRecreateTopicAfterDeletion() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, 0);
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic);
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        this.verifyTopicDeletion(topic, servers);
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Option<Object> leaderIdOpt = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        Assert.assertTrue((String)"New leader should be elected after re-creating topic test", (boolean)leaderIdOpt.isDefined());
        Assert.assertTrue((String)"Replicas for topic test not created in 1000ms", (boolean)TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicAndPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicAndPartition topicAndPartition$7;
            private final Seq servers$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.servers$5.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testRecreateTopicAfterDeletion$1 $outer;

                    public final boolean apply(boolean res, KafkaServer server) {
                        return res && server.getLogManager().getLog(this.$outer.topicAndPartition$7).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.topicAndPartition$7 = topicAndPartition$7;
                this.servers$5 = servers$5;
            }
        }, 1000L));
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$13) {
                x$13.shutdown();
            }
        });
    }

    @Test
    public void testTopicConfigChangesDuringDeleteTopic() {
        String topic = "test";
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic);
        Properties topicConfigs = new Properties();
        ((Hashtable)topicConfigs).put("segment.ms", "1000000");
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        this.verifyTopicDeletion(topic, servers);
        try {
            AdminUtils$.MODULE$.changeTopicConfig(this.zkClient(), topic, topicConfigs);
            throw this.fail("Should fail with AdminOperationException for topic doesn't exist");
        }
        catch (AdminOperationException adminOperationException) {
            servers.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaServer x$14) {
                    x$14.shutdown();
                }
            });
            return;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testAutoCreateAfterDeleteTopic() {
        TopicAndPartition topicAndPartition = new TopicAndPartition("test", 0);
        String topic = topicAndPartition.topic();
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic);
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), topic);
        this.verifyTopicDeletion(topic, servers);
        Properties props = new Properties();
        ((Hashtable)props).put("metadata.broker.list", ((TraversableOnce)servers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(KafkaServer s) {
                return new StringBuilder().append((Object)s.config().hostName()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)s.config().port())).toString();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(","));
        ((Hashtable)props).put("serializer.class", "kafka.serializer.StringEncoder");
        ((Hashtable)props).put("producer.type", "sync");
        ((Hashtable)props).put("request.required.acks", "1");
        ((Hashtable)props).put("message.send.max.retries", "1");
        ProducerConfig producerConfig = new ProducerConfig(props);
        Producer producer = new Producer(producerConfig);
        producer.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test1")}));
        Assert.assertTrue((String)"Topic not auto created", (boolean)ZkUtils$.MODULE$.pathExists(this.zkClient(), ZkUtils$.MODULE$.getTopicPath(topic)));
        Option<Object> leaderIdOpt = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        Assert.assertTrue((String)"New leader should be elected after re-creating topic test", (boolean)leaderIdOpt.isDefined());
        try {
            producer.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test1")}));
        }
        catch (Throwable throwable) {
            try {
                throw this.fail("fails with exception", throwable);
                catch (FailedToSendMessageException failedToSendMessageException) {
                    throw this.fail("Topic should have been auto created");
                }
            }
            catch (Throwable throwable2) {
                void var6_6;
                var6_6.close();
                throw throwable2;
            }
        }
        producer.close();
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$15) {
                x$15.shutdown();
            }
        });
        return;
        catch (Throwable throwable) {
            throw this.fail("fails with exception", throwable);
        }
        catch (FailedToSendMessageException failedToSendMessageException) {
            throw this.fail("Topic should have been auto created");
        }
    }

    @Test
    public void testDeleteNonExistingTopic() {
        TopicAndPartition topicAndPartition = new TopicAndPartition("test", 0);
        String topic = topicAndPartition.topic();
        Seq<KafkaServer> servers = this.createTestTopicAndCluster(topic);
        AdminUtils$.MODULE$.deleteTopic(this.zkClient(), "test2");
        this.verifyTopicDeletion("test2", servers);
        Assert.assertTrue((String)"Replicas for topic test not created in 1000ms", (boolean)TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicAndPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicAndPartition topicAndPartition$8;
            private final Seq servers$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.servers$6.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDeleteNonExistingTopic$1 $outer;

                    public final boolean apply(boolean res, KafkaServer server) {
                        return res && server.getLogManager().getLog(this.$outer.topicAndPartition$8).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.topicAndPartition$8 = topicAndPartition$8;
                this.servers$6 = servers$6;
            }
        }, 1000L));
        Assert.assertTrue((String)"Topic test mistakenly deleted", (boolean)ZkUtils$.MODULE$.pathExists(this.zkClient(), ZkUtils$.MODULE$.getTopicPath(topic)));
        Option<Object> leaderIdOpt = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        Assert.assertTrue((String)"Leader should exist for topic test", (boolean)leaderIdOpt.isDefined());
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$16) {
                x$16.shutdown();
            }
        });
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic) {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, 0);
        List<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3);
        brokerConfigs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Properties p) {
                return p.setProperty("delete.topic.enable", "true");
            }
        });
        List servers = (List)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(new KafkaConfig(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, List$.MODULE$.canBuildFrom());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Assert.assertTrue((String)"Replicas for topic test not created in 1000ms", (boolean)TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicAndPartition, servers){
            public static final long serialVersionUID = 0L;
            public final TopicAndPartition topicAndPartition$9;
            private final List servers$7;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.servers$7.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$createTestTopicAndCluster$1 $outer;

                    public final boolean apply(boolean res, KafkaServer server) {
                        return res && server.getLogManager().getLog(this.$outer.topicAndPartition$9).isDefined();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.topicAndPartition$9 = topicAndPartition$9;
                this.servers$7 = servers$7;
            }
        }, 1000L));
        return servers;
    }

    private void verifyTopicDeletion(String topic, Seq<KafkaServer> servers) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, 0);
        Assert.assertTrue((String)"Admin path /admin/delete_topic/test path not deleted in 1000ms even after a replica is restarted", (boolean)TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !ZkUtils$.MODULE$.pathExists(this.$outer.zkClient(), ZkUtils$.MODULE$.getDeleteTopicPath(this.topic$1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, 1000L));
        Assert.assertTrue((String)"Topic path /brokers/topics/test not deleted after /admin/delete_topic/test path is deleted", (boolean)TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicTest $outer;
            private final String topic$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !ZkUtils$.MODULE$.pathExists(this.$outer.zkClient(), ZkUtils$.MODULE$.getTopicPath(this.topic$1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, 100L));
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)BoxesRunTime.unboxToBoolean((Object)servers.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final TopicAndPartition topicAndPartition$10;

            public final boolean apply(boolean res, KafkaServer server) {
                return res && server.getLogManager().getLog(this.topicAndPartition$10).isEmpty();
            }
            {
                this.topicAndPartition$10 = topicAndPartition$10;
            }
        })));
    }

    public DeleteTopicTest() {
        ZooKeeperTestHarness$class.$init$(this);
    }
}

