/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.util.Properties;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.FetchResponsePartitionData;
import kafka.common.ErrorMapping$;
import kafka.common.KafkaException;
import kafka.common.OffsetOutOfRangeException;
import kafka.consumer.SimpleConsumer;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.integration.ProducerConsumerTestHarness;
import kafka.integration.ProducerConsumerTestHarness$class;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.scalatest.junit.JUnit3Suite;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0001\u0002\u0001\u000f\t!B*\u0019>z\u0013:LG\u000f\u0015:pIV\u001cWM\u001d+fgRT!a\u0001\u0003\u0002\u0017%tG/Z4sCRLwN\u001c\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t%A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"BA\u0006K+:LGoM*vSR,\u0007CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005m\u0001&o\u001c3vG\u0016\u00148i\u001c8tk6,'\u000fV3ti\"\u000b'O\\3tg\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\u0012!\u0007\t\u0003'\u0001Aqa\u0007\u0001C\u0002\u0013\u0005A$\u0001\u0003q_J$X#A\u000f\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\u0007%sG\u000f\u0003\u0004%\u0001\u0001\u0006I!H\u0001\u0006a>\u0014H\u000f\t\u0005\bM\u0001\u0011\r\u0011\"\u0001(\u0003\u0015\u0001(o\u001c9t+\u0005A\u0003CA\u0015/\u001b\u0005Q#BA\u0016-\u0003\u0011)H/\u001b7\u000b\u00035\nAA[1wC&\u0011qF\u000b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bBB\u0019\u0001A\u0003%\u0001&\u0001\u0004qe>\u00048\u000f\t\u0005\bg\u0001\u0011\r\u0011\"\u00015\u0003\u0019\u0019wN\u001c4jOV\tQ\u0007\u0005\u00027s5\tqG\u0003\u00029\t\u000511/\u001a:wKJL!AO\u001c\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\u0007y\u0001\u0001\u000b\u0011B\u001b\u0002\u000f\r|gNZ5hA!9a\b\u0001b\u0001\n\u0003y\u0014aB2p]\u001aLwm]\u000b\u0002\u0001B\u0019\u0011IR\u001b\u000e\u0003\tS!a\u0011#\u0002\u0013%lW.\u001e;bE2,'BA# \u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u000f\n\u0013A\u0001T5ti\"1\u0011\n\u0001Q\u0001\n\u0001\u000b\u0001bY8oM&<7\u000f\t\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u0003Q\u0011X-];fgRD\u0015M\u001c3mKJdunZ4feV\tQ\n\u0005\u0002O'6\tqJ\u0003\u0002Q#\u0006)An\\45U*\u0011!KD\u0001\u0007CB\f7\r[3\n\u0005Q{%A\u0002'pO\u001e,'\u000f\u0003\u0004W\u0001\u0001\u0006I!T\u0001\u0016e\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0019><w-\u001a:!\u0011\u0015A\u0006\u0001\"\u0011Z\u0003\u0015\u0019X\r^+q)\u0005Q\u0006C\u0001\u0010\\\u0013\tavD\u0001\u0003V]&$\b\"\u00020\u0001\t\u0003J\u0016\u0001\u0003;fCJ$un\u001e8\t\u000b\u0001\u0004A\u0011A-\u0002'Q,7\u000f\u001e)s_\u0012,8-Z!oI\u001a+Go\u00195\t\u000b\t\u0004A\u0011A-\u00021Q,7\u000f\u001e)s_\u0012,8-Z!oI6+H\u000e^5GKR\u001c\u0007\u000eC\u0003e\u0001\u0011\u0005\u0011,\u0001\tuKN$X*\u001e7uSB\u0013x\u000eZ;dK\")a\r\u0001C\u00013\u00061B/Z:u\u001bVdG/\u001b)s_\u0012,8-\u001a*fg\u0016tG\r")
public class LazyInitProducerTest
extends JUnit3Suite
implements ProducerConsumerTestHarness {
    private final int port;
    private final Properties props;
    private final KafkaConfig config;
    private final List<KafkaConfig> configs;
    private final Logger requestHandlerLogger;
    private final String host;
    private Producer<String, String> producer;
    private SimpleConsumer consumer;
    private List<KafkaServer> servers;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public Producer<String, String> producer() {
        return this.producer;
    }

    @Override
    public void producer_$eq(Producer<String, String> x$1) {
        this.producer = x$1;
    }

    @Override
    public SimpleConsumer consumer() {
        return this.consumer;
    }

    @Override
    public void consumer_$eq(SimpleConsumer x$1) {
        this.consumer = x$1;
    }

    @Override
    public void kafka$integration$ProducerConsumerTestHarness$$super$setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$ProducerConsumerTestHarness$$super$tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$ProducerConsumerTestHarness$_setter_$host_$eq(String x$1) {
        this.host = x$1;
    }

    @Override
    public List<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    @TraitSetter
    public void servers_$eq(List<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int port() {
        return this.port;
    }

    public Properties props() {
        return this.props;
    }

    public KafkaConfig config() {
        return this.config;
    }

    @Override
    public List<KafkaConfig> configs() {
        return this.configs;
    }

    public Logger requestHandlerLogger() {
        return this.requestHandlerLogger;
    }

    @Override
    public void setUp() {
        ProducerConsumerTestHarness$class.setUp(this);
        if (this.configs().size() <= 0) {
            throw new KafkaException("Must suply at least one server config.");
        }
        this.requestHandlerLogger().setLevel(Level.FATAL);
    }

    @Override
    public void tearDown() {
        this.requestHandlerLogger().setLevel(Level.ERROR);
        ProducerConsumerTestHarness$class.tearDown(this);
    }

    public void testProduceAndFetch() {
        String topic = "test";
        List sentMessages = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        List producerData = (List)sentMessages.map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$1;

            public final KeyedMessage<String, String> apply(String m) {
                return new KeyedMessage(this.topic$1, (Object)this.topic$1, (Object)m);
            }
            {
                this.topic$1 = topic$1;
            }
        }, List$.MODULE$.canBuildFrom());
        this.producer().send((Seq)producerData);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), topic, 0, 1000L);
        ByteBufferMessageSet fetchedMessage = null;
        while (fetchedMessage == null || fetchedMessage.validBytes() == 0) {
            FetchResponse fetched = this.consumer().fetch(new FetchRequestBuilder().addFetch(topic, 0, 0L, 10000).build());
            fetchedMessage = fetched.messageSet(topic, 0);
        }
        Assert.assertEquals((Object)sentMessages, (Object)((TraversableOnce)fetchedMessage.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(MessageAndOffset m) {
                return Utils$.MODULE$.readString(m.message().payload(), Utils$.MODULE$.readString$default$2());
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList());
        try {
            FetchResponse fetchedWithError = this.consumer().fetch(new FetchRequestBuilder().addFetch(topic, 0, -1L, 10000).build());
            fetchedWithError.data().values().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(FetchResponsePartitionData pdata) {
                    ErrorMapping$.MODULE$.maybeThrowException(pdata.error());
                }
            });
            throw this.fail("Expected an OffsetOutOfRangeException exception to be thrown");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {
            return;
        }
    }

    public void testProduceAndMultiFetch() {
        List topicOffsets = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"test4", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test1", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test2", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test3", (Object)BoxesRunTime.boxToInteger((int)0))}));
        HashMap messages2 = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        topicOffsets.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$1) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages2, builder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LazyInitProducerTest $outer;
            private final HashMap messages$1;
            private final FetchRequestBuilder builder$2;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$1) {
                Tuple2<String, Object> tuple2 = x$1;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int offset = tuple2._2$mcI$sp();
                    List producedData = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"a_").append((Object)topic).toString(), new StringBuilder().append((Object)"b_").append((Object)topic).toString()}));
                    this.messages$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topic), (Object)producedData));
                    this.$outer.producer().send((Seq)producedData.map((Function1)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$2;

                        public final KeyedMessage<String, String> apply(String m) {
                            return new KeyedMessage(this.topic$2, (Object)this.topic$2, (Object)m);
                        }
                        {
                            this.topic$2 = topic$2;
                        }
                    }, List$.MODULE$.canBuildFrom()));
                    TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.$outer.servers(), topic, 0, 1000L);
                    FetchRequestBuilder fetchRequestBuilder = this.builder$2.addFetch(topic, offset, 0L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.messages$1 = messages$1;
                this.builder$2 = builder$2;
            }
        });
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topicOffsets.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$2) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages2, response){
            public static final long serialVersionUID = 0L;
            private final HashMap messages$1;
            private final FetchResponse response$1;

            public final void apply(Tuple2<String, Object> x$2) {
                Tuple2<String, Object> tuple2 = x$2;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int offset = tuple2._2$mcI$sp();
                    ByteBufferMessageSet fetched = this.response$1.messageSet(topic, offset);
                    Assert.assertEquals((Object)this.messages$1.apply((Object)topic), (Object)fetched.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(MessageAndOffset m) {
                            return Utils$.MODULE$.readString(m.message().payload(), Utils$.MODULE$.readString$default$2());
                        }
                    }, Iterable$.MODULE$.canBuildFrom()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.messages$1 = messages$1;
                this.response$1 = response$1;
            }
        });
        FetchRequestBuilder builder2 = new FetchRequestBuilder();
        topicOffsets.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$3) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$3;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, builder2){
            public static final long serialVersionUID = 0L;
            private final FetchRequestBuilder builder$1;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$3) {
                Tuple2<String, Object> tuple2 = x$3;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int offset = tuple2._2$mcI$sp();
                    FetchRequestBuilder fetchRequestBuilder = this.builder$1.addFetch(topic, offset, -1L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        FetchRequest request2 = builder2.build();
        FetchResponse responses = this.consumer().fetch(request2);
        responses.data().values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LazyInitProducerTest $outer;

            public final void apply(FetchResponsePartitionData pd) {
                try {
                    ErrorMapping$.MODULE$.maybeThrowException(pd.error());
                    throw this.$outer.fail("Expected an OffsetOutOfRangeException exception to be thrown");
                }
                catch (OffsetOutOfRangeException offsetOutOfRangeException) {
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void testMultiProduce() {
        List topics = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3"}));
        HashMap messages2 = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        ObjectRef produceList = new ObjectRef((Object)Nil$.MODULE$);
        topics.foreach((Function1)new Serializable(this, messages2, builder, produceList){
            public static final long serialVersionUID = 0L;
            private final HashMap messages$2;
            private final FetchRequestBuilder builder$3;
            private final ObjectRef produceList$1;

            public final FetchRequestBuilder apply(String topic) {
                List set = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"a_").append((Object)topic).toString(), new StringBuilder().append((Object)"b_").append((Object)topic).toString()}));
                this.messages$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topic), (Object)set));
                this.produceList$1.elem = (List)((List)this.produceList$1.elem).$plus$plus((GenTraversableOnce)set.map((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$3;

                    public final KeyedMessage<String, String> apply(String x$4) {
                        return new KeyedMessage(this.topic$3, (Object)this.topic$3, (Object)x$4);
                    }
                    {
                        this.topic$3 = topic$3;
                    }
                }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
                return this.builder$3.addFetch(topic, 0, 0L, 10000);
            }
            {
                this.messages$2 = messages$2;
                this.builder$3 = builder$3;
                this.produceList$1 = produceList$1;
            }
        });
        this.producer().send((Seq)((List)produceList.elem));
        topics.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LazyInitProducerTest $outer;

            public final void apply(String topic) {
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.$outer.servers(), topic, 0, 1000L);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topics.foreach((Function1)new Serializable(this, messages2, response){
            public static final long serialVersionUID = 0L;
            private final HashMap messages$2;
            private final FetchResponse response$2;

            public final void apply(String topic) {
                ByteBufferMessageSet fetched = this.response$2.messageSet(topic, 0);
                Assert.assertEquals((Object)this.messages$2.apply((Object)topic), (Object)fetched.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(MessageAndOffset m) {
                        return Utils$.MODULE$.readString(m.message().payload(), Utils$.MODULE$.readString$default$2());
                    }
                }, Iterable$.MODULE$.canBuildFrom()));
            }
            {
                this.messages$2 = messages$2;
                this.response$2 = response$2;
            }
        });
    }

    public void testMultiProduceResend() {
        List topics = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3"}));
        HashMap messages2 = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        ObjectRef produceList = new ObjectRef((Object)Nil$.MODULE$);
        topics.foreach((Function1)new Serializable(this, messages2, builder, produceList){
            public static final long serialVersionUID = 0L;
            private final HashMap messages$3;
            private final FetchRequestBuilder builder$4;
            private final ObjectRef produceList$2;

            public final FetchRequestBuilder apply(String topic) {
                List set = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"a_").append((Object)topic).toString(), new StringBuilder().append((Object)"b_").append((Object)topic).toString()}));
                this.messages$3.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topic), (Object)set));
                this.produceList$2.elem = (List)((List)this.produceList$2.elem).$plus$plus((GenTraversableOnce)set.map((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$4;

                    public final KeyedMessage<String, String> apply(String x$5) {
                        return new KeyedMessage(this.topic$4, (Object)this.topic$4, (Object)x$5);
                    }
                    {
                        this.topic$4 = topic$4;
                    }
                }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
                return this.builder$4.addFetch(topic, 0, 0L, 10000);
            }
            {
                this.messages$3 = messages$3;
                this.builder$4 = builder$4;
                this.produceList$2 = produceList$2;
            }
        });
        this.producer().send((Seq)((List)produceList.elem));
        topics.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LazyInitProducerTest $outer;

            public final void apply(String topic) {
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.$outer.servers(), topic, 0, 1000L);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.producer().send((Seq)((List)produceList.elem));
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topics.foreach((Function1)new Serializable(this, messages2, response){
            public static final long serialVersionUID = 0L;
            private final HashMap messages$3;
            private final FetchResponse response$3;

            public final void apply(String topic) {
                ByteBufferMessageSet topicMessages = this.response$3.messageSet(topic, 0);
                Assert.assertEquals((Object)((TraversableLike)this.messages$3.apply((Object)topic)).$plus$plus((GenTraversableOnce)this.messages$3.apply((Object)topic), Seq$.MODULE$.canBuildFrom()), (Object)topicMessages.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(MessageAndOffset m) {
                        return Utils$.MODULE$.readString(m.message().payload(), Utils$.MODULE$.readString$default$2());
                    }
                }, Iterable$.MODULE$.canBuildFrom()));
            }
            {
                this.messages$3 = messages$3;
                this.response$3 = response$3;
            }
        });
    }

    public LazyInitProducerTest() {
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        ProducerConsumerTestHarness$class.$init$(this);
        this.port = TestUtils$.MODULE$.choosePort();
        this.props = TestUtils$.MODULE$.createBrokerConfig(0, this.port());
        this.config = new KafkaConfig(this.props());
        this.configs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{this.config()}));
        this.requestHandlerLogger = Logger.getLogger(KafkaRequestHandler.class);
    }
}

